/*  
	WLVProtos.h	1.5 
    	Copyright 1997 Willows Software, Inc. 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.

The maintainer of the Willows TWIN Libraries may be reached (Email) 
at the address twin@willows.com	

*/
#ifndef __WLVPROTOS_H__
#define __WLVPROTOS_H__

/* prototypes from WLVHelpr.c */

void 
LVCols_Init 
(
    PLVIEWCOLS      lpLVCols
);

void 
LVCols_Destroy
(
    PLVIEWCOLS      lpLVCols
);

int
LVCols_InsertCol 
( 
    PLVIEWCOLS          lpCols,
    int                 iCol,
    LV_COLUMN*          lpLCol 
);

BOOL
LVCols_LocateSubItem
(
    PLVIEWCOL           lpCols,
    PLVITEMPATH         pSubItmPath,
    BOOL                bCreate
);

/* need enhancement */
LPSTR
LVRows_Alloc
(
    PLVIEWROWS      lpRows,
    int             size
);

int
LVReport_BSearch
(
    PLVIEWROW       pRows,
    PLVSORTITEM     pSortRows,
    long            Count,
    HLVITEM         hItem,
    UINT            style
);

#if 0
int
LVRows_Connect
(
    PLVIEWROWS      lpRows,
    HLVITEM         hItem,
    UINT            style
);
#endif

void 
LVRows_Init 
(
    PLVIEWROWS      lpLVRows
);

int
LVRows_SetRowItm
(
    PLVIEWROWS      lpRows,
    int             iItem,
    LV_ITEM*        lplvi,
    UINT            style
);

/* prototypes from WLVBox.c */

LRESULT WINAPI 
LVEdit_WndProc
(
	HWND				hWnd,
    UINT				uMessage,
    WPARAM				wParam,
    LPARAM				lParam
);

void
LVLBox_OnHScroll
(
    HWND                    hWnd,
    int                     iCode,
    int                     iPos
);


void
LVLBox_OnVScroll
(
    HWND                    hWnd,
    int                     iCode,
    int                     iPos
);

BOOL
LVEdit_Subclass
(
    HWND                hwLBox
);


LRESULT WINAPI 
LVEdit_WndProc
(
	HWND				hWnd,
    UINT				uMessage,
    WPARAM				wParam,
    LPARAM				lParam
);

/* prototypes from WIMGLIST.c */

#include "windows.h"
#include "WLists.h"
#include "WCommCtrl.h"
#include "WImgList.h"
#include "WImageIO.h"
#include "WBmp.h"

typedef struct _WIMAGE
{
        HDC                     hMemoryDC;
        HDC                     hMaskDC;
        int                     NumImages;
        int                     NumUsed;
} WIMAGE;

int WINAPI
WImageList_ICopyImage
( 
	WHIMAGELIST			hImageList, 
	int				ImageIndex,
	HBITMAP				hBitmap,
	HBITMAP				hMask
);

int 
WImageList_IAddImage
( 
	WHIMAGELIST			hImageList, 
	int				nAddedImages,
	HBITMAP				hBitmap,
	HBITMAP				hMask
);

int WINAPI
WImageList_Add
(
	WHIMAGELIST			hImageList,
	HBITMAP				hBitmap,
	HBITMAP				hMask
);

int WINAPI
WImageList_AddMasked
(
	WHIMAGELIST		hImageList,
	HBITMAP			hBitmap,
	COLORREF		MaskColor
);

BOOL WINAPI
WImageList_BeginDrag
(
	WHIMAGELIST		hImageList,
	int			ImageIndex,
	int			HotSpotX,
	int			HotSpotY
);

WHIMAGELIST WINAPI
WImageList_Create
(
	int			SubImageWidth,
	int			SubImageHeight,
	UINT			CreateFlags,
	int			NumberOfSubImages,
	int			NumberOfImagesToGrowBy
);

BOOL WINAPI
WImageList_Destroy
(
	WHIMAGELIST		hImageList
);

BOOL WINAPI
WImageList_DragEnter
(
	HWND				hWnd,
	int				WindowX,  /* Note this is not ClientX */
	int				WindowY   /* Note this is not ClientY */
);

BOOL WINAPI
WImageList_DragLeave
(
	HWND				hWnd
);

BOOL WINAPI
WImageList_DragMove
(
	int				WindowX,  /* Note this is not ClientX */
	int				WindowY   /* Note this is not ClientY */
);

BOOL WINAPI
WImageList_DragShowNolock
(
	BOOL				Show
);

BOOL WINAPI
WImageList_Draw
(
	WHIMAGELIST			hImageList,
	int				ImageIndex,
	HDC				hDC,
	int				X,
	int				Y,
	UINT				DrawFlags
);

BOOL WINAPI
WImageList_DrawEx
(
	WHIMAGELIST		hImageList,
	int			ImageIndex,
	HDC			hDC,
	int			X,
	int			Y,
	int			DX,
	int			DY,
	COLORREF		BackgroundColor,
	COLORREF		ForegroundColor,
	UINT			DrawFlags
);

BOOL WINAPI
WImageList_EndDrag ( );


COLORREF WINAPI
WImageList_GetBkColor
(
	WHIMAGELIST			hImageList
);

WHIMAGELIST WINAPI
WImageList_GetDragImage
(
	POINT				*pDragPos,
	POINT				*pHotSpot
);

HICON WINAPI
WImageList_GetIcon
(
	WHIMAGELIST		hImageList,
	int			ImageIndex,
	UINT			DrawFlags
);

BOOL WINAPI
WImageList_GetIconSize
(
	WHIMAGELIST		hImageList,
	int				*pIconWidth,
	int				*pIconHeight
);

int WINAPI
WImageList_GetImageCount 
( 
	WHIMAGELIST		hImageList
);

BOOL WINAPI
WImageList_GetImageInfo 
( 
	WHIMAGELIST		hImageList,
	int				ImageIndex,
	IMAGEINFO FAR   *pImageInfo
);

WHIMAGELIST WINAPI
WImageList_LoadBitmap
(
	HINSTANCE			hInstance,
	LPCSTR				pstrBitmap,
	int				    SubImageWidth,
	int				    NumberOfImagesToGrowBy,
	COLORREF			MaskColor
);

WHIMAGELIST WINAPI
WImageList_LoadImage
(
	HINSTANCE			hInstance,
	LPCSTR				pstrImage,
	int				SubImageWidth,
	int				NumberOfImagesToGrowBy,
	COLORREF			MaskColor,
	UINT				ImageType,
	UINT				LoadFlags
);

WHIMAGELIST WINAPI
WImageList_Merge
(
	WHIMAGELIST			hImageList1,
	int				ImageIndex1,
	WHIMAGELIST			hImageList2,
	int				ImageIndex2,
	int				DX,
	int				DY
);

BOOL WINAPI
WImageList_Remove 
( 
	WHIMAGELIST		hImageList, 
	int				ImageIndex
);

BOOL WINAPI
WImageList_Replace
(
	WHIMAGELIST		hImageList,
	int			ImageIndex,
	HBITMAP			hBitmap,
	HBITMAP			hMask
);

int WINAPI
WImageList_ReplaceIcon
(
	WHIMAGELIST		hImageList,
	int		    	ImageIndex,
	HICON			hIcon
);

COLORREF WINAPI
WImageList_SetBkColor
(
	WHIMAGELIST			hImageList,
	COLORREF			BackgroundColor
);

BOOL WINAPI
WImageList_SetDragCursorImage
(
	WHIMAGELIST		hImageList,
	int		    	ImageIndex,
	int		    	HotSpotX,
	int		        HotSpotY
);

BOOL WINAPI
WImageList_SetIconSize
(
	WHIMAGELIST		hImageList,
	int		    	SubImageHeight,
	int		    	SubImageWidth
);

BOOL WINAPI
WImageList_SetOverlayImage
(
	WHIMAGELIST		hImageList,
	int			ImageIndex,
	int			OverlayIndex
);

BOOL WINAPI
WImage_IRemove
( 
	WIMAGE			*pImage,
	int			iRemoved,
	int			Height,
	int			Width,
	BOOL			bMask
);

static BOOL 
W_IDrawNonMaskedImage 
( 
	WHIMAGELIST		hImageList,
	int			ImageIndex,
	HDC			hDstDC,
	int			X,
	int			Y,
	int			DX,
	int			DY,
	COLORREF		BackgroundColor,
	COLORREF		ForegroundColor,
	UINT			DrawFlags
);


#if 1
static BOOL 
W_IDrawMaskedImage 
( 
	WHIMAGELIST		hImageList,
	int			ImageIndex,
	HDC			hDstDC,
	int			X,
	int			Y,
	int			DX,
	int			DY,
	COLORREF		BackgroundColor,
	COLORREF		ForegroundColor,
	UINT			DrawFlags
);
#else
static BOOL 
W_IDrawMaskedImage 
( 
   HDC				hDstDC, 
   WIMAGE*			pImageBlock, 
   int				X, 
   int				Y,
   int				DX,
   int				DY,
   int				SrcX,
   int				SrcY,
   COLORREF			ForegroundColor,
   COLORREF			BackgroundColor,
   HBRUSH			hBlendBrush,
   UINT				DrawFlags
);
#endif

static BOOL 
W_IRemoveAll 
( 
   WIMAGE*			pImage
);

/* prototypes from WLVIEW.c */

static int
LView_IAllocItmHandle 
(
    LISTVIEWDATA*       pthis
);


static void
LView_IDownHeapCB
(
    PLVSORTITEM         pSortAr,
    int                 N,
    int                 k,
    PFNTVCOMPARE        lpfnCmp,
    LPARAM              lParamSort
);

static void
LView_IDoHeapSort
(
    PLVSORTITEM         pSortAr,
    int                 Count,
    PFNLVCOMPARE        pfnCompare,
    LPARAM              lParamSort
);

static void
LView_IDrawSubItmLIcon
(
    HWND                    hWnd, 
	LISTVIEWDATA*	        pthis,
    PLVITEMPATH             pItmPath,
    PLVITEMLAYOUT           pLayout
);

static void
LView_IDrawSubItmRP
(
    HWND                    hWnd, 
	LISTVIEWDATA*	        pthis,
    PLVITEMPATH             pItmPath,
    PLVITEMLAYOUT           pLayout,
    UINT                    uStyle
);

static BOOL
LView_IArrangeIcons
(
    HWND                hwLView,
    PLISTVDATA          pthis

);

static BOOL
LView_IIsItmVisible
(
    HWND                hwLView,
    PLISTVDATA          pthis,
    RECT                rcClip,
    RECT                rcItem  
);

static void
LView_IOwnerDraw
(
    HWND                    hWnd, 
	LISTVIEWDATA*	        pthis,
    PLVITEMPATH             pItmPath,
    PLVITEMLAYOUT           pLayout,
    UINT                    uStyle
);

static void
LView_ISetItemRect
(
    HWND                hwLView,
    PLISTVDATA          pthis,
    int                 iItem,
    PLVIEWROW           pItm,
    PLVITEMLAYOUT       pItmLayout  
);

static BOOL
LView_IGetFirstVisibleItm
(
    HWND                hwLView,
    PLISTVDATA          pthis,
    PLVITEMPATH         pItmPath,
    PLVITEMLAYOUT       pItmLayout  
);

#if 0
/* new */
/* used expressly in small/large icon listview */
static int
LView_IGetItmFromPt
(
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    LPPOINT             lppt
);
#else
/* new */
/* used expressly in small/large icon listview */
static int
LView_IGetItmFromPt
(
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    LPPOINT             lppt
);
#endif

#if 0
/* new */
/* used expressly in small/large icon listview */
static int
LView_IGetNearestItmFromPt
(
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    LPPOINT             lppt
);
#else
/* new */
/* used expressly in small/large icon listview */
static int
LView_IGetNearestItmFromPt
(
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    LPPOINT             lppt
);
#endif

/* new */
static BOOL
LView_IGetItmText
(
    HWND                hWnd,
    LV_ITEM*            pLVItem,
    LPSTR*              lppText  
);

static BOOL
LView_IGetNextSubItm
(
    PLISTVDATA          pthis,
    PLVITEMPATH         pItmPath,
    PLVITEMLAYOUT       pItmLayout  
);


static BOOL
LView_IGetNextVisibleItm
(
    HWND                hwLView,
    PLISTVDATA          pthis,
    PLVITEMPATH         pItmPath,
    PLVITEMLAYOUT       pItmLayout  
);


HGLOBAL
LView_IGetResource
(
    HWND                hwTree,
    PLISTVDATA*         ppTree
);


/* new */
static BOOL
LView_ICloseSubItm
( 
    LISTVIEWDATA*       pthis,
    PLVITEMPATH         pSubItmPath
);

static void
LView_IInferItmState
(
    HWND                hWnd,
    PLISTVDATA          pthis,
    int                 iItem,
    PLVIEWROW           pItm,
    PLVITEMLAYOUT       pItmLayout  
);

static void
LView_ISelectItm
(
    HWND                hWnd,
    LISTVIEWDATA*       pthis,
    int                 iSel
);

/* new */
static BOOL
LView_IOpenSubItm
( 
    LISTVIEWDATA*       pthis,
    PLVITEMPATH         pSubItmPath,
    BOOL                bCreate
);

#if 0
static BOOL
LView_IReposition
(
    HWND                hWnd,
    PLISTVDATA          pthis,
    int                 iItem,
    int                 x,
    int                 y
);
#else
static BOOL
LView_IReposition
(
    HWND                hWnd,
    PLISTVDATA          pthis,
    int                 iItem,
    int                 x,
    int                 y
);
#endif

static BOOL
LView_ISetColWidth
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iCol,
    int                 iWidth
);


/* new */
static BOOL
LView_IUpdateSubItm 
( 
/*    LISTVIEWDATA*       pthis,*/
    PLVITEMPATH         pSubItmPath,
    LV_ITEM*            lplvi 
);

void
LView_IResetScroll
(
    HWND                hWnd,
    PLISTVDATA          pthis
);

void
LView_IReleaseResource
(
    HGLOBAL             hRsrc,
    PLISTVDATA          pTree
);

static BOOL 
LView_OnCreate 
(
	HWND			hWnd, 
	CREATESTRUCT*		pcs
);

void
LView_OnDrawItem
(
    HWND                    hWnd, 
    LISTVIEWDATA*	    pthis,
    PLVITEMPATH             pItmPath,
    PLVITEMLAYOUT           pLayout
);

void 
LView_OnKeyDown (HWND hWnd, int VKey, int cRepeat, UINT keyFlags);

/* to be deleted later */
static void 
LView_OnMButtonDown (HWND hWnd, int x, int y, UINT keyFlags);

static void 
LView_OnLButtonDown 
(
    	HWND            hWnd, 
    	int             x, 
    	int             y, 
    	UINT            keyFlags,
    	BOOL            bLBtnDown
); 

static void 
LView_OnLButtonUp (HWND hWnd, int x, int y, UINT keyFlags);

/*Need revisit this*/
static void 
LView_OnDestroy ( HWND hWnd );

static void 
LView_OnMouseMove 
(
	HWND			hWnd,
    	UINT            	uMessage,
	int			x, 
	int			y, 
	UINT			keyFlags
); 

static void 
LView_OnNotify 
(
	HWND			hWnd,
    	UINT            	uMessage,
	int		    	idControl, 
	LPNMHDR         	lpNotify 
); 

#if 1
static int 
LView_OnEraseBkground 
(
	HWND			hWnd, 
	HDC			hDC 
);
#endif

#if 0
static void 
LView_OnMeasureItem
(   
    HWND                hWnd, 
    MEASUREITEMSTRUCT*  lpMeasureItem 
);
#endif

static void 
LView_OnPaint 
(
	HWND			hWnd, 
	HDC		    	hPaintDC 
);


static void 
LView_OnSetFocus ( HWND hWnd, BOOL bSetFocus );

static void 
LView_OnTimer 
(
	HWND				hWnd, 
	int			    	idTimer 
);


/* new */
static HWND 
LView_OnEditLabel 
( 
    HWND            hWnd, 
	LISTVIEWDATA*	pthis,
    int             iItem 
); 

static BOOL 
LView_OnEndEditLabelNow 
( 
    HWND                hWnd, 
    LISTVIEWDATA*	pthis,
    BOOL                fCancel 
); 

static BOOL
LView_OnEnsureVisible
(
    HWND            hWnd, 
    LISTVIEWDATA*   pthis,
    int             iItem,
    BOOL            bPartial
);


static void 
LView_OnStyleChanged 
(
	HWND			hWnd, 
    	WORD                	wStyleType,
    	LPSTYLESTRUCT       	lpStyle
);



static LRESULT WINAPI 
LView_WndProc
(
	HWND			hWnd,
        UINT			uMessage,
        WPARAM			wParam,
        LPARAM			lParam
);

static HIMAGELIST
LView_OnCreateDragImage
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iItem,
    LPPOINT             lppt
);

#if 0
static BOOL
LView_OnDeleteAllItems
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis
);
#else
static BOOL
LView_OnDeleteAllItems
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis
);
#endif

static BOOL
LView_OnDeleteCol
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iCol
);

static BOOL
LView_OnDeleteItem
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iItem
);

static int
LView_OnFindItem
(
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iStart,
    LV_FINDINFO*        lpFind
);


static BOOL
LView_OnGetCol
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iCol,
    LV_COLUMN*          lpLCol
);

static int
LView_OnGetColWidth
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iCol
);

static int
LView_OnGetCountPerPage
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis
);

static BOOL
LView_OnGetItem
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    LV_ITEM*            lplvi
);

static BOOL
LView_OnGetItemPos
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iItem,
    LPPOINT             lppt
);

static BOOL
LView_OnGetItemRect
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iItem,
    LPRECT              lpRect
);

static int
LView_OnGetItemState
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iItem,
    UINT                statemask
);

static int
LView_OnGetItemText
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iItem,
    LV_ITEM*            lplvi
);

static int
LView_OnInsertCol 
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iCol,
    LV_COLUMN*          lpLCol 
);

static int
LView_OnInsertItem 
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    LV_ITEM*            lplvi 
);

static BOOL
LView_OnRedrawItms
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iFirst,
    int                 iLast
);

BOOL
LView_OnScroll
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 dx,
    int                 dy
);

static BOOL
LView_OnSetCol
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iCol,
    LV_COLUMN*          lpLCol
);

static BOOL
LView_OnSetColWidth
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iCol,
    int                 iWidth
);

static BOOL
LView_OnSetItemText
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iItem,
    LV_ITEM*            lplvi 
);

static int
LView_OnGetNextItem
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iStart,
    UINT                flags
);

static int
LView_OnGetStrWidth
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    LPSTR               lpText
);

static int
LView_OnHitTest
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    LV_HITTESTINFO*     lpht
);

static HIMAGELIST
LView_OnSetImageList
(
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iImageType,
    HIMAGELIST          hIml
);

/* in progress */
static BOOL
LView_OnSetItem
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    LV_ITEM*            lplvi
);

static void
LView_OnSetItemCount
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iCount
);


static BOOL
LView_OnSetItemState
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iItem,
    LV_ITEM*            lplvi
);

static BOOL
LView_OnSetItemPos
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    int                 iItem,
    int                 x,
    int                 y
);

static BOOL
LView_OnSortItems
( 
    HWND                hWnd, 
    LISTVIEWDATA*       pthis,
    LPARAM              lParamSort,
    PFNLVCOMPARE        pfnCompare
);

static LRESULT  
LView_LVMWndProc
(
	HWND			hWnd,
    UINT			uMessage,
    WPARAM			wParam,
    LPARAM			lParam
);

int WINAPI 
LView_Initialize 
(
	HINSTANCE		hinst
); 

void WINAPI LView_Terminate 
(
	HINSTANCE			hInstance
); 


#endif /* __WLVPROTOS_H__ */

