/*  Log.h	2.11
    Copyright 1997 Willows Software, Inc. 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.

The maintainer of the Willows TWIN Libraries may be reached (Email) 
at the address twin@willows.com	

*/

/*********************************************************************
 *	Logging
 *	TRACE allows control over 
 *		api call and return
 *		message send and return
 *		enumeration functions
 *	additionally, each api call can trigger specific operations
 *	to be performed, or LOGGING MASKS to be active during that API
 *	
 *	DEBUG allows various internal logging to be performed
 *
 *	Three functions(macros) are defined, whose behavior is defined
 *	depending on the settings of TRACE and DEBUG
 *
 *	MACRO		TRACE ONLY 	TRACE & DEBUG	DEBUG ONLY
 *	----------
 *	APISTR(s)	apistr s	apistr s	logstr s
 *	ERRSTR(s)	logstr s	logstr s	logstr s
 *	LOGSTR(s)			logstr s	logstr s
 *	INTSTR(s)	intstr s	intstr s  	logstr s
 *	DRVSTR(s)	drvstr s	drvstr s  	logstr s
 *
 *	This by default provides the original behavior, but now may be
 *	modified by setting the WIN_OPENLOG flag
 *
 ************************************************************************/

#ifndef Log__h
#define Log__h	

#include "windows.h"

/* Logging prototypes for direct usage */
void logstr(unsigned long flg, ...);
void apistr(long flag, ...);
void intstr(long flag, ...);
void LogAPIcall(WORD,WORD,LPSTR,LPSTR);
void LogAPIret(WORD,WORD,LPSTR,LPSTR);


#ifdef  TRACE

#define APISTR(s) apistr s
#define ERRSTR(s) logstr s
#define INTSTR(s) intstr s
#define DRVSTR(s) drvstr s

#ifdef  DEBUG
#define LOGSTR(s) logstr s
#else
#define LOGSTR(s) 
#endif

#else
/* 
 *	DEBUG defined, emulate original logging style
 */
#ifdef  DEBUG

#define APISTR(s) logstr s
#define ERRSTR(s) logstr s
#define LOGSTR(s) logstr s
#define INTSTR(s) logstr s
#define DRVSTR(s) logstr s

#else

/* 
 *	NO LOGGING/TRACING
 *	ERRSTR will still be logged...
 */
#define LOGSTR(s) 
#define ERRSTR(s) logstr s
#define APISTR(s)
#define INTSTR(s)
#define DRVSTR(s)

#endif

#endif

/******************************************************************
 *
 *	32 bit flag values
 *	1 general printing flags
 *	2 library printing flags
 *	3 binary interface flags
 *	4 subsystem printing flags
 *	5 windows printing flags
 *	6 driver printing flags
 *	7 misc. printing flags
 *	8 remote printing flags
 *
 ******************************************************************/

#define LF_ERR		0x0001
#define LF_WARNING	0x0002
#define LF_STUB 	0x0004
#define LF_LOG		0x0008
#define LF_ERRORS	(LF_ERR|LF_WARNING|LF_STUB)

#define LF_APICALL	0x0010
#define LF_APIRET	0x0020
#define LF_LIBCALL	0x0040
#define LF_LIBRET	0x0080

#define LF_INTERFACE	0x0100
#define LF_INT		0x0200
#define LF_RESOURCE	0x0400
#define LF_EXEC		0x0800

#define LF_WINDOWS	0x1000
#define LF_MESSAGE	0x2000
#define LF_CONTROL	0x4000
#define LF_DIALOGS	0x8000

#define LF_DRIVER	0x00010000
#define LF_PGH		0x00020000
#define LF_PWH 		0x00040000
#define LF_PSH 		0x00080000

#define LF_GDI		0x00100000
#define LF_REGIONS	0x00200000
#define LF_MENU		0x00400000
#define LF_OBJECTS	0x00800000

#define LF_API 		0x01000000
#define LF_XDOS		0x02000000
#define LF_MFS 		0x04000000
#define LF_PRINTER	0x08000000

#define LF_SHARED	0x10000000
#define LF_DDE		0x20000000
#define LF_OLE 		0x40000000
#define LF_FILE32	0x80000000

/* extra mappings... */
#define LF_ALL		LF_LOG

#define LF_STDERR 	LF_WARNING

#define LF_MDI		LF_WINDOWS
#define LF_NONCLIENT	LF_WINDOWS
#define LF_CLASSES	LF_WINDOWS

#define LF_HOOK		LF_MESSAGE

#define LF_EXTERNAL	LF_PSH
#define LF_KEYS		LF_PSH

#define LF_GRAPHICS	LF_PGH

#define LF_MEMORY	LF_RESOURCE

#define LF_SHELL	LF_SHARED

/* 
 *	Logging Control structure
 *		apinum		how many api's have been called totally 
 *		module		current module/ordinal being called
 *		ordinal
 *		apilog		whether to log this api call/return pair
 *		sublog		whether to log nested apis 
 *		msglog		whether to log sendmessages call/return pairs
 */
struct RunControl {
	long	apinum;		/* how many api's called */
	int	module;
	char *  apistr;		/* what api is being traced */
	int 	ordinal;
	int	apilog;		/* whether to log api call */
	int	sublog;		/* whether to log nested calls */
				/* 0 do not log nested calls */
				/* 1 log first call */
				/* 2 log all direct calls... */
				/* 4 log all nested calls... */
	int	msglog;		/* whether to log messages... */
};

#endif
