/*  platform.h	1.25
    Copyright 1997 Willows Software, Inc. 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.

The maintainer of the Willows TWIN Libraries may be reached (Email) 
at the address twin@willows.com	

*/


/*
 *  This file must be included by every module in our library, either
 *  directly, or indirectly via windows.h.  The contents of this file
 *  are the following types of things:
 *
 *    Platform-specific files that must be included in most/all modules.
 *    Platform-specific capability definitions (TWIN_*) that drive
 *        conditionally compiled code within the library.
 *
 *
 *  The following are the available defines that can be made for each 
 *  platform to enable/disable certain behaviour.  This overall list
 *  must be kept up to date.  If a new capability is added, check all
 *  platforms to see if the given entity should be defined for that
 *  case.
 *
 *  --------
 *  TWIN_FPCLASS_IEEEFP_H 
 *
 *	Used to control how the MS functions fpclass() and finite()
 *	are defined, as well as supporting macros.  Currently, the
 *      only allowed method is through the <ieeefp.h> file. 
 *
 *  --------
 *  TWIN_ISCSYM_DEFINED
 *
 *      Set this if the platform already defines __iscsym().
 *
 *  --------
 *  TWIN_BOOL_DEFINED
 *
 *	Set this if the platform already defines BOOL (and the definition is
 *	compatible with the Windows definition).
 *
 *  --------
 *  TWIN_SHORT_DEFINED
 *
 *	Set this if the platform already defines SHORT (and the definition is
 *	compatible with the Windows definition).
 *
 *  --------
 *  TWIN_USHORT_DEFINED
 *
 *	Set this if the platform already defines USHORT (and the definition is
 *	compatible with the Windows definition).
 *
 *  --------
 *  TWIN_INT_DEFINED
 *
 *	Set this if the platform already defines INT (and the definition is
 *	compatible with the Windows definition).
 *
 *  --------
 *  TWIN_UINT_DEFINED
 *
 *	Set this if the platform already defines UINT (and the definition is
 *	compatible with the Windows definition).
 *
 *  --------
 *  TWIN_LONG_DEFINED
 *
 *	Set this if the platform already defines LONG (and the definition is
 *	compatible with the Windows definition).
 *
 *  --------
 *  TWIN_ULONG_DEFINED
 *
 *	Set this if the platform already defines ULONG (and the definition is
 *	compatible with the Windows definition).
 *
 *  --------
 *  TWIN_EMPTY_MODTABLE
 *
 *	Set this if the platform requires an empty modtable.
 *
 *  --------
 *  TWIN_EMPTY_LSD_PRINTER
 *
 *	Set this if the platform requires an empty lsd printer table.
 *
 *  --------
 *  TWIN_INTERP_NOT_SUPPORTED
 *
 *	Set this if the platform does not support the interpreter.
 *      (Perhaps this should be a Makefile/buildtime flag instead?).
 *
 *  --------
 *  TWIN_RUNTIME_DRVTAB
 *
 *	Set this if the platform requires the DrvTab entries to be set
 *      at runtime.  It's ok to set this even if it's not really needed.
 *
 *  --------
 *  TWIN_HASSTATFS
 *  TWIN_HASVFSSTAT
 *
 *	Set one or the other to determine if the operating system supports
 * 	statfs(), or vfsstat().  This is used in the XDOS emulation package
 *      to determine the size of a given filesystem, for DOS INT21 FN36.
 *
 *  --------
 */

/*****************************************************************/

#ifndef platform__h
#define platform__h

#if defined(LINUX)
#define TWIN_HASDLFCN	1
#define SYNC_CODE_DATA
#endif

#ifdef __VMS
#include <stdlib.h> /* some code assumes this */
#define unlink(x) delete(x)
#if __VMS_VER < 70000000
  int  strcasecmp(const char *, const char *);
  int  strncasecmp(const char *, const char *, size_t);
#endif
#endif


/*****************************************************************/

#define TWIN_SLASHSTRING	"/"
#define TWIN_SLASHCHAR	 	'/'
#define _EXTERN_ extern

/*****************************************************************/
#endif  /* platform__h */
