/********************************************************************
*	StringUtils.c
*
*	Implements string utilites not in the Macintosh ANSI C library.
*
*	WARNING:  strdup uses malloc, therefore this file needs to be compiled into the same
*                   library that it is used.  This is to avoid mixing up memory pools (bad!!).
*
*   Copyright (c) 1995, Willows Software Inc.  All rights reserved.
********************************************************************/

static char *StringUtils_c =  "IDENT:  @(#)StringUtils.c	1.3 3/14/97 14:04:57";


#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <Memory.h>

#include "StringUtils.h"


/*************************************************
*	strcasecmp
*
*	Implements a non-case sensitive string compare.
*************************************************/
int strcasecmp(const char *s1, const char *s2)
{
char *n1 = (char *)s1, *n2 = (char *)s2;
	
	if (s1 == NULL || s2 == NULL)
		return 1;
	
	while (*n1) {
		if (toupper(*n1++) != toupper(*n2++))
			return (*(n1-1)-*(n2-1));
	}

	return *n2;

}


/*************************************************
*	strncasecmp
*
*	Implements a non-case sensitive string compare for n characters.
*************************************************/
int strncasecmp(const char *s1,  const char *s2, int n)
{
char *n1 = (char *)s1, *n2 = (char *)s2;
int i = 0;

	if (s1 == NULL || s2 == NULL)
		return 1;
	
	while (*n1 && i < n ) {
		i++;
		if (toupper(*n1++) != toupper(*n2++))
			return (*(n1-1)-*(n2-1));
	}

    if (i == n)
    	return 0;
    else
		return *n2;

}


/*************************************************
*	strdup
*
*	Duplicates a string, allocating the memory required to do so.
*************************************************/
char *strdup(const char *s)
{
int len = strlen(s);
char *s2;

	if (len > 0) {
		s2 = (char *)malloc(len);
		strcpy(s2, s);
		return(s2);		
	}
	else
		return(NULL);
}


/********************************************************************
* trim
*
*	Remove any trailing blanks, tabs, and newlines.
* Returns string length.
********************************************************************/
int trim(char *s)
{
int n;

	for (n = strlen(s) -1; n >= 0; n--)
		if (s[n] != ' ' && s[n] != '\t' && s[n] != '\n')
			break;
	
	s[n+1] = '\0';
	return (n);
}


/*************************************************
*	strcpyPPC
*
*	Possibly a faster string copy.
*************************************************/
char *strcpyPPC(register char *dst, register char *src)
{
register long	x = 0;
	
	while((dst[x] = src[x]) != 0)
		x++;
	
	return dst;
}

/********************************************************************
* c2pstrcpy	-	Pascal string utilities
*
*  copy c string 'src' to pascal string 'dst'
*  Returns the pascal strings pointer.
********************************************************************/
unsigned char *c2pstrcpy(register unsigned char *dst, register char *src)
{
register int i = 0;

	while((dst[i+1] = src[i]) != 0)
		i++;

	dst[0] = i;			/* Set pascal string length*/
	
	return(dst);
}


/********************************************************************
* pstrcpy	-	Pascal string utilities
*
*  copy pascal string 'src' to c string 'dst'
*  Returns the c strings pointer.
********************************************************************/
char *p2cstrcpy(register char *dst, register unsigned char *src)
{
register int i;

	for(i = 0; i < *src; i++)
		dst[i] = src[i+1];

	dst[i] = '\0';			/* Terminate c string */
	
	return(dst);
}



/********************************************************************
* pstrcpy	-	Pascal string utilities
*
*  copy string 'src' to string 'dst'
********************************************************************/
void pstrcpy(unsigned char *dst, unsigned char *src)
{
	/* copy string in */
	BlockMove(src + 1, dst + 1, *src);
	/* adjust length byte */
	*dst = *src;
}


/********************************************************************
* pstrcat	-	Pascal string utilities
*
*  add string 'src' to end of string 'dst'
********************************************************************/
void pstrcat(unsigned char *dst, unsigned char *src)
{
	/* copy string in */
	BlockMove(src + 1, dst + *dst + 1, *src);
	/* adjust length byte */
	*dst += *src;
}

/********************************************************************
* pstrinsert	-	Pascal string utilities
*
*  insert string 'src' at beginning of string 'dst'
********************************************************************/
void pstrinsert(unsigned char *dst, unsigned char *src)
{
	/* make room for new string */
	BlockMove(dst + 1, dst + *src + 1, *dst);
	/* copy new string in */
	BlockMove(src + 1, dst + 1, *src);
	/* adjust length byte */
	*dst += *src;
}



