/********************************************************************
*	StringUtils.h
*
*	Implements string utilites not in the Macintosh ANSI C library.
*
*   Copyright (c) 1995, Willows Software Inc.  All rights reserved.
********************************************************************/
#ifndef StringUtils__h
#define StringUtils__h

/* "@(#)StringUtils.h	1.3  9/27/96 17:08:25" */



/* Prototypes */
char * strlwr(char *s);
int strcasecmp(const char *s1, const char *s2);
int strncasecmp(const char *s1,  const char *s2, int n);
char *strdup(const char *s);
int trim(char *s);


/* Pascal string utilities */
char *p2cstrcpy(register char *dst, register unsigned char *src);
unsigned char *c2pstrcpy(register unsigned char *dst, register char *src);
void pstrcpy(unsigned char *dst, unsigned char *src);
void pstrcat(unsigned char *dst, unsigned char *src);
void pstrinsert(unsigned char *dst, unsigned char *src);

/* A faster string copy */
char *strcpyPPC(register char *dst, register char *src);


#endif		/* StringUtils__h */
