/*	Willows Software, Inc. - Feb 1997	*/
#ifndef access__h
#define access__h
/*	"@(#)access.h	1.2 :/users/sccs/src/win/mac/s.access.h 2/7/97 11:16:20" */

#ifndef sfntAccessIncludes
#define sfntAccessIncludes

#include "sfnt_enum.h"

#define fNoError			 0
#define fTableNotFound		-1
#define fNameNotFound		-2
#define fMemoryError		-3
#define fUnimplemented		-4
#define fCMapNotFound		-5
#define fGlyphNotFound		-6

typedef long FontError;
typedef long fontTableTag;

typedef struct FontTableInfo {
	long		offset;			/* from beginning of sfnt to beginning of the table */
	long		length;			/* length of the table */
	long		checkSum;		/* checkSum of the table */
} FontTableInfo;

typedef struct FixPoint {
	Fixed	x;
	Fixed	y;
} FixPoint;

typedef struct GlyphOutline {
	long		contourCount;
	long		pointCount;
	
	FixPoint	origin;
	FixPoint	advance;

	short**	endPoints;		/* [contourCount] */
	Byte**	onCurve;		/* [pointCount] */
	Fixed**	x;			/* [pointCount] */
	Fixed**	y;			/* [pointCount] */
} GlyphOutline;

typedef Fixed Matrix[3][3];

#ifdef	__cplusplus
extern "C" {
#endif	//	__cplusplus

/*	Return the number of tagged tables in the sfnt
*/
long CountSfntTables(Handle sfnt);

/*	Return the tag for the indexth table, start with 0
 *	Return 0 if index is out of range.
 */
fontTableTag GetSfntTag(Handle sfnt, long index);

/*	Fill out the FontTableInfo record for the tagged table.
*/
FontError GetSfntTableInfo(Handle sfnt, fontTableTag, FontTableInfo*);

/*	Grow userCopy and then copy the tagged table into it.
*/
FontError GetSfntTable(Handle sfnt, fontTableTag, Handle userCopy);

/*	Return in name the string for the font name identified by nameID.
 *	Defined values for nameID are in sfnt_enum.h under sfnt_NameIndex.
 */
FontError GetSfntNameString(Handle sfnt, long nameID, Str255 name);

/*	Return the glyph index for the given charCode.  0 means the char is missing.
*/
long GetCharGlyphIndex(Handle sfnt, unsigned short charCode);

/*	Return the number of glyphs in this sfnt.
*/
long CountSfntGlyphs(Handle sfnt);

/*	Return the GlyphOutline record for the indexed glyph.
*/
FontError GetGlyphOutline(Handle sfnt, long index, GlyphOutline*, Matrix);

#ifdef	__cplusplus
}
#endif	//	__cplusplus


#endif
#endif

