#ifndef accessLibraryIncludes
#define accessLibraryIncludes

#ifndef sfntAccessIncludes
	#include "access.h"
#endif

#ifndef curveIncludes
	#include "curves.h"
#endif


typedef struct {
	Fixed	m11;
	Fixed	m12;
	Fixed	m21;
	Fixed	m22;
} TransMatrix, *TransMatrixPtr;


#ifdef	__cplusplus
extern "C" {
#endif	//	__cplusplus

void InitMatrix(Matrix);

/*	Return a handle to the sfnt in the given font family with the given style.
*/
Handle GetNamedSfntHandle(Str255 fontName, short styleWord);
Handle GetSfntHandle(short txFont, short styleWord);

/*	Allocate the initial arrays for the GlyphOutline.
*/
FontError InitGlyphOutline(GlyphOutline* out);

/*	Dispose the memory allocated for the GlyphOutline.
*/
FontError KillGlyphOutline(GlyphOutline* out);

/*	Lock/Unlock the arrays in the GlyphOutline.
*/
void LockGlyphOutline(GlyphOutline*);
void UnlockGlyphOutline(GlyphOutline*);

/*	These modify the outline, origin and advance.
*/
void AppendGlyphOutline(GlyphOutline* a, GlyphOutline* b);
void MoveGlyphOutline(GlyphOutline*, Fixed xDelta, Fixed yDelta );
void MoveToGlyphOutline(GlyphOutline* out, Fixed xCoord, Fixed yCoord );
void ScaleGlyphOutline(GlyphOutline* out, Fixed xScale, Fixed yScale);
void MapGlyphOutline(GlyphOutline*, Matrix, Rect* bounds, Point* origin );

/*	Convert a glyph outline into a paths, allocated as a NewPtr.
*/
paths* OutlineToPaths(GlyphOutline* out);

/*	Works like StdText, but frames the outlines using FrameGlyphOutline.
*/
void FrameText( unsigned char* text, FixPoint* scale, int mark );

//
//	FrameTextTransform():	Works like FrameText but applies a transform to each point
//
Boolean
FrameTextTransform( unsigned char* text, TransMatrixPtr m, Rect* bounds, Point* origin );

/*	Just like FrameText, but returns the paths. It also fills out finalPenPosition
 *	with the pen location for the end of the text.
*/
paths* Text2Paths( unsigned char* text, FixPoint* scale, TransMatrixPtr m, FixPoint* finalPenPosition, Rect* bounds, Point* origin );

#ifdef	__cplusplus
}
#endif	//	__cplusplus

#endif
