/********************************************************************
*   DrvDC.h
*
*   Macintosh device specific drawing context (DC) definintion.
*
*   Copyright (c) 1995-1997, Willows Software Inc.  All rights reserved.
*   
********************************************************************/
#ifndef DrvDC__h
#define DrvDC__h

#include "windows.h"
#include "DrvImages.h"
#include "DrvText.h"

/* Drawing Context definition */
typedef struct tagDRIVERDC
{
    void		*grafPort;						// graphics port (CGrafPtr)		
    int 		bLocalGrafPort;				// Indicates the driver allocated the CGrafPort
	long		dwDCFlags;						// DCX flags	
	POINT	cpt;									// Current point in the DC.		

    int		bkFillMode;						// OPAQUE/TRASPARENT		     
	int		ropFunction;						// logical operation on GC						
    int		stretchMode;					// SetStretchBltMode		
    int		polyFillMode;					// ALTERNATE or WINDING fill mode.

	COLORREF 		textColor;				// Pixel for TextColor	(each are COLOREF's)	
	COLORREF 		penColor;				// Pixel for PenColor		
	COLORREF 		brushColor;			// Pixel for BrushColor		
	COLORREF 		backColor;			// Pixel for BackgroundColor	 

    int		penStyle;							// PS_XX for null pen, etc.	
    short	penWidth;
    short	penHeight;

    void		*brushFillPat;					// PixPatHandle or *Pattern, see brushFillStyle.
    int		brushFlag;							// BFP_NULL do not fill.
    													// BFP_PIXMAP use FillCRect with brushFillPat as a PixPatHandle.
    													// BFP_BITMAP use FillRect with brushFillPat as a *Pattern. 
    													// BFP_PIXEL use PaintRect with brushColor.
	long		brushXOrigin;					// Origin
	LPDRVIMAGEDATA	lpDrvImage;	/* bitmap		*/
    
    void 		*updateRegion;					// Region for storing update info (RgnHandle)
	void		*clipRegion;						// Clip region of dc.
	void		*visibleRegion;					// Visible region of dc.
	void		*combinedRegion;				// The combination of all vis, update, and clip regions. Used for the graf port.
														// This region is in dc local coordinates and must be offset accordingly.
	int		clipOriginX, clipOriginY;
	
    LPDRVFONTDATA lpFontData;		/* driver font data ptr */
														
    void*		hPrint;							//	TPrint handle
														
} DRIVERDC;
typedef DRIVERDC *LPDRIVERDC;

#define	IS_PRINTING_DC(lpddc)		(( lpddc->hPrint!=nil ) ? true : false )



/* Prototypes */
int DrvSelectDC(int save, LPDRIVERDC dc);

/* Definitions */
#define SAVE			TRUE			/* For use with the DrvSelectDC call */
#define RESTORE		FALSE






#endif		/* DrvDC__h */
