/********************************************************************
*   DrvImages.h
*
*   Private definitions for imaging driver subsustem	
*
*   Copyright (c) 1994-1997, Willows Software Inc.  All rights reserved.
*   
********************************************************************/

#ifndef DrvImages__h
#define DrvImages__h

/* "@(#)DrvImages.h	1.5  12/22/95 17:41:37" */

typedef struct tagDRVIMAGEDATA {
    int nWidth;
    int nHeight;
    int nLinePad;
    int nBitsPixel;
    int nWidthBytes;
    int fMono;
    int fInvalid;
	PixMapHandle image;
} DRVIMAGEDATA;
typedef DRVIMAGEDATA *LPDRVIMAGEDATA;


/* Pixmap handling prototypes */
PixMapHandle DrvCreatePixmap(void *data, short width, short height, 
										short rowBytes, short bitsPerPix, short copyData);

PixMapHandle CreatePixmapFromRect(Rect srcRect);
PixMapHandle DrvCreatePixmapFromPixmap(PixMapHandle srcPixMap, Rect srcRect, Rect *newRect);
					  
void DrvDestroyPixmap(PixMapHandle pixMap, short freeData);

short DrvCopyPixMap(PixMapHandle srcPixMap, PixMapHandle destPixMap, 
								Rect srcRect, Rect destRect, long rasterOp);

long DrvGetPixmapBits(PixMapHandle pixMap, void *data);


#define TEMPPIXMAPDEPTH 8




#endif		/* DrvImages__h */
