/********************************************************************
*   DrvInit.c
*
*   Macintosh device specific driver and sub-system initialization.
*
*   Copyright (c) 1994-1997, Willows Software Inc.  All rights reserved.  
********************************************************************/

/* Standard includes */
#include <SIOUX.h>
#include <stdio.h>
#include <console.h>
#include <setjmp.h>
#include <MWException.h>

#include <Fonts.h>
#include <TextEdit.h>
#include <Dialogs.h>
#include <SegLoad.h>
#include <Gestalt.h>

/* Driver includes */
#include "DrvHook.h"
#include "Log.h"
#include "compat.h"
#include "DrvMenus.h"
#include "DrvKeyboard.h"
#include "DrvErrors.h"
#include "DrvSystem.h"
#include "DrvGraphics.h"
#include "DrvEvents.h"

static OSInitialized = false;

/* this is exported to other driver subsystems, but NOT to the library */
TWINLIBCALLBACKPROC LibCallback;

/* Exported prototypes */
int InitOS(void);

#define INIT 1

/********************************************************************
*   PrivateInitDriver
*
* wFunc has to be DSUBSYSTEM_INIT 
* dwParam1 - compatibility mask
* dwParam2 - init/exit flag
* lpStruct - points to the structure to fill
********************************************************************/
DWORD PrivateInitDriver(WORD wFunc, LPARAM dwParam1, LPARAM dwParam2, LPVOID lpStruct)
{
UINT uiCompatibility = (UINT)dwParam1;
LPTWINDRVCONFIG lpDrvConfig = (LPTWINDRVCONFIG)lpStruct;

	switch (wFunc) {
	
	case DSUBSYSTEM_INIT:

    if (dwParam2 == 0) { 							/* Exit */
		LOGSTR((LF_DRIVER,"PrivateInitDriver: system exit\n"));
		return 0L;
	}
	else {													/* Init */
		LOGSTR((LF_DRIVER,"PrivateInitDriver: system init\n"));

		InitOS();

		/* Here is our all important lifeline back to the library!! */
		LibCallback = lpDrvConfig->lpDrvCallback;

		/* Holding down the option-period keys drops into debugger. */
		if (IsKeyPressed(AK_period) && IsKeyPressed(AK_Control))
			DropIntoDebugger(NULL);

		/* Initialize the core subsystems */
//		DRVCALL_SYSTEM(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateSystemHook(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
//		DRVCALL_EVENTS(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateEventHook(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
//		DRVCALL_WINDOWS(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateWindowsHook(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);

		/* Initialize the other subsytems */
//		DRVCALL_COLORS(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateColorsHook(DSUBSYSTEM_INIT,uiCompatibility,INIT,NULL);
//		DRVCALL_KEYBOARD(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateKeyboardHook(DSUBSYSTEM_INIT,uiCompatibility,INIT,NULL);
//		DRVCALL_TEXT(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateTextHook(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
//		DRVCALL_GRAPHICS(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateGraphicsHook(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
//		DRVCALL_DC(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateDCHook(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
//		DRVCALL_IPC(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateIPCHook(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
//		DRVCALL_IMAGES(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateImageHook(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
//		DRVCALL_REGIONS(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
		PrivateRegionsHook(DSUBSYSTEM_INIT, uiCompatibility, INIT, NULL);
//		DRVCALL_CURSORS(DSUBSYSTEM_INIT, 0, INIT, NULL);
		PrivateCursorHook(DSUBSYSTEM_INIT, 0, INIT, NULL);
//		DRVCALL_CURSORS(PCH_SETCLIPCURSOR, 0, 0, NULL);
		PrivateCursorHook(PCH_SETCLIPCURSOR, 0, 0, NULL);

		/* Return dimentions of the display, library puts these values into the SysMetrics.c structure */		
		lpDrvConfig->nScreenWidth = DisplaySize(DP_WIDTH);
		lpDrvConfig->nScreenHeight = DisplaySize(DP_HEIGHT);

		return 1L;
    }
    
    case DSUBSYSTEM_GETCAPS:

		LOGSTR((LF_DRIVER,"PrivateInitDriver: MacOS init\n"));
		InitOS();
		return 1L;
		
	default:
		break;
	}
	
	return(0L);
}



/****************************************************************
*	InitOS
*
*	Initialize all of the toolbox managers, also verify color quickdraw is available.
****************************************************************/
int InitOS(void)
{
OSErr		err;
SysEnvRec	theWorld;
long vers;
unsigned long secs;

	if(OSInitialized)
		return(true);				/* Been here, done that! */

	/* Perform the CRITICAL system initializations. */
	InitGraf(&(qd.thePort));
	InitFonts();
	InitWindows();
	InitMenus();
	InitCursor();
	TEInit();
	FlushEvents( everyEvent, 0 );
	InitDialogs(NULL);

	MaxApplZone();
	MoreMasters();

#ifdef DebugDCs
    TPKInitRgns();
#endif

	OSInitialized = true;

	GetDateTime(&secs);		/* Get the current date in seconds */
	qd.randSeed = secs;			/* Set the random seed to the current date in seconds */

	/*	Test the computer to be sure we can do color. */
	err = SysEnvirons(1, &theWorld);
	if (theWorld.hasColorQD == false) 	{
		AlertMsg("Sorry, color QuickDraw required to continue.", STOPALERT);
		ExitToShell();					/* If no color QD, we must leave. */
	}

    /* Check system version */
    Gestalt(gestaltSystemVersion, &vers);
    vers = (vers >> 8) & 0xf;                               /* shift result over and mask out major version number */
    if (vers < 7) {
		AlertMsg("Sorry, System 7.0 or greater is required.", STOPALERT);
        ExitToShell();
    }

	/* Add keyUp to the mask (does not seem to stay set though!)*/
	SetEventMask(everyEvent);			/* We should undo this later */

#ifdef SHOWCONSOLE
		/* Setup the console */
		SIOUXSettings.standalone = FALSE;
		SIOUXSettings.setupmenus = FALSE;
		SIOUXSettings.initializeTB = FALSE;
		SIOUXSettings.autocloseonquit = TRUE;
		SIOUXSettings.asktosaveonclose = FALSE;
#endif

	/* Make sure our callbacks are in place */
	InitAppleEvents();

	DrvBuildMenuBars();

	return(true);
}
