/********************************************************************
*   DrvKeyboard.h
*
*   Copyright (c) 1994-1997, Willows Software Inc.  All rights reserved.  
********************************************************************/

#ifndef DrvKeyboard__h
#define DrvKeyboard__h

/* "@(#)DrvKeyboard.h	1.3  11/13/95 12:01:31" */

/* Check for a particular key down */
/* Use the AK_XXX constants */
short IsKeyPressed(unsigned short keyCode);
DWORD PostAltF4Keystroke(void);


#define	KT_TYPE			0
#define	KT_SUBTYPE		1
#define	KT_NUMFKEYS	2

#define KS_UNSHIFTED   0
#define KS_SHIFTED      1

#ifndef OEMVK_KEYS
#define OEMVK_KEYS

#define VK_1	0x31
#define VK_2	0x32
#define VK_3	0x33
#define VK_4	0x34
#define VK_5	0x35
#define VK_6	0x36
#define VK_7	0x37
#define VK_8	0x38
#define VK_9	0x39
#define VK_0	0x30

#define VK_A	0x41
#define VK_B	0x42
#define VK_C	0x43
#define VK_D	0x44
#define VK_E	0x45
#define VK_F	0x46
#define VK_G	0x47
#define VK_H	0x48
#define VK_I		0x49
#define VK_J	0x4a
#define VK_K	0x4b
#define VK_L	0x4c
#define VK_M	0x4d
#define VK_N	0x4e
#define VK_O	0x4f
#define VK_P	0x50
#define VK_Q	0x51
#define VK_R	0x52
#define VK_S	0x53
#define VK_T	0x54
#define VK_U	0x55
#define VK_V	0x56
#define VK_W	0x57
#define VK_X	0x58
#define VK_Y	0x59
#define VK_Z	0x5a

#define VK_OEM_SCROLL	0x91

#define VK_OEM_1	0xba
#define VK_OEM_PLUS	0xbb
#define VK_OEM_COMMA	0xbc
#define VK_OEM_MINUS	0xbd
#define VK_OEM_PERIOD	0xbe
#define VK_OEM_2	0xbf

#define VK_OEM_3	0xc0

#define VK_OEM_4	0xdb
#define VK_OEM_5	0xdc
#define VK_OEM_6	0xdd
#define VK_OEM_7	0xde
#define VK_OEM_8	0xdf

#define VK_ALT		0x2a  /* OEM specific key, to map to external ALT */
#endif

/* virtual key array: maps vk_keys to ascii keys */
typedef struct tagKEYSTATE
{
    UINT	virtual;			/* vk keys to return based on keycode 	*/
    UINT	keypad;			/* vk keys if NUMLOCK 			*/

    UINT	vkUnshifted;	/* wm_char to return for given vk_key   */
    UINT	vkShifted;	

    UINT 	vk_state;	/* state of vk_key */
} KEYSTATE;

typedef struct tagKEYTABLE
{
    UINT	FromCode;
    UINT	ToCode;
    char *name;
} KEYTABLE;



#define AK_DEADKEY		0xFF

/* Apple Extended Keyboard II virtual key codes */
#define AK_BackSpace		0x33
#define AK_Tab				0x30
#define AK_Clear				0x47
#define AK_Return			0x24
#define AK_KP_Enter		0x4C
#define AK_Shift_L			0x38
#define AK_Shift_R			0x38
#define AK_Control			0x3B
#define AK_Control_L		AK_Control
#define AK_Control_R		AK_Control
#define AK_Command		0x37
#define AK_Menu				AK_Command	// Command key
#define AK_Pause				0x71		// F15 - <shift> Pause
#define AK_Caps_Lock		0x39
#define AK_space				0x31
#define AK_Prior				0x74		// Page up
#define AK_Next				0x79		// Page down
#define AK_End					0x77
#define AK_Home				0x73
#define AK_Left				0x7B		// Arrow
#define AK_Up					0x7E			// Arrow
#define AK_Right				0x7C		// Arrow
#define AK_Down				0x7D		// Arrow
#define AK_Select			AK_DEADKEY		// ????
#define AK_Option			0x3A
#define AK_Alt_R				AK_Option
#define AK_Alt_L				AK_Option
#define AK_Break				0x71		// F15 break and <shift> pause
#define AK_Print				0x69		// F13 - <shift> Print Screen
#define AK_Execute			AK_DEADKEY		// ????
#define AK_Insert				0x72		// Help - <shift>Ins
#define AK_Delete			0x75
#define AK_Help				0x72		// Help - <shift>Ins

#define AK_0					0x1D
#define AK_1					0x12
#define AK_2					0x13
#define AK_3					0x14
#define AK_4					0x15
#define AK_5					0x17
#define AK_6					0x16
#define AK_7					0x1A
#define AK_8					0x1C
#define AK_9					0x19

#define AK_a					0x00
#define AK_b					0x0B
#define AK_c					0x08
#define AK_d					0x02
#define AK_e					0x0E
#define AK_f					0x03
#define AK_g					0x05
#define AK_h					0x04
#define AK_i						0x22
#define AK_j					0x26
#define AK_k					0x28
#define AK_l						0x25
#define AK_m					0x2E
#define AK_n					0x2D
#define AK_o					0x1F
#define AK_p					0x23
#define AK_q					0x0C
#define AK_r					0x0F
#define AK_s					0x01
#define AK_t					0x11
#define AK_u					0x20
#define AK_v					0x09
#define AK_w					0x0D
#define AK_x					0x07
#define AK_y					0x10
#define AK_z					0x06

#define AK_KP_0				0x52
#define AK_KP_1				0x53
#define AK_KP_2				0x54
#define AK_KP_3				0x55
#define AK_KP_4				0x56
#define AK_KP_5				0x57
#define AK_KP_6				0x58
#define AK_KP_7				0x59
#define AK_KP_8				0x5B
#define AK_KP_9				0x5C

#define AK_KP_Multiply	0x43
#define AK_KP_Add			0x45
#define AK_KP_Separator	0x51		// Keypad "="
#define AK_KP_Subtract	0x4E
#define AK_KP_Decimal	0x41
#define AK_KP_Divide		0x4B

#define AK_F1					0x7A
#define AK_F2					0x78
#define AK_F3					0x63
#define AK_F4					0x76
#define AK_F5					0x60
#define AK_F6					0x61
#define AK_F7					0x62
#define AK_F8					0x64
#define AK_F9					0x65
#define AK_F10				0x6D
#define AK_F11				0x67
#define AK_F12				0x6F
#define AK_F13				0x69
#define AK_F14				0x6B
#define AK_F15				0x71
#define AK_F16				AK_DEADKEY

#define AK_Num_Lock		0x47
#define AK_Scroll_Lock	0x6B		// F14 and <shift> scroll lock

#define AK_semicolon		0x29
#define AK_equal				0x18
#define AK_comma			0x2B
#define AK_minus				0x1B
#define AK_period			0x2F
#define AK_slash				0x2C

#define AK_quoteleft		0x32		// Left quote and tilde

#define AK_bracketleft		0x21
#define AK_backslash		0x2A
#define AK_bracketright	0x1E
#define AK_quoteright		0x27

#define AK_Escape			0x35
#define AK_Cancel			AK_DEADKEY			// ????

#endif




