/*	
    DrvMemory.c	1.2 
    Copyright 1997 Willows Software, Inc. 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.

The maintainer of the Willows TWIN Libraries may be reached (Email) 
at the address twin@willows.com	

*/


/* Memory allocation support for the library  */

#include "DrvHook.h"

DWORD PrivateMemoryHook(WORD dwCode, LPARAM dwParam1,	LPARAM dwParam2, LPVOID lpStruct)
{

    switch(dwCode) {
 	/* dwParam1 - number of bytes to allocate */
	case PMH_ALLOCMEM:
		return (DWORD) DrvMalloc(dwParam1);
			
	/* dwParam1 - number of bytes */
	/* lpStruct - pointer to realloc */
	case PMH_REALLOCMEM:
		return (DWORD) DrvRealloc(lpStruct, dwParam1);

	/* lpStruct - address to free */
	case PMH_FREEMEM:
		DrvFree(lpStruct);
		return 1L;

	case PMH_ALLOCMEMCHECK:
		return (DWORD) DrvMallocCheck(dwParam1,
						((LPTWINDRVMALLOC)lpStruct)->lparam,
						((LPTWINDRVMALLOC)lpStruct)->wparam,
						((LPTWINDRVMALLOC)lpStruct)->flag,
						((LPTWINDRVMALLOC)lpStruct)->handle);
									
	case PMH_REALLOCMEMCHECK:
		return (DWORD) DrvReallocCheck(
						((LPTWINDRVMALLOC)lpStruct)->theptr,
									dwParam1,
						((LPTWINDRVMALLOC)lpStruct)->lparam,
						((LPTWINDRVMALLOC)lpStruct)->wparam,
						((LPTWINDRVMALLOC)lpStruct)->flag,
						((LPTWINDRVMALLOC)lpStruct)->handle);

	case PMH_FREEMEMCHECK:
		DrvFreeCheck(	((LPTWINDRVMALLOC)lpStruct)->theptr,
						((LPTWINDRVMALLOC)lpStruct)->lparam,
						((LPTWINDRVMALLOC)lpStruct)->wparam);
		return 1L;

	default:
	    return (0L);						/* eventually, make this blow up */
	}
}
