/********************************************************************
*   DrvMenus.c
*
*   Top level menu functional implementation.
*
*   Copyright (c) 1995-1997, Willows Software Inc.  All rights reserved.
********************************************************************/

#include <Dialogs.h>
#include <Menus.h>

#include "DrvMenus.h"
#include "DrvErrors.h"
#include "DrvWindows.h"
#include "DrvKeyboard.h"
#include "DrvGlobals.h"

/* Local function definintions */
static void ChooseFile(short item);
static void RunDeskAccesory(short item);


/********************************************************************
*	BuildMenuBars
*
*	Handles the top level macintosh window.
*********************************************************************/
void DrvBuildMenuBars(void)
{
MenuHandle	appleMenu, fileMenu, editMenu;

	/* create "Apple" menu */
	appleMenu = NewMenu(APPLE_MENU, "\p\024" );		
	AppendMenu(appleMenu, "\pAbout...");
	AppendMenu(appleMenu, "\p(-" );			/* dotted line */
	AddResMenu(appleMenu, 'DRVR' );			/* Add DA list */
	InsertMenu(appleMenu, 0 );						/* install in menu bar */

	/* Create the File menu */
	fileMenu = NewMenu(FILE_MENU, "\pFile" );
	AppendMenu(fileMenu, "\pClose/W;(-;Quit/Q" );
	InsertMenu(fileMenu, 0 );

	/* Create the Edit menu */
	editMenu = NewMenu(EDIT_MENU,"\pEdit" );
	AppendMenu(editMenu, "\pUndo/Z;(-;Cut/X;Copy/C;Paste/V;Clear" );
	InsertMenu(editMenu, 0 );
	DisableItem(editMenu, 0);			/* disable the entire menu */
	
	DrawMenuBar();	/* display: Apple   File   Edit  */

}



/********************************************************************
*	MenuDispatch
*
*	Handles the top level macintosh window.
*********************************************************************/
void DrvMenuDispatch(short menuNumber, short itemNumber)
{
	if(menuNumber != 0)
		switch(menuNumber) {
		case APPLE_MENU:
			if(itemNumber == APPLE_ABOUT)
				ShowAboutWindow();
			else
				RunDeskAccesory(itemNumber);
			break;
		
		case FILE_MENU:
			ChooseFile(itemNumber);
			break;
			
		case EDIT_MENU:
			SystemEdit(itemNumber-1);
			break;
			
		default:
			break;
		}
}


/********************************************************************
*	ChooseFile
*
*	Handles the File menu
*********************************************************************/
static void ChooseFile(short item)
{
	switch(item) {
	case FILE_CLOSE:		
		CloseFrontWindow();		
		break;

	case FILE_QUIT:
		PostAltF4Keystroke();	
		break;
	
	default:			break;
	}
}


/********************************************************************
*	RunDeskAccesory
*
*	Launches a desk accesory.
*********************************************************************/
static void RunDeskAccesory(short item)
{
	GrafPtr		savePort;
	short		daRefNum;
	Str255		daName;
	
	GetPort(&savePort);

	GetItem(GetMHandle(APPLE_MENU), item, daName);

	daRefNum = OpenDeskAcc(daName);
	SetPort(savePort);
}

#ifdef LATER
/* jco: Mac Menu Bar */
DrvSetNativeMenuBar(LPSTR lpsz)
{
	LPSTR stringPointer = lpsz;
	int menuID = 256;
	MenuHandle menuHandle;
	
	/* really need to dispose of existing menus */
	/* plus, I don't really need to recreate the Apple menu each time */
	ClearMenuBar();
	menuHandle = NewMenu(menuID++, "\p\024");
	AppendMenu(menuHandle, "\pAbout ;(-");
	AppendResMenu(menuHandle, 'DRVR');
	InsertMenu(menuHandle, 0 );						/* install in menu bar */
	
	while(strlen(stringPointer)) {
		menuHandle = NewMenu(menuID++, CtoPstr(stringPointer));
		InsertMenu(menuHandle, 0);
		stringPointer += stringPointer[0] + 1;
	}
	DrawMenuBar();
}

short
MenuIDFromX(short x)
{
#pragma options align=mac68k
	typedef struct tagMenuInMenuList
	{
		MenuHandle menuHandle;
		short leftEdge;
	} MenuInMenuList;
	
	typedef struct tagMenuList
	{
		short lastMenu;
		short lastRight;
		short mbResID;
		struct tagMenuInMenuList menus;
	} MenuList;
	typedef MenuList *MenuListPtr;
	typedef MenuListPtr *MenuListHandle;
#pragma options align=reset
	
	MenuListHandle menuList;
	short rightEdge;
	short leftEdge;
	int i, numMenus;
	short menuID, currentMenuID, nextMenuID;
	MenuHandle menuHandle;
	MenuInMenuList *menus;
	
	menuList = (MenuListHandle)LMGetMenuList();
	numMenus = (((**menuList).lastMenu) / sizeof(MenuInMenuList));
	menus = &((**menuList).menus);
	
	menuID = 0;
	
	for(i=0; i < numMenus; i++)
	{
		leftEdge = menus[i].leftEdge;			/* setting left edge is easy */
		if(i < numMenus - 1) {					/* if not the rightmost menu (the process menu) */
			menuHandle = menus[i].menuHandle;
			currentMenuID = (**menuHandle).menuID;	/* get menuID of the current menu */
			menuHandle = menus[i+1].menuHandle;
			nextMenuID = (**menuHandle).menuID;		/* get menuID of the next menu in menuList */
			/* if current menuID is positive, and next menuID is negative, */
			/* then we're at the break between left and right aligned menus */
			if(nextMenuID < 0 && currentMenuID > 0)	
				rightEdge = (**menuList).lastRight;	/* at break.  right is "lastRight" */
			else
				rightEdge = menus[i+1].leftEdge;	/* not at break.  right is next's left */
		} else {
			GDHandle gdh = GetMainDevice();			/* we're at last menu (the process menu) */
			rightEdge = (**gdh).gdRect.right - menus[0].leftEdge;	/* right edge is same distance from right that first menu is from left */
		}
		if( x >= leftEdge && x <= rightEdge) {		/* now that we've set left & right edges, see if we're within 'em */
			menuHandle = menus[i].menuHandle;		/* yup, lets get our menuID and get out of here */
			menuID = (**menuHandle).menuID;
			break;
		}
	}
	return menuID;
}

/********************************************************************
*	DrvMenuSelect
*
*	Custom version of MenuSelect that doesn't use Mac OS Menu Manager
*********************************************************************/
long
DrvMenuSelect(Point startPt)
{
	Point currentPt;
	short menuID;
	
	/* determine the menu based on startPt */
	/* startPt is already in global coordinates? */
	menuID = MenuIDFromX(startPt.h);
	HiliteMenu(menuID);
	
	while(WaitMouseUp()) {
	/* track the mouse */
	GetMouse(&currentPt);
	LocalToGlobal(&currentPt);
	menuID = MenuIDFromX(currentPt.h);
	HiliteMenu(menuID);
	/* for now, I don't handle Mac OS system menus */
	if( menuID < 0 || menuID == 256) continue;
	
	}
}
#endif
