
/********************************************************************
*   DrvRopCodes.h
*
*   Macintosh device specific raster-op code implementation.
*
*   Copyright (c) 1994-1997, Willows Software Inc.  All rights reserved.  
********************************************************************/
#ifndef DrvRopCodes__h
#define DrvRopCodes__h

/*	"@(#)DrvROPCodes.h	1.3 :/users/sccs/src/win/mac/s.DrvROPCodes.h 9/27/96 13:14:21" */

#define RI_1		R2_BLACK				/* 0			GXclear	*/
#define RI_2 	R2_NOTMERGEPEN		/* DPon	GXnor	*/  
#define RI_3 	R2_MASKNOTPEN		/* DPna	GXandInverted	*/  
#define RI_4 	R2_NOTCOPYPEN		/* Pn  		GXcopyInverted	*/ 
#define RI_5 	R2_MASKPENNOT		/* PDna	GXandReverse	*/
#define RI_6 	R2_NOT					/* Dn  		GXinvert	*/
#define RI_7 	R2_XORPEN				/* DPx 	GXxor	*/
#define RI_8 	R2_NOTMASKPEN		/* DPan	GXnand	*/
#define RI_9 	R2_MASKPEN			/* DPa 	GXand	*/
#define RI_10	R2_NOTXORPEN			/* DPxn	GXequiv	*/
#define RI_11	R2_NOP					/* D   		GXnoop	*/
#define RI_12	R2_MERGENOTPEN		/* DPno	GXorInverted	*/
#define RI_13	R2_COPYPEN				/* P   		GXcopy	*/
#define RI_14	R2_MERGEPENNOT		/* PDno	GXorReverse	*/
#define RI_15	R2_MERGEPEN			/* DPo 	GXor	*/
#define RI_16	R2_WHITE					/* 1			GXset	*/

#define ROP_BD	0x0100	/* fill dest with brush */
#define ROP_FD	0x0200  	/* fill dest w/o brush */
#define ROP_SD	0x0300	/* copy src into dest	*/
#define ROP_DB	0x8400	/* create pixmap; combine dest with brush into pixmap */
#define ROP_DS	0x8500	/* create pixmap; combine dest with src into pixmap */
#define ROP_SB	0x8600	/* create pixmap; combine src with brush into pixmap */
#define ROP_SP	0x0700  	/* copy src into pixmap */
#define ROP_BP	0x0800  	/* fill pixmap with brush */
#define ROP_PD	0x0900  	/* copy pixmap into dest */

/* Opcodes to determine the pixmaps involved */
#define OP_SRC		0x01
#define OP_DEST		0x02
#define OP_BRUSH	0x04
#define OP_TMP		0x08

#define OP_NOP		0
#define OP_SD			OP_SRC | OP_DEST
#define OP_BD			OP_BRUSH | OP_DEST
#define OP_BSD		OP_BRUSH | OP_SRC | OP_DEST
#define OP_BSDT		OP_BRUSH | OP_SRC | OP_DEST | OP_TMP

typedef struct {
	DWORD   dwROP;
	WORD	opcode;
	WORD	bRops[4];
} ROPtable;


extern int ROPS[];				/* Translates R2_COPYPEN to srcCopy ... */
extern ROPtable ROPTab[];	/* ROP Engine table, the magic four steps! */


#endif /* DrvROPCodes__h */
