/********************************************************************
*   DrvSupport.c
*
*   Macintosh drivers support implementation.
*
*   Copyright (c) 1994-1997, Willows Software Inc.  All rights reserved.  
********************************************************************/

#include <string.h>
#include <ctype.h>

#include "MacSupport.h"
#include "StringUtils.h"


/********************************************************************
*   TwinMac_GetQDGlobals
*
*   Return the real, initialized, qd globals pointer.  
********************************************************************/
QDGlobals *TwinMac_GetQDGlobals(void)
{
	return (&qd);
}


/********************************************************************
*   TwinMac_GetAppName
*
*   Return the name of this application.  
********************************************************************/
char *TwinMac_GetAppName(char *appName, int size)
{
short err;
ProcessSerialNumber psn;
ProcessInfoRec psInfo;
Str255 procName;
char *cProcName;

	/* Get information about ourselves */
	GetCurrentProcess(&psn);
	psInfo.processNumber = psn;
	psInfo.processInfoLength = sizeof(ProcessInfoRec);
	psInfo.processAppSpec = NULL;		/* We do not want location now */
	psInfo.processName = procName;
	err = GetProcessInformation(&psn, &psInfo);
	
	/* Convert name and copy */
	cProcName = p2cstr(procName);
	strncpy(appName, cProcName, size);
	appName[size-1] = '\0';
	
	return(appName);
}

/*************************************************
*	strlwr
*
*	convert string to lower case
*************************************************/
char *
strlwr(char *s)
{
    char *p;

    p = s;
    while (*p != 0)
    {
        if (isupper(*p))
            *p = tolower(*p);
        p++;
    }

    return(s);
}
