/********************************************************************
*   DrvSystem.h
*
*   Copyright (c) 1994-1997, Willows Software Inc.  All rights reserved.  
********************************************************************/

#ifndef DrvSystem__h
#define DrvSystem__h

#include <stdio.h>
#include "WinMalloc.h"

/* Memory allocation, all memory must be allocated using these calls at the driver level */
void *DrvMalloc(size_t theSize);
void *DrvRealloc(void *thePtr, size_t theSize);
void DrvFree(void *thePtr);

/* Memory allocation from the library, must be used if the library will dispose of the memory. */
void *LibMalloc(size_t theSize);
void *LibRealloc(void *thePtr, size_t theSize);
void LibFree(void *thePtr);

/* Our exit routine */
void DrvFatalExit(short exitCode);

char *GetEnv(const char *env);
int DrvGetCommandLine(int argc, char ***argv);

/* Directory and OS Utilities */
void DropIntoDebugger(char *msg);


#ifdef DRVMALLOC_CHECK

LPVOID	DrvMallocCheck(unsigned int, char *,int,int,int);
LPVOID	DrvReallocCheck(LPVOID,unsigned int, char *,int,int,int);
void	DrvFreeCheck(LPVOID,char *,int);

#define DrvMalloc(s) 	DrvMallocCheck(s,__FILE__,__LINE__,0,0)
#define DrvFree(l)	DrvFreeCheck(l,__FILE__,__LINE__)
#define DrvRealloc(l,s)	DrvReallocCheck(l,s,__FILE__,__LINE__,0,0)

#define DRVMALLOC(s,t,h)    DrvMallocCheck(s,__FILE__,__LINE__,t,h)
#define DRVFREE(l) 	    DrvFreeCheck(l,__FILE__,__LINE__)
#define DRVREALLOC(l,s,t,h) DrvReallocCheck(l,s,__FILE__,__LINE__,t,h)
#else

LPVOID DrvMalloc(unsigned long);
void  DrvFree(LPVOID);
LPVOID DrvRealloc(LPVOID,unsigned long);

#define DRVMALLOC(s,t,h)    DrvMalloc(s)
#define DRVFREE(l) 	    DrvFree(l)
#define DRVREALLOC(l,s,t,h) DrvRealloc(l,s)
#endif

#endif		/* DrvSystem__h */
