/********************************************************************
*   DrvText.h
*
*   Macintosh driver text sub-system implementation.
*
*   Copyright (c) 1995-1997, Willows Software Inc.  All rights reserved.
********************************************************************/

#ifndef DrvText__h
#define DrvText__h

/****************************************************************************
 * Driver Dependent Font Declaration
 ****************************************************************************/
typedef struct tagDRVFONTDATA {
	/* display device specific corollaries 				     */
	char     	*familyName;						/* what string to load for this font */
	short	fontID;									/* device dependent font family ID    */
	Style	face;
	int   		fontSize;								/* what is the height */
	int		ascent, descent;					/* aspect of font	*/
	int		intLeading, extLeading;

   	int 		isTrueType;							/* what type of font RASTER_FONTTYPE or TRUETYPE_FONTTYPE */
	int		nLock;									/* Number of dc's using the font structure for caching */
	
	/* Log font text metrics */
	int tmHeight, tmWeight, tmItalic, tmUnderlined, tmStruckOut;
} DRVFONTDATA, *LPDRVFONTDATA;



#endif			/* DrvText__h */

