/********************************************************************
*   DrvUtils.h
*
*   Macintosh driver utilities.
*
*   Copyright (c) 1994-1997, Willows Software Inc.  All rights reserved.
********************************************************************/
#ifndef DrvUtils__h
#define DrvUtils__h

#include "StringUtils.h"		/* Supply the string utilities as well */


/* Macro to simplify rectangle conversion */
#define WINRECT2MACRECT(winR, macR) 	\
	(macR)->left 	= (winR)->left;				\
	(macR)->right 	= (winR)->right;			\
	(macR)->top 		= (winR)->top;				\
	(macR)->bottom = (winR)->bottom		

/* Macro to simplify rectangle assignment */
#define SETRECTMAC(macR, x1, y1, x2, y2) 	\
	(macR)->left 		= x1;								\
	(macR)->right 		= x2;								\
	(macR)->top 			= y1;								\
	(macR)->bottom 	= y2								

/* Macro to simplify setting a mac rect from x,y,width,height coords */
#define SETMACRECTFROMXYWH(macR, x, y, cx, cy)	\
	(macR)->left			= x;											\
	(macR)->top	 		= y;											\
	(macR)->right		= (x) + (cx);								\
	(macR)->bottom 	= (y) + (cy)						

/* Sets the mac RGBColor structure from a COLOREF */
#define COLORREFTOMACRGB(cr, rgbColor) 			\
	(rgbColor)->red 		= GetRValue(cr) * 256;		\
	(rgbColor)->green 	= GetGValue(cr) * 256;		\
	(rgbColor)->blue 		= GetBValue(cr) * 256

/* Sets the mac RGBColor structure from a COLOREF */
#define MACRGBTOCOLORREF(rgbColor)	 			\
			RGB(((rgbColor)->red >> 8), 						\
				((rgbColor)->green >> 8), 						\
				((rgbColor)->blue >> 8))

#define EQUALRGBCOLORS(a, b)							\
			(((a)->red == (b)->red) && ((a)->green == (b)->green) && ((a)->blue == (b)->blue))

/* Functions to simplify rectangle assignment, and reduce code size */
void WinRect2MacRect(RECT *winR, Rect *macR);
void MacRect2WinRect(Rect *macR, RECT *winR);


/* Misc helper functions and macros */
#define RECTWIDTH(macR)	((macR)->right - (macR)->left)
#define RECTHEIGHT(macR)	((macR)->bottom - (macR)->top)
int AbsSizeOfRect(Rect r, short width);
void ResetRect(Rect *r);
void NormalizeRect(Rect *r, short reset);					
short IsFlipped(Rect *srcRect, Rect *destRect);
short IsStretched(Rect *srcRect, Rect *destRect);

/* Codes returned from IsFlipped */
#define NOFLIP	0x00
#define FLIPH	0x01		
#define FLIPV	0x02


extern RGBColor blkRgbColor, whtRgbColor;


Boolean BitTest(long testWord, short bitNum);		/* MSB...LSB */


#endif		/* DrvUtils__h */
