/********************************************************************
*   TwinGlue.c
*
*   Glue for supporting the C libraries.
*
*   Copyright (c) 1995, Willows Software Inc.  All rights reserved.
********************************************************************/

static char *TwinGlue_c =  "IDENT:  @(#)TwinGlue.c	1.1 12/6/95 11:24:40";

/********************************************************************
*	This file will be made into a shared library that exports these global variables.
*	To allow correct access to the one and only qd global and exit jump buffers, these
*	 variables are provided here.  For it to work correctly, the library must be set to
*	 "Initialize Before" so that the variables are loaded prior to the __start function call. 
*
*	This TwinGlue shared library is then to be included by any library using the C library.
*
********************************************************************/

#include <QuickDraw.h>
#include <setjmp.h>


/* This is the C runtime glue we need to support */
QDGlobals qd;								/*	define the Quickdraw globals here!	*/
jmp_buf __program_exit;				/*	exit() does a longjmp() to here		*/
void (*__atexit_hook)(void);		/*	atexit()  sets this up if it is ever called	*/
void (*___atexit_hook)(void);		/*	_atexit() sets this up if it is ever called	*/
int __aborting;								/*	abort() sets this and longjmps to __program_exit	*/




