/********************************************************************
*   TwinStartup.c
*
*   Replacement _start routine.
*
*   Copyright (c) 1994, Willows Software Inc.  All rights reserved.  
********************************************************************/

/* "@(#)TwinStartup.c	1.1  12/6/95 11:24:57" */

#include <QuickDraw.h>
#include <setjmp.h>

/* This is the C runtime glue variables we need to support */
extern jmp_buf __program_exit;				/*	exit() does a longjmp() to here		*/
extern void (*__atexit_hook)(void);			/*	atexit()  sets this up if it is ever called	*/
extern void (*___atexit_hook)(void);		/*	_atexit() sets this up if it is ever called	*/
extern int __aborting;								/*	abort() sets this and longjmps to __program_exit	*/


/********************************************************************
*	__start
*
*	Perform the setup of the jump buffers and call the main() function.
*	This is copied directly from the Starup.c file provided by metrowerks.
********************************************************************/
void __start(void)
{
char *argv = 0;
	
	if (setjmp(__program_exit) == 0) {		//	set up jmp_buf for exit()
		main(0, &argv);								//	call main(argc, argv)
		if (__atexit_hook)
			__atexit_hook();							//	call atexit() procs
	}
	if (!__aborting) {
		__destroy_global_chain();				//	destroy static objects
		if (___atexit_hook)
			___atexit_hook();							//	call _atexit() procs
	}
}
