/*
    
	DragDrop.c	1.4
    	Copyright 1997 Willows Software, Inc. 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.


For more information about the Willows Twin Libraries.

	http://www.willows.com	

To send email to the maintainer of the Willows Twin Libraries.

	mailto:twin@willows.com 

 */

#include "windows.h"
#include "windowsx.h"
/*
#include "shellapi.h"
*/
#define __SHELLAPI_H__
#include "Willows.h"

#include "Log.h"
#include "DragDrop.h"

void WINAPI
DragAcceptFiles(HWND hWnd, BOOL fAccept)
{
    DWORD dwExStyle;

    LOGSTR((LF_SHELL,"DragAcceptFiles: hWnd %x fAccept %d\n",
	hWnd,fAccept));

    if (!IsWindow(hWnd))
	return;

    dwExStyle = GetWindowExStyle(hWnd);

    if (fAccept)
	dwExStyle |= WS_EX_ACCEPTFILES;
    else
	dwExStyle &= ~WS_EX_ACCEPTFILES;

    SetWindowLong(hWnd,GWL_EXSTYLE,dwExStyle);
}

UINT WINAPI
DragQueryFile(HDROP hDrop, UINT iFile, LPSTR lpszFile, UINT cb)
{
    LOGSTR((LF_SHELL,"DragQueryFile: hdrop %x ifile %x lpsz %s cb %d\n",
	hDrop,iFile,lpszFile?lpszFile:"NULL",cb));

    return 0;
}

BOOL WINAPI
DragQueryPoint(HDROP hDrop, POINT *lppt)
{
#ifdef	LATER
    HGLOBAL hGlobal = (HGLOBAL)hDrop;
    LPDRAGINFO lpDragInfo;

    if (NULL == (lpDragInfo = (LPDRAGINFO)GlobalLock(hGlobal)))
	return FALSE;

    lppt->x = lpDragInfo->x;
    lppt->y = lpDragInfo->y;

    LOGSTR((LF_SHELL,"DragQueryPoint: hdrop %x pt %d,%d\n",
	hDrop,lppt->x,lppt->y));

    GlobalUnlock(hGlobal);

    return TRUE;
#else
    return FALSE;
#endif
}

void WINAPI
DragFinish(HDROP hDrop)
{
    HGLOBAL hGlobal = (HGLOBAL)hDrop;

    LOGSTR((LF_SHELL,"DragFinish: hdrop %x\n",hDrop));

    GlobalFree(hGlobal);
}
