/*    
	OleSvr.c	2.4
    	Copyright 1997 Willows Software, Inc. 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.


For more information about the Willows Twin Libraries.

	http://www.willows.com	

To send email to the maintainer of the Willows Twin Libraries.

	mailto:twin@willows.com 

 */
#include "windows.h"
#include "windowsx.h"
#include "ole.h"
#include "Log.h"

static OLESERVER oleserver;
static OLESERVERVTBL vtbl;

OLESTATUS
OleBlockServer(LHSERVER lhsrvr)
{
    LOGSTR((LF_OLE,"OleBlockServer: STUB server %x\n",lhsrvr));
    return OLE_OK;
}

OLESTATUS
OleRegisterServer(LPCSTR lpszClass, LPOLESERVER lpsrvr,
		LHSERVER *lplhserver, HINSTANCE hInst,
		OLE_SERVER_USE srvuse)
{
    LOGSTR((LF_OLE,"OleRegisterServer: STUB class %s inst %x use %d\n",
	lpszClass,hInst,srvuse));

    vtbl = *lpsrvr->lpvtbl;
    oleserver.lpvtbl = &vtbl;

    *lplhserver = 0x100000;

    return OLE_OK;
}

OLESTATUS
OleRegisterServerDoc(LHSERVER lphsrvr, LPCSTR lpszDocName,
			LPOLESERVERDOC lpdoc, LHSERVERDOC *lplhdoc)
{
    LOGSTR((LF_OLE,"OleRegisterServerDoc: STUB server %x doc %s lpdoc %x\n",
	lphsrvr,lpszDocName,lpdoc));
    *lplhdoc = 0x100001;
    return OLE_OK;
}

OLESTATUS
OleRenameServerDoc(LHSERVERDOC lhDoc, LPCSTR lpszDocName)
{
    LOGSTR((LF_OLE,"OleRenameServerDoc: STUB lhdoc %x name %s\n",
	lhDoc,lpszDocName));
    return OLE_OK;
}

OLESTATUS
OleRevertServerDoc(LHSERVERDOC lhdoc)
{
    LOGSTR((LF_OLE,"OleRevertServerDoc: STUB lhdoc %x\n",lhdoc));
    return OLE_OK;
}

OLESTATUS
OleRevokeObject(LPOLECLIENT lpClient)
{
    LOGSTR((LF_OLE,"OleRevokeObject: STUB lpClient %x\n",lpClient));
    return OLE_OK;
}

OLESTATUS
OleRevokeServer(LHSERVER lhServer)
{
    OLESTATUS status = 0;

    LOGSTR((LF_OLE,"OleRevokeServer: STUB lhServer %x\n",lhServer));

    if (lhServer == 0x100000)
	status = oleserver.lpvtbl->Release(&oleserver);

    LOGSTR((LF_OLE,"OleRevokeServer: STUB Release returned %x\n",status));

    return status;
}

OLESTATUS
OleRevokeServerDoc(LHSERVERDOC lhdoc)
{
    LOGSTR((LF_OLE,"OleRevokeServerDoc: STUB lhdoc %x\n",lhdoc));
    return OLE_OK;
}

OLESTATUS
OleSavedServerDoc(LHSERVERDOC lhdoc)
{
    LOGSTR((LF_OLE,"OleSavedServerDoc: STUB lhdoc %x\n",lhdoc));
    return OLE_OK;
}

OLESTATUS
OleUnblockServer(LHSERVER lhsrvr,BOOL *lpfRequest)
{
    LOGSTR((LF_OLE,"OleUnblockServer: STUB server %x, flag addr %x\n",
			lhsrvr,lpfRequest));
	*lpfRequest = FALSE;
    return OLE_OK;
}
