/*    
	utils.c	2.20
    	Copyright 1997 Willows Software, Inc. 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.


For more information about the Willows Twin Libraries.

	http://www.willows.com	

To send email to the maintainer of the Willows Twin Libraries.

	mailto:twin@willows.com 

 */


#include "windows.h"
#include "utils.h"
#include "Log.h"
#include "ctype.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef __VMS
#include <unixio.h>
#endif 

static int      opnlog_fd = -2;
unsigned long	opnlog_id = 0;
static unsigned long	opnlog_id_init = 0;
static char     opnlog_fmt[64*1024];

#define LOG_INIT	0
#define LOG_NOOP	1
#define LOG_LOGGING	2
static int log_state = LOG_INIT;

static int
opnlog()
{
        char	*fn, *usp;

	if (log_state == LOG_LOGGING)
		return(opnlog_id); 
#ifndef	NETWARE
	if ( (fn = (char *)getenv("WIN_OPENLOG")) )
#else
	fn = "- -1";
#endif
	{
		if ( (usp = (char *)strchr(fn, ' ')) ) {
			*usp++ = '\0';
			opnlog_id = (unsigned long)strtol(usp,0,0);
		}

		if( strcmp(fn, "-") == 0 )
			return (opnlog_fd = 1);

		(void) unlink(fn);
		return (opnlog_fd = creat(fn, 0666));
	}
	opnlog_id_init = opnlog_id;

	return (opnlog_fd = 0);
}


unsigned long
TwinLogOff(/* void */)
{
	unsigned long oldval;
	oldval = opnlog_id;
	log_state = LOG_NOOP;
	opnlog_id = 0;
	return(oldval);
}

unsigned long
TwinLogOn(/* void */)
{
	unsigned long oldval;
	oldval = opnlog_id;
	log_state = LOG_LOGGING;
	if (opnlog_fd == -2)
		opnlog_fd = 1;
	opnlog_id = (unsigned long)(-1);
	return(oldval);
}

unsigned long
TwinLogReset(/* void */)
{
	unsigned long oldval;
	oldval = opnlog_id;
	opnlog_id = opnlog_id_init;
	if (opnlog_id)
		log_state = LOG_LOGGING;
	return(oldval);
}

unsigned long
TwinLogGet(/* void */)
{
	return(opnlog_id);
}

unsigned long
TwinLogSet(unsigned long setval)
{
	unsigned long oldval;

	oldval = opnlog_id;
	opnlog_id = setval;
	if (opnlog_id)
	{
		log_state = LOG_LOGGING;
		if (opnlog_fd == -2)
			opnlog_fd = 1;
	}
	return(oldval);
}

 

/*
 *   logstr should be called like
 *	  logstr(logtype, format, arg1, arg2...);	
 */


void TWIN_vslogstr(unsigned long flg, va_list args);

/*VARARGS */
void
logstr(unsigned long flg, ...)
{
	va_list args;

	va_start(args, flg);

	TWIN_vslogstr(flg, args);

	va_end(args);
}

void
TWIN_vslogstr (unsigned long flg, va_list args)
{
	char *fmt;

	switch(log_state) {
	case LOG_INIT:
		log_state = LOG_NOOP;
		if ( opnlog() )
			log_state = LOG_LOGGING;
		opnlog_id |= LF_ERRORS;	
		break;

	case LOG_NOOP:
	case LOG_LOGGING:
		/* point to fmt and args... */
		fmt = va_arg(args, char *);

		/* print out remainder of message locally */
		vsprintf(opnlog_fmt,fmt,args);

		/* if we are loggin this class, then write it out */
		if((log_state == LOG_LOGGING) && (flg & opnlog_id))
			write(opnlog_fd, opnlog_fmt, strlen(opnlog_fmt));
	}

	if(flg & LF_ERRORS)
		write(2, opnlog_fmt,strlen(opnlog_fmt));

}

/*
 *
 *	MessagePrintf(HWND hwnd, LPCSTR caption, UINT flags, LPCSTR fmt...)
 *
 */


int
MessagePrintf(HWND hwnd,LPCSTR caption, DWORD flags, ...)
{
	va_list args;
	char   *fmt;
	int	rc;
	
	va_start(args, flags);

	fmt = va_arg(args,char *);

	vsprintf(opnlog_fmt,fmt,args);

	rc = MessageBox(hwnd,opnlog_fmt,caption,flags);

	va_end(args);

	return rc;
}

void
DumpMemory(char *s,char *p,int n)
{
	int i,j;
	char x;
	char   *chrptr;
	char	buffer[132];
	char	temp[80];

	if(n==0)
		return;

	printf("%s:\n",s);
	for(i=0;i<n;i++) {
		sprintf(buffer,"%x: ",(unsigned int) p);
		chrptr = p;

		for(j=0;j<16;j++) {
			x=*p++;
			x &= 0xff;
			sprintf(temp,"%2.2x ",x&0xff);
			strcat(buffer,temp);
		}		
		strcat(buffer,"   ");
		p = chrptr;
		chrptr = buffer + strlen(buffer);
		for(j=0;j<16;j++) {
			if(isalnum(*p))
				*chrptr++ = *p;
			else	*chrptr++ = '.';
			p++;
		}	
		*chrptr = 0;

		i += 16;
		strcat(buffer,"\n");
		printf("%s",buffer);
	}
}

