/*    
	WinBin.c	2.5
    	Copyright 1997 Willows Software, Inc. 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.


For more information about the Willows Twin Libraries.

	http://www.willows.com	

To send email to the maintainer of the Willows Twin Libraries.

	mailto:twin@willows.com 

 */

#include <string.h>

#include "windows.h"
#include "windowsx.h"
#include "commdlg.h"

#include "Log.h"
#include "kerndef.h"
#include "Module.h"

/* This is to determine whether this object file has been linked in */
BOOL IsBinaryApp = TRUE;

extern LPSTR strpbrkr(LPCSTR,LPCSTR);
extern HANDLE InternalLoadLibrary(WORD,LPSTR,LPARAM);

static char szFilter[] = "Windows .EXE|*.exe|";

extern int __argc;
extern char **__argv;

int
WinMain(HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmdLine, int nCmdShow)
{
    int    rc;
    LPSTR  lpszFileName=0,lpszTemp;
    char	szDirName[256], szFile[256];
    OPENFILENAME of;
    LPOPENFILENAME lpofn;
    char chReplace;
    int i;

    APISTR((LF_API,"WinMain(hInst=%x,hPrev=%x,lpstr=%s,nCmdShow=%x)\n",
	hInstance,hPrev,lpCmdLine,nCmdShow));

    if (__argc > 1) {
	lpszFileName = WinMalloc(lstrlen(__argv[1])+5);
	lstrcpy(lpszFileName,__argv[1]);
	lpszTemp = strpbrkr(lpszFileName,"/");
	lpszTemp = (lpszTemp)?lpszTemp+1:lpszFileName;
	if (!strchr(lpszTemp,'.'))
	    lstrcat(lpszFileName,".exe");
    }
    else {
	getcwd(szDirName,256);
	chReplace = szFilter[lstrlen(szFilter)-1];
	for(i=0;szFilter[i] != '\0'; i++)
	    if(szFilter[i] == chReplace) szFilter[i] = '\0';
	memset((LPVOID)&of,'\0',sizeof(OPENFILENAME));
	lpofn = &of;
	lpofn->lStructSize = sizeof(OPENFILENAME);
	lpofn->hwndOwner = (HWND)NULL;
	lpofn->lpstrFilter = szFilter;
	lpofn->nFilterIndex = 1;
	lpofn->lpstrFile    = szFile;
	lpofn->nMaxFile     = sizeof(szFile);
	lpofn->lpstrInitialDir = szDirName;
	rc = GetOpenFileName(lpofn);
	if (rc == IDOK)
		lpszFileName = lpofn->lpstrFile;
	else exit(0);
    }

    LOGSTR((LF_LOG,"file: [%s] %d\n",lpszFileName,strlen(lpszFileName)));
    LOGSTR((LF_LOG,"load: [%s] %d\n",lpCmdLine,strlen(lpCmdLine)));
    rc = InternalLoadLibrary(ILL_BINARY|ILL_APPL|ILL_FILENAME,
					lpCmdLine,(LPARAM)lpszFileName);
    APISTR((LF_API,"WinMain(...) returns\n"));
    return 0;
}

