/********************************************************************
	@(#)WinConfig.h	1.12 Twin configuration file management.
    	Copyright 1997 Willows Software, Inc. 

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.


For more information about the Willows Twin Libraries.

	http://www.willows.com	

To send email to the maintainer of the Willows Twin Libraries.

	mailto:twin@willows.com 

********************************************************************/
 
 
char *GetTwinFilename(void);
char *GetTwinString(int, char *,int );
unsigned long GetTwinInt(int);
char *GetEnv(const char *env);


/* WinConfig Sections definitions */
#define WCS_BOOT        0
#define WCS_WINDOWS     1
#define WCS_PORTALIAS   2
#define WCS_FONTSUB     3
#define WCS_COLORS      4
#define WCS_DEVICES     5
#define WCS_XDOS        6
#define WCS_ENV         7
#define WCS_COMMDLG     8

/* WinConfig Parameter definitions */
#define	WCP_DISPLAY	1
#define	WCP_HEIGHT	2
#define	WCP_WIDTH	3
#define	WCP_WINDOWS	4
#define	WCP_TEMP	5

#define	WCP_OPENPATH	6
#define	WCP_TASKING	7
#define	WCP_LOGFILE	8
#define	WCP_LOGMASK	9
#define	WCP_COMPAT	10

#define	WCP_PRINTER	11
#define	WCP_DBLCLICK	12
#define	WCP_CURBLINK	13
#define	WCP_FONTFACE	14
#define	WCP_FONTSIZE	15

#define	WCP_FONTBOLD	16
#define	WCP_FONTMAP	17
#define	WCP_HELPPROG	18
#define	WCP_ICONFACE	19
#define	WCP_ICONSIZE	20

#define	WCP_OUTPUT	21
#define WCP_WINFLAG	22
#define	WCP_LIBRARY	23
#define	WCP_PORTNAME	24
#define	WCP_FONTALIAS	25

#define	WCP_COLORS	26
#define	WCP_DEVICES	27
#define	WCP_DOSMODE	28
#define	WCP_MEMORY	29
#define	WCP_EXTENDED	30

#define	WCP_HARDWARE	31
#define	WCP_NFILES	32
#define	WCP_SETUP	33
#define WCP_FATAL	34
#define WCP_VERIFY	35

#define WCP_COLORMAP	36
#define WCP_DITHER	37
#define WCP_NOMAPDIR	38
#define WCP_DEBUGGER	39
#define WCP_NOPAGING	40

#define WCP_VERBOSE	41
#define WCP_CONTROL	42

#define WCP_DOSDRIVES		43
#define WCP_DRIVELETTERS	44
#define WCP_PATHSASDRIVES	45
#define WCP_SIZEGRIP		46




typedef struct twinrc {
	int     parameter;
	int	opcode;
	int     section;
	char   *lpszkeyname;
	char   *lpszdefault;
	char   *lpszenviron;
	long    lparam;
	char   *lpszstring;
} TWINRC, *LPTWINRC;

/*
**   MiD 03-JAN-1996   The first 3 fontmapper flags have been
**                     moved from DrvText.h, plus added Scalable 
**                     Only flag. 
*/
#define FM_HIRESFONT    0x10   /* use highest resolution fonts only        */
#define FM_NOSCALABLE   0x20   /* do not allow scalable font mapping       */
#define FM_SYSTEMFONT   0x40   /* use system font in dialog boxes w/ fonts */
#define FM_SCALABLEONLY 0x80   /* skip bitmap fonts: overwrites FM_NOSCALABLE */

