/*
 * Electric(tm) VLSI Design System
 *
 * File: aidtable.c
 * Aid dispatch table
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */
#include "global.h"

/*
 * when adding an aid, also update these files:
 * key.c:      capability setting
 * The "key" utility
 */

/*
 * sample routines and their arguments:
 *
 * aa_init(INTBIG *argc, char *argv[], AIDENTRY *aid) {}
 * INTSML aa_set(INTSML count, char *par[]) {}
 * INTBIG aa_request(char *command,...) {}
 * aa_examinenodeproto(NODEPROTO *np) {}
 * aa_slice() {}
 * aa_done() {}
 * aa_startbatch(INTSML source) {}
 * aa_endbatch() {}
 * aa_startobjectchange(INTBIG addr, INTBIG type) {}
 * aa_endobjectchange(INTBIG addr, INTBIG type) {}
 * aa_modifynodeinst(NODEINST *ni, INTBIG olx, INTBIG oly, INTBIG ohx, INTBIG ohy,
 *    INTSML orot, INTSML otran) {}
 * aa_modifyarcinst(ARCINST *ai, INTBIG oxA, INTBIG oyA, INTBIG oxB, INTBIG oyB,
 *    INTBIG owid, INTBIG olen) {}
 * aa_modifyportproto(PORTPROTO *pp) {}
 * aa_modifynodeproto(NODEPROTO *np) {}
 * aa_modifydescript(VARIABLE *var, INTBIG old) {}
 * aa_newobject(INTBIG addr, INTBIG type) {}
 * aa_killobject(INTBIG addr, INTBIG type) {}
 * aa_newvariable(INTBIG addr, INTBIG type, INTBIG key, INTBIG newtype) {}
 * aa_killvariable(INTBIG addr, INTBIG type, INTBIG key, INTBIG oldaddr,
 *    INTBIG oldtype, INTBIG olddescript) {}
 * aa_modifyvariable(INTBIG addr, INTBIG type, INTBIG key, INTBIG vartype,
 *    INTBIG index, INTBIG oldvalue) {}
 * aa_insertvariable(INTBIG addr, INTBIG type, INTBIG key, INTBIG vartype, INTBIG index) {}
 * aa_deletevariable(INTBIG addr, INTBIG type, INTBIG key, INTBIG vartype, INTBIG index,
 *    INTBIG ovalue) {}
 * aa_readlibrary(LIBRARY *lib) {}
 * aa_eraselibrary(LIBRARY *lib) {}
 * aa_writelibrary(LIBRARY *lib, INTSML pass) {}
 */

/*
 * first come the interactive tools:
 *    us     user interface aid
 *    io     input/output in many forms
 * now come the synthesis tools:
 *    com    compaction
 *    pla    PLA generator
 *    ro     wire router (stitching and river-routing only)
 *    sc     Quisc silicon compiler (Queen's University)
 *    mapper FPGA mapper
 *    vhdl   VHDL compiler (Queen's University)
 *    compen compensation
 * now the aids preceeded by the network tool:
 *    net    network maintenance and comparison
 *    dr     incremental design rule checking
 *    sim    simulation (esim,rsim,rnl,mossim,spice,als,verilog,silos,etc.)
 *    proj   project management (should be last)
 * the rest is dreaming:
 *    rat    ratio check
 *    pow    power estimation
 *    vec    test vector generation
 *    nov    novice user help
 *    fra    fracturing for fabrication
 *    sea    function search
 *    tv     timing verification
 *    pr     placement and routing for TTL
 *    ga     gate array layout
 *    pad    pad frame support
 *    flr    floor planning
 */

#if COMAID
# include "compact.h"
  extern COMCOMP com_compactp;
#endif

#if COMPENAID
# include "compensate.h"
  extern COMCOMP compen_compensatep;
#endif

#if DRCAID
# include "drc.h"
  extern COMCOMP dr_drcp;
#endif

# include "eio.h"
extern COMCOMP io_iop;

#if MAPPERAID
# include "mapper.h"
  extern COMCOMP map_mapperp;
#endif

#include "network.h"
extern COMCOMP net_networkp;

#if PLAAID
# include "pla.h"
  extern COMCOMP pla_plap;
#endif

#if PROJECTAID
# include "projecttool.h"
  extern COMCOMP proj_projp;
#endif

#if ROUTAID
# include "rout.h"
  extern COMCOMP ro_routerp;
#endif

#if SCAID
# include "sc1.h"
  extern COMCOMP sc_silcomp;
#endif

#if SIMAID
# include "sim.h"
  extern COMCOMP sim_simulatorp;
#endif

# include "usr.h"
extern COMCOMP us_userp;

#if VHDLAID
# include "vhdl.h"
  extern COMCOMP vhdl_comp;
#endif

AIDENTRY el_aids[] =
{
	/********** the interactive tools **********/

	/* user interface */
	{"user", AIDON | AIDINCREMENTAL, 0, 0, &us_userp, NOCLUSTER,
	us_init,                 us_done,                us_set,
	us_request,              us_examinenodeproto,    us_slice,
	us_startbatch,           us_endbatch,
	us_startobjectchange,    us_endobjectchange,
	us_modifynodeinst,       us_modifyarcinst,       us_modifyportproto,
	us_modifynodeproto,      us_modifydescript,
	us_newobject,            us_killobject,
	us_newvariable,          us_killvariable,
	us_modifyvariable,       us_insertvariable,      us_deletevariable,
	us_readlibrary,          us_eraselibrary,        us_writelibrary,
	NOVARIABLE, 0},

	/* I/O module */
	{"io", 0, 0, 0, &io_iop, NOCLUSTER,
	io_init,                 io_done,                io_set,
	io_request,              io_examinenodeproto,    io_slice,
	io_startbatch,           io_endbatch,
	io_startobjectchange,    io_endobjectchange,
	io_modifynodeinst,       io_modifyarcinst,       io_modifyportproto,
	io_modifynodeproto,      io_modifydescript,
	io_newobject,            io_killobject,
	io_newvariable,          io_killvariable,
	io_modifyvariable,       io_insertvariable,      io_deletevariable,
	io_readlibrary,          io_eraselibrary,        io_writelibrary,
	NOVARIABLE, 0},

#if COMAID
	/* compaction module */
	{"compaction", AIDSYNTHESIS,              0, 0, &com_compactp, NOCLUSTER,
	com_init,                com_done,               com_set,
	com_request,             com_examinenodeproto,   com_slice,
	com_startbatch,          com_endbatch,
	com_startobjectchange,   com_endobjectchange,
	com_modifynodeinst,      com_modifyarcinst,      com_modifyportproto,
	com_modifynodeproto,     com_modifydescript,
	com_newobject,           com_killobject,
	com_newvariable,         com_killvariable,
	com_modifyvariable,      com_insertvariable,     com_deletevariable,
	com_readlibrary,         com_eraselibrary,       com_writelibrary,
	NOVARIABLE, 0},
#endif

#if PLAAID
	/* PLA generation module */
	{"pla", AIDSYNTHESIS,                     0, 0, &pla_plap, NOCLUSTER,
	pla_init,                pla_done,               pla_set,
	pla_request,             pla_examinenodeproto,   pla_slice,
	pla_startbatch,          pla_endbatch,
	pla_startobjectchange,   pla_endobjectchange,
	pla_modifynodeinst,      pla_modifyarcinst,      pla_modifyportproto,
	pla_modifynodeproto,     pla_modifydescript,
	pla_newobject,           pla_killobject,
	pla_newvariable,         pla_killvariable,
	pla_modifyvariable,      pla_insertvariable,     pla_deletevariable,
	pla_readlibrary,         pla_eraselibrary,       pla_writelibrary,
	NOVARIABLE, 0},
#endif

#if ROUTAID
	/* wire routing module */
	{"routing", AIDINCREMENTAL | AIDSYNTHESIS, 0, 0, &ro_routerp, NOCLUSTER,
	ro_init,                 ro_done,                ro_set,
	ro_request,              ro_examinenodeproto,    ro_slice,
	ro_startbatch,           ro_endbatch,
	ro_startobjectchange,    ro_endobjectchange,
	ro_modifynodeinst,       ro_modifyarcinst,       ro_modifyportproto,
	ro_modifynodeproto,      ro_modifydescript,
	ro_newobject,            ro_killobject,
	ro_newvariable,          ro_killvariable,
	ro_modifyvariable,       ro_insertvariable,      ro_deletevariable,
	ro_readlibrary,          ro_eraselibrary,        ro_writelibrary,
	NOVARIABLE, 0},
#endif

#if SCAID
	/* Quisc "Silicon" Compiler module */
	{"silicon-compiler", AIDSYNTHESIS,	0, 0,	&sc_silcomp,	NOCLUSTER,
	sc_init,                 sc_done,                sc_set,
	sc_request,              sc_examinenodeproto,    sc_slice,
	sc_startbatch,           sc_endbatch,
	sc_startobjectchange,    sc_endobjectchange,
	sc_modifynodeinst,       sc_modifyarcinst,       sc_modifyportproto,
	sc_modifynodeproto,      sc_modifydescript,
	sc_newobject,            sc_killobject,
	sc_newvariable,          sc_killvariable,
	sc_modifyvariable,       sc_insertvariable,      sc_deletevariable,
	sc_readlibrary,          sc_eraselibrary,        sc_writelibrary,
	NOVARIABLE, 0},
#endif

#if MAPPERAID
	/* mapper module */
	{"mapper", AIDSYNTHESIS,	0, 0,	&map_mapperp,	NOCLUSTER,
	map_init,                map_done,               map_set,
	map_request,             map_examinenodeproto,   map_slice,
	map_startbatch,          map_endbatch,
	map_startobjectchange,   map_endobjectchange,
	map_modifynodeinst,      map_modifyarcinst,      map_modifyportproto,
	map_modifynodeproto,     map_modifydescript,
	map_newobject,           map_killobject,
	map_newvariable,         map_killvariable,
	map_modifyvariable,      map_insertvariable,     map_deletevariable,
	map_readlibrary,         map_eraselibrary,       map_writelibrary,
	NOVARIABLE, 0},
#endif

#if VHDLAID
	/* VHDL compiler module */
	{"vhdl-compiler", AIDSYNTHESIS,	0, 0,	&vhdl_comp,	NOCLUSTER,
	vhdl_init,               vhdl_done,              vhdl_set,
	vhdl_request,            vhdl_examinenodeproto,  vhdl_slice,
	vhdl_startbatch,         vhdl_endbatch,
	vhdl_startobjectchange,  vhdl_endobjectchange,
	vhdl_modifynodeinst,     vhdl_modifyarcinst,     vhdl_modifyportproto,
	vhdl_modifynodeproto,    vhdl_modifydescript,
	vhdl_newobject,          vhdl_killobject,
	vhdl_newvariable,        vhdl_killvariable,
	vhdl_modifyvariable,     vhdl_insertvariable,    vhdl_deletevariable,
	vhdl_readlibrary,        vhdl_eraselibrary,      vhdl_writelibrary,
	NOVARIABLE, 0},
#endif

#if COMPENAID
	/* compensation module */
	{"compensation", AIDSYNTHESIS,	0, 0,	&compen_compensatep,	NOCLUSTER,
	compen_init,             compen_done,            compen_set,
	compen_request,          compen_examinenodeproto,compen_slice,
	compen_startbatch,       compen_endbatch,
	compen_startobjectchange,compen_endobjectchange,
	compen_modifynodeinst,   compen_modifyarcinst,   compen_modifyportproto,
	compen_modifynodeproto,  compen_modifydescript,
	compen_newobject,        compen_killobject,
	compen_newvariable,      compen_killvariable,
	compen_modifyvariable,   compen_insertvariable,  compen_deletevariable,
	compen_readlibrary,      compen_eraselibrary,    compen_writelibrary,
	NOVARIABLE, 0},
#endif

	/* network maintenance and comparison */
	{"network", AIDON | AIDINCREMENTAL, 0, 0, &net_networkp, NOCLUSTER,
	net_init,                net_done,               net_set,
	net_request,             net_examinenodeproto,   net_slice,
	net_startbatch,          net_endbatch,
	net_startobjectchange,   net_endobjectchange,
	net_modifynodeinst,      net_modifyarcinst,      net_modifyportproto,
	net_modifynodeproto,     net_modifydescript,
	net_newobject,           net_killobject,
	net_newvariable,         net_killvariable,
	net_modifyvariable,      net_insertvariable,     net_deletevariable,
	net_readlibrary,         net_eraselibrary,       net_writelibrary,
	NOVARIABLE, 0},

#if DRCAID
	/* design-rule checker */
	{"drc", AIDON | AIDINCREMENTAL | AIDANALYSIS, 0, 0, &dr_drcp, NOCLUSTER,
	dr_init,                 dr_done,                dr_set,
	dr_request,              dr_examinenodeproto,    dr_slice,
	dr_startbatch,           dr_endbatch,
	dr_startobjectchange,    dr_endobjectchange,
	dr_modifynodeinst,       dr_modifyarcinst,       dr_modifyportproto,
	dr_modifynodeproto,      dr_modifydescript,
	dr_newobject,            dr_killobject,
	dr_newvariable,          dr_killvariable,
	dr_modifyvariable,       dr_insertvariable,      dr_deletevariable,
	dr_readlibrary,          dr_eraselibrary,        dr_writelibrary,
	NOVARIABLE,0},
#endif

#if SIMAID
	/* simulation module */
	{"simulation", AIDANALYSIS, 0, 0, &sim_simulatorp, NOCLUSTER,
	sim_init,                sim_done,               sim_set,
	sim_request,             sim_examinenodeproto,   sim_slice,
	sim_startbatch,          sim_endbatch,
	sim_startobjectchange,   sim_endobjectchange,
	sim_modifynodeinst,      sim_modifyarcinst,      sim_modifyportproto,
	sim_modifynodeproto,     sim_modifydescript,
	sim_newobject,           sim_killobject,
	sim_newvariable,         sim_killvariable,
	sim_modifyvariable,      sim_insertvariable,     sim_deletevariable,
	sim_readlibrary,         sim_eraselibrary,       sim_writelibrary,
	NOVARIABLE, 0},
#endif

#if PROJECTAID
	/* project management module */
	{"project", AIDON | AIDINCREMENTAL, 0, 0, &proj_projp, NOCLUSTER,
	proj_init,               proj_done,              proj_set,
	proj_request,            proj_examinenodeproto,  proj_slice,
	proj_startbatch,         proj_endbatch,
	proj_startobjectchange,  proj_endobjectchange,
	proj_modifynodeinst,     proj_modifyarcinst,     proj_modifyportproto,
	proj_modifynodeproto,    proj_modifydescript,
	proj_newobject,          proj_killobject,
	proj_newvariable,        proj_killvariable,
	proj_modifyvariable,     proj_insertvariable,    proj_deletevariable,
	proj_readlibrary,        proj_eraselibrary,      proj_writelibrary,
	NOVARIABLE, 0},
#endif

	/* termination */
	{NULL, 0, 0, 0, NULL, NULL,
	 NULL, NULL, NULL,
	 NULL, NULL, NULL,
	 NULL, NULL,
	 NULL, NULL,
	 NULL, NULL, NULL,
	 NULL, NULL,
	 NULL, NULL,
	 NULL, NULL,
	 NULL, NULL, NULL,
	 NULL, NULL, NULL,
	 NULL, 0}
};
