/*
 * Electric(tm) VLSI Design System
 *
 * File: dberror.c
 * Database error handler
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#include "global.h"
#include "database.h"

INTBIG db_lasterror;			/* last error message */
INTSML db_printerrors;			/* flag for printing internal errors */

char *db_errortype[] =
{
	"no error",								/* DBNOERROR */
	"no memory",							/* DBNOMEM */
	"bad transposition",					/* DBBADTRANS */
	"bad rotation",							/* DBBADROT */
	"bad prototype",						/* DBBADPROTO */
	"bad parent",							/* DBBADPARENT */
	"invalid instance",						/* DBBADINST */
	"invalid name",							/* DBBADNAME */
	"bad width",							/* DBBADWIDTH */
	"bad end A node/port",					/* DBBADENDAN */
	"bad end B node/port",					/* DBBADENDBN */
	"bad end A connection",					/* DBBADENDAC */
	"bad end B connection",					/* DBBADENDBC */
	"bad end A position",					/* DBBADENDAP */
	"bad end B position",					/* DBBADENDBP */
	"bad new width",						/* DBBADNEWWID */
	"bad facet",							/* DBBADFACET */
	"bad library",							/* DBBADLIB */
	"bad size",								/* DBBADSIZE */
	"bad object type",						/* DBBADOBJECT */
	"bad sub port",							/* DBBADSUBPORT */
	"still has arcs",						/* DBHASARCS */
	"still has ports",						/* DBHASPORTS */
	"facet has instances",					/* DBHASINSTANCES */
	"recursive call",						/* DBRECURSIVE */
	"arc not in port",						/* DBNOTINPORT */
	"conflicts with primitive",				/* DBCONFLICT */
	"port mismatch",						/* DBPORTMM */
	"duplicate name",						/* DBDUPLICATE */
	"primitive prototype",					/* DBPRIMITIVE */
	"bad transformation matrix",			/* DBBADTMAT */
	"variable does not exist",				/* DBNOVAR */
	"variable cannot be changed",			/* DBVARFIXED */
	"variable cannot be displayable array",	/* DBVARARRDIS */
	"this is the last technology",			/* DBLASTECH */
	"technology is still in use"			/* DBTECINUSE */
};

/*
 * database error routine codes
 */
char *db_routines[] =
{
	"addstringtoinfstr",	/*  1 */
	"addtechnology",		/*  2 */
	"addtoinfstr",			/*  3 */
	"allocarcinst",			/*  4 */
	"alloccell",			/*  5 */
	"allocgeom",			/*  6 */
	"alloclibrary",			/*  7 */
	"allocnodeinst",		/*  8 */
	"allocnodeproto",		/*  9 */
	"allocpolygon",			/* 10 */
	"allocportarcinst",		/* 11 */
	"allocportexpinst",		/* 12 */
	"allocportproto",		/* 13 */
	"allocstring",			/* 14 */
	"alloctechnology",		/* 15 */
	"allocview",			/* 16 */
	"copynodeproto",		/* 17 */
	"delind",				/* 18 */
	"delindkey",			/* 19 */
	"delvalkey",			/* 20 */
	"describevariable",		/* 21 */
	"extendpolygon",		/* 22 */
	"initinfstr",			/* 23 */
	"initobjlist",			/* 24 */
	"insind",				/* 25 */
	"insindkey",			/* 26 */
	"killarcinst",			/* 27 */
	"killlibrary",			/* 28 */
	"killnodeinst",			/* 29 */
	"killnodeproto",		/* 30 */
	"killportproto",		/* 31 */
	"killtechnology",		/* 32 */
	"makekey",				/* 33 */
	"modifyarcinst",		/* 34 */
	"moveportproto",		/* 35 */
	"newarcinst",			/* 36 */
	"newlibrary",			/* 37 */
	"newnodeinst",			/* 38 */
	"newnodeproto",			/* 39 */
	"newportproto",			/* 40 */
	"newview",				/* 41 */
	"replacearcinst",		/* 42 */
	"replacenodeinst",		/* 43 */
	"returninfstr",			/* 44 */
	"setind",				/* 45 */
	"setindkey",			/* 46 */
	"setval",				/* 47 */
	"setvalkey",			/* 48 */
	"transmult",			/* 49 */
	"xform",				/* 50 */
};

/*
 * routine to report a database error
 */
INTBIG db_error(INTBIG code)
{
	db_lasterror = code;
	if (db_printerrors != 0) telldatabaseerror();
	return(-1);
}

/*
 * routine to print an error message
 */
void telldatabaseerror(void)
{
	REGISTER INTSML routine, error;

	routine = (db_lasterror >> 16) - 1;
	error = db_lasterror & 0xFFFF;
	if (error == DBNOERROR) ttyputmsg("No error"); else
		ttyputmsg("%s: %s", db_routines[routine], db_errortype[error]);
}
