/*
 * Electric(tm) VLSI Design System
 *
 * File: graphmacsys.c
 * Interface for Apple Macintosh computers
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#include "global.h"
#include "egraphics.h"
#include "usr.h"
#include "dblang.h"

#include <Desk.h>
#include <Gestalt.h>
#include <LowMem.h>
#include <Processes.h>
#include <SIOUX.h>

#if	LANGTCL
# include "tclMac.h"
#endif
#ifdef	USETK
# include "tk.h"
# include "tkInt.h"
# include "tkMacInt.h"

# define MYEVENTS (ExposureMask | ButtonPressMask | ButtonReleaseMask | KeyPressMask |\
				   PointerMotionMask | StructureNotifyMask | FocusChangeMask)
  typedef int (*TclMacConvertEventPtr)(EventRecord *eventPtr);

  Tk_Window          gra_tktopwindow;			/* top TK window */

  /* void TclMacSetEventProc(TclMacConvertEventPtr procPtr); */
  /* int TkMacConvertEvent(EventRecord *eventPtr); */
  void InitializeTK(void);
  void tcl_init(void);
  Tk_Window MakeTKWindow(short type, short left, short right, short top, short bottom,
  	void (*eventproc)(ClientData, XEvent*));
#endif

#if	LANGTCL
 Tcl_Interp *myTCLInterp;
#endif

/****** prototypes for local routines ******/
INTSML gra_trapavailable(INTSML);
INTSML gra_gettraptype(INTSML);
INTSML gra_numtoolboxtraps(void);
char *DoMacintoshInitialization(void);
int InitializeTCL(void);
void el_primaryinit(void);
void el_secondaryinit(INTBIG, char*[]);
void el_slice(void);

/******************** INITIALIZATION ********************/

void main(void)
{
    short argc;
    char *argv[4], *progname;

	/* initialize for the operating system */
	progname = DoMacintoshInitialization();
	argc = 1;
	argv[0] = progname;

	/* primary initialization of Electric */
	el_primaryinit();

#if	LANGTCL
	/* initialize TCL */
	if (InitializeTCL() == TCL_ERROR)
		error("InitializeTCL failed: %s\n", myTCLInterp->result);
#endif

#ifdef	USETK
	/* initialize TK */
	InitializeTK();
#endif

	/* secondary initialization of Electric */
    el_secondaryinit(argc, argv);

	/* now run Electric */
    for(;;)
    {
    	el_slice();
    }
}

#define _Gestalt 0xA1AD

char *DoMacintoshInitialization(void)
{
	long ppcresponse;
	ProcessSerialNumber psn;
	ProcessInfoRec pinfo;
	unsigned char processname[50];
	static char appname[50];
#if defined(__MWERKS__) && __MC68020__
	long response;
#endif

	MaxApplZone();
	InitGraf(&qd.thePort);
	InitFonts();
	FlushEvents(everyEvent, 0);
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(0L);
	InitCursor();

	/* must have system 7 */
	if (!gra_trapavailable(_Gestalt))
		error("The Macintosh must be running system 7");

	/* see if this is a powerPC */
	Gestalt(gestaltPPCToolboxAttr, &ppcresponse);

	/* check for 020 if the code was compiled for it */
#if defined(__MWERKS__) && __MC68020__
	Gestalt(gestaltProcessorType, &response);
	if (ppcresponse == 0 &&
		(response == gestalt68000 || response == gestalt68010))
			error("The Macintosh must have a 68020 or better processor");
#endif

	/* check for floating point unit if the code was compiled for it */
#if defined(__MWERKS__) && __MC68881__
	Gestalt(gestaltFPUType, &response);
	if (ppcresponse == 0 && response == gestaltNoFPU)
		error("The Macintosh must have a Floating Point Processor");
#endif

	/* determine "arguments" to the program */
	pinfo.processInfoLength = sizeof (ProcessInfoRec);
	pinfo.processName = processname;
	pinfo.processAppSpec = 0;
	GetCurrentProcess(&psn);
	GetProcessInformation(&psn, &pinfo);
	strncpy(appname, (char *)&pinfo.processName[1], pinfo.processName[0]);
	appname[pinfo.processName[0]] = 0;
	return(appname);
}

/*
 * routine to determine whether a trap exists in the Mac
 */
INTSML gra_trapavailable(INTSML theTrap)
{
	INTSML ttype;

	ttype = gra_gettraptype(theTrap);
	if (ttype == ToolTrap)
	{
		theTrap &= 0x7FF;
		if (theTrap >= gra_numtoolboxtraps()) return(0);
	}
	return(NGetTrapAddress(theTrap, ttype) != NGetTrapAddress(0, ToolTrap));
}

/*
 * support routine to determine what kind of trap this is
 */
INTSML gra_gettraptype(INTSML theTrap)
{
	if ((theTrap&0x800) != 0) return(ToolTrap);
	return(OSTrap);
}

/*
 * support routine to determine how many Mac Toolbox traps are available
 */
INTSML gra_numtoolboxtraps(void)
{
	/* 0xA86E is "InitGraf" */
	if (NGetTrapAddress(0xA86E, 1) == NGetTrapAddress(0xAA6E, 1)) return(0x200);
	return(0x400);
}

#if	LANGTCL

int InitializeTCL(void)
{
	int err;
	char *newArgv[2];

	tcl_macQdPtr = &qd;
    Tcl_MacSetEventProc(TkMacConvertEvent);

	/* set the program name/path */
	newArgv[0] = "Electric";
	newArgv[1] = NULL;
	(void)Tcl_FindExecutable(newArgv[0]);

	myTCLInterp = Tcl_CreateInterp();
	if (myTCLInterp == 0) error("from Tcl_CreateInterp");

	/* tell Electric the TCL interpreter handle */
	el_tclinterpreter(myTCLInterp);

	/* Make command-line arguments available in the Tcl variables "argc" and "argv" */
	Tcl_SetVar(myTCLInterp, "argv", "", TCL_GLOBAL_ONLY);
	Tcl_SetVar(myTCLInterp, "argc", "0", TCL_GLOBAL_ONLY);
	Tcl_SetVar(myTCLInterp, "argv0", "electric", TCL_GLOBAL_ONLY);

	/* Set the "tcl_interactive" variable */
	Tcl_SetVar(myTCLInterp, "tcl_interactive", "1", TCL_GLOBAL_ONLY);

	/* initialize the interpreter */
	err = Tcl_Init(myTCLInterp);
	if (err != TCL_OK) error("(from Tcl_Init) %s", myTCLInterp->result);

	return(err);
}

#endif

#ifdef	USETK

void InitializeTK(void)
{
	int code;

	/* make the top tk window */
	gra_tktopwindow = TkCreateMainWindow(myTCLInterp, "", "Electric");
	if (gra_tktopwindow == NULL) return;
	(void)Tk_SetClass(gra_tktopwindow, "Electric");
	(void)Tcl_ResetResult(myTCLInterp);

	/* initialize tk package */
	if (Tcl_PkgRequire(myTCLInterp, "Tcl", TCL_VERSION, 1) == NULL)
		error("(from Tcl_PkgRequire) %s", myTCLInterp->result);
	code = Tcl_PkgProvide(myTCLInterp, "Tk", TK_VERSION);
	if (code != TCL_OK) error("(from Tcl_PkgProvide) %s", myTCLInterp->result);
	code = TkpInit(myTCLInterp);
	if (code != TCL_OK) return;
}

/*
 * Routine to create a TK window of type "type":
 *  1  Scrolling text window
 *  2  Graphic edit window
 *  3  Dialog window with title banner
 *  4  Dialog windiw with no title banner
 * The window runs from "left" to "right" and from "top" to "bottom".
 * The event proc to use for this window is in "eventproc"
 */
Tk_Window MakeTKWindow(short type, short left, short right, short top, short bottom,
	void (*eventproc)(ClientData, XEvent*))
{
	Tk_Window win;
	char windowname[100], unsupportedcmd[200], *argv[3];
	static INTSML windowcount = 1;

	sprintf(windowname, ".electric%d", windowcount);
	windowcount++;
	sprintf(unsupportedcmd, "toplevel %s -container 1", windowname);
	if (Tcl_VarEval(myTCLInterp, unsupportedcmd, 0) == TCL_ERROR)
		ttyputerr("Tcl_VarEval returned %s", myTCLInterp->result);
	win = Tk_NameToWindow(myTCLInterp, windowname, gra_tktopwindow);
	switch (type)
	{
		case 1:
		case 2:
			sprintf(unsupportedcmd, "unsupported1 style %s zoomDocProc", windowname);
			break;
		case 3:
			sprintf(unsupportedcmd, "unsupported1 style %s noGrowNoCloseDocProc", windowname);
			break;
		case 4:
			sprintf(unsupportedcmd, "unsupported1 style %s dBoxProc", windowname);
			break;
	}
	if (Tcl_Eval(tcl_interp, unsupportedcmd) != TCL_OK)
	{
		ttyputmsg("ERROR from Tcl_Eval: %s", tcl_interp->result);
		Tcl_ResetResult(tcl_interp);
	}

	(void)Tk_GeometryRequest(win, right-left, bottom-top);
	(void)Tk_MoveToplevelWindow(win, left, top);
	(void)Tk_MapWindow(win);
	(void)Tk_CreateEventHandler(win, MYEVENTS, eventproc, (ClientData)NULL);

	if (type == 3 || type == 4)
	{
		argv[0] = "grab";
		argv[1] = "-global";
		argv[2] = windowname;
		if (Tk_GrabCmd((ClientData)gra_tktopwindow, myTCLInterp, 3, argv) != TCL_OK)
		{
			ttyputmsg("ERROR from Tk_GrabCmd: %s", myTCLInterp->result);
			Tcl_ResetResult(myTCLInterp);
		}
	}

	return(win);
}

#endif
