/*
 * Electric(tm) VLSI Design System
 *
 * File: graphpcchildframe.cpp
 * implementation of the CChildFrame class
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#include "graphpcstdafx.h"
#include "graphpc.h"
#include "graphpcchildframe.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildFrame

IMPLEMENT_DYNCREATE(CChildFrame, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CChildFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CChildFrame)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MBUTTONDBLCLK()
	ON_WM_MBUTTONDOWN()
	ON_WM_MBUTTONUP()
	ON_WM_RBUTTONDBLCLK()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_PAINT()
	ON_WM_CHAR()
	ON_WM_SIZE()
	ON_WM_CLOSE()
	ON_WM_MDIACTIVATE()
	ON_WM_KEYDOWN()
	ON_WM_MOVE()
	ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChildFrame construction/destruction

CChildFrame::CChildFrame()
{
}

CChildFrame::~CChildFrame()
{
}

BOOL CChildFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	return CMDIChildWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CChildFrame diagnostics

#ifdef _DEBUG
void CChildFrame::AssertValid() const
{
	CMDIChildWnd::AssertValid();
}

void CChildFrame::Dump(CDumpContext& dc) const
{
	CMDIChildWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CChildFrame message handlers

void gra_buttonaction(int state, UINT nFlags, CPoint point, CWnd *frm);
void gra_mouseaction(UINT nFlags, CPoint point, CWnd *frm);
void gra_keyaction(UINT nChar, UINT nFlags, UINT nRepCnt);
void gra_repaint(CChildFrame *frame, CPaintDC *dc);
void gra_resize(CChildFrame *frame, int cx, int cy);
int gra_closeframe(CChildFrame *frame);
void gra_activateframe(CChildFrame *frame, BOOL bActivate);
void gra_msgwindowchange(void);
void gra_setdefaultcursor(void);

void CChildFrame::OnLButtonDown(UINT nFlags, CPoint point) 
{
	gra_buttonaction(0, nFlags|MK_LBUTTON, point, this);
}

void CChildFrame::OnLButtonUp(UINT nFlags, CPoint point) 
{
	gra_buttonaction(1, nFlags|MK_LBUTTON, point, this);
}

void CChildFrame::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	gra_buttonaction(2, nFlags|MK_LBUTTON, point, this);
}

void CChildFrame::OnMButtonDown(UINT nFlags, CPoint point) 
{
	gra_buttonaction(0, nFlags|MK_MBUTTON, point, this);
}

void CChildFrame::OnMButtonUp(UINT nFlags, CPoint point) 
{
	gra_buttonaction(1, nFlags|MK_MBUTTON, point, this);
}

void CChildFrame::OnMButtonDblClk(UINT nFlags, CPoint point) 
{
	gra_buttonaction(2, nFlags|MK_MBUTTON, point, this);
}

void CChildFrame::OnRButtonDown(UINT nFlags, CPoint point) 
{
	gra_buttonaction(0, nFlags|MK_RBUTTON, point, this);
}

void CChildFrame::OnRButtonUp(UINT nFlags, CPoint point) 
{
	gra_buttonaction(1, nFlags|MK_RBUTTON, point, this);
}

void CChildFrame::OnRButtonDblClk(UINT nFlags, CPoint point) 
{
	gra_buttonaction(2, nFlags|MK_RBUTTON, point, this);
}

void CChildFrame::OnMouseMove(UINT nFlags, CPoint point) 
{
	gra_mouseaction(nFlags, point, this);
}

void CChildFrame::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	gra_repaint(this, &dc);

	// Do not call CMDIChildWnd::OnPaint() for painting messages
}

void CChildFrame::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	gra_keyaction(nChar, nFlags, nRepCnt);
}

void CChildFrame::OnSize(UINT nType, int cx, int cy) 
{
	CMDIChildWnd::OnSize(nType, cx, cy);
	
	gra_resize(this, cx, cy);
}

void CChildFrame::OnClose() 
{
	if (gra_closeframe(this) == 0) return;

	CMDIChildWnd::OnClose();
}

void CChildFrame::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd) 
{
	CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);

	gra_activateframe(this, bActivate);
}

void CChildFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if ((nFlags&0x100) != 0)
	{
		if (nChar == VK_DELETE) gra_keyaction(010,  nFlags, nRepCnt);
		if (nChar == VK_UP)     gra_keyaction(0x1E, nFlags, nRepCnt);
		if (nChar == VK_DOWN)   gra_keyaction(0x1F, nFlags, nRepCnt);
		if (nChar == VK_RIGHT)  gra_keyaction(0x1D, nFlags, nRepCnt);
		if (nChar == VK_LEFT)   gra_keyaction(0x1C, nFlags, nRepCnt);
	}
	CMDIChildWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CChildFrame::OnMove(int x, int y) 
{
	CMDIChildWnd::OnMove(x, y);

	extern CChildFrame *gra_messageswindow;
	if (this == gra_messageswindow) gra_msgwindowchange();
}

BOOL CChildFrame::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	if (CMDIChildWnd::OnSetCursor(pWnd, nHitTest, message)) return(1);
	gra_setdefaultcursor();
	return(1);
}
