/*
 * Electric(tm) VLSI Design System
 *
 * File: compact.h
 * One-dimensional compactor aid
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#ifdef __cplusplus
extern "C"
{
#endif

void com_init(INTBIG*, char*[], AIDENTRY*);
void com_done(void);
INTSML com_set(INTSML, char*[]);
INTBIG com_request(char*, va_list);
void com_examinenodeproto(NODEPROTO*);
void com_slice(void);
void com_startbatch(AIDENTRY*);
void com_endbatch(void);
void com_startobjectchange(INTBIG, INTBIG);
void com_endobjectchange(INTBIG, INTBIG);
void com_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void com_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void com_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void com_modifynodeproto(NODEPROTO*);
void com_modifydescript(VARIABLE*, INTBIG);
void com_newobject(INTBIG, INTBIG);
void com_killobject(INTBIG, INTBIG);
void com_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void com_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void com_modifyvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void com_insertvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void com_deletevariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void com_readlibrary(LIBRARY*);
void com_eraselibrary(LIBRARY*);
void com_writelibrary(LIBRARY*, INTSML);

#ifdef __cplusplus
};
#endif
