/*
 * Electric(tm) VLSI Design System
 *
 * File: compensate.h
 * Aid for compensating geometry
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#ifdef __cplusplus
extern "C"
{
#endif

void compen_init(INTBIG*, char*[], AIDENTRY*);
void compen_done(void);
INTSML compen_set(INTSML, char*[]);
INTBIG compen_request(char*, va_list);
void compen_examinenodeproto(NODEPROTO*);
void compen_slice(void);
void compen_startbatch(AIDENTRY*);
void compen_endbatch(void);
void compen_startobjectchange(INTBIG, INTBIG);
void compen_endobjectchange(INTBIG, INTBIG);
void compen_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void compen_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void compen_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void compen_modifynodeproto(NODEPROTO*);
void compen_modifydescript(VARIABLE*, INTBIG);
void compen_newobject(INTBIG, INTBIG);
void compen_killobject(INTBIG, INTBIG);
void compen_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void compen_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void compen_modifyvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void compen_insertvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void compen_deletevariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void compen_readlibrary(LIBRARY*);
void compen_eraselibrary(LIBRARY*);
void compen_writelibrary(LIBRARY*, INTSML);

#ifdef __cplusplus
};
#endif
