/*
 * Electric(tm) VLSI Design System
 *
 * File: config.h
 * Site-dependent definitions
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#ifndef _CONFIG_H_
#define _CONFIG_H_ 1

/********************* MACHINE DETERMINATION *********************/

/* determine if it is Macintosh OS */
#if defined(THINK_C) || defined(THINK_CPLUS) || defined(__MWERKS__)
#  define MACOS 1
#endif

/* determine if it is Windows NT/95 */
#if (defined(_WIN32) || defined(__WIN32__)) && !defined(WIN32)
#  define WIN32 1
#endif

/* determine if it is UNIX */
#if !defined(MACOS) && !defined(WIN32)
#  define ONUNIX 1
#endif

#ifdef	MACOS					/* Macintosh */
#  define STDC_HEADERS 1
#  define RETSIGTYPE   void
#  define DIRSEP       ':'
#  define HOMEDIR      ":"
#  define ELECTRICAUD  "electric.aud"
#  define ELECTRICLOG  "electric.log"
#  define LIBDIR       ":lib:"
#  define LISPDIR      ":lib:Lisp:"
#  define TCLDIR       ":lib:Tcl:"
#  define TKDIR        ":lib:Tk:"
#  define ESIMLOC      ":lib:rsim"
#  define RSIMLOC      ":lib:esim"
#  define RNLLOC       ":lib:rnl"
#endif

#ifdef WIN32					/* Windows */
#  define STDC_HEADERS 1
#  define RETSIGTYPE   void
#  define DIRSEP       '\\'
#  define HOMEDIR      ""
#  define ELECTRICAUD  "electric.aud"
#  define ELECTRICLOG  "electric.log"
#  define LIBDIR       "\\lib\\"
#  define LISPDIR      "\\lib\\lisp\\"
#  define TCLDIR       "\\lib\\tcl"
#  define TKDIR        "\\lib\\tk"
#  define SORTLOC      "C:\\Program Files\\sort"
#  define ESIMLOC      "C:\\Program Files\\esim"
#  define RSIMLOC      "C:\\Program Files\\rsim"
#  define RNLLOC       "C:\\Program Files\\rnl"
#  define SPICELOC     "C:\\Program Files\\spice"
#  define FLATDRCLOC   "C:\\Program Files\\ffindshort"
#  define SFLATDRCLOC  "C:\\Program Files\\findshort"
#endif

#ifdef ONUNIX					/* UNIX */
#  include "defines.h"
#  define DIRSEP       '/'
#  define HOMEDIR      "~/"
#  define ELECTRICAUD  "electric.aud"
#  define ELECTRICLOG  ".electric.log"
#  define LIBDIR       "/usr/local/electric/lib/"
#  define LISPDIR      "/usr/local/electric/lib/lisp/"
#  define TCLDIR       "/usr/local/electric/lib/tcl"
#  define TKDIR        "/usr/local/electric/lib/tk"
#  define DEFSHELL     "/bin/csh"
#  define SORTLOC      "/usr/bin/sort"
#  define ESIMLOC      "/usr/local/bin/esim"
#  define RSIMLOC      "/usr/local/bin/rsim"
#  define PRESIMLOC    "/usr/local/bin/presim"
#  define RNLLOC       "/usr/local/bin/rnl"
#  define SPICELOC     "/usr/local/bin/spice"
#  define FLATDRCLOC   "/usr/local/bin/ffindshort"
#  define SFLATDRCLOC  "/usr/local/bin/findshort"
#endif

/********************* SOURCE MODULE CONFIGURATION *********************/

/*
 * There are a number of different source configurations available, all defined
 * in the command-line when compiling Electric:
 *
 * EWORLD   all source code
 * EGNU     GNU release
 * EGNUL    GNU release with LISP and TCL added
 * EVE      VLSI product
 * ELM      Mechanical product
 * ELF      FPGA (generic) product
 * ELFA     FPGA (Actel) product
 */
#ifdef EWORLD
#  undef  EWORLD
#  define EWORLD 1
#else
#  define EWORLD 0
#endif

#ifdef EVE
#  undef  EVE
#  define EVE 1
#else
#  define EVE 0
#endif

#ifdef ELM
#  undef  ELM
#  define ELM 1
#else
#  define ELM 0
#endif

#ifdef ELF
#  undef  ELF
#  define ELF 1
#else
#  define ELF 0
#endif

#ifdef ELFA
#  undef  ELFA
#  define ELFA 1
#else
#  define ELFA 0
#endif

#ifdef ELFD
#  undef ELFD
#  define ELFD 1
#else
#  define ELFD 0
#endif

#ifdef EGNUL
#  undef EGNUL
#  define EGNUL 1
#else
#  define EGNUL 0
#endif

/* default configuration is for GNU */
#if EWORLD+EVE+ELM+ELF+ELFA+EGNUL == 0
#define EGNU 1
#endif

#ifdef EGNU
#  undef EGNU
#  define EGNU 1
#else
#  define EGNU 0
#endif

/* The tools (User and I/O are always enabled) */
#define COMAID             (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define COMPENAID          (EWORLD | EGNU | EGNUL |  0  | ELM |  0  |   0  |   0 )
#define DRCAID             (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define MAPPERAID          (   0   |   0  |   0   |  0  |  0  |  0  |   0  |   0 )
#define PLAAID             (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define PROJECTAID         (EWORLD |   0  |   0   | EVE |  0  |  0  |   0  |   0 )
#define ROUTAID            (EWORLD | EGNU | EGNUL | EVE |  0  |  0  | ELFA |   0 )
#define SCAID              (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define SIMAID             (EWORLD | EGNU | EGNUL | EVE |  0  |  0  | ELFA |   0 )
#define VHDLAID            (EWORLD | EGNU | EGNUL | EVE |  0  |  0  | ELFA | ELFD)

/* The simulator output formats */
#define SIMMOSSIM          (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define SIMPAL             (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define SIMALS             (EWORLD | EGNU | EGNUL | EVE |  0  |  0  | ELFA |   0 )
#define SIMSILOS           (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define SIMSIM             (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define SIMSPICE           (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define SIMTEXSIM          (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define SIMVERILOG         (EWORLD |   0  |   0   | EVE |  0  |  0  | ELFA |   0 )

/* The I/O modules (Binary and Text are always enabled) */
#define IOCIF              (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define IODXF              (EWORLD | EGNU | EGNUL |  0  | ELM |  0  |   0  |   0 )
#define IOEDIF             (EWORLD |   0  |   0   | EVE |  0  |  0  | ELFA | ELFD)
#define IOGDS              (EWORLD | EGNU | EGNUL | EVE | ELM |  0  |   0  |   0 ) 
#define IOHPGL             (EWORLD | EGNU | EGNUL | EVE | ELM | ELF | ELFA |   0 )
#define IOL                (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define IOPOSTSCRIPT       (EWORLD | EGNU | EGNUL | EVE | ELM | ELF | ELFA | ELFD)
#ifdef MACOS
#  define IOQUICKDRAW      (EWORLD | EGNU | EGNUL | EVE | ELM | ELF | ELFA | ELFD)
#else
#  define IOQUICKDRAW      0
#endif
#define IOSDF              (EWORLD |   0  |   0   | EVE |  0  |  0  | ELFA |   0 )

/* The technologies (Artwork, Generic and Schematic are always enabled) */
#define TECBICMOS          (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define TECBIPOLAR         (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define TECCMOS            (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define TECCMOSDODN        (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define TECDYNA            (   0   |   0  |   0   |  0  |  0  |  0  |   0  | ELFD)
#define TECEFIDO           (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define TECFPGA            (EWORLD |   0  |   0   | EVE |  0  | ELF |   0  |   0 )
#define TECGEM             (EWORLD | EGNU | EGNUL |  0  |  0  |  0  |   0  |   0 )
#define TECMOCMOS          (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define TECMOCMOSSUB       (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define TECMOCMOS2         (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define TECNCMOS3          (EWORLD |   0  |   0   | EVE |  0  |  0  |   0  |   0 )
#define TECNMOS            (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define TECPCB             (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define TECRCMOS           (EWORLD | EGNU | EGNUL | EVE |  0  |  0  |   0  |   0 )

/* The language interfaces */
#define LANGLISP           (EWORLD |   0  | EGNUL | EVE |  0  |  0  |   0  |   0 )
#define LANGMM             (   0   |   0  |   0   |  0  |  0  |  0  |   0  |   0 )
#ifdef ONUNIX
#  define LANGTCL          (EWORLD |   0  |   0   | EVE |  0  |  0  |   0  | ELFD)
#else
#  define LANGTCL          (EWORLD |   0  | EGNUL | EVE |  0  |  0  |   0  | ELFD)
#endif

#endif  /* _CONFIG_H_ - at top */
