/*
 * Electric(tm) VLSI Design System
 *
 * File: dblang.h
 * TCL, Lisp and Mathematica header module
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

/***************************** MATHEMATICA DECLARATIONS *****************************/

#if LANGMM
# include <mathlink.h>
  void db_mathematicaprocesspackets(INTSML);
  INTSML db_mathematicagetstring(INTSML);
  INTSML db_mathematicainit(void);
  extern MLINK db_mathematicalink;
#endif

/***************************** LISP DECLARATIONS *****************************/

#if LANGLISP
# include "elkscheme.h"
  void lsp_init(void);
  Object lsp_makeobject(char*);
  INTSML lsp_describeobject(Object, INTBIG, INTBIG*);
#endif

/***************************** TCL DECLARATIONS *****************************/

#if LANGTCL
# include "tclInt.h"
  void el_tclinterpreter(Tcl_Interp *interp);
  INTBIG tcl_converttoelectric(char *tclstr, INTBIG type);
  void tcl_nativemenuinitialize(void);
  INTSML tcl_nativemenuload(INTSML count, char *par[]);
  extern Tcl_Interp *tcl_interp;
  extern char *tcl_outputbuffer, *tcl_outputloc;
#endif
