/*
 * Electric(tm) VLSI Design System
 *
 * File: drc.h
 * Design-rule check aid
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#ifdef __cplusplus
extern "C"
{
#endif

void dr_init(INTBIG*, char*[], AIDENTRY*);
void dr_done(void);
INTSML dr_set(INTSML, char*[]);
INTBIG dr_request(char*, va_list);
void dr_examinenodeproto(NODEPROTO*);
void dr_slice(void);
void dr_startbatch(AIDENTRY*);
void dr_endbatch(void);
void dr_startobjectchange(INTBIG, INTBIG);
void dr_endobjectchange(INTBIG, INTBIG);
void dr_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void dr_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void dr_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void dr_modifynodeproto(NODEPROTO*);
void dr_modifydescript(VARIABLE*, INTBIG);
void dr_newobject(INTBIG, INTBIG);
void dr_killobject(INTBIG, INTBIG);
void dr_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void dr_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void dr_modifyvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void dr_insertvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void dr_deletevariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void dr_readlibrary(LIBRARY*);
void dr_eraselibrary(LIBRARY*);
void dr_writelibrary(LIBRARY*, INTSML);

/* intertool prototypes */
INTSML drcb_check(NODEPROTO*, INTSML);
INTSML drcb_debug(void);
INTSML drcb_vdebug(void);
char *drcb_next_error(void);
char *drcb_prev_error(void);
char *drcb_curr_error(void);
char *drcb_first_error(void);
INTSML drcb_print_hierarchy(NODEPROTO*);
INTSML drcb_highlight_step(NODEPROTO*);
INTSML drcb_nodestats(NODEPROTO*);
INTSML drc_flatwrite(NODEPROTO*);
INTSML drc_flatignore(char*);
INTSML drc_flatunignore(char*);
INTSML drcb_errorcount(void);
NETWORK *dr_network(NODEINST*, PORTPROTO*);

#ifdef __cplusplus
};
#endif
