/*
 * Electric(tm) VLSI Design System
 *
 * File: edialogs.h
 * Header file for dialog handling
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#define	OK           1
#define	CANCEL       2

#define ITEMTYPE   017
#define	BUTTON       0
#define	CHECK       01
#define	RADIO       02
#define	SCROLL      03
#define	MESSAGE     04
#define	EDITTEXT    05
#define	ICON        06
#define	USERDRAWN   07
#define	POPUP      010
#define	PROGRESS   011
#define	INACTIVE  0200

/* the last parameter to "DiaInitTextDialog" */
#define	SCSELMOUSE    1			/* mouse clicks select in scroll area */
#define	SCSELKEY      2			/* key strokes select in scroll area */
#define	SCDOUBLEQUIT  4			/* double-click in scroll area exits dialog */
#define	SCREPORT      8			/* report selections in the scroll area */
#define	SCHORIZBAR   16			/* want horizontal scroll-bar in scroll area */
#define	SCSMALLFONT  32			/* want small text in scroll area */
#define	SCFIXEDWIDTH 64			/* want fixed-width text in scroll area */

typedef struct
{
	INTSML top, left, bottom, right;
} RECTAREA;

typedef struct
{
	INTBIG        data;
	RECTAREA      r;
	unsigned char type;
	char         *msg;
} DIALOGITEM;

typedef struct
{
	RECTAREA    windowRect;
	char       *movable;
	INTSML      items;
	DIALOGITEM *list;
} DIALOG;

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes for dialog routines */
void   DiaAllowSubDialog(void);
void   DiaCharacterEdit(INTSML item);
void   DiaDefaultButton(INTSML item);
void   DiaDimItem(INTSML item);
void   DiaDoneDialog(void);
void   DiaDrawRect(RECTAREA *r, INTSML on);
void   DiaEditControl(INTSML item);
void   DiaFrameRect(RECTAREA *r);
INTSML DiaGetControl(INTSML item);
INTSML DiaGetCurLine(INTSML item);
void   DiaGetMouse(INTSML *x, INTSML *y);
INTSML DiaGetNextCharacter(INTSML *item);
INTSML DiaGetPopupEntry(INTSML item);
char  *DiaGetScrollLine(INTSML item, INTSML which);
char  *DiaGetText(INTSML item);
INTSML DiaInitDialog(DIALOG *dialog);
void   DiaInitTextDialog(INTSML item, INTSML (*toplist)(char **),
		char *(*nextinlist)(void), void (*donelist)(void),
		INTSML sortpos, INTSML flags);
void   DiaItemRect(INTSML item, RECTAREA *rect);
void   DiaLoadTextDialog(INTSML item, INTSML (*toplist)(char **), char *(*nextinlist)(void),
		void (*donelist)(void), INTSML sortpos);
INTSML DiaNextHit(void);
void   DiaNoEditControl(INTSML item);
void   DiaOpaqueEdit(INTSML item);
void   DiaPercent(INTSML item, INTBIG p);
void   DiaRedispRoutine(INTSML item, void (*routine)(RECTAREA*));
void   DiaRedrawDialogWindow(void);
void   DiaSelectLine(INTSML item, INTSML which);
void   DiaSetControl(INTSML item, INTSML value);
void   DiaSetPopup(INTSML item, INTSML count, char **names);
void   DiaSetPopupEntry(INTSML item, INTSML entry);
void   DiaSetScrollLine(INTSML item, INTSML which, char *msg);
void   DiaSetText(INTSML item, char *msg);
void   DiaStuffLine(INTSML item, char *line);
void   DiaUnDimItem(INTSML item);
INTSML DiaValidEntry(INTSML item);

#ifdef __cplusplus
};
#endif
