/*
 * Electric(tm) VLSI Design System
 *
 * File: eio.h
 * Input/output aid: header file
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#include <setjmp.h>

/* successive versions of the binary file have smaller numbers */
#define	MAGIC9        -1589				/* current magic number: version 9 */
#define	MAGIC8        -1587				/* older magic number: version 8 */
#define	MAGIC7        -1585				/* older magic number: version 7 */
#define	MAGIC6        -1583				/* older magic number: version 6 */
#define	MAGIC5        -1581				/* older magic number: version 5 */
#define	MAGIC4        -1579				/* older magic number: version 4 */
#define	MAGIC3        -1577				/* older magic number: version 3 */
#define	MAGIC2        -1575				/* older magic number: version 2 */
#define	MAGIC1        -1573				/* oldest magic number: version 1 */

/* I/O formats: */
#define	FBINARY          0				/* binary */
#define	FCIF             1				/* CIF */
#define	FDXF             2				/* DXF format */
#define	FEDIF            3				/* Electronic Design Interchange Format */
#define	FGDS             4				/* Calma GDS-II format */
#define	FHPGL            5				/* HPGL format (plotting) */
#define	FL               6				/* L format (Silicon Compilers) */
#define	FPOSTSCRIPT      7				/* PostScript (plotting) */
#define	FQUICKDRAW       8				/* Quickdraw (plotting) */
#define FSDF             9				/* SDF */
#define	FTEXT           10				/* text */
#define	FVHDL           11				/* VHDL */

/* aid:inout.IO_state: */
#define	CIFINSQUARE          01			/* bit set for CIF input to square wires */
#define	CIFOUTEXACT          02			/* bit set for CIF output to mimic screen */
#define	CIFOUTMERGE          04			/* bit set for CIF output to merge polygons */
#define	CIFOUTADDDRC        010			/* bit set for CIF output to include DRC layer */
#define	IODEBUG             020			/* bit set to debug input */
#define	PLOTFOCUS           040			/* bit set to focus plot output */
#define	PLOTDATES          0100			/* bit set to include dates in plot output */
#define CIFOUTNOTCEN       0200			/* bit set for non-centered CIF */
#define GDSOUTMERGE        0400			/* bit set for GDS output to merge polgons */
#define GDSOUTADDDRC      01000			/* bit set for GDS output to include DRC layer */
#define EPSPSCRIPT        02000			/* bit set for Encapsulated PostScript output */
#define HPGL2             04000			/* bit set for HPGL/2 output instead of HPGL */
#define EDIFSCHEMATIC    010000			/* bit set for EDIF write schematic instead of netlist */
#define DXFALLLAYERS     020000			/* bit set for DXF to read all layers instead of technology list */
#define DXFFLATTENINPUT  040000			/* bit set for DXF to flatten input */
#define SDFVERBOSE      0100000         /* bit set for SDF verbose input */

/* miscellaneous */
extern FILE        *io_fileout;			/* channel for output */
extern FILE        *io_filein;			/* channel for input */
extern char        *io_namesave;		/* for saving the global namespace */
extern INTBIG      *io_newnames;		/* for adding new names to global namespace */
extern jmp_buf      io_filerror;		/* nonlocal jump when I/O fails */
extern INTSML       io_cifbase;			/* index used when writing CIF */
extern INTBIG       io_state;			/* key for "IO_state" */
extern INTSML       io_verbose;			/* 0: silent  1:verbose  -1:display facets during input */
extern NODEINST   **io_nodelist;		/* list of nodes for readin */
extern INTBIG      *io_nodecount;		/* number of nodeinsts in each facet */
extern ARCINST    **io_arclist;			/* list of arcs for readin */
extern INTBIG      *io_arccount;		/* number of arcinsts in each facet */
extern NODEPROTO  **io_nodeprotolist;	/* list of facets for readin */
extern CELL       **io_celllist;		/* list of cells for readin */
extern TECHNOLOGY **io_techlist;		/* list of technologies for readin */
extern INTBIG      *io_aidlist;			/* list of aids for readin */
extern PORTPROTO  **io_portprotolist;	/* list of portprotos for readin */
extern INTBIG      *io_portcount;		/* number of portprotos in each facet */
extern PORTPROTO  **io_portpprotolist;	/* list of primitive portprotos for readin */
extern NODEPROTO  **io_nodepprotolist;	/* list of primitive nodeprotos for readin */
extern ARCPROTO   **io_arcprotolist;	/* list of arcprotos for readin */
extern AIDENTRY    *io_aid;				/* the I/O aid object */

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes for tool interface */
void io_init(INTBIG*, char*[], AIDENTRY*);
void io_done(void);
INTSML io_set(INTSML, char*[]);
INTBIG io_request(char*, va_list);
void io_examinenodeproto(NODEPROTO*);
void io_slice(void);
void io_startbatch(AIDENTRY*);
void io_endbatch(void);
void io_startobjectchange(INTBIG, INTBIG);
void io_endobjectchange(INTBIG, INTBIG);
void io_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void io_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void io_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void io_modifynodeproto(NODEPROTO*);
void io_modifydescript(VARIABLE*, INTBIG);
void io_newobject(INTBIG, INTBIG);
void io_killobject(INTBIG, INTBIG);
void io_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void io_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void io_modifyvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void io_insertvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void io_deletevariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void io_readlibrary(LIBRARY*);
void io_eraselibrary(LIBRARY*);
void io_writelibrary(LIBRARY*, INTSML);

/* prototypes for intratool interface */
void io_yankvariabledata(LIBRARY*);
void io_fixnewlib(LIBRARY*);
void io_setoutputbloat(char*, INTBIG);
INTBIG io_getoutputbloat(char*);
INTSML io_readbinlibrary(LIBRARY*);
INTSML io_readciflibrary(LIBRARY*);
INTSML io_readdxflibrary(LIBRARY*);
INTSML io_readediflibrary(LIBRARY*);
INTSML io_readgdslibrary(LIBRARY*);
INTSML io_readsdflibrary(LIBRARY*);
INTSML io_readtextlibrary(LIBRARY*);
INTSML io_readvhdllibrary(LIBRARY*);
INTSML io_writebinlibrary(LIBRARY*);
INTSML io_writeciflibrary(LIBRARY*);
INTSML io_writedxflibrary(LIBRARY*);
INTSML io_writeediflibrary(LIBRARY*);
INTSML io_writegdslibrary(LIBRARY*);
INTSML io_writehpgllibrary(LIBRARY*);
INTSML io_writellibrary(LIBRARY*);
INTSML io_writepostscriptlibrary(LIBRARY*);
INTSML io_writequickdrawlibrary(LIBRARY*);
INTSML io_writetextlibrary(LIBRARY*);

#ifdef __cplusplus
};
#endif
