/*
 * Electric(tm) VLSI Design System
 *
 * File: iogdsi.h
 * Input/output aid: GDSII stream
 * Written by: Glen Lawson
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

/* data declarations */
#define BLOCKSIZE		2048
#define MAXLINELENGTH	132
#define MAXPOINTS		4096
#define MAXLAYERS		64
#define IDSTRING		128
#define TEXTLINE		512
#define MINFONTWIDTH	130
#define MINFONTHEIGHT	190

typedef unsigned char	byte_unsigned;
typedef char			byte_integer;

typedef enum
{
	GDS_POLY,
	GDS_RECTANGLE,
	GDS_OBLIQUE,
	GDS_LINE,
	GDS_CLOSED
} shape_type;

typedef enum
{
	GDS_NULLSYM,
	GDS_HEADER,
	GDS_BGNLIB,
	GDS_LIBNAME,
	GDS_UNITS,
	GDS_ENDLIB,
	GDS_BGNSTR,
	GDS_STRNAME,
	GDS_ENDSTR,
	GDS_BOUNDARY,
	GDS_PATH,
	GDS_SREF,
	GDS_AREF,
	GDS_TEXTSYM,
	GDS_LAYER,
	GDS_DATATYPSYM,
	GDS_WIDTH,
	GDS_XY,
	GDS_ENDEL,
	GDS_SNAME,
	GDS_COLROW,
	GDS_TEXTNODE,
	GDS_NODE,
	GDS_TEXTTYPE,
	GDS_PRESENTATION,
	GDS_SPACING,
	GDS_STRING,
	GDS_STRANS,
	GDS_MAG,
	GDS_ANGLE,
	GDS_UINTEGER,
	GDS_USTRING,
	GDS_REFLIBS,
	GDS_FONTS,
	GDS_PATHTYPE,
	GDS_GENERATIONS,
	GDS_ATTRTABLE,
	GDS_STYPTABLE,
	GDS_STRTYPE,
	GDS_ELFLAGS,
	GDS_ELKEY,
	GDS_LINKTYPE,
	GDS_LINKKEYS,
	GDS_NODETYPE,
	GDS_PROPATTR,
	GDS_PROPVALUE,
	GDS_BOX,
	GDS_BOXTYPE,
	GDS_PLEX,
	GDS_BGNEXTN,
	GDS_ENDEXTN,
	GDS_TAPENUM,
	GDS_TAPECODE,
	GDS_STRCLASS,
	GDS_NUMTYPES,
	GDS_IDENT,
	GDS_REALNUM,
	GDS_SHORT_NUMBER,
	GDS_NUMBER,
	GDS_FLAGSYM,
	GDS_FORMAT,
	GDS_MASK,
	GDS_ENDMASKS,
	GDS_BADFIELD
} gsymbol;

typedef enum
{
	GDS_ERR,
	GDS_NONE,
	GDS_FLAGS,
	GDS_SHORT_WORD,
	GDS_LONG_WORD,
	GDS_SHORT_REAL,
	GDS_LONG_REAL,
	GDS_ASCII_STRING
} datatype_symbol;

gsymbol io_gdsIoption_set[] =
{
	GDS_ATTRTABLE,
	GDS_REFLIBS,
	GDS_FONTS,
	GDS_GENERATIONS,
	GDS_BADFIELD
};
gsymbol io_gdsIshape_set[] =
{
	GDS_AREF,
	GDS_SREF,
	GDS_BOUNDARY,
	GDS_PATH,
	GDS_NODE,
	GDS_TEXTSYM,
	GDS_BOX,
	GDS_BADFIELD
};
gsymbol io_gdsIgood_op_set[] =
{
	GDS_HEADER,
	GDS_BGNLIB,
	GDS_LIBNAME,
	GDS_UNITS,
	GDS_ENDLIB,
	GDS_BGNSTR,
	GDS_STRNAME,
	GDS_ENDSTR,
	GDS_BOUNDARY,
	GDS_PATH,
	GDS_SREF,
	GDS_AREF,
	GDS_TEXTSYM,
	GDS_LAYER,
	GDS_DATATYPSYM,
	GDS_WIDTH,
	GDS_XY,
	GDS_ENDEL,
	GDS_SNAME,
	GDS_COLROW,
	GDS_TEXTNODE,
	GDS_NODE,
	GDS_TEXTTYPE,
	GDS_PRESENTATION,
	GDS_STRING,
	GDS_STRANS,
	GDS_MAG,
	GDS_ANGLE,
	GDS_REFLIBS,
	GDS_FONTS,
	GDS_PATHTYPE,
	GDS_GENERATIONS,
	GDS_ATTRTABLE,
	GDS_NODETYPE,
	GDS_PROPATTR,
	GDS_PROPVALUE,
	GDS_BOX,
	GDS_BOXTYPE,
	GDS_FORMAT,
	GDS_MASK,
	GDS_ENDMASKS,
	GDS_BADFIELD
};
gsymbol io_gdsIbackup_set[] =
{
	GDS_UNITS,
	GDS_REFLIBS,
	GDS_FONTS,
	GDS_ATTRTABLE,
	GDS_BADFIELD
};
gsymbol io_gdsImask_set[] =
{
	GDS_DATATYPSYM,
	GDS_TEXTTYPE,
	GDS_BOXTYPE,
	GDS_NODETYPE,
	GDS_BADFIELD
};
gsymbol io_gdsIunsupported_set[] =
{
	GDS_ELFLAGS,
	GDS_PLEX,
	GDS_BADFIELD
};

gsymbol io_gdsIrecovery_set[100];

typedef struct
{
	char a11[7];
	char a12[7];
	char a21[7];
	char a22[7];
} orientation_type;

typedef struct
{
	INTBIG	px;
	INTBIG	py;
} point_type;

typedef struct
{
	INTBIG	tag;
	union {
		UINTSML	value;
		struct
		{
			unsigned flag0:1;
			unsigned flag1:1;
			unsigned flag2:1;
			unsigned flag3:1;
			unsigned flag4:1;
			unsigned flag5:1;
			unsigned flag6:1;
			unsigned flag7:1;
			unsigned flag8:1;
			unsigned flag9:1;
			unsigned flag10:1;
			unsigned flag11:1;
			unsigned flag12:1;
			unsigned flag13:1;
			unsigned flag14:1;
			unsigned flag15:1;
		} f;
	} u;
} bit_array;

typedef struct _stream
{
	FILE	*fp;
	char buf[BLOCKSIZE];
} STREAM;
