/*
 * Electric(tm) VLSI Design System
 *
 * File: network.h
 * Network tool: header file for fully instantiated networks
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

/*********************** PCOMP MODULES ***********************/

#define	NOPCOMP ((PCOMP *)-1)
#define	PCOMPBLOCKSIZE	50			/* number to "malloc" at a time */

/* meaning of PCOMP->state */
#define	NEGATEDPORT  1				/* if port is negated */
#define	EXPORTEDPORT 2				/* if port is exported */

typedef struct Ipcomp
{
	NODEINST       *actual;			/* actual component */
	INTSML          function;		/* component function */
	INTBIG          id;				/* local data for component */
	INTSML          wirecount;		/* number of unconnected ports (wires) */
	PORTPROTO     **portlist;		/* PORTPROTOs on each wire */
	struct Ipnet  **netnumbers;		/* initial netnumbers for each wire */
	INTSML         *state;			/* information about the connection */
	INTSML         *count;			/* connection count on each wire */
	struct Ipconn **pconnlist;		/* array of connections */
	struct Ipcomp  *nextinbucket;	/* next in bucket list */
	struct Ipcomp  *nextpcomp;		/* next in list of pseudocomponents */
} PCOMP;
extern PCOMP *net_pcompfree;

/*********************** PNET MODULES ***********************/

#define	NOPNET ((PNET *)-1)
#define	PNETBLOCKSIZE	50			/* number to "malloc" at a time */

/* meaning of PNET->flags */
#define	POWERNET    1				/* if net is power */
#define	GROUNDNET   2				/* if net is ground */
#define	EXPORTEDNET 4				/* if net is exported */

typedef struct Ipnet
{
	INTSML         flags;			/* state bits */
	PORTPROTO     *realport;		/* top-level port on this net (if any) */
	struct Ipnet  *nextpnet;		/* next in list */
} PNET;
extern PNET *net_pnetfree;

/*********************** PCONN MODULES ***********************/

#define	NOPCONN ((PCONN *)-1)
#define	PCONNBLOCKSIZE	50			/* number to "malloc" at a time */

typedef struct Ipconn
{
	PCOMP         *pcomp;			/* component on this net */
	struct Ipconn *nextpconn;		/* next in list */
} PCONN;
extern PCONN *net_pconnfree;

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes for tool interface */
void net_init(INTBIG*, char*[], AIDENTRY*);
void net_done(void);
INTSML net_set(INTSML, char*[]);
INTBIG net_request(char*, va_list);
void net_examinenodeproto(NODEPROTO*);
void net_slice(void);
void net_startbatch(AIDENTRY*);
void net_endbatch(void);
void net_startobjectchange(INTBIG, INTBIG);
void net_endobjectchange(INTBIG, INTBIG);
void net_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void net_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void net_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void net_modifynodeproto(NODEPROTO*);
void net_modifydescript(VARIABLE*, INTBIG);
void net_newobject(INTBIG, INTBIG);
void net_killobject(INTBIG, INTBIG);
void net_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void net_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void net_modifyvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void net_insertvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void net_deletevariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void net_readlibrary(LIBRARY*);
void net_eraselibrary(LIBRARY*);
void net_writelibrary(LIBRARY*, INTSML);

/* prototypes for intratool interface */
INTSML net_getfunction(NODEINST*);
NETWORK *net_gethighlightednet(INTSML, INTSML);
void net_freeallpcomp(PCOMP*);
void net_freeallpnet(PNET*);
PCOMP *net_makepseudo(NODEPROTO*, INTSML*, INTSML*, INTSML*, INTSML*, PNET**, INTSML, INTSML);
INTSML net_equate(INTSML);
INTSML net_compare(void);
INTSML net_setfirst(void);
INTSML net_setsecond(void);
INTSML net_setequiv(void);
INTSML net_clearequiv(void);
INTSML net_buswidth(char*);
void net_reevaluatefacet(NODEPROTO*);
INTSML net_evalbusname(INTBIG, char*, char***, INTSML**, NODEPROTO*);

#ifdef __cplusplus
};
#endif
