/*
 * Electric(tm) VLSI Design System
 *
 * File: pla.h
 * Programmable Logic Array Generator
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

extern AIDENTRY *pla_aid;

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes for tool interface */
void pla_init(INTBIG*, char*[], AIDENTRY*);
void pla_done(void);
INTSML pla_set(INTSML, char*[]);
INTBIG pla_request(char*, va_list);
void pla_examinenodeproto(NODEPROTO*);
void pla_slice(void);
void pla_startbatch(AIDENTRY*);
void pla_endbatch(void);
void pla_startobjectchange(INTBIG, INTBIG);
void pla_endobjectchange(INTBIG, INTBIG);
void pla_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void pla_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void pla_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void pla_modifynodeproto(NODEPROTO*);
void pla_modifydescript(VARIABLE*, INTBIG);
void pla_newobject(INTBIG, INTBIG);
void pla_killobject(INTBIG, INTBIG);
void pla_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void pla_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void pla_modifyvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void pla_insertvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void pla_deletevariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void pla_readlibrary(LIBRARY*);
void pla_eraselibrary(LIBRARY*);
void pla_writelibrary(LIBRARY*, INTSML);

/* prototypes for intratool interface */
void plac_generate(void);
void plac_dec(void);
void plac_n_generate(void);
void plac_p_generate(void);

#ifdef __cplusplus
};
#endif
