/*
 * Electric(tm) VLSI Design System
 *
 * File: rout.h
 * Header file for the wire routing aid
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

/* routing mode */
#define	STITCH      1				/* automatic stitch of adjoining nodes */
#define	MIMIC       2				/* mimic user stitching */
#define	STYLE      07				/* the above values */
#define	SELECT    010				/* bit set if each wire should be OKed */
#define	SELSKIP   020				/* bit set if OK's should be skipped */
#define	SELDONE   040				/* bit set if any selection was done */

extern AIDENTRY *ro_aid;			/* the Router aid object */
extern INTBIG    ro_state;			/* cached key for "ROUT_state" */
extern INTSML    ro_count;			/* number of stitches made */
extern INTBIG    ro_prefered;		/* cached key for "ROUT_prefered_arc" */

/****************************** AUTO-STITCH ROUTING ******************************/

/* check modules */
#define	NORCHECK ((RCHECK *)-1)

typedef struct Icheck
{
	NODEINST      *entity;			/* node instance being checked */
	struct Icheck *nextcheck;		/* next in list */
} RCHECK;
extern RCHECK *ro_firstcheck;
extern RCHECK *ro_checkfree;

extern AIDENTRY *ro_source;			/* source of batch of changes */

/****************************** MIMIC ROUTING ******************************/

extern ARCINST  *ro_lastarc;		/* last created arc for mimicing */

/****************************** MAZE ROUTING ******************************/

extern INTBIG ro_mazegridx;
extern INTBIG ro_mazegridy;
extern INTBIG ro_mazeoffsetx;
extern INTBIG ro_mazeoffsety;
extern INTBIG ro_mazeboundary;

/****************************** ROUTINES ******************************/

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes for tool interface */
void ro_init(INTBIG*, char*[], AIDENTRY*);
void ro_done(void);
INTSML ro_set(INTSML, char*[]);
INTBIG ro_request(char*, va_list);
void ro_examinenodeproto(NODEPROTO*);
void ro_slice(void);
void ro_startbatch(AIDENTRY*);
void ro_endbatch(void);
void ro_startobjectchange(INTBIG, INTBIG);
void ro_endobjectchange(INTBIG, INTBIG);
void ro_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void ro_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void ro_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void ro_modifynodeproto(NODEPROTO*);
void ro_modifydescript(VARIABLE*, INTBIG);
void ro_newobject(INTBIG, INTBIG);
void ro_killobject(INTBIG, INTBIG);
void ro_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void ro_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void ro_modifyvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void ro_insertvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void ro_deletevariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void ro_readlibrary(LIBRARY*);
void ro_eraselibrary(LIBRARY*);
void ro_writelibrary(LIBRARY*, INTSML);

/* prototypes for intratool interface */
INTSML ro_river(NODEPROTO*);
void ro_autostitch(void);
void ro_mimicstitch(void);
INTSML ro_didaccept(ARCINST*, ARCINST*, ARCINST*);
INTBIG ro_findnetends(NETWORK *net, NODEINST ***nilist, PORTPROTO ***pplist,
	INTBIG **xplist, INTBIG **yplist);

void ro_mazerouteselected(void);
void ro_mazeroutecell(void);

#ifdef __cplusplus
};
#endif
