/*
 * Electric(tm) VLSI Design System
 *
 * File: sim.h
 * Simulation aid: header file
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

/********************* for all simulators *********************/

#define	ESIM     0						/* ESIM from MIT (SIM format) */
#define	RSIM     1						/* RSIM from MIT (SIM format) */
#define	RNL      2						/* RNL from MIT (SIM format) */
#define COSMOS	 3						/* COSMOS from CMU (SIM format) */
#define	SPICE    4						/* SPICE from Berkeley (SPICE format) */
#define MOSSIM   5						/* MOSSIM from CalTech (NTK format) */
#define TEXSIM   6						/* TEGAS from Calma (TDL format) */
#define ABEL     7						/* ABEL from Data I/O (PAL programmer) */
#define VERILOG  8						/* VERILOG from Gateway (VER format) */
#define SILOS	 9						/* SILOS from Simucad */
#define ALS 	10						/* ALS (NET format) */

extern AIDENTRY  *sim_aid;				/* the Simulator aid object */
extern INTBIG     sim_format;			/* key for "SIM_format" (ESIM, etc) */
extern INTBIG     sim_netfile;			/* key for "SIM_netfile" */
extern INTBIG     sim_dontrun;			/* key for "SIM_dontrun" */
extern NODEPROTO *sim_simnt;			/* facet being simulated */
extern INTBIG     sim_tosim[2];			/* pipe to the simulator process */
extern INTBIG     sim_fromsim[2];		/* pipe from the simulator process */
extern INTBIG     sim_process;			/* process number of simulator */

/********************* for Simulation Window *********************/

/* the bits returned by "sim_window_isactive()" */
#define SIMWINDOWWAVEFORM   1			/* set if waveform window is active */
#define SIMWINDOWSCHEMATIC  2			/* set if schematic window is active */

/* logic levels and signal strengths in the window */
#define LOGIC_LOW      -1
#define LOGIC_X        -2
#define LOGIC_HIGH     -3
#define OFF_STRENGTH    0
#define NODE_STRENGTH   1
#define GATE_STRENGTH   2
#define VDD_STRENGTH    3

/* the meaning of "sim_window_state" */
#define FULLSTATE      01		/* set for full 12-state simulation */
#define SHOWWAVEFORM   02		/* set to show waveform window */
#define ADVANCETIME    04		/* set to advance time to end of simulation */

extern INTSML       sim_window_state;

/* prototypes */
void   sim_window_init(void);
INTSML sim_window_create(INTSML, NODEPROTO*, INTSML(*)(WINDOW*, INTSML), INTSML(*)(WINDOW*, INTSML));
void   sim_window_stopsimulation(void);
INTSML sim_window_isactive(NODEPROTO **np);
void   sim_window_redraw(void);
void   sim_window_setlines(INTSML);
INTSML sim_window_getlines(void);
void   sim_window_savegraph(void);
void   sim_window_displaymode(INTSML full);
void   sim_window_displaycolor(INTSML strength, INTSML color);
INTBIG sim_window_newtrace(INTSML, char*, INTBIG);
void   sim_window_loaddigtrace(INTBIG, INTSML, float*, INTSML*);
void   sim_window_loadanatrace(INTBIG, INTSML, float*, float*);
void   sim_window_setanarange(float, float);
void   sim_window_settraceline(INTBIG, INTSML);
void   sim_window_killtrace(INTBIG);
void   sim_window_killalltraces(void);
INTSML sim_window_gettraceline(INTBIG);
char  *sim_window_gettracename(INTBIG);
INTBIG sim_window_gettracedata(INTBIG);
float  sim_window_getanatracevalue(INTBIG, float);
INTBIG sim_window_findtrace(char*);
void   sim_window_inittraceloop(void);
void   sim_window_inittraceloop2(void);
INTBIG sim_window_nexttraceloop(void);
INTBIG sim_window_nexttraceloop2(void);
void   sim_window_sethighlighttrace(INTBIG);
INTBIG sim_window_gethighlighttrace(void);
void   sim_window_setmaincursor(float);
float  sim_window_getmaincursor(void);
void   sim_window_setextensioncursor(float);
float  sim_window_getextensioncursor(void);
void   sim_window_settimerange(float, float);
void   sim_window_gettimerange(float*, float*);
void   sim_window_updatelayoutwindow(void);
void   sim_windowconvertengineeringnotation(float, char*);

/********************* for ESIM *********************/

#define	ESIMNAME    "esim"

/********************* for RSIM *********************/

#define	RSIMPRENAME "presim"
#define	RSIMNAME    "rsim"
#define	RSIMIN      "rsim.in"			/* name of file with binary network */

/********************* for ALS *********************/

#define	NET_EXT		".net"
#define PLOT_EXT	".hpgl"

/********************* for RNL *********************/

#define	RNLPRENAME  "presim"
#define	RNLNAME     "rnl"
#define	RNLIN       "rnl.in"			/* name of file with binary network */
#define	RNLCOMM     "nl.l"				/* file with simulator initialization */

/********************* for SPICE *********************/

/*
 * Often it is best to run spice on a remote machine
 * Remove the comments from '#define REMOTESPICE' if this is what you want.
 * Also, set SPICENAME, and SPICEHOST appropriately.
 */
#define SPICENAME        "hspice"       /* eg. "spice" or "hspice" */
/* #define REMOTESPICE */               /* set this if on remote machine */
#undef  REMOTESPICE                     /* set this if spice is local */
/* #define SPICEHOST     "bill" */      /* the name of the remote machine */

#define MAXSPICELEVEL     3             /* levels 1, 2, and 3 */

/* Meaning of bits in sim_spice_state */
#define SPICERESISTANCE  01             /* set for resistances */
#define SPICEPLOT        02             /* set for plots (vs prints) */
#define SPICEDEBUG       04             /* set for debugging */
#define SPICENODENAMES  010             /* set for node names (vs numbers) */
#define SPICETYPE       060             /* mask for spice type */
#define SPICE2          000             /* type - spice 2 */
#define SPICE3          020             /* type - spice 3 */
#define SPICEHSPICE     040             /* type - hspice  */

/* Possible modes for sim_spice() */
#define SPICEWRITE       01             /* write a spice deck */
#define SPICEEXECUTE     02             /* execute spice */
#define SPICEPARSE       04             /* parse spice output */

extern INTBIG sim_spice_level;			/* key for "SIM_spice_level" */
extern INTBIG sim_spice_state;			/* key for "SIM_spice_state" */
extern INTSML sim_spice_debug;			/* SPICE debugging */
extern INTBIG sim_listingfile;			/* key for "SIM_listingfile" */

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes for tool interface */
void   sim_init(INTBIG*, char*[], AIDENTRY*);
void   sim_done(void);
INTSML sim_set(INTSML, char*[]);
INTBIG sim_request(char*, va_list);
void   sim_examinenodeproto(NODEPROTO*);
void   sim_slice(void);
void   sim_startbatch(AIDENTRY*);
void   sim_endbatch(void);
void   sim_startobjectchange(INTBIG, INTBIG);
void   sim_endobjectchange(INTBIG, INTBIG);
void   sim_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void   sim_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void   sim_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void   sim_modifynodeproto(NODEPROTO*);
void   sim_modifydescript(VARIABLE*, INTBIG);
void   sim_newobject(INTBIG, INTBIG);
void   sim_killobject(INTBIG, INTBIG);
void   sim_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void   sim_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void   sim_modifyvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void   sim_insertvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void   sim_deletevariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void   sim_readlibrary(LIBRARY*);
void   sim_eraselibrary(LIBRARY*);
void   sim_writelibrary(LIBRARY*, INTSML);

INTSML simals_charhandlerschem(WINDOW*, INTSML);
INTSML simals_charhandlerwave(WINDOW*, INTSML);

/* prototypes for intratool interface */
void   sim_spice_xprintf(FILE*, char*, ...);
INTSML sim_spice_charhandler(WINDOW*, INTSML);
INTSML sim_simpointout(char*, INTSML);
void   sim_spice_execute(char*, char*);
void   sim_writesim(NODEPROTO*, INTSML);
void   sim_writepalnetlist(NODEPROTO*);
void   sim_writemossim(NODEPROTO*);
void   sim_writetexnetlist(NODEPROTO*);
void   sim_writespice(NODEPROTO*);
void   sim_writevernetlist(NODEPROTO*);
void   sim_writesilnetlist(NODEPROTO*);
void   sim_resumesim(INTSML);

#ifdef __cplusplus
};
#endif
