/*
 * Electric(tm) VLSI Design System
 *
 * File: tecgen.h
 * Generic technology description: header file
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

/* all of the technology primitives */
extern TECHNOLOGY *gen_tech;				/* the technology */

extern NODEPROTO  *gen_univpinprim;			/* Universal Pin */
extern NODEPROTO  *gen_invispinprim;		/* Invisible Pin */
extern NODEPROTO  *gen_unroutedpinprim;		/* Unrouted Pin */
extern NODEPROTO  *gen_facetcenterprim;		/* Facet center */
extern NODEPROTO  *gen_portprim;			/* Port */
extern NODEPROTO  *gen_drcprim;				/* DRC Node */

extern ARCPROTO   *gen_universalarc;		/* universal arc */
extern ARCPROTO   *gen_invisiblearc;		/* invisible arc */
extern ARCPROTO   *gen_unroutedarc;			/* unrouted arc */

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes for interface routines */
INTSML gen_initprocess(TECHNOLOGY*, INTSML);
INTSML gen_nodepolys(NODEINST*);
INTSML gen_arcpolys(ARCINST*);
void gen_shapenodepoly(NODEINST*, INTSML, POLYGON*);
void gen_shapeportpoly(NODEINST*, PORTPROTO*, POLYGON*, XARRAY, INTSML);
void gen_shapearcpoly(ARCINST*, INTSML, POLYGON*);

#ifdef __cplusplus
};
#endif
