/*
 * Electric(tm) VLSI Design System
 *
 * File: tecschem.h
 * Schematic technology header
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

/* all of the primitives */
extern TECHNOLOGY *sch_tech;			/* the technology */

extern NODEPROTO  *sch_wirepinprim;		/* wire pin */
extern NODEPROTO  *sch_buspinprim;		/* bus pin */
extern NODEPROTO  *sch_bufprim;			/* general BUFFER */
extern NODEPROTO  *sch_andprim;			/* general AND */
extern NODEPROTO  *sch_orprim;			/* general OR */
extern NODEPROTO  *sch_xorprim;			/* general XOR */
extern NODEPROTO  *sch_ffprim;			/* general FLIP FLOP */
extern NODEPROTO  *sch_muxprim;			/* general MUX */
extern NODEPROTO  *sch_bboxprim;		/* black box */
extern NODEPROTO  *sch_switchprim;		/* switch */
extern NODEPROTO  *sch_offpageprim;		/* off page connector */
extern NODEPROTO  *sch_pwrprim;			/* power */
extern NODEPROTO  *sch_gndprim;			/* ground */
extern NODEPROTO  *sch_sourceprim;		/* source (voltage, current) */
extern NODEPROTO  *sch_transistorprim;	/* transistor */
extern NODEPROTO  *sch_resistorprim;	/* resistor */
extern NODEPROTO  *sch_capacitorprim;	/* capacitor */
extern NODEPROTO  *sch_diodeprim;		/* diode */
extern NODEPROTO  *sch_inductorprim;	/* inductor */
extern NODEPROTO  *sch_meterprim;		/* meter */
extern NODEPROTO  *sch_wellprim;		/* well connection */
extern NODEPROTO  *sch_substrateprim;	/* substrate connection */
extern NODEPROTO  *sch_twoportprim;		/* generic two-port block */

extern ARCPROTO   *sch_wirearc;			/* wire arc */
extern ARCPROTO   *sch_busarc;			/* bus arc */

extern INTBIG      sch_flipfloptypekey;	/* key for "SCHEM_flipflop_type" */
extern INTBIG      sch_transistortypekey;	/* key for "SCHEM_transistor_type" */
extern INTBIG      sch_sourcekey;		/* key for "SCHEM_source" */
extern INTBIG      sch_meterkey;		/* key for "SCHEM_meter_type" */
extern INTBIG      sch_diodekey;		/* key for "SCHEM_diode" */
extern INTBIG      sch_capacitancekey;	/* key for "SCHEM_capacitance" */
extern INTBIG      sch_resistancekey;	/* key for "SCHEM_resistance" */
extern INTBIG      sch_inductancekey;	/* key for "SCHEM_inductance" */
extern INTBIG      sch_twoportkey;		/* key for "SCHEM_twoport_type" */
extern INTBIG      sch_functionkey;		/* key for "SCHEM_function" */

#ifdef __cplusplus
extern "C"
{
#endif

/* prototypes for technology routines */
void sch_shapearcpoly(ARCINST*, INTSML, POLYGON*);
INTSML sch_arcpolys(ARCINST*);
void sch_shapeportpoly(NODEINST*, PORTPROTO*, POLYGON*, XARRAY, INTSML);
INTSML sch_nodeEpolys(NODEINST*);
void sch_shapeEnodepoly(NODEINST*, INTSML, POLYGON*);
void sch_shapenodepoly(NODEINST*, INTSML, POLYGON*);
INTSML sch_nodepolys(NODEINST*);
void sch_setmode(INTSML, char*[]);
INTSML sch_initprocess(TECHNOLOGY*, INTSML);

#ifdef __cplusplus
};
#endif
