/*
 * Electric(tm) VLSI Design System
 *
 * File: iovhdl.c
 * Input/output aid: VHDL input
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#include "config.h"
#if VHDLAID

#include "global.h"
#include "eio.h"
#include "edialogs.h"
#include <ctype.h>

#define MAXCHARS 300

INTBIG io_vhdllength;
INTBIG io_vhdlcurline;

/*
 * Routine to read the VHDL file into library "lib".  Returns nonzero on error.
 */
INTSML io_readvhdllibrary(LIBRARY *lib)
{
	REGISTER FILE *io;
	char *pt, *start, text[MAXCHARS], facetname[256];
	REGISTER INTSML save, sectionnamelen;
	enum {SECTIONNONE, SECTIONCOMPONENT, SECTIONENTITY} sectiontype;
	REGISTER INTBIG i, len, curLength;
	REGISTER NODEPROTO *storagefacet;
	void *stringarray;
	REGISTER VARIABLE *var;
	extern DIALOG usr_progressdialog;

	/* get the VHDL file */
	if ((io = xopen(lib->libfile, FILETYPEVHDL, "", &pt)) == NULL)
	{
		ttyputerr("File %s not found", lib->libfile);
		return(1);
	}

	/* determine file length */
	io_vhdllength = filesize(io);
	if (io_verbose < 0 && io_vhdllength > 0)
	{
		if (DiaInitDialog(&usr_progressdialog) != 0)
		{
			xclose(io);
			return(1);
		}
		DiaPercent(1, 0);
	}

	/* read the file */
	io_vhdlcurline = 0;
	storagefacet = NONODEPROTO;
	for(;;)
	{
		if (stopping("VHDL")) break;
		if (xfgets(text, MAXCHARS, io) != 0) break;
		io_vhdlcurline++;
		if ((io_vhdlcurline % 100) == 0)
		{
			curLength = xtell(io);
			DiaPercent(1, curLength * 100L / io_vhdllength);
		}

		if (storagefacet == NONODEPROTO)
		{
			/* scan for start of facet */
			pt = text;
			while (*pt == ' ' || *pt == '\t') pt++;
			sectiontype = SECTIONNONE;
			if (strncmp(pt, "component", (sectionnamelen = 9)) == 0)
				sectiontype = SECTIONCOMPONENT;
			else if (strncmp(pt, "entity", (sectionnamelen = 6)) == 0)
				sectiontype = SECTIONENTITY;
			if (sectiontype != SECTIONNONE)
			{
				pt += sectionnamelen;
				if (*pt == ' ' || *pt == '\t')
				{
					while (*pt == ' ' || *pt == '\t') pt++;
					start = pt;
					while (*pt != 0 && *pt != ' ' && *pt != '\t') pt++;
					save = *pt;
					*pt = 0;
					strcpy(facetname, start);
					for(storagefacet = lib->firstnodeproto; storagefacet != NONODEPROTO;
						storagefacet = storagefacet->nextnodeproto)
							if (namesame(facetname, storagefacet->cell->cellname) == 0 &&
								storagefacet->cellview == el_vhdlview) break;
					*pt = save;

					/* see if the facet already exists */
					if (storagefacet != NONODEPROTO)
					{
						/* already there: start with the existing VHDL */
						stringarray = newstringarray(io_aid->cluster);
						var = getvalkey((INTBIG)storagefacet, VNODEPROTO, VSTRING|VISARRAY,
							el_facet_message);
						if (var != NOVARIABLE)
						{
							len = getlength(var);
							for(i=0; i<len; i++)
								addtostringarray(stringarray, ((char **)var->addr)[i]);
							addtostringarray(stringarray, "");
						}
					} else
					{
						strcat(facetname, "{vhdl}");
						storagefacet = newnodeproto(facetname, lib);
						if (storagefacet == NONODEPROTO)
						{
							ttyputerr("Could not create facet %s", facetname);
							return(0);
						}
						stringarray = newstringarray(io_aid->cluster);
					}
				}
			}
			if (storagefacet == NONODEPROTO) continue;
		}

		/* save this line in the facet */
		addtostringarray(stringarray, text);

		/* see if this is the last line */
		pt = text;
		while (*pt == ' ' || *pt == '\t') pt++;
		if (strncmp(pt, "end", 3) == 0)
		{
			pt += 3;
			if (*pt == ' ' || *pt == '\t')
			{
				while (*pt == ' ' || *pt == '\t') pt++;
				switch (sectiontype)
				{
					case SECTIONCOMPONENT:
						if (strncmp(pt, "component", 9) == 0)
						{
							stringarraytotextfacet(stringarray, storagefacet, 1);
							killstringarray(stringarray);
							storagefacet = NONODEPROTO;
						}
						break;
					case SECTIONENTITY:
						start = pt;
						while (*pt != ';' && *pt != ' ' && *pt != '\t' && *pt != 0) pt++;
						save = *pt;   *pt = 0;
						if (namesame(start, storagefacet->cell->cellname) == 0)
						{
							stringarraytotextfacet(stringarray, storagefacet, 1);
							killstringarray(stringarray);
							storagefacet = NONODEPROTO;
						}
						*pt = save;
						break;
					default:
						break;
				}
			}
		}
	}
	xclose(io);
	if (io_verbose < 0 && io_vhdllength > 0)
	{
		DiaPercent(1, 100);
		DiaDoneDialog();
	}
	return(0);
}

#endif  /* VHDLAID - at top */
