/*
 * Electric(tm) VLSI Design System
 *
 * File: tectable.c
 * Technology tables
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#include "global.h"

#include "tecart.h"
extern COMCOMP art_parse;
extern GRAPHICS *art_layers[];
extern TECH_ARCS *art_arcprotos[];
extern TECH_NODES *art_nodeprotos[];
extern TECH_VARIABLES art_variables[];

#if TECBICMOS
  extern GRAPHICS *bicmos_layers[];
  extern TECH_ARCS *bicmos_arcprotos[];
  extern TECH_NODES *bicmos_nodeprotos[];
  extern TECH_VARIABLES bicmos_variables[];
  INTSML bicmos_initprocess(TECHNOLOGY*, INTSML);
#endif

#if TECBIPOLAR
  extern GRAPHICS *bipolar_layers[];
  extern TECH_ARCS *bipolar_arcprotos[];
  extern TECH_NODES *bipolar_nodeprotos[];
  extern TECH_VARIABLES bipolar_variables[];
  INTSML bipolar_initprocess(TECHNOLOGY*, INTSML);
#endif

#if TECCMOS
  extern GRAPHICS *cmos_layers[];
  extern TECH_ARCS *cmos_arcprotos[];
  extern TECH_NODES *cmos_nodeprotos[];
  extern TECH_VARIABLES cmos_variables[];
  INTSML cmos_initprocess(TECHNOLOGY*, INTSML);
#endif

#if TECCMOSDODN
# include "teccmosdodn.h"
  extern GRAPHICS *dodcmosn_layers[];
  extern TECH_ARCS *dodcmosn_arcprotos[];
  extern TECH_NODES *dodcmosn_nodeprotos[];
  extern TECH_VARIABLES dodcmosn_variables[];
#endif

#if TECDYNA
# include "tecdyna.h"
  extern GRAPHICS *dyna_layers[];
  extern TECH_ARCS *dyna_arcprotos[];
  extern TECH_NODES *dyna_nodeprotos[];
  extern TECH_VARIABLES dyna_variables[];
#endif

#if TECEFIDO
  extern GRAPHICS *efido_layers[];
  extern TECH_ARCS *efido_arcprotos[];
  extern TECH_NODES *efido_nodeprotos[];
  extern TECH_VARIABLES efido_variables[];
  INTSML efido_initprocess(TECHNOLOGY*, INTSML);
#endif

#if TECGEM
# include "tecgem.h"
  extern GRAPHICS *gem_layers[];
  extern TECH_ARCS *gem_arcprotos[];
  extern TECH_NODES *gem_nodeprotos[];
  extern TECH_VARIABLES gem_variables[];
#endif

#include "tecgen.h"
extern GRAPHICS *gen_layers[];
extern TECH_ARCS *gen_arcprotos[];
extern TECH_NODES *gen_nodeprotos[];
extern TECH_VARIABLES gen_variables[];

#if TECMOCMOS
# include "tecmocmos.h"
  extern COMCOMP mocmos_parse;
  extern GRAPHICS *mocmos_layers[];
  extern TECH_ARCS *mocmos_arcprotos[];
  extern TECH_NODES *mocmos_nodeprotos[];
  extern TECH_VARIABLES mocmos_variables[];
#endif

#if TECMOCMOSSUB
# include "tecmocmossub.h"
  extern COMCOMP mocmossub_parse;
  extern GRAPHICS *mocmossub_layers[];
  extern TECH_ARCS *mocmossub_arcprotos[];
  extern TECH_NODES *mocmossub_nodeprotos[];
  extern TECH_VARIABLES mocmossub_variables[];
#endif

#if TECMOCMOS2
  extern GRAPHICS *mocmos2_layers[];
  extern TECH_ARCS *mocmos2_arcprotos[];
  extern TECH_NODES *mocmos2_nodeprotos[];
  extern TECH_VARIABLES mocmos2_variables[];
  INTSML mocmos2_initprocess(TECHNOLOGY*, INTSML);
#endif

#if TECNCMOS3
# include "tecncmos3.h"
  extern GRAPHICS *ncmos3_layers[];
  extern TECH_ARCS *ncmos3_arcprotos[];
  extern TECH_NODES *ncmos3_nodeprotos[];
  extern TECH_VARIABLES ncmos3_variables[];
#endif

#if TECNMOS
  extern GRAPHICS *nmos_layers[];
  extern TECH_ARCS *nmos_arcprotos[];
  extern TECH_NODES *nmos_nodeprotos[];
  extern TECH_VARIABLES nmos_variables[];
  INTSML nmos_initprocess(TECHNOLOGY*, INTSML);
#endif

#if TECPCB
  extern GRAPHICS *pcb_layers[];
  extern TECH_ARCS *pcb_arcprotos[];
  extern TECH_NODES *pcb_nodeprotos[];
  extern TECH_VARIABLES pcb_variables[];
  INTSML pcb_initprocess(TECHNOLOGY*, INTSML);
#endif

#if TECRCMOS
# include "tecrcmos.h"
  extern GRAPHICS *rcmos_layers[];
  extern TECH_ARCS *rcmos_arcprotos[];
  extern TECH_NODES *rcmos_nodeprotos[];
  extern TECH_VARIABLES rcmos_variables[];
#endif

#include "tecschem.h"
extern COMCOMP sch_parse;
extern GRAPHICS *sch_layers[];
extern TECH_ARCS *sch_arcprotos[];
extern TECH_NODES *sch_nodeprotos[];
extern TECH_VARIABLES sch_variables[];

#if TECFPGA
# include "tecfpga.h"
  extern COMCOMP fpga_parse;
  extern GRAPHICS *fpga_layers[];
  extern TECH_ARCS *fpga_arcprotos[];
  extern TECH_NODES *fpga_nodeprotos[];
  extern TECH_VARIABLES fpga_variables[];
#endif

/*
 * the first entry in this table MUST BE THE GENERIC TECHNOLOGY!
 */
TECHNOLOGY el_technologylist[] =
{
	/* Generic */
	{"generic", 0, 2000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"Miscellaneous interconnect, constraint, and glyph",
	0, gen_layers, 0, gen_arcprotos, 0, gen_nodeprotos, gen_variables,
	gen_initprocess, 0, 0, gen_nodepolys, gen_nodepolys,
	gen_shapenodepoly, gen_shapenodepoly, gen_shapeportpoly, gen_arcpolys,
	gen_shapearcpoly, NOTECHNOLOGY, NONSTANDARD, 0, 0},

#if TECNMOS
	/* NMOS */
	{"nmos", 0, 4000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"n-channel MOS (from Mead & Conway)",
	0, nmos_layers, 0, nmos_arcprotos, 0, nmos_nodeprotos, nmos_variables,
	nmos_initprocess, 0, 0, 0, 0, 0, 0, 0, 0, 0, NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

#if TECCMOS
	/* CMOS */
	{"cmos", 0, 4000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"Complementary MOS (from Griswold, N-Well)",
	0, cmos_layers, 0, cmos_arcprotos, 0, cmos_nodeprotos, cmos_variables,
	cmos_initprocess, 0, 0, 0, 0, 0, 0, 0, 0, 0, NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

#if TECDYNA
	/* DynaChip */
    {"dyna", 0, 2000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
    "DynaChip DL5000 series FPGA",
    0, dyna_layers, 0, dyna_arcprotos, 0, dyna_nodeprotos, dyna_variables,
    0, 0, 0, dyna_nodepolys, 0, dyna_shapenodepoly, 0, 0, 0, 0,
	NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

#if TECMOCMOS
	/* MOSIS CMOS */
	{"mocmos", 0, 2000,NONODEPROTO,NOARCPROTO,NOVARIABLE,0,&mocmos_parse,NOCLUSTER,
	"Complementary MOS (from MOSIS, P-Well, double metal)",
	0, mocmos_layers, 0, mocmos_arcprotos, 0, mocmos_nodeprotos, mocmos_variables,
	mocmos_initprocess, mocmos_setmode, 0, 0, 0, 0, 0, 0, mocmos_arcpolys,
	mocmos_shapearcpoly, NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

#if TECMOCMOSSUB
	/* MOSIS CMOS Submicron */
	{"mocmossub", 0, 400,NONODEPROTO,NOARCPROTO,NOVARIABLE,0,&mocmossub_parse,NOCLUSTER,
	"Complementary MOS (from MOSIS, Submicron, P-Well, quad metal, double poly)",
	0, mocmossub_layers, 0, mocmossub_arcprotos, 0, mocmossub_nodeprotos, mocmossub_variables,
	mocmossub_initprocess, mocmossub_setmode, 0, 0, 0, 0, 0, 0, 0, 0, NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

#if TECMOCMOS2
	/* MOSIS CMOS, 2 micron */
	{"mocmos2", 0, 2000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"Complementary MOS (MOSIS, Orbit, P-Well, double metal, double poly)",
	0, mocmos2_layers, 0, mocmos2_arcprotos, 0, mocmos2_nodeprotos, mocmos2_variables,
	mocmos2_initprocess, 0, 0, 0, 0, 0, 0, 0, 0, 0, NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

#if TECBICMOS
	/* MOSIS BiCMOS */
	{"bicmos", 0, 2000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"MOSIS BiCMOS (N-Well, 2u, SCE Rules)",
	0, bicmos_layers, 0, bicmos_arcprotos, 0, bicmos_nodeprotos, bicmos_variables,
	bicmos_initprocess, 0, 0, 0, 0, 0, 0, 0, 0, 0, NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

#if TECRCMOS
	/* Round MOSIS CMOS */
	{"rcmos", 0, 2000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"Complementary MOS (round, from MOSIS, P-Well, double metal)",
	0, rcmos_layers, 0, rcmos_arcprotos, 0, rcmos_nodeprotos, rcmos_variables,
	rcmos_initprocess, 0, 0, 0, 0, 0, 0, 0, rcmos_arcpolys, rcmos_shapearcpoly,
	NOTECHNOLOGY, NONSTANDARD|NONEGATEDARCS, 0, 0},
#endif

#if TECNCMOS3
	/* Northern Telecom CMOS */
	{"ncmos3", 0, 2000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"Complementary MOS (from Northern Telecom, P-Well, 3 micron, double metal)",
	0, ncmos3_layers, 0, ncmos3_arcprotos, 0, ncmos3_nodeprotos, ncmos3_variables,
	ncmos3_initprocess, 0, 0, ncmos3_nodepolys, ncmos3_nodeEpolys, ncmos3_shapenodepoly,
	ncmos3_shapeEnodepoly, 0, 0, 0, NOTECHNOLOGY, (NONSTANDARD|NONEGATEDARCS), 0, 0},
#endif

#if TECCMOSDODN
	/* DOD CMOS (from Gary Lambert) */
	{"cmosdodn", 0, 2000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"DODCmosN, lambda rules: PWell, 1 Poly, 2 Metal",
	0, dodcmosn_layers, 0, dodcmosn_arcprotos, 0, dodcmosn_nodeprotos, dodcmosn_variables,
 	dodcmosn_initprocess, 0, 0, 0, 0, dodcmosn_shapenodepoly, 0, 0, 0, 0, NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

#if TECBIPOLAR
	/* bipolar */
	{"bipolar", 0, 4000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"Self-Aligned Single Poly Bipolar",
	0, bipolar_layers, 0, bipolar_arcprotos, 0, bipolar_nodeprotos, bipolar_variables,
	bipolar_initprocess, 0, 0, 0, 0, 0, 0, 0, 0, 0, NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

	/* Schematic capture */
	{"schematic", 0, 4000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,&sch_parse,
	NOCLUSTER, "Schematic Capture",
	0, sch_layers, 0, sch_arcprotos, 0, sch_nodeprotos, sch_variables,
	sch_initprocess, sch_setmode, 0, sch_nodepolys, sch_nodeEpolys,
	sch_shapenodepoly, sch_shapeEnodepoly, sch_shapeportpoly, sch_arcpolys,
	sch_shapearcpoly, NOTECHNOLOGY, NONSTANDARD, 0, 0},

#if TECFPGA
	/* FPGA */
	{"fpga", 0, 2000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,&fpga_parse,NOCLUSTER,
	"FPGA Building-Blocks",
	0, fpga_layers, 0, fpga_arcprotos, 0, fpga_nodeprotos, fpga_variables,
	fpga_initprocess, fpga_setmode, 0, fpga_nodepolys, fpga_nodeEpolys,
	fpga_shapenodepoly, fpga_shapeEnodepoly, fpga_shapeportpoly, fpga_arcpolys,
	fpga_shapearcpoly, NOTECHNOLOGY, NONSTANDARD, 0, 0},
#endif

#if TECPCB
	/* Printed Circuit Board */
	{"pcb", 0, 2540000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"Eight-Layer Printed Circuit Board",
	0, pcb_layers, 0, pcb_arcprotos, 0, pcb_nodeprotos, pcb_variables,
	pcb_initprocess, 0, 0, 0, 0, 0, 0, 0, 0, 0, NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

	/* Artwork */
	{"artwork", 0, 2000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,&art_parse,NOCLUSTER,
	"General Purpose Sketchpad Facility",
	0, art_layers, 0, art_arcprotos, 0, art_nodeprotos, art_variables,
	art_initprocess, art_setmode, 0, art_nodepolys, art_nodeEpolys,
	art_shapenodepoly, art_shapeEnodepoly, art_shapeportpoly, art_arcpolys, art_shapearcpoly,
	NOTECHNOLOGY, NONSTANDARD|NONELECTRICAL|NONEGATEDARCS, 0, 0},

#if TECGEM
	/* Gem Planning */
	{"gem", 0, 2000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"Group Element Model (from Lansky)",
	0, gem_layers, 0, gem_arcprotos, 0, gem_nodeprotos, gem_variables,
	gem_initprocess, 0, 0, 0, 0, gem_shapenodepoly, 0, 0, 0, gem_shapearcpoly,
	NOTECHNOLOGY, NONSTANDARD|NONELECTRICAL|NODIRECTIONALARCS|NONEGATEDARCS, 0, 0},
#endif

#if TECEFIDO
	/* Digital Filter */
	{"efido", 0, 20000, NONODEPROTO,NOARCPROTO,NOVARIABLE,0,NOCOMCOMP,NOCLUSTER,
	"Digital Filter Facility (from Kroeker)",
	0, efido_layers, 0, efido_arcprotos, 0, efido_nodeprotos, efido_variables,
	efido_initprocess, 0, 0, 0, 0, 0, 0, 0, 0, 0, NOTECHNOLOGY, NONEGATEDARCS, 0, 0},
#endif

	/* termination */
	{NULL, 0, 0, NULL, NULL, NULL, 0, NULL, NULL, NULL,
	0, NULL, 0, NULL, 0, NULL, NULL,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0}
};
