/*
 * Electric(tm) VLSI Design System
 *
 * File: usrcom2.c
 * User interface aid: parameter parsing routines, part 2
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#include "global.h"
#include "usr.h"

extern KEYWORD us_onoffopt[], us_texttopt[];

/* prototypes for local routines */
INTSML us_paramvisiblelayers(char*, COMCOMP*[], char);

/* the "var" command */
static COMCOMP varmoddxp = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	INPUTOPT, " \t", "X offset of variable", 0};
static COMCOMP varmoddyp = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	0, " \t", "Y offset of variable", 0};
static COMCOMP varmoddsp = {us_texttopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Text style of variable", 0};
static KEYWORD varmodopt[] =
{
	{"lisp",              0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"tcl",               0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"mathematica",       0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"display",           3,{&varmoddxp,&varmoddyp,&varmoddsp,NOKEY,NOKEY}},
	{"temporary",         0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"fractional",        0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"cannot-change",     0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP varmodp = {varmodopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "modifier to the variable", 0};
static KEYWORD varhcnopt[] =
{
	{"language",          0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"display",           0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"temporary",         0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"cannot-change",     0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP varhcnp = {varhcnopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	INPUTOPT, " \t", "how to unchange the variable", 0};
static KEYWORD varhcopt[] =
{
	{"not",               1,{&varhcnp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"lisp",              0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"tcl",               0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"mathematica",       0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"display",           3,{&varmoddxp,&varmoddyp,&varmoddsp,NOKEY,NOKEY}},
	{"temporary",         0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"cannot-change",     0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP varhcp = {varhcopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "how to change the variable", 0};
COMCOMP us_varvalp = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	0, " \t", "new value of variable", 0};
COMCOMP us_varvalcp = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	0, " \t", "this variable cannot be set!", 0};
static COMCOMP varupdp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "modification to variable", 0};
COMCOMP us_varvsp = {NOKEYWORD, us_topofvars, us_nextvars, NOPARAMS, NOBACKUP,
	NOFILL|INPUTOPT|INCLUDENOISE, " \t", "variable name to set", 0};
COMCOMP us_varvep = {NOKEYWORD, us_topofvars, us_nextvars, NOPARAMS, NOBACKUP,
	NOFILL|INPUTOPT, " \t", "variable name to examine", 0};
static COMCOMP varvcp = {NOKEYWORD, us_topofvars, us_nextvars, NOPARAMS,
	NOBACKUP, NOFILL|INPUTOPT, " \t", "variable name to change", 0};
static COMCOMP varvpp = {NOKEYWORD, us_topofvars, us_nextvars, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "variable to pick in menu", 0};
static COMCOMP varvtp = {NOKEYWORD, us_topofvars, us_nextvars, NOPARAMS,
	NOBACKUP, INPUTOPT|INCLUDENOISE, " \t", "variable to edit in window", 0};
static COMCOMP varqhp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "header string for edit window", 0};
static KEYWORD varqopt[] =
{
	{"header",              1,{&varqhp,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
COMCOMP us_varqp = {varqopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, 0, " \t", "text editing option", 0};
COMCOMP us_varvdp = {NOKEYWORD, us_topofvars, us_nextvars, NOPARAMS, NOBACKUP,
	NOFILL, " \t", "variable name to delete", 0};
static COMCOMP varvmp = {NOKEYWORD,us_topofvars,us_nextvars,NOPARAMS,NOBACKUP,
	NOFILL|INPUTOPT, " \t", "variable name to modify", 0};
static COMCOMP varbdp = {NOKEYWORD, us_topofvars, us_nextvars, NOPARAMS, NOBACKUP,
	NOFILL|INPUTOPT|INCLUDENOISE, " \t", "variable name to set", 0};
static COMCOMP varbs1p = {NOKEYWORD, us_topofvars, us_nextvars, NOPARAMS, NOBACKUP,
	NOFILL|INPUTOPT|INCLUDENOISE, " \t", "first operand variable name", 0};
static COMCOMP varbs2p = {NOKEYWORD, us_topofvars, us_nextvars, NOPARAMS, NOBACKUP,
	NOFILL|INPUTOPT|INCLUDENOISE, " \t", "second operand variable name", 0};
static COMCOMP varbs2tp = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	NOFILL|INPUTOPT, " \t", "pattern matching string", 0};
static KEYWORD varbs2tyopt[] =
{
	{"unknown",               0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"integer",               0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"short",                 0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"fixed-point",           0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"address",               0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"character",             0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"string",                0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"float",                 0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"double",                0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"nodeinst",              0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"nodeproto",             0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"cell",                  0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"portarcinst",           0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"portexpinst",           0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"portproto",             0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"arcinst",               0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"arcproto",              0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"geometry",              0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"r-tree",                0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"library",               0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"technology",            0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"aid",                   0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"network",               0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"view",                  0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"window",                0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"graphics",              0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"constraint",            0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"general",               0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
COMCOMP us_varbs2typ = {varbs2tyopt, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	NOFILL|INPUTOPT, " \t", "type to request", 0};
static KEYWORD varbopt[] =
{
	{"set",                 0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"concat",              1,{&varbs2p,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"type",                1,{&us_varbs2typ,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"select",              1,{&varbs2p,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"pattern",             1,{&varbs2tp,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
COMCOMP varbop = {varbopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, 0, " \t", "operator to perform on variables", 0};
static KEYWORD varopt[] =
{
	{"set",               3,{&us_varvsp,&us_varvalp,&varmodp,NOKEY,NOKEY}},
	{"examine",           1,{&us_varvep,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"change",            2,{&varvcp,&varhcp,NOKEY,NOKEY,NOKEY}},
	{"delete",            1,{&us_varvdp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"pick",              1,{&varvpp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"textedit",          2,{&varvtp,&us_varqp,NOKEY,NOKEY,NOKEY}},
	{"vector",            3,{&varbdp,&varbs1p,&varbop,NOKEY,NOKEY}},
	{"+",                 3,{&varvmp,&varupdp,&varmodp,NOKEY,NOKEY}},
	{"-",                 3,{&varvmp,&varupdp,&varmodp,NOKEY,NOKEY}},
	{"*",                 3,{&varvmp,&varupdp,&varmodp,NOKEY,NOKEY}},
	{"/",                 3,{&varvmp,&varupdp,&varmodp,NOKEY,NOKEY}},
	{"mod",               3,{&varvmp,&varupdp,&varmodp,NOKEY,NOKEY}},
	{"and",               3,{&varvmp,&varupdp,&varmodp,NOKEY,NOKEY}},
	{"or",                3,{&varvmp,&varupdp,&varmodp,NOKEY,NOKEY}},
	{"|",                 3,{&varvmp,&varupdp,&varmodp,NOKEY,NOKEY}},
	TERMKEY
};
COMCOMP us_varp = {varopt, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	0, " \t", "option for manipulating variables", 0};

/* the "view" command */
static COMCOMP viewc1p = {NOKEYWORD, us_topoffacets, us_nextparse, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "facet name whose view is to be changed", 0};
COMCOMP us_viewc2p = {NOKEYWORD, topofviews, nextviews, NOPARAMS,
	NOBACKUP, 0, " \t", "new view for the facet", 0};
static COMCOMP viewdp = {NOKEYWORD, topofviews, nextviews, NOPARAMS, NOBACKUP,
	INPUTOPT, " \t", "view name to delete", 0};
static KEYWORD viewvhopt[] =
{
	{"vertical",        0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP viewvhp = {viewvhopt, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	INPUTOPT, " \t", "option to rotate frame", 0};
static KEYWORD viewfopt[] =
{
	{"A",                 1,{&viewvhp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"D",                 1,{&viewvhp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"none",              0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP viewfp = {viewfopt, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	INPUTOPT, " \t", "frame size to use for this facet", 0};
COMCOMP us_viewn1p = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	INPUTOPT, " \t", "new view name", 0};
static COMCOMP viewn2p = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	0, " \t", "abbreviation for new view name", 0};
static KEYWORD viewtopt[] =
{
	{"text",              0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP viewn3p = {viewtopt, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	0, " \t", "type of view (graphical)", 0};
static KEYWORD viewopt[] =
{
	{"new",               3,{&us_viewn1p,&viewn2p,&viewn3p,NOKEY,NOKEY}},
	{"delete",            1,{&viewdp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"change",            2,{&viewc1p,&us_viewc2p,NOKEY,NOKEY,NOKEY}},
	{"frame",             1,{&viewfp,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
COMCOMP us_viewp = {viewopt, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	0, " \t", "option for manipulating cell views", 0};

/* the "visiblelayers" command */
static KEYWORD visiblelayersnoptp[] =
{
	{"no-list",           0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP visiblelayersnp = {visiblelayersnoptp, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, 0, " \t", "option to supress layer listing", 0};
INTSML us_paramvisiblelayers(char *i, COMCOMP *j[], char c)
{ j[0] = &visiblelayersnp; return(1);}
COMCOMP us_visiblelayersp = {NOKEYWORD, us_topoflayers, us_nextparse,
	us_paramvisiblelayers, NOBACKUP, NOFILL|INPUTOPT, " \t",
		"layers to be made visible (* for all)", "show layers"};

/* the "window" command */
static KEYWORD windowspopt[] =
{
	{"horizontal",    0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"vertical",      0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP windowspp = {windowspopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	INPUTOPT, " \t", "way to split the window", 0};
COMCOMP us_windowmp = {NOKEYWORD, us_topofwindows, us_nextparse, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "other window whose scale to match", 0};
COMCOMP us_windowup = {NOKEYWORD, us_topofwindows, us_nextparse, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "window to use", 0};
static COMCOMP windowap = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	INPUTOPT, " \t", "amount to move window", 0};
static COMCOMP windowsp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	INPUTOPT, " \t", "amount to scale", 0};
static KEYWORD windowzopt[] =
{
	{"integral",     0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"nonintegral",  0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP windowzp = {windowzopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "option to force window scale to align with pixels",
		"show current state"};
static COMCOMP windowmasp = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "magnification amount (2, 4, or 8)", "4"};
static KEYWORD windowmaopt[] =
{
	{"on",           1,{&windowmasp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"off",          0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"temporary",    1,{&windowmasp,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP windowmap = {windowmaopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "option to force window scale to align with pixels",
		"show current magnification"};
static KEYWORD windownopt[] =
{
	{"standard",     0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"pen",          0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"tee",          0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP windownp = {windownopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "default cursor to use in window", 0};
static KEYWORD windowtopt[] =
{
	{"draw",        0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"hash-out",    0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP windowtp = {windowtopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "how to draw tiny facets in window", 0};
static COMCOMP windowdp = {us_onoffopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "mode in which cursor-based operations drag objects",
		"show current state"};
COMCOMP us_windowrnamep = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "view name", 0};
static COMCOMP windowsnamep = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, NOFILL|INPUTOPT|INCLUDENOISE, " \t", "view name", 0};
static KEYWORD windowoopt[] =
{
	{"on",        0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"off",       0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP windowop = {windowoopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "whether to allow overlappable layers", 0};
static KEYWORD windowsbaopt[] =
{
	{"align",        0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"angle",        0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"arc",          0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"facet",        0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"grid",         0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"lambda",       0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"network",      0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"node",         0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"package",      0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"part",         0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"project",      0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"root",         0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"selection",    0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"size",         0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"technology",   0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"x",            0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"y",            0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP windowsbap = {windowsbaopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "area in status bar", 0};
static COMCOMP windowsblp = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "line number (1-based)", 0};
static COMCOMP windowsbsp = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "starting percentage of position on line", 0};
static COMCOMP windowsbep = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "ending percentage of position on line", 0};
static COMCOMP windowsbtp = {NOKEYWORD, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "title of status field", 0};
static KEYWORD windowsbcopt[] =
{
	{"persistent",       0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"temporary",        0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP windowsbcp = {windowsbcopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	INPUTOPT, " \t", "persistence of current node in status bar", ""};
static KEYWORD windowsbopt[] =
{
	{"add",          5,{&windowsbap,&windowsblp,&windowsbsp,&windowsbep,&windowsbtp}},
	{"delete",       1,{&windowsbap,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"current-node", 1,{&windowsbcp,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
static COMCOMP windowsbp = {windowsbopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "commands for status bar", 0};
static KEYWORD windowopt[] =
{
	{"1-window",            0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"split",               1,{&windowspp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"new",                 0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"delete",              0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"kill",                0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"join",                0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"match",               1,{&us_windowmp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"use",                 1,{&us_windowup,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"peek",                0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"up",                  1,{&windowap,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"down",                1,{&windowap,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"left",                1,{&windowap,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"right",               1,{&windowap,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"in-zoom",             1,{&windowsp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"out-zoom",            1,{&windowsp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"all-displayed",       0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"trace-displayed",     0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"highlight-displayed", 0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"cursor-centered",     0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"center-highlight",    0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"save",                1,{&us_windowrnamep,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"name",                1,{&windowsnamep,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"dragging",            1,{&windowdp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"magnification",       1,{&windowmap,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"zoom-scale",          1,{&windowzp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"normal-cursor",       2,{&windownp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"measure",             0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"drop-down-menus",     0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"pop-up-menus",        0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"tiny-facets",         1,{&windowtp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"overlappable-display",1,{&windowop,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"status-bar",          1,{&windowsbp,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
COMCOMP us_windowp = {windowopt, NOTOPLIST, NONEXTLIST, NOPARAMS, NOBACKUP,
	0, " \t", "window display control option", 0};

/* the "yanknode" command */
static KEYWORD yanknodeopt[] =
{
	{"keep-ports",    0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};
COMCOMP us_yanknodep = {yanknodeopt, NOTOPLIST, NONEXTLIST, NOPARAMS,
	NOBACKUP, INPUTOPT, " \t", "yanknode option", 0};
