/*
 * Electric(tm) VLSI Design System
 *
 * File: usrdiacom1.c
 * Special command dialogs, part 1
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#include "global.h"
#include "egraphics.h"
#include "usr.h"
#include "usrdiacom.h"
#include "efunction.h"
#include "tecart.h"
#include "tecschem.h"
#include "usredtec.h"
#include "sim.h"
#include "eio.h"
#include "edialogs.h"

/*
 * the list of contributors to Electric (NOT INCLUDING STEVEN M. RUBIN)
 */
char *usr_castofthousands[] =
{
	"Philip Attfield",
	"Ron Bolton",
	"Mark Brinsmead",
	"Stefano Concina",
	"Peter Gallant",
	"R. Brian Gardiner",
	"T. J. Goodman",
	"D. Guptill",
	"Robert Hon",
	"Sundaravarathan Iyengar",
	"Allan Jost",
	"Wallace Kroeker",
	"Andrew Kostiuk",
	"Oliver Laumann",
	"Glen Lawson",
	"David Lewis",
	"Erwin Liu",
	"John Mohammed",
	"Mark Moraes",
	"Sid Penstone",
	"J. P. Polonovski",
	"Kevin Ryan",
	"Nora Ryan",
	"Brent Serbin",
	"Boaz Shmueli",
	"Ken Stevens",
	"Lyndon Swab",
	"Brian W. Thomson",
	"Burnie West",
	"Telle Whitney",
	"Rob Winstanley",
	"Russell Wright",
	"David J. Yurach",
	0
};

char *usr_gnucopying[] =
{
	"TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION",
	"",
	"0. This License applies to any program or other work which contains a notice placed by",
	"the copyright holder saying it may be distributed under the terms of this General",
	"Public License. The 'Program', below, refers to any such program or work, and a",
	"'work based on the Program' means either the Program or any derivative work under",
	"copyright law: that is to say, a work containing the Program or a portion of it,",
	"either verbatim or with modifications and/or translated into another language.",
	"(Hereinafter, translation is included without limitation in the term 'modification'.)",
	"Each licensee is addressed as 'you'.",
	"",
	"Activities other than copying, distribution and modification are not covered by this",
	"License; they are outside its scope. The act of running the Program is not restricted,",
	"and the output from the Program is covered only if its contents constitute a work based",
	"on the Program (independent of having been made by running the Program). Whether that",
	"is true depends on what the Program does.",
	"",
	"1. You may copy and distribute verbatim copies of the Program's source code as you",
	"receive it, in any medium, provided that you conspicuously and appropriately publish",
	"on each copy an appropriate copyright notice and disclaimer of warranty; keep intact",
	"all the notices that refer to this License and to the absence of any warranty; and",
	"give any other recipients of the Program a copy of this License along with the Program.", 
	"",
	"You may charge a fee for the physical act of transferring a copy, and you may at your",
	"option offer warranty protection in exchange for a fee.",
	"",
	"2. You may modify your copy or copies of the Program or any portion of it, thus forming",
	"a work based on the Program, and copy and distribute such modifications or work under",
	"the terms of Section 1 above, provided that you also meet all of these conditions:",
	"",
	"*	a) You must cause the modified files to carry prominent notices stating that you",
	"	changed the files and the date of any change.",
	"",
	"*	b) You must cause any work that you distribute or publish, that in whole or",
	"	in part contains or is derived from the Program or any part thereof, to be licensed",
	"	as a whole at no charge to all third parties under the terms of this License.",
	"",
	"*	c) If the modified program normally reads commands interactively when run, you",
	"	must cause it, when started running for such interactive use in the most ordinary",
	"	way, to print or display an announcement including an appropriate copyright notice",
	"	and a notice that there is no warranty (or else, saying that you provide a warranty)",
	"	and that users may redistribute the program under these conditions, and telling the",
	"	user how to view a copy of this License. (Exception: if the Program itself is",
	"	interactive but does not normally print such an announcement, your work based on the",
	"	Program is not required to print an announcement.)",
	"",
	"These requirements apply to the modified work as a whole. If identifiable sections",
	"of that work are not derived from the Program, and can be reasonably considered independent",
	"and separate works in themselves, then this License, and its terms, do not apply to those",
	"sections when you distribute them as separate works. But when you distribute the same",
	"sections as part of a whole which is a work based on the Program, the distribution of",
	"the whole must be on the terms of this License, whose permissions for other licensees",
	"extend to the entire whole, and thus to each and every part regardless of who wrote it.",
	"",
	"Thus, it is not the intent of this section to claim rights or contest your rights to",
	"work written entirely by you; rather, the intent is to exercise the right to control",
	"the distribution of derivative or collective works based on the Program.",
	"",
	"In addition, mere aggregation of another work not based on the Program with the Program",
	"(or with a work based on the Program) on a volume of a storage or distribution medium",
	"does not bring the other work under the scope of this License.",
	"",
	"3. You may copy and distribute the Program (or a work based on it, under Section 2)",
	"in object code or executable form under the terms of Sections 1 and 2 above provided",
	"that you also do one of the following:",
	"",
	"*	a) Accompany it with the complete corresponding machine-readable source code,",
	"which must be distributed under the terms of Sections 1 and 2 above on a medium",
	"customarily used for software interchange; or,",
	"",
	"*	b) Accompany it with a written offer, valid for at least three years, to give",
	"any third party, for a charge no more than your cost of physically performing source",
	"distribution, a complete machine-readable copy of the corresponding source code,",
	"to be distributed under the terms of Sections 1 and 2 above on a medium customarily",
	"used for software interchange; or,",
	"",
	"*	c) Accompany it with the information you received as to the offer to distribute",
	"corresponding source code. (This alternative is allowed only for noncommercial",
	"distribution and only if you received the program in object code or executable",
	"form with such an offer, in accord with Subsection b above.)",
	"",
	"The source code for a work means the preferred form of the work for making",
	"modifications to it. For an executable work, complete source code means all",
	"the source code for all modules it contains, plus any associated interface",
	"definition files, plus the scripts used to control compilation and installation",
	"of the executable. However, as a special exception, the source code distributed",
	"need not include anything that is normally distributed (in either source or binary",
	"form) with the major components (compiler, kernel, and so on) of the operating",
	"system on which the executable runs, unless that component itself accompanies the executable.",
	"",
	"If distribution of executable or object code is made by offering access to copy",
	"from a designated place, then offering equivalent access to copy the source code",
	"from the same place counts as distribution of the source code, even though third",
	"parties are not compelled to copy the source along with the object code.",
	"",
	"4. You may not copy, modify, sublicense, or distribute the Program except as",
	"expressly provided under this License. Any attempt otherwise to copy, modify,",
	"sublicense or distribute the Program is void, and will automatically terminate your",
	"rights under this License. However, parties who have received copies, or rights,",
	"from you under this License will not have their licenses terminated so long as",
	"such parties remain in full compliance.",
	"",
	"5. You are not required to accept this License, since you have not signed it.",
	"However, nothing else grants you permission to modify or distribute the Program or",
	"its derivative works. These actions are prohibited by law if you do not accept this",
	"License. Therefore, by modifying or distributing the Program (or any work based on",
	"the Program), you indicate your acceptance of this License to do so, and all its",
	"terms and conditions for copying, distributing or modifying the Program or works based on it.",
	"",
	"6. Each time you redistribute the Program (or any work based on the Program),",
	"the recipient automatically receives a license from the original licensor to copy,",
	"distribute or modify the Program subject to these terms and conditions. You may not",
	"impose any further restrictions on the recipients' exercise of the rights granted",
	"herein. You are not responsible for enforcing compliance by third parties to this License.", 
	"",
	"7. If, as a consequence of a court judgment or allegation of patent infringement",
	"or for any other reason (not limited to patent issues), conditions are imposed",
	"on you (whether by court order, agreement or otherwise) that contradict the conditions",
	"of this License, they do not excuse you from the conditions of this License. If you",
	"cannot distribute so as to satisfy simultaneously your obligations under this",
	"License and any other pertinent obligations, then as a consequence you may not",
	"distribute the Program at all. For example, if a patent license would not permit",
	"royalty-free redistribution of the Program by all those who receive copies directly",
	"or indirectly through you, then the only way you could satisfy both it and this",
	"License would be to refrain entirely from distribution of the Program.",
	"",
	"If any portion of this section is held invalid or unenforceable under any",
	"particular circumstance, the balance of the section is intended to apply and",
	"the section as a whole is intended to apply in other circumstances.",
	"",
	"It is not the purpose of this section to induce you to infringe any patents",
	"or other property right claims or to contest validity of any such claims; this",
	"section has the sole purpose of protecting the integrity of the free software",
	"distribution system, which is implemented by public license practices. Many",
	"people have made generous contributions to the wide range of software distributed",
	"through that system in reliance on consistent application of that system; it is",
	"up to the author/donor to decide if he or she is willing to distribute software",
	"through any other system and a licensee cannot impose that choice.",
	"",
	"This section is intended to make thoroughly clear what is believed to be a",
	"consequence of the rest of this License.",
	"",
	"8. If the distribution and/or use of the Program is restricted in certain",
	"countries either by patents or by copyrighted interfaces, the original copyright",
	"holder who places the Program under this License may add an explicit geographical",
	"distribution limitation excluding those countries, so that distribution is permitted",
	"only in or among countries not thus excluded. In such case, this License incorporates",
	"the limitation as if written in the body of this License.",
	"",
	"9. The Free Software Foundation may publish revised and/or new versions of the",
	"General Public License from time to time. Such new versions will be similar in",
	"spirit to the present version, but may differ in detail to address new problems",
	"or concerns.",
	"",
	"Each version is given a distinguishing version number. If the Program specifies",
	"a version number of this License which applies to it and 'any later version',",
	"you have the option of following the terms and conditions either of that version",
	"or of any later version published by the Free Software Foundation. If the Program",
	"does not specify a version number of this License, you may choose any version ever",
	"published by the Free Software Foundation.",
	"",
	"10. If you wish to incorporate parts of the Program into other free programs",
	"whose distribution conditions are different, write to the author to ask for",
	"permission. For software which is copyrighted by the Free Software Foundation,",
	"write to the Free Software Foundation; we sometimes make exceptions for this.",
	"Our decision will be guided by the two goals of preserving the free status of",
	"all derivatives of our free software and of promoting the sharing and reuse of",
	"software generally.",
	0
};

char *usr_gnuwarranty[] =
{
	"NO WARRANTY",
	"",
	"11. Because the program is licensed free of charge, there is no warranty for the",
	"program, to the extent permitted by applicable law. Except when otherwise stated",
	"in writing the copyright holders and/or other parties provide the program 'as is'",
	"without warranty of any kind, either expressed or implied, including, but not",
	"limited to, the implied warranties of merchantability and fitness for a particular",
	"purpose. The entire risk as to the quality and performance of the program is with you.",
	"Should the program prove defective, you assume the cost of all necessary servicing,",
	"repair or correction. ",
	"",
	"12. In no event unless required by applicable law or agreed to in writing will any",
	"copyright holder, or any other party who may modify and/or redistribute the program",
	"as permitted above, be liable to you for damages, including any general, special,",
	"incidental or consequential damages arising out of the use or inability to use the",
	"program (including but not limited to loss of data or data being rendered inaccurate",
	"or losses sustained by you or third parties or a failure of the program to operate",
	"with any other programs), even if such holder or other party has been advised of",
	"the possibility of such damages. ",
	0
};

/* icons for the "About Electric" dialog */
unsigned char usr_icon130[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 03, 0377, 0377, 0, 07, 0377, 0377, 0, 014, 0, 0, 0, 030, 0, 0,
	0, 060, 0, 0, 0, 0140, 0, 0, 0, 0300, 0, 0, 01, 0200, 0, 0,
	03, 0, 0, 0, 03, 0, 0, 0, 06, 0, 0, 0, 06, 0, 0, 0,
	014, 03, 0374, 0, 014, 03, 0374, 0, 030, 03, 0374, 0, 030, 03, 0374, 0,
	060, 03, 0374, 0, 060, 03, 0374, 0, 0140, 03, 0374, 0, 0140, 03, 0374, 0,
	0300, 03, 0374, 0, 0300, 03, 0374, 0, 0300, 03, 0374, 0, 0300, 03, 0374, 0,
	0300, 03, 0374, 0, 0300, 03, 0374, 0, 0300, 03, 0374, 0, 0300, 03, 0374, 0
};
unsigned char usr_icon129[] =
{
	0300, 03, 0374, 0, 0300, 03, 0374, 0, 0300, 03, 0374, 0, 0300, 03, 0374, 0,
	0300, 03, 0374, 0, 0300, 03, 0374, 0, 0300, 0, 0, 0, 0300, 0, 0, 0,
	0140, 0, 0, 03, 0140, 0, 0, 07, 060, 0, 0, 017, 060, 0, 0, 037,
	030, 0, 0, 077, 030, 0, 0, 077, 014, 0, 0, 077, 014, 0, 0, 077,
	06, 0, 0, 077, 06, 0, 0, 077, 03, 0, 0, 077, 03, 0, 0, 077,
	01, 0200, 0, 0, 0, 0300, 0, 0, 0, 0140, 0, 0, 0, 060, 0, 0,
	0, 030, 0, 0, 0, 014, 0, 0, 0, 07, 0377, 0377, 0, 03, 0377, 0377,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon131[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0377, 0377, 0300, 0, 0377, 0377, 0340, 0, 0, 0, 060, 0, 0, 0, 030, 0,
	0, 0, 014, 0, 0, 0, 06, 0, 0, 0, 03, 0, 0, 0, 01, 0200,
	0, 0, 0, 0300, 0, 0, 0, 0300, 0, 0, 0, 0140, 0, 0, 0, 0140,
	0, 077, 0300, 060, 0, 077, 0300, 060, 0, 077, 0300, 030, 0, 077, 0300, 030,
	0, 077, 0300, 014, 0, 077, 0300, 014, 0, 077, 0300, 06, 0, 077, 0300, 06,
	0, 077, 0300, 03, 0, 077, 0300, 03, 0, 077, 0300, 03, 0, 077, 0300, 03,
	0, 077, 0300, 03, 0, 077, 0300, 03, 0, 077, 0300, 03, 0, 077, 0300, 03
};
unsigned char usr_icon132[] =
{
	0, 077, 0300, 03, 0, 077, 0300, 03, 0, 077, 0300, 03, 0, 077, 0300, 03,
	0, 0, 0, 03, 0, 0, 0, 03, 0, 0, 0, 03, 0, 0, 0, 03,
	0300, 0, 0, 06, 0340, 0, 0, 06, 0360, 0, 0, 014, 0370, 0, 0, 014,
	0374, 0, 0, 030, 0374, 0, 0, 030, 0374, 0, 0, 060, 0374, 0, 0, 060,
	0374, 0, 0, 0140, 0374, 0, 0, 0140, 0374, 0, 0, 0300, 0374, 0, 0, 0300,
	0, 0, 01, 0200, 0, 0, 03, 0, 0, 0, 06, 0, 0, 0, 014, 0,
	0, 0, 030, 0, 0, 0, 060, 0, 0377, 0377, 0340, 0, 0377, 0377, 0300, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

/* About Electric */
DIALOGITEM usr_aboutdialogitems[] =
{
 /*  1 */ {0, {216,24,240,104}, BUTTON, "Continue"},
 /*  2 */ {0, {88,8,104,448}, MESSAGE, "Protected by license, redistribution prohibited"},
 /*  3 */ {0, {64,8,80,373}, MESSAGE, "Copyright (c) 1989-1998 Electric Editor Incorporated"},
 /*  4 */ {0, {120,8,136,209}, MESSAGE, "Written by Steven M. Rubin"},
 /*  5 */ {0, {8,8,24,295}, MESSAGE, "The Electric(tm) Design System"},
 /*  6 */ {0, {32,8,48,246}, MESSAGE, "Version XXXX"},
 /*  7 */ {0, {16,376,48,408}, ICON|INACTIVE, (char *)usr_icon130},
 /*  8 */ {0, {48,376,80,408}, ICON|INACTIVE, (char *)usr_icon129},
 /*  9 */ {0, {16,408,48,440}, ICON|INACTIVE, (char *)usr_icon131},
 /* 10 */ {0, {48,408,80,440}, ICON|INACTIVE, (char *)usr_icon132},
 /* 11 */ {0, {144,136,264,445}, SCROLL, ""},
 /* 12 */ {0, {120,216,138,404}, BUTTON, "And a Cast of Thousands"},
 /* 13 */ {0, {172,16,190,112}, BUTTON, "Restrictions"}
};
DIALOG usr_aboutdialog = {{50,75,323,528}, 0, 13, usr_aboutdialogitems};

/* GNU About Electric */
DIALOGITEM usr_aboutgnudialogitems[] =
{
 /*  1 */ {0, {28,320,52,400}, BUTTON, "Continue"},
 /*  2 */ {0, {300,12,316,356}, MESSAGE, "Electric comes with ABSOLUTELY NO WARRANTY"},
 /*  3 */ {0, {64,8,80,373}, MESSAGE, "Copyright (c) 1998 Electric Editor Incorporated"},
 /*  4 */ {0, {96,8,112,221}, MESSAGE, "Written by Steven M. Rubin"},
 /*  5 */ {0, {8,8,24,295}, MESSAGE, "The Electric(tm) Design System"},
 /*  6 */ {0, {32,8,48,246}, MESSAGE, "Version XXXX"},
 /*  7 */ {0, {16,420,48,452}, ICON|INACTIVE, (char *)usr_icon130},
 /*  8 */ {0, {48,420,80,452}, ICON|INACTIVE, (char *)usr_icon129},
 /*  9 */ {0, {16,452,48,484}, ICON|INACTIVE, (char *)usr_icon131},
 /* 10 */ {0, {48,452,80,484}, ICON|INACTIVE, (char *)usr_icon132},
 /* 11 */ {0, {120,8,293,487}, SCROLL, ""},
 /* 12 */ {0, {96,232,114,420}, BUTTON, "And a Cast of Thousands"},
 /* 13 */ {0, {324,12,340,330}, MESSAGE, "This is free software, and you are welcome to"},
 /* 14 */ {0, {300,358,318,496}, BUTTON, "Warranty details"},
 /* 15 */ {0, {336,358,354,496}, BUTTON, "Copying details"},
 /* 16 */ {0, {344,12,360,309}, MESSAGE, "redistribute it under certain conditions"}
};
DIALOG usr_aboutgnudialog = {{50,75,419,573}, 0, 16, usr_aboutgnudialogitems};

/* Array */
DIALOGITEM usr_arraydialogitems[] =
{
 /*  1 */ {0, {160,360,184,424}, BUTTON, "OK"},
 /*  2 */ {0, {160,32,184,96}, BUTTON, "Cancel"},
 /*  3 */ {0, {12,160,28,205}, EDITTEXT, "1"},
 /*  4 */ {0, {52,160,68,205}, EDITTEXT, "1"},
 /*  5 */ {0, {96,160,112,235}, EDITTEXT, "0"},
 /*  6 */ {0, {124,160,140,235}, EDITTEXT, "0"},
 /*  7 */ {0, {164,140,180,318}, CHECK, "Generate array indices"},
 /*  8 */ {0, {4,216,20,393}, CHECK, "Flip alternate columns"},
 /*  9 */ {0, {44,216,60,376}, CHECK, "Flip alternate rows"},
 /* 10 */ {0, {12,36,28,151}, MESSAGE, "X repeat factor:"},
 /* 11 */ {0, {52,36,68,151}, MESSAGE, "Y repeat factor:"},
 /* 12 */ {0, {96,4,112,154}, MESSAGE, "X edge overlap:"},
 /* 13 */ {0, {124,4,140,154}, MESSAGE, "Y centerline distance:"},
 /* 14 */ {0, {100,244,116,425}, RADIO, "Space by edge overlap"},
 /* 15 */ {0, {120,244,136,455}, RADIO, "Space by centerline distance"},
 /* 16 */ {0, {20,216,36,425}, CHECK, "Stagger alternate columns"},
 /* 17 */ {0, {60,216,76,400}, CHECK, "Stagger alternate rows"}
};
DIALOG usr_arraydialog = {{50,75,245,533}, "Array Current Node", 17, usr_arraydialogitems};

/* Node defaults */
DIALOGITEM usr_defnodedialogitems[] =
{
 /*  1 */ {0, {248,456,272,520}, BUTTON, "OK"},
 /*  2 */ {0, {208,456,232,520}, BUTTON, "Cancel"},
 /*  3 */ {0, {80,200,96,310}, EDITTEXT, ""},
 /*  4 */ {0, {140,16,156,240}, RADIO, "Expand new facet instances"},
 /*  5 */ {0, {140,260,156,499}, RADIO, "Unexpand new facet instances"},
 /*  6 */ {0, {80,15,96,197}, MESSAGE, "X size of new primitives:"},
 /*  7 */ {0, {100,15,116,197}, MESSAGE, "Y size of new primitives:"},
 /*  8 */ {0, {100,200,116,310}, EDITTEXT, ""},
 /*  9 */ {0, {15,15,31,225}, RADIO, "Defaults for primitive node:"},
 /* 10 */ {0, {15,225,31,435}, MESSAGE, ""},
 /* 11 */ {0, {25,440,45,530}, BUTTON, "Next node"},
 /* 12 */ {0, {35,15,51,225}, RADIO, "Defaults for facet instance:"},
 /* 13 */ {0, {35,225,51,435}, MESSAGE, ""},
 /* 14 */ {0, {184,16,200,316}, CHECK, "Disallow modification of existing facets"},
 /* 15 */ {0, {232,16,248,278}, CHECK, "Check facet dates during creation"},
 /* 16 */ {0, {256,16,272,222}, MESSAGE, "Orientation of all new nodes:"},
 /* 17 */ {0, {256,232,272,297}, EDITTEXT, ""},
 /* 18 */ {0, {256,320,272,425}, CHECK, "Transposed"},
 /* 19 */ {0, {64,16,65,520}, MESSAGE, ""},
 /* 20 */ {0, {128,16,129,520}, MESSAGE, ""},
 /* 21 */ {0, {168,16,169,520}, MESSAGE, ""},
 /* 22 */ {0, {208,16,224,330}, CHECK, "Disallow modification of locked primitives"},
 /* 23 */ {0, {184,328,200,508}, CHECK, "Tiny facets hashed out"}
};
DIALOG usr_defnodedialog = {{50,75,334,612}, "Node Defaults", 23, usr_defnodedialogitems};

/* ALS Clock */
DIALOGITEM usr_alsclockdialogitems[] =
{
 /*  1 */ {0, {8,312,32,376}, BUTTON, "OK"},
 /*  2 */ {0, {40,312,64,376}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,8,26,101}, RADIO, "Frequency:"},
 /*  4 */ {0, {24,8,42,101}, RADIO, "Period:"},
 /*  5 */ {0, {64,8,82,101}, RADIO, "Custom:"},
 /*  6 */ {0, {16,208,32,283}, EDITTEXT, ""},
 /*  7 */ {0, {16,112,32,199}, MESSAGE, "Freq/Period:"},
 /*  8 */ {0, {96,256,112,370}, RADIO, "Gate Strength"},
 /*  9 */ {0, {200,232,216,369}, RADIO, "Undefined Phase"},
 /* 10 */ {0, {88,8,104,151}, MESSAGE, "Random Distribution:"},
 /* 11 */ {0, {88,160,104,223}, EDITTEXT, ""},
 /* 12 */ {0, {112,256,128,367}, RADIO, "VDD Strength"},
 /* 13 */ {0, {80,256,96,377}, RADIO, "Node Strength"},
 /* 14 */ {0, {184,232,200,328}, RADIO, "High Phase"},
 /* 15 */ {0, {256,272,280,363}, BUTTON, "Delete Phase"},
 /* 16 */ {0, {136,8,251,221}, SCROLL|INACTIVE, ""},
 /* 17 */ {0, {144,224,160,288}, MESSAGE, "Duration:"},
 /* 18 */ {0, {224,272,248,363}, BUTTON, "Add Phase"},
 /* 19 */ {0, {264,8,280,197}, MESSAGE, "Phase Cycles (0 for infinite):"},
 /* 20 */ {0, {264,200,280,247}, EDITTEXT, ""},
 /* 21 */ {0, {144,296,160,369}, EDITTEXT, ""},
 /* 22 */ {0, {120,8,136,99}, MESSAGE, "Phase List:"},
 /* 23 */ {0, {168,232,184,327}, RADIO, "Low Phase"}
};
DIALOG usr_alsclockdialog = {{50,75,341,456}, "Clock Specification", 23, usr_alsclockdialogitems};

/* Copy from library */
DIALOGITEM usr_copyfacetdialogitems[] =
{
 /*  1 */ {0, {136,332,160,404}, BUTTON, "OK"},
 /*  2 */ {0, {72,332,96,404}, BUTTON, "Cancel"},
 /*  3 */ {0, {32,16,192,314}, SCROLL, ""},
 /*  4 */ {0, {8,8,24,177}, MESSAGE, "Copy facet from library:"},
 /*  5 */ {0, {8,176,24,407}, POPUP, ""}
};
DIALOG usr_copyfacetdialog = {{50,75,249,491}, "Cross-Library Copy", 5, usr_copyfacetdialogitems};

/* Arc defaults */
DIALOGITEM usr_defarcdialogitems[] =
{
 /*  1 */ {0, {192,312,216,384}, BUTTON, "OK"},
 /*  2 */ {0, {192,72,216,144}, BUTTON, "Cancel"},
 /*  3 */ {0, {15,150,31,350}, MESSAGE, ""},
 /*  4 */ {0, {15,15,31,145}, RADIO, "Defaults for arc:"},
 /*  5 */ {0, {40,15,56,175}, RADIO, "Defaults for all arcs"},
 /*  6 */ {0, {15,360,35,430}, BUTTON, "Next arc"},
 /*  7 */ {0, {80,16,100,73}, CHECK, "Rigid"},
 /*  8 */ {0, {80,112,100,214}, CHECK, "Fixed-angle"},
 /*  9 */ {0, {80,224,100,299}, CHECK, "Slidable"},
 /* 10 */ {0, {104,16,124,95}, CHECK, "Negated"},
 /* 11 */ {0, {104,112,124,205}, CHECK, "Directional"},
 /* 12 */ {0, {104,224,124,344}, CHECK, "Ends extended"},
 /* 13 */ {0, {40,260,60,428}, BUTTON, "Reset to initial defaults"},
 /* 14 */ {0, {136,72,152,160}, EDITTEXT, ""},
 /* 15 */ {0, {136,16,152,64}, MESSAGE, "Width:"},
 /* 16 */ {0, {136,184,152,232}, MESSAGE, "Angle:"},
 /* 17 */ {0, {136,240,152,304}, EDITTEXT, ""},
 /* 18 */ {0, {160,16,176,47}, MESSAGE, "Pin:"},
 /* 19 */ {0, {160,48,176,358}, MESSAGE, ""},
 /* 20 */ {0, {160,368,176,423}, BUTTON, "Set pin"}
};
DIALOG usr_defarcdialog = {{50,75,278,509}, "Arc Defaults", 20, usr_defarcdialogitems};

/* DRC error */
DIALOGITEM usr_drcerrdialogitems[] =
{
 /*  1 */ {0, {88,40,112,104}, BUTTON, "OK"},
 /*  2 */ {0, {120,208,144,336}, BUTTON, "Stop Checking"},
 /*  3 */ {0, {120,8,144,136}, BUTTON, "Ignore this error"},
 /*  4 */ {0, {88,208,112,336}, BUTTON, "Continue Silently"},
 /*  5 */ {0, {8,8,80,336}, MESSAGE, ""}
};
DIALOG usr_drcerrdialog = {{50,75,202,419}, "DRC Violation", 5, usr_drcerrdialogitems};

/* Layer Patterns */
unsigned char usr_icon300[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0210, 0210, 0210, 0210, 0104, 0104, 021, 021, 042, 042, 042, 042, 021, 021, 0104, 0104,
	0210, 0210, 0210, 0210, 0104, 0104, 021, 021, 042, 042, 042, 042, 021, 021, 0104, 0104,
	0210, 0210, 0210, 0210, 0104, 0104, 021, 021, 042, 042, 042, 042, 021, 021, 0104, 0104,
	0210, 0210, 0210, 0210, 0104, 0104, 021, 021, 042, 042, 042, 042, 021, 021, 0104, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon301[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0314, 0314, 0377, 0377, 0314, 0314, 0, 0, 063, 063, 0377, 0377, 063, 063, 0, 0,
	0314, 0314, 0377, 0377, 0314, 0314, 0, 0, 063, 063, 0377, 0377, 063, 063, 0, 0,
	0314, 0314, 0377, 0377, 0314, 0314, 0, 0, 063, 063, 0377, 0377, 063, 063, 0, 0,
	0314, 0314, 0377, 0377, 0314, 0314, 0, 0, 063, 063, 0377, 0377, 063, 063, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon302[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0125, 0125, 0140, 0140, 0125, 0125, 0220, 0220, 0125, 0125, 0220, 0220, 0125, 0125, 0140, 0140,
	0125, 0125, 06, 06, 0125, 0125, 011, 011, 0125, 0125, 011, 011, 0125, 0125, 06, 06,
	0125, 0125, 0140, 0140, 0125, 0125, 0220, 0220, 0125, 0125, 0220, 0220, 0125, 0125, 0140, 0140,
	0125, 0125, 06, 06, 0125, 0125, 011, 011, 0125, 0125, 011, 011, 0, 0, 06, 06,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon303[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	042, 042, 0104, 0104, 0, 0, 021, 021, 0210, 0210, 0104, 0104, 0, 0, 021, 021,
	042, 042, 0104, 0104, 0, 0, 021, 021, 0210, 0210, 0104, 0104, 0, 0, 021, 021,
	042, 042, 0104, 0104, 0, 0, 021, 021, 0210, 0210, 0104, 0104, 0, 0, 021, 021,
	042, 042, 0104, 0104, 0, 0, 021, 021, 0210, 0210, 0104, 0104, 0, 0, 021, 021,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon304[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	020, 020, 04, 04, 040, 040, 02, 02, 0100, 0100, 01, 01, 0200, 0200, 0200, 0200,
	01, 01, 0100, 0100, 02, 02, 040, 040, 04, 04, 020, 020, 010, 010, 010, 010,
	020, 020, 04, 04, 040, 040, 02, 02, 0100, 0100, 01, 01, 0200, 0200, 0200, 0200,
	01, 01, 0100, 0100, 02, 02, 040, 040, 04, 04, 020, 020, 010, 010, 010, 010,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon305[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0100, 0100, 020, 0, 0200, 0200, 0, 040, 01, 01, 0100, 0, 02, 02, 0, 0200,
	01, 01, 0, 01, 0200, 0200, 02, 0, 0100, 0100, 0, 04, 040, 040, 010, 0,
	0100, 0100, 0, 020, 0200, 0200, 040, 0, 01, 01, 0, 0100, 02, 02, 0200, 0,
	01, 01, 01, 0, 0200, 0200, 0, 02, 0100, 0100, 04, 0, 040, 040, 0, 010,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon306[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	010, 0, 0, 0, 0, 04, 03, 03, 02, 0, 0204, 0204, 0, 01, 03, 03,
	0, 0200, 0, 0, 0100, 0, 060, 060, 0, 040, 0110, 0110, 020, 0, 060, 060,
	0, 010, 0, 0, 04, 0, 03, 03, 0, 02, 0204, 0204, 01, 0, 03, 03,
	0200, 0, 0, 0, 0, 0100, 060, 060, 040, 0, 0110, 0110, 0, 020, 060, 060,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon307[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	034, 034, 0, 0, 076, 076, 0314, 0314, 066, 066, 0, 0, 076, 076, 0314, 0314,
	034, 034, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	034, 034, 0, 0, 076, 076, 0314, 0314, 066, 066, 0, 0, 076, 076, 0314, 0314,
	034, 034, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon308[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 042, 042, 021, 021, 0210, 0210, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 042, 042, 021, 021, 0210, 0210, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 042, 042, 021, 021, 0210, 0210, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 042, 042, 021, 021, 0210, 0210, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon309[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 042, 042, 042, 042, 0104, 0104, 0125, 0125, 0210, 0210, 042, 042,
	0, 0, 0, 0, 042, 042, 042, 042, 0104, 0104, 0125, 0125, 0210, 0210, 042, 042,
	0, 0, 0, 0, 042, 042, 042, 042, 0104, 0104, 0125, 0125, 0210, 0210, 042, 042,
	0, 0, 0, 0, 042, 042, 042, 042, 0104, 0104, 0125, 0125, 0210, 0210, 042, 042,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
unsigned char usr_icon310[] =
{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0377, 0377, 0, 0, 0377, 0377, 0, 0, 0377, 0377, 0, 0, 0377, 0377,
	0, 0, 0377, 0377, 0, 0, 0377, 0377, 0, 0, 0377, 0377, 0, 0, 0377, 0377,
	0, 0, 0377, 0377, 0, 0, 0377, 0377, 0, 0, 0377, 0377, 0, 0, 0377, 0377,
	0, 0, 0377, 0377, 0, 0, 0377, 0377, 0, 0, 0377, 0377, 0, 0, 0377, 0377,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
UINTSML tty_predefpats[] =
{
	0x8888,  /* X   X   X   X    */
	0x4444,  /*  X   X   X   X   */
	0x2222,  /*   X   X   X   X  */
	0x1111,  /*    X   X   X   X */
	0x8888,  /* X   X   X   X    */
	0x4444,  /*  X   X   X   X   */
	0x2222,  /*   X   X   X   X  */
	0x1111,  /*    X   X   X   X */

	0x8888,  /* X   X   X   X    */
	0x1111,  /*    X   X   X   X */
	0x2222,  /*   X   X   X   X  */
	0x4444,  /*  X   X   X   X   */
	0x8888,  /* X   X   X   X    */
	0x1111,  /*    X   X   X   X */
	0x2222,  /*   X   X   X   X  */
	0x4444,  /*  X   X   X   X   */

	0xCCCC,  /* XX  XX  XX  XX   */
	0xCCCC,  /* XX  XX  XX  XX   */
	0x3333,  /*   XX  XX  XX  XX */
	0x3333,  /*   XX  XX  XX  XX */
	0xCCCC,  /* XX  XX  XX  XX   */
	0xCCCC,  /* XX  XX  XX  XX   */
	0x3333,  /*   XX  XX  XX  XX */
	0x3333,  /*   XX  XX  XX  XX */

	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0x0000,  /*                  */
	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0x0000,  /*                  */
	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0x0000,  /*                  */
	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0x0000,  /*                  */

	0xAAAA,  /* X X X X X X X X  */
	0xAAAA,  /* X X X X X X X X  */
	0xAAAA,  /* X X X X X X X X  */
	0xAAAA,  /* X X X X X X X X  */
	0xAAAA,  /* X X X X X X X X  */
	0xAAAA,  /* X X X X X X X X  */
	0xAAAA,  /* X X X X X X X X  */
	0xAAAA,  /* X X X X X X X X  */

	0x6060,  /*  XX      XX      */
	0x9090,  /* X  X    X  X     */
	0x9090,  /* X  X    X  X     */
	0x6060,  /*  XX      XX      */
	0x0606,  /*      XX      XX  */
	0x0909,  /*     X  X    X  X */
	0x0909,  /*     X  X    X  X */
	0x0606,  /*      XX      XX  */

	0x2222,  /*   X   X   X   X  */
	0x0000,  /*                  */
	0x8888,  /* X   X   X   X    */
	0x0000,  /*                  */
	0x2222,  /*   X   X   X   X  */
	0x0000,  /*                  */
	0x8888,  /* X   X   X   X    */
	0x0000,  /*                  */

	0x4444,  /*  X   X   X   X   */
	0x1111,  /*    X   X   X   X */
	0x4444,  /*  X   X   X   X   */
	0x1111,  /*    X   X   X   X */
	0x4444,  /*  X   X   X   X   */
	0x1111,  /*    X   X   X   X */
	0x4444,  /*  X   X   X   X   */
	0x1111,  /*    X   X   X   X */

	0x1010,  /*    X       X     */
	0x2020,  /*   X       X      */
	0x4040,  /*  X       X       */
	0x8080,  /* X       X        */
	0x0101,  /*        X       X */
	0x0202,  /*       X       X  */
	0x0404,  /*      X       X   */
	0x0808,  /*     X       X    */

	0x0808,  /*     X       X    */
	0x0404,  /*      X       X   */
	0x0202,  /*       X       X  */
	0x0101,  /*        X       X */
	0x8080,  /* X       X        */
	0x4040,  /*  X       X       */
	0x2020,  /*   X       X      */
	0x1010,  /*    X       X     */

	0x4040,  /*  X       X       */
	0x8080,  /* X       X        */
	0x0101,  /*        X       X */
	0x0202,  /*       X       X  */
	0x0101,  /*        X       X */
	0x8080,  /* X       X        */
	0x4040,  /*  X       X       */
	0x2020,  /*   X       X      */

	0x1000,  /*    X             */
	0x0020,  /*           X      */
	0x4000,  /*  X               */
	0x0080,  /*         X        */
	0x0001,  /*                X */
	0x0200,  /*       X          */
	0x0004,  /*              X   */
	0x0800,  /*     X            */

	0x0800,  /*     X            */
	0x0004,  /*              X   */
	0x0200,  /*       X          */
	0x0001,  /*                X */
	0x0080,  /*         X        */
	0x4000,  /*  X               */
	0x0020,  /*           X      */
	0x1000,  /*    X             */

	0x0000,  /*                  */
	0x0303,  /*       XX      XX */
	0x4848,  /*  X  X    X  X    */
	0x0303,  /*       XX      XX */
	0x0000,  /*                  */
	0x3030,  /*   XX      XX     */
	0x8484,  /* X    X  X    X   */
	0x3030,  /*   XX      XX     */

	0x1C1C,  /*    XXX     XXX   */
	0x3E3E,  /*   XXXXX   XXXXX  */
	0x3636,  /*   XX XX   XX XX  */
	0x3E3E,  /*   XXXXX   XXXXX  */
	0x1C1C,  /*    XXX     XXX   */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x0000,  /*                  */

	0x0000,  /*                  */
	0xCCCC,  /* XX  XX  XX  XX   */
	0x0000,  /*                  */
	0xCCCC,  /* XX  XX  XX  XX   */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x0000,  /*                  */

	0x0000,  /*                  */
	0x0000,  /*                  */
	0x2222,  /*   X   X   X   X  */
	0x8888,  /* X   X   X   X    */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x2222,  /*   X   X   X   X  */
	0x8888,  /* X   X   X   X    */

	0x0000,  /*                  */
	0x0000,  /*                  */
	0x1111,  /*    X   X   X   X */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x1111,  /*    X   X   X   X */
	0x0000,  /*                  */

	0x0000,  /*                  */
	0x2222,  /*   X   X   X   X  */
	0x4444,  /*  X   X   X   X   */
	0x8888,  /* X   X   X   X    */
	0x0000,  /*                  */
	0x2222,  /*   X   X   X   X  */
	0x4444,  /*  X   X   X   X   */
	0x8888,  /* X   X   X   X    */

	0x0000,  /*                  */
	0x2222,  /*   X   X   X   X  */
	0x5555,  /*  X X X X X X X X */
	0x2222,  /*   X   X   X   X  */
	0x0000,  /*                  */
	0x2222,  /*   X   X   X   X  */
	0x5555,  /*  X X X X X X X X */
	0x2222,  /*   X   X   X   X  */

	0x0000,  /*                  */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x0000,  /*                  */
	0x0000,  /*                  */

	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0xFFFF,  /* XXXXXXXXXXXXXXXX */
	0xFFFF   /* XXXXXXXXXXXXXXXX */
};
DIALOGITEM usr_patterndialogitems[] =
{
 /*  1 */ {0, {176,296,200,360}, BUTTON, "OK"},
 /*  2 */ {0, {80,296,104,360}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,8,24,184}, MESSAGE, "Stipple Pattern for Layer:"},
 /*  4 */ {0, {8,184,24,368}, MESSAGE, ""},
 /*  5 */ {0, {80,16,208,272}, USERDRAWN, ""},
 /*  6 */ {0, {128,288,152,368}, BUTTON, "Next Layer"},
 /*  7 */ {0, {56,8,72,160}, CHECK, "Use Stipple Pattern"},
 /*  8 */ {0, {24,8,56,40}, ICON, (char *)usr_icon300},
 /*  9 */ {0, {24,40,56,72}, ICON, (char *)usr_icon301},
 /* 10 */ {0, {24,72,56,104}, ICON, (char *)usr_icon302},
 /* 11 */ {0, {24,104,56,136}, ICON, (char *)usr_icon303},
 /* 12 */ {0, {24,136,56,168}, ICON, (char *)usr_icon304},
 /* 13 */ {0, {24,168,56,200}, ICON, (char *)usr_icon305},
 /* 14 */ {0, {24,200,56,232}, ICON, (char *)usr_icon306},
 /* 15 */ {0, {24,232,56,264}, ICON, (char *)usr_icon307},
 /* 16 */ {0, {24,264,56,296}, ICON, (char *)usr_icon308},
 /* 17 */ {0, {24,296,56,328}, ICON, (char *)usr_icon309},
 /* 18 */ {0, {24,328,56,360}, ICON, (char *)usr_icon310},
 /* 19 */ {0, {56,184,72,336}, CHECK, "Outline Pattern"}
};
DIALOG usr_patterndialog = {{50,75,266,453}, "Edit Stipple Patterns", 19, usr_patterndialogitems};

/* Artwork Color/Layer */
DIALOGITEM usr_artworkdialogitems[] =
{
 /*  1 */ {0, {168,340,192,404}, BUTTON, "OK"},
 /*  2 */ {0, {168,244,192,308}, BUTTON, "Cancel"},
 /*  3 */ {0, {120,292,136,419}, RADIO, "Outlined Pattern"},
 /*  4 */ {0, {32,16,160,272}, USERDRAWN, ""},
 /*  5 */ {0, {56,292,72,388}, RADIO, "Solid color"},
 /*  6 */ {0, {168,24,184,77}, MESSAGE, "Color:"},
 /*  7 */ {0, {88,292,104,388}, RADIO, "Use Pattern"},
 /*  8 */ {0, {0,16,32,48}, ICON, (char *)usr_icon300},
 /*  9 */ {0, {0,48,32,80}, ICON, (char *)usr_icon301},
 /* 10 */ {0, {0,80,32,112}, ICON, (char *)usr_icon302},
 /* 11 */ {0, {0,112,32,144}, ICON, (char *)usr_icon303},
 /* 12 */ {0, {0,144,32,176}, ICON, (char *)usr_icon304},
 /* 13 */ {0, {0,176,32,208}, ICON, (char *)usr_icon305},
 /* 14 */ {0, {0,208,32,240}, ICON, (char *)usr_icon306},
 /* 15 */ {0, {0,240,32,272}, ICON, (char *)usr_icon307},
 /* 16 */ {0, {0,272,32,304}, ICON, (char *)usr_icon308},
 /* 17 */ {0, {0,304,32,336}, ICON, (char *)usr_icon309},
 /* 18 */ {0, {0,336,32,368}, ICON, (char *)usr_icon310},
 /* 19 */ {0, {168,80,184,214}, POPUP, "Overlappable 1"}
};
DIALOG usr_artworkdialog = {{50,75,253,498}, "Set Look of Highlighted", 19, usr_artworkdialogitems};

/* Technologies */
DIALOGITEM usr_techselectdialogitems[] =
{
 /*  1 */ {0, {96,216,120,280}, BUTTON, "OK"},
 /*  2 */ {0, {24,216,48,280}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,8,153,193}, SCROLL, ""},
 /*  4 */ {0, {160,8,192,292}, MESSAGE, ""}
};
DIALOG usr_techselectdialog = {{50,75,250,373}, "Change Current Technology", 4, usr_techselectdialogitems};

/* Dependent Libraries */
DIALOGITEM usr_dependentlibdialogitems[] =
{
 /*  1 */ {0, {208,368,232,432}, BUTTON, "OK"},
 /*  2 */ {0, {208,256,232,320}, BUTTON, "Cancel"},
 /*  3 */ {0, {32,8,177,174}, SCROLL, ""},
 /*  4 */ {0, {8,8,24,153}, MESSAGE, "Dependent Libraries:"},
 /*  5 */ {0, {208,8,224,165}, MESSAGE, "Libraries are examined"},
 /*  6 */ {0, {40,192,64,256}, BUTTON, "Remove"},
 /*  7 */ {0, {88,192,112,256}, BUTTON, "<< Add"},
 /*  8 */ {0, {128,280,144,427}, MESSAGE, "Library (if not in list):"},
 /*  9 */ {0, {152,280,168,432}, EDITTEXT, ""},
 /* 10 */ {0, {8,272,24,361}, MESSAGE, "All Libraries:"},
 /* 11 */ {0, {224,8,240,123}, MESSAGE, "from bottom up"},
 /* 12 */ {0, {32,272,118,438}, SCROLL, ""},
 /* 13 */ {0, {184,8,200,67}, MESSAGE, "Current:"},
 /* 14 */ {0, {184,72,200,254}, MESSAGE, ""}
};
DIALOG usr_dependentlibdialog = {{50,75,296,524}, "Dependent Library Selection", 14, usr_dependentlibdialogitems};

/* Library paths */
DIALOGITEM usr_librarypathdialogitems[] =
{
 /*  1 */ {0, {76,312,100,376}, BUTTON, "OK"},
 /*  2 */ {0, {76,32,100,96}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,16,24,220}, MESSAGE, "Location of library files:"},
 /*  4 */ {0, {32,8,64,400}, EDITTEXT, ""}
};
DIALOG usr_librarypathdialog = {{50,75,159,485}, "Current Disk Paths", 4, usr_librarypathdialogitems};

/* Help */
DIALOGITEM usr_helpdialogitems[] =
{
 /*  1 */ {0, {288,376,312,440}, BUTTON, "OK"},
 /*  2 */ {0, {8,32,24,91}, MESSAGE, "Topics:"},
 /*  3 */ {0, {8,192,280,636}, SCROLL, ""},
 /*  4 */ {0, {24,8,309,177}, SCROLL, ""}
};
DIALOG usr_helpdialog = {{50,75,378,719}, "Help", 4, usr_helpdialogitems};

/* Technology Variables */
DIALOGITEM usr_techvarsdialogitems[] =
{
 /*  1 */ {0, {208,472,232,536}, BUTTON, "OK"},
 /*  2 */ {0, {208,376,232,440}, BUTTON, "Cancel"},
 /*  3 */ {0, {24,8,143,264}, SCROLL, ""},
 /*  4 */ {0, {176,16,192,55}, MESSAGE, "Type:"},
 /*  5 */ {0, {176,56,192,142}, MESSAGE, ""},
 /*  6 */ {0, {152,104,168,536}, MESSAGE, ""},
 /*  7 */ {0, {24,280,143,536}, SCROLL, ""},
 /*  8 */ {0, {8,16,24,240}, MESSAGE, "Current Variables on Technology:"},
 /*  9 */ {0, {8,288,24,419}, MESSAGE, "Possible Variables:"},
 /* 10 */ {0, {208,280,232,344}, BUTTON, "<< Copy"},
 /* 11 */ {0, {208,24,232,88}, BUTTON, "Remove"},
 /* 12 */ {0, {176,216,192,533}, EDITTEXT, ""},
 /* 13 */ {0, {208,136,232,237}, BUTTON, "Edit Strings"},
 /* 14 */ {0, {176,168,192,212}, MESSAGE, "Value:"},
 /* 15 */ {0, {152,16,168,98}, MESSAGE, "Description:"}
};
DIALOG usr_techvarsdialog = {{50,75,293,622}, "Technology Variables", 15, usr_techvarsdialogitems};

/* SPICE Options */
DIALOGITEM usr_spiceoptdialogitems[] =
{
 /*  1 */ {0, {56,408,80,466}, BUTTON, "OK"},
 /*  2 */ {0, {16,408,40,466}, BUTTON, "Cancel"},
 /*  3 */ {0, {56,240,72,351}, CHECK, "Execute Deck"},
 /*  4 */ {0, {8,96,24,187}, POPUP, "Spice 2"},
 /*  5 */ {0, {240,216,256,375}, RADIO, "Use Model from File:"},
 /*  6 */ {0, {224,216,240,426}, RADIO, "Derive Model from Circuitry"},
 /*  7 */ {0, {32,96,48,140}, POPUP, "1"},
 /*  8 */ {0, {288,256,304,295}, BUTTON, "Set"},
 /*  9 */ {0, {256,224,288,480}, MESSAGE, ""},
 /* 10 */ {0, {32,240,48,372}, CHECK, "Use Node Names"},
 /* 11 */ {0, {8,240,24,359}, CHECK, "Use Parasitics"},
 /* 12 */ {0, {8,8,24,93}, MESSAGE, "File Format:"},
 /* 13 */ {0, {32,8,48,93}, MESSAGE, "SPICE Level:"},
 /* 14 */ {0, {80,16,96,200}, RADIO, "Use Built-in Model Cards"},
 /* 15 */ {0, {96,16,112,213}, RADIO, "Use Model Cards from File:"},
 /* 16 */ {0, {96,216,128,480}, MESSAGE, ""},
 /* 17 */ {0, {136,16,152,140}, RADIO, "No Trailer Cards"},
 /* 18 */ {0, {152,16,168,202}, RADIO, "Include Trailer from File:"},
 /* 19 */ {0, {152,208,184,480}, MESSAGE, ""},
 /* 20 */ {0, {64,8,80,209}, MESSAGE, ""},
 /* 21 */ {0, {112,160,128,199}, BUTTON, "Set"},
 /* 22 */ {0, {168,160,184,199}, BUTTON, "Set"},
 /* 23 */ {0, {224,8,320,206}, SCROLL, ""},
 /* 24 */ {0, {208,8,224,80}, MESSAGE, "For Facet:"}
};
DIALOG usr_spiceoptdialog = {{50,75,379,563}, "SPICE Options", 24, usr_spiceoptdialogitems};

/* Printing Options */
DIALOGITEM usr_printingoptdialogitems[] =
{
 /*  1 */ {0, {96,336,120,394}, BUTTON, "OK"},
 /*  2 */ {0, {40,336,64,394}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,200,24,395}, RADIO, "Plot only Highlighted Area"},
 /*  4 */ {0, {8,16,24,150}, RADIO, "Plot Entire Facet"},
 /*  5 */ {0, {64,16,80,208}, CHECK, "Encapsulated PostScript"},
 /*  6 */ {0, {40,16,56,171}, CHECK, "Plot Date In Corner"},
 /*  7 */ {0, {96,16,112,74}, RADIO, "HPGL"},
 /*  8 */ {0, {96,88,112,162}, RADIO, "HPGL/2"},
 /*  9 */ {0, {120,16,136,183}, RADIO, "HPGL/2 plot fills page"},
 /* 10 */ {0, {136,16,152,173}, RADIO, "HPGL/2 plot fixed at:"},
 /* 11 */ {0, {136,176,152,236}, EDITTEXT, ""},
 /* 12 */ {0, {136,240,152,401}, MESSAGE, "internal units per pixel"}
};
DIALOG usr_printingoptdialog = {{50,75,211,483}, "Printing Options", 12, usr_printingoptdialogitems};

/* File Progress */
DIALOGITEM usr_progressdialogitems[] =
{
 /*  1 */ {0, {32,8,49,230}, PROGRESS, ""},
 /*  2 */ {0, {8,8,24,230}, MESSAGE, "Reading file..."}
};
DIALOG usr_progressdialog = {{50,75,112,312}, 0, 2, usr_progressdialogitems};

/* Resistance */
DIALOGITEM usr_resistancedialogitems[] =
{
 /*  1 */ {0, {40,192,64,256}, BUTTON, "OK"},
 /*  2 */ {0, {40,16,64,80}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,24,24,118}, EDITTEXT, ""},
 /*  4 */ {0, {8,128,24,239}, POPUP, "Ohms"},
 /*  5 */ {0, {40,104,64,168}, BUTTON, "More..."}
};
DIALOG usr_resistancedialog = {{50,75,124,345}, "Resistance", 5, usr_resistancedialogitems};

/* Capacitance */
DIALOGITEM usr_capacitancedialogitems[] =
{
 /*  1 */ {0, {40,176,64,240}, BUTTON, "OK"},
 /*  2 */ {0, {40,16,64,80}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,16,24,110}, EDITTEXT, ""},
 /*  4 */ {0, {8,120,24,246}, POPUP, "Milli-farads"},
 /*  5 */ {0, {40,96,64,160}, BUTTON, "More..."}
};
DIALOG usr_capacitancedialog = {{50,75,121,330}, "Capacitance", 5, usr_capacitancedialogitems};

/* Inductance */
DIALOGITEM usr_inductancedialogitems[] =
{
 /*  1 */ {0, {40,168,64,232}, BUTTON, "OK"},
 /*  2 */ {0, {40,8,64,72}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,16,24,110}, EDITTEXT, ""},
 /*  4 */ {0, {8,120,24,237}, POPUP, "Henrys"},
 /*  5 */ {0, {40,88,64,152}, BUTTON, "More..."}
};
DIALOG usr_inductancedialog = {{50,75,126,317}, "Inductance", 5, usr_inductancedialogitems};

/* VCCS Transconductance */
DIALOGITEM usr_vccsdialogitems[] =
{
 /*  1 */ {0, {40,176,64,240}, BUTTON, "OK"},
 /*  2 */ {0, {40,16,64,80}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,16,24,110}, EDITTEXT, ""},
 /*  4 */ {0, {8,120,24,247}, POPUP, "Siemens"},
 /*  5 */ {0, {40,96,64,160}, BUTTON, "More..."}
};
DIALOG usr_vccsdialog = {{50,75,125,329}, "VCCS Transconductance", 5, usr_vccsdialogitems};

/* Area */
DIALOGITEM usr_areadialogitems[] =
{
 /*  1 */ {0, {40,208,64,272}, BUTTON, "OK"},
 /*  2 */ {0, {40,32,64,96}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,16,24,110}, EDITTEXT, ""},
 /*  4 */ {0, {8,120,24,290}, POPUP, "Square centimicrons"},
 /*  5 */ {0, {40,120,64,184}, BUTTON, "More..."}
};
DIALOG usr_areadialog = {{50,75,122,373}, "Area", 5, usr_areadialogitems};

/* Width/Length */
DIALOGITEM usr_widlendialogitems[] =
{
 /*  1 */ {0, {64,200,88,264}, BUTTON, "OK"},
 /*  2 */ {0, {64,24,88,88}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,64,24,158}, EDITTEXT, ""},
 /*  4 */ {0, {20,168,36,287}, POPUP, "Centimicrons"},
 /*  5 */ {0, {8,8,24,59}, MESSAGE, "Width:"},
 /*  6 */ {0, {32,64,48,158}, EDITTEXT, ""},
 /*  7 */ {0, {32,8,48,60}, MESSAGE, "Length:"},
 /*  8 */ {0, {64,112,88,176}, BUTTON, "More..."}
};
DIALOG usr_widlendialog = {{50,75,148,366}, "Transistor Length/Width", 8, usr_widlendialogitems};

/* Gain */
DIALOGITEM usr_gaindialogitems[] =
{
 /*  1 */ {0, {40,176,64,240}, BUTTON, "OK"},
 /*  2 */ {0, {40,16,64,80}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,88,24,213}, EDITTEXT, ""},
 /*  4 */ {0, {8,40,24,83}, MESSAGE, "Gain:"},
 /*  5 */ {0, {40,96,64,160}, BUTTON, "More..."}
};
DIALOG usr_gaindialog = {{50,75,122,334}, "Gain", 5, usr_gaindialogitems};

/* Window Views */
DIALOGITEM usr_windowviewdialogitems[] =
{
 /*  1 */ {0, {256,56,280,166}, BUTTON, "Restore View"},
 /*  2 */ {0, {216,8,240,72}, BUTTON, "Done"},
 /*  3 */ {0, {32,8,208,234}, SCROLL, ""},
 /*  4 */ {0, {8,96,24,229}, EDITTEXT, ""},
 /*  5 */ {0, {216,120,240,230}, BUTTON, "Save This View"},
 /*  6 */ {0, {8,8,24,90}, MESSAGE, "View name:"}
};
DIALOG usr_windowviewdialog = {{50,75,342,316}, "Window Views", 6, usr_windowviewdialogitems};

/* Create To */
DIALOGITEM usr_createtodialogitems[] =
{
 /*  1 */ {0, {64,96,88,160}, BUTTON, "OK"},
 /*  2 */ {0, {64,8,88,72}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,48,24,142}, EDITTEXT, ""},
 /*  4 */ {0, {8,20,24,42}, MESSAGE, "X:"},
 /*  5 */ {0, {32,48,48,142}, EDITTEXT, ""},
 /*  6 */ {0, {32,20,48,42}, MESSAGE, "Y:"}
};
DIALOG usr_createtodialog = {{50,75,147,244}, "Create At Location", 6, usr_createtodialogitems};

/* Port display */
DIALOGITEM usr_portdisplaydialogitems[] =
{
 /*  1 */ {0, {100,92,124,156}, BUTTON, "OK"},
 /*  2 */ {0, {100,8,124,72}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,8,24,155}, RADIO, "Full Port Names"},
 /*  4 */ {0, {28,8,44,155}, RADIO, "Short Port Names"},
 /*  5 */ {0, {48,8,64,155}, RADIO, "Ports as Crosses"},
 /*  6 */ {0, {68,8,84,155}, RADIO, "No Ports Shown"}
};
DIALOG usr_portdisplaydialog = {{133,131,270,304}, "Port Display", 6, usr_portdisplaydialogitems};

/* prototypes for local routines */
INTSML tty_patternstroke(INTBIG, INTBIG);
void tty_redrawpattern(RECTAREA*);
void tty_writephases(float[], INTSML[], INTSML);
INTSML tty_topofprims(char**);
char *tty_nextprims(void);
INTSML usr_topoftechs(char**);
char *usr_nexttechs(void);
void tty_defarcload(ARCPROTO*, NODEPROTO**);
void tty_loadnode(NODEPROTO*);
void tty_stufftechdescript(void);
void tty_showliblist(char**, INTSML);
void tty_setcurrenttechvar(TECHVAR*);
void tty_movedialogtonode(DIALOG*, GEOM*);
INTSML tty_nullup(INTBIG, INTBIG);
void tty_nullvoid(void);
INTSML tty_nullchar(INTBIG, INTBIG, INTSML);

/****************************** DIALOG CODE ******************************/

INTSML tty_nullup(INTBIG x, INTBIG y)  { return(0); }
void tty_nullvoid(void) {}
INTSML tty_nullchar(INTBIG x, INTBIG y, INTSML ch) { return(0); }

/*
 * special case for the "About Electric" menu
 * version number        = 6 (stat text)
 * authors               = 12 (button)
 * restrictions (nonGNU) = 13 (button)
 * warranty (GNU)        = 14 (button)
 * copying (GNU)         = 15 (button)
 */
void tty_aboutdlog(char *licline)
{
#if EGNU || EGNUL
	char line[256];
	INTSML itemHit, i;

	/* show the GNU "about" dialog */
	if (DiaInitDialog(&usr_aboutgnudialog) != 0) return;
	DiaInitTextDialog(11, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1,
		SCSMALLFONT|SCHORIZBAR);
#else
	char **restrictions;
	char line[256];
	INTSML itemHit, i, rests;

	/* show the commercial "about" dialog */
	if (DiaInitDialog(&usr_aboutdialog) != 0) return;
	DiaInitTextDialog(11, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1, 0);
	rests = us_describerestrictions(&restrictions);
	if (rests == 0) DiaDimItem(13); else DiaUnDimItem(13);
#endif
	(void)strcpy(line, "Version ");
	(void)strcat(line, el_version);
	DiaSetText(6, line);

	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK) break;
		if (itemHit == 12)
		{
			DiaLoadTextDialog(11, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1);
			for(i=0; usr_castofthousands[i] != 0; i++) DiaStuffLine(11, usr_castofthousands[i]);
			DiaSelectLine(11, -1);
			continue;
		}
#if EGNU == 0 && EGNUL == 0
		if (itemHit == 13)
		{
			DiaLoadTextDialog(11, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1);
			for(i=0; i<rests; i++) DiaStuffLine(11, restrictions[i]);
			DiaSelectLine(11, -1);
			continue;
		}
#endif
		if (itemHit == 14)
		{
			DiaLoadTextDialog(11, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1);
			for(i=0; usr_gnuwarranty[i] != 0; i++) DiaStuffLine(11, usr_gnuwarranty[i]);
			DiaSelectLine(11, -1);
			continue;
		}
		if (itemHit == 15)
		{
			DiaLoadTextDialog(11, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1);
			for(i=0; usr_gnucopying[i] != 0; i++) DiaStuffLine(11, usr_gnucopying[i]);
			DiaSelectLine(11, -1);
			continue;
		}
	}
	DiaDoneDialog();
}

/*
 * special case for the "array" menu
 * X repeat factor = 3 (edit text)
 * Y repeat factor = 4 (edit text)
 * X spacing       = 5 (edit text)
 * Y spacing       = 6 (edit text)
 * Flip in X       = 8 (check box)
 * Flip in Y       = 9 (check box)
 * Add names       = 7 (check box)
 * X spacing label = 12 (stat text)
 * Y spacing label = 13 (stat text)
 * Space by edge   = 14 (radio button)
 * Space by center = 15 (radio button)
 * Stagger in X    = 16 (check box)
 * Stagger in Y    = 17 (check box)
 */
INTSML tty_arraydlog(char *paramstart[])
{
	REGISTER INTSML itemHit;
	REGISTER INTBIG xcentdist, ycentdist, xsize, ysize;
	INTBIG xoverlap, yoverlap, plx, ply, phx, phy;
	REGISTER NODEINST *ni;
	XARRAY trans;

	/* display the array dialog box */
	if (DiaInitDialog(&usr_arraydialog) != 0) return(0);
	DiaSetText(3, "1");
	DiaSetText(4, "1");
	DiaSetControl(14, 1);
	DiaSetText(12, "X edge overlap:");
	DiaSetText(13, "Y edge overlap:");
	ni = (NODEINST *)us_getobject(OBJNODEINST, 0);
	if (ni == NONODEINST) xsize = ysize = 0; else
	{
		makeangle(ni->rotation, ni->transpose, trans);
		nodesizeoffset(ni->proto, &plx, &ply, &phx, &phy);
		xform(ni->highx-ni->lowx - plx - phx, ni->highy-ni->lowy - ply - phy, &xoverlap, &yoverlap, trans);
		xsize = abs(xoverlap);   ysize = abs(yoverlap);
	}
	xoverlap = yoverlap = 0;
	xcentdist = xsize;   ycentdist = ysize;

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL) break;
		if (itemHit == OK && DiaValidEntry(3) && DiaValidEntry(4) && DiaValidEntry(5) &&
			DiaValidEntry(6)) break;
		if (itemHit == 7 || itemHit == 8 || itemHit == 9 || itemHit == 16 || itemHit == 17)
			DiaSetControl(itemHit, (INTSML)(1-DiaGetControl(itemHit)));
		if (itemHit == 14 || itemHit == 15)
		{
			DiaSetControl(14, 0);
			DiaSetControl(15, 0);
			DiaSetControl(itemHit, 1);
			if (itemHit == 14)
			{
				DiaSetText(12, "X edge overlap:");
				DiaSetText(13, "Y edge overlap:");
				xcentdist = atola(DiaGetText(5));
				ycentdist = atola(DiaGetText(6));
				DiaSetText(5, latoa(xoverlap));
				DiaSetText(6, latoa(yoverlap));
			} else
			{
				DiaSetText(12, "X centerline distance:");
				DiaSetText(13, "Y centerline distance:");
				xoverlap = atola(DiaGetText(5));
				yoverlap = atola(DiaGetText(6));
				DiaSetText(5, latoa(xcentdist));
				DiaSetText(6, latoa(ycentdist));
			}
			continue;
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		(void)initinfstr();
		(void)addstringtoinfstr(DiaGetText(3));
		if (DiaGetControl(8) != 0) (void)addtoinfstr('f');
		if (DiaGetControl(16) != 0) (void)addtoinfstr('s');
		(void)addtoinfstr(' ');
		(void)addstringtoinfstr(DiaGetText(4));
		if (DiaGetControl(9) != 0) (void)addtoinfstr('f');
		if (DiaGetControl(17) != 0) (void)addtoinfstr('s');
		(void)addtoinfstr(' ');
		xoverlap = atola(DiaGetText(5));
		yoverlap = atola(DiaGetText(6));
		if (DiaGetControl(15) != 0)
		{
			xoverlap = xsize - xoverlap;
			yoverlap = ysize - yoverlap;
		}
		(void)addstringtoinfstr(latoa(xoverlap));
		(void)addtoinfstr(' ');
		(void)addstringtoinfstr(latoa(yoverlap));
		if (DiaGetControl(7) == 0) (void)addstringtoinfstr(" no-names");
		paramstart[0] = returninfstr();
	}
	DiaDoneDialog();
	return(1);
}

/*
 * special case for the "artwork primitive color&pattern" menu
 * Pattern squares = 4 (user item)
 * Color           = 19 (popup)
 * Solid           = 5 (radio button)
 * Use Pattern     = 7 (radio button)
 * Outline pattern = 3 (radio button)
 * Predefined pats = 8-18
 */
static RECTAREA tty_strokerect;
static INTBIG tty_origpattern[8];
static INTSML tty_strokeup;

void tty_redrawpattern(RECTAREA *bigr)
{
	INTSML j, k, bits;
	RECTAREA r;

	for(j=0; j<8; j++)
	{
		bits = tty_origpattern[j] & 0xFFFF;
		for(k=0; k<16; k++)
		{
			r.left = tty_strokerect.left + k*16;   r.right = r.left + 17;
			r.top = tty_strokerect.top + j*16;     r.bottom = r.top + 17;
			if ((bits & (1<<(15-k))) != 0) DiaDrawRect(&r, 1); else DiaFrameRect(&r);
		}
	}
}

INTSML tty_patternstroke(INTBIG ox, INTBIG oy)
{
	INTSML x, y;
	REGISTER INTSML j, k, bits;
	RECTAREA r;

	DiaGetMouse(&x, &y);
	j = (y - tty_strokerect.top) / 16;  if (j < 0) j = 0;  if (j > 7) j = 7;
	k = (x - tty_strokerect.left) / 16;  if (k < 0) k = 0;  if (k > 15) k = 15;
	r.left = tty_strokerect.left + k*16;   r.right = r.left + 17;
	r.top = tty_strokerect.top + j*16;     r.bottom = r.top + 17;
	bits = tty_origpattern[j] & 0xFFFF;
	if (tty_strokeup == 0)
	{
		DiaFrameRect(&r);
		bits &= ~(1<<(15-k));
	} else
	{
		DiaDrawRect(&r, 1);
		bits |= 1<<(15-k);
	}
	tty_origpattern[j] = bits;
	return(0);
}

INTSML tty_artlookdlog(char *paramstart[])
{
	RECTAREA r;
	INTBIG addr, type;
	UINTSML spattern[8];
	REGISTER NODEINST *ni;
	REGISTER ARCINST *ai;
	REGISTER VARIABLE *colorvar, *patternvar;
	INTSML itemHit, i, j, k, bits, err, x, y;
	HIGHLIGHT *high;
	static char *colornames[25] = {"Overlappable 1", "Overlappable 2", "Overlappable 3",
		"Overlappable 4", "Overlappable 5", "White", "Black", "Gray", "Light Gray",
		"Dark Gray", "Red", "Light Red", "Dark Red", "Green", "Light Green", "Dark Green",
		"Blue", "Light Blue", "Dark Blue", "Cyan", "Magenta", "Yellow", "Orange",
		"Purple", "Brown"};
	static INTSML valuelist[25] =
	{
		COLORT1,		/* overlappable 1 */
		COLORT2,		/* overlappable 2 */
		COLORT3,		/* overlappable 3 */
		COLORT4,		/* overlappable 4 */
		COLORT5,		/* overlappable 5 */
		WHITE,			/* white */
		BLACK,			/* black */
		GRAY,			/* gray */
		LGRAY,			/* light gray */
		DGRAY,			/* dark gray */
		RED,			/* red */
		LRED,			/* light red */
		DRED,			/* dark red */
		GREEN,			/* green */
		LGREEN,			/* light green */
		DGREEN,			/* dark green */
		BLUE,			/* blue */
		LBLUE,			/* light blue */
		DBLUE,			/* dark blue */
		CYAN,			/* cyan */
		MAGENTA,		/* magenta */
		YELLOW,			/* yellow */
		ORANGE,			/* orange */
		PURPLE,			/* purple */
		BROWN			/* brown */
	};

	/* make sure there is an artwork primitive highlighted */
	high = us_getonehighlight();
	if (high == NOHIGHLIGHT) return(0);
	err = 0;
	if ((high->status&HIGHTYPE) != HIGHFROM) err = 1; else
	{
		if (high->fromgeom->entrytype == OBJNODEINST)
		{
			ni = high->fromgeom->entryaddr.ni;
			if (ni->proto->index == 0 || ni->proto->tech != art_tech) err = 1;
			addr = (INTBIG)ni;
			type = VNODEINST;
		} else
		{
			ai = high->fromgeom->entryaddr.ai;
			if (ai->proto->tech != art_tech) err = 1;
			addr = (INTBIG)ai;
			type = VARCINST;
		}
	}
	if (err != 0)
	{
		us_abortcommand("First find a single node or arc in the Artwork technology");
		return(0);
	}

	/* display the pattern dialog box */
	if (DiaInitDialog(&usr_artworkdialog) != 0) return(0);
	DiaSetPopup(19, 25, colornames);
	DiaItemRect(4, &tty_strokerect);
	DiaRedispRoutine(4, tty_redrawpattern);
	DiaFrameRect(&tty_strokerect);

	/* set existing conditions */
	colorvar = getvalkey(addr, type, VINTEGER, art_colorkey);
	if (colorvar != NOVARIABLE)
	{
		for(i=0; i<25; i++) if (valuelist[i] == colorvar->addr)
		{
			DiaSetPopupEntry(19, i);
			break;
		}
	}
	for(i=0; i<8; i++) tty_origpattern[i] = 0;
	patternvar = getvalkey(addr, type, -1, art_patternkey);
	if (patternvar != NOVARIABLE && getlength(patternvar) == 8)
	{
		if ((patternvar->type&VTYPE) == VINTEGER)
		{
			for(i=0; i<8; i++) tty_origpattern[i] = ((UINTBIG *)patternvar->addr)[i];
			DiaSetControl(7, 1);
		} else if ((patternvar->type&VTYPE) == VSHORT)
		{
			for(i=0; i<8; i++) tty_origpattern[i] = ((UINTSML *)patternvar->addr)[i];
			DiaSetControl(3, 1);
		}
	} else DiaSetControl(5, 1);
	tty_redrawpattern(&tty_strokerect);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK) break;
		if (itemHit == 4)
		{
			DiaGetMouse(&x, &y);
			j = (y - tty_strokerect.top) / 16;  if (j < 0) j = 0;  if (j > 7) j = 7;
			k = (x - tty_strokerect.left) / 16;  if (k < 0) k = 0;  if (k > 15) k = 15;
			bits = tty_origpattern[j] & 0xFFFF;
			if ((bits & (1<<(15-k))) != 0) tty_strokeup = 0; else tty_strokeup = 1;
			trackcursor(0, tty_nullup, tty_nullvoid, tty_patternstroke, tty_nullchar,
				tty_nullvoid, TRACKNORMAL);
			continue;
		}
		if (itemHit == 5 || itemHit == 7 || itemHit == 3)
		{
			DiaSetControl(5, 0);
			DiaSetControl(7, 0);
			DiaSetControl(3, 0);
			DiaSetControl(itemHit, 1);
			continue;
		}
		if (itemHit >= 8 && itemHit <= 18)
		{
			DiaGetMouse(&x, &y);
			DiaItemRect(itemHit, &r);
			j = (r.top+r.bottom)/2;
			if (y < j-8 || y > j+8) continue;
			i = (itemHit-8) * 2;
			if (x > (r.left+r.right)/2) i++;
			i *= 8;
			for(j=0; j<8; j++) tty_origpattern[j] = tty_predefpats[i++] & 0xFFFF;
			tty_redrawpattern(&tty_strokerect);
			continue;
		}
	}

	if (itemHit != CANCEL)
	{
		/* prepare for change */
		us_pushhighlight();
		us_clearhighlightcount();
		startobjectchange(addr, type);

		/* make the change */
		if (DiaGetControl(5) != 0)
		{
			if (patternvar != NOVARIABLE) (void)delvalkey(addr, type, art_patternkey);
		} else if (DiaGetControl(7) != 0)
		{
			(void)setvalkey(addr, type, art_patternkey, (INTBIG)tty_origpattern,
				VINTEGER|VISARRAY|(8<<VLENGTHSH));
		} else
		{
			for(i=0; i<8; i++) spattern[i] = tty_origpattern[i];
			(void)setvalkey(addr, type, art_patternkey, (INTBIG)spattern, VSHORT|VISARRAY|(8<<VLENGTHSH));
		}
		i = DiaGetPopupEntry(19);
		if (valuelist[i] == 014)
		{
			/* black is the default */
			if (colorvar != NOVARIABLE) (void)delvalkey(addr, type, art_colorkey);
		} else (void)setvalkey(addr, type, art_colorkey, valuelist[i], VINTEGER);

		/* complete change */
		endobjectchange(addr, type);
		(void)us_pophighlight(0);
	}
	DiaDoneDialog();
	paramstart[0] = "";
	return(1);
}

/*
 * special case for the "layer pattern" menu
 * Name of layer   = 4 (stat text)
 * Pattern squares = 5 (user item)
 * Next layer      = 6 (button)
 * Use pattern     = 7 (check box)
 * Predefined pats = 8-18 (icon)
 */
INTSML tty_patterndlog(char *paramstart[])
{
	INTSML itemHit, curlayer, i, j, k, bits, *origbits, *orignature, x, y, dispstyle;
	RECTAREA r;
	GRAPHICS *desc;

	if (us_needwindow()) return(0);

	/* get memory to save state */
	origbits = (INTSML *)emalloc(el_curtech->layercount * 8 * SIZEOFINTSML, us_aid->cluster);
	if (origbits == 0) return(0);
	orignature = (INTSML *)emalloc(el_curtech->layercount * SIZEOFINTSML, us_aid->cluster);
	if (orignature == 0) return(0);
	dispstyle = us_getdispstyle(el_curwindow);
	for(i=0; i<el_curtech->layercount; i++)
	{
		orignature[i] = (el_curtech->layers[i])->style[dispstyle];
		for(j=0; j<8; j++) origbits[i*8+j] = (el_curtech->layers[i])->raster[j];
	}
	curlayer = 0;

	/* display the pattern dialog box */
	if (DiaInitDialog(&usr_patterndialog) != 0)
	{
		efree((char *)origbits);
		efree((char *)orignature);
		return(0);
	}
	DiaItemRect(5, &tty_strokerect);
	DiaRedispRoutine(5, tty_redrawpattern);
	DiaFrameRect(&tty_strokerect);

	/* setup initial layer: number 0 */
	curlayer = 0;
	DiaSetText(4, layername(el_curtech, curlayer));
	desc = el_curtech->layers[curlayer];
	if ((desc->style[us_getdispstyle(el_curwindow)]&NATURE) == PATTERNED)
	{
		DiaUnDimItem(19);
		DiaSetControl(7, 1);
		if ((desc->style[dispstyle]&OUTLINEPAT) != 0) DiaSetControl(19, 1);
	} else DiaDimItem(19);
	for(j=0; j<8; j++) tty_origpattern[j] = desc->raster[j] & 0xFFFF;
	tty_redrawpattern(&tty_strokerect);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL) break;
		if (itemHit == OK) break;
		if (itemHit == 7)
		{
			/* the "Use Stipple" box */
			if (DiaGetControl(7) == 0)
			{
				DiaSetControl(7, 1);
				DiaUnDimItem(19);
				desc->style[dispstyle] = (desc->style[dispstyle] & ~NATURE) | PATTERNED;
			} else
			{
				DiaSetControl(7, 0);
				DiaSetControl(19, 0);
				DiaDimItem(19);
				desc->style[dispstyle] = (desc->style[dispstyle] & ~NATURE) | SOLIDC;
			}
			continue;
		}
		if (itemHit == 19)
		{
			/* the "Outline Pattern" box */
			if (DiaGetControl(19) == 0)
			{
				DiaSetControl(19, 1);
				desc->style[dispstyle] |= OUTLINEPAT;
			} else
			{
				DiaSetControl(19, 0);
				desc->style[dispstyle] &= ~OUTLINEPAT;
			}
			continue;
		}
		if (itemHit == 6)
		{
			/* the "Next Layer" button */
			curlayer++;
			if (curlayer >= el_curtech->layercount) curlayer = 0;
			DiaSetText(4, layername(el_curtech, curlayer));
			desc = el_curtech->layers[curlayer];
			DiaSetControl(7, 0);
			DiaUnDimItem(19);
			DiaSetControl(19, 0);
			if ((desc->style[dispstyle]&NATURE) == PATTERNED)
			{
				DiaSetControl(7, 1);
				if ((desc->style[dispstyle]&OUTLINEPAT) != 0) DiaSetControl(19, 1);
			} else DiaDimItem(19);
			for(j=0; j<8; j++) tty_origpattern[j] = desc->raster[j] & 0xFFFF;
			tty_redrawpattern(&tty_strokerect);
			continue;
		}

		if (itemHit == 5)
		{
			DiaGetMouse(&x, &y);
			j = (y - tty_strokerect.top) / 16;  if (j < 0) j = 0;  if (j > 7) j = 7;
			k = (x - tty_strokerect.left) / 16;  if (k < 0) k = 0;  if (k > 15) k = 15;
			bits = desc->raster[j] & 0xFFFF;
			if ((bits & (1<<(15-k))) != 0) tty_strokeup = 0; else tty_strokeup = 1;
			trackcursor(0, tty_nullup, tty_nullvoid, tty_patternstroke,
				tty_nullchar, tty_nullvoid, TRACKNORMAL);
			for(j=0; j<8; j++) desc->raster[j] = tty_origpattern[j];
			continue;
		}
		if (itemHit >= 8 && itemHit <= 18)
		{
			DiaGetMouse(&x, &y);
			DiaItemRect(itemHit, &r);
			j = (r.top+r.bottom)/2;
			if (y < j-8 || y > j+8) continue;
			i = (itemHit-8) * 2;
			if (x > (r.left+r.right)/2) i++;
			i *= 8;
			for(j=0; j<8; j++)
			{
				bits = tty_predefpats[i++] & 0xFFFF;
				desc->raster[j] = bits;
				tty_origpattern[j] = bits;
			}
			tty_redrawpattern(&tty_strokerect);
			continue;
		}
	}

	if (itemHit == CANCEL)
	{
		for(i=0; i<el_curtech->layercount; i++)
		{
			(el_curtech->layers[i])->style[dispstyle] = orignature[i];
			for(j=0; j<8; j++) (el_curtech->layers[i])->raster[j] = origbits[i*8+j];
		}
	}
	efree((char *)origbits);
	efree((char *)orignature);
	DiaDoneDialog();
	paramstart[0] = "";
	return(1);
}

/*
 * special case for the "als clock" dialog
 */
#define	MAXPHASES 20
INTSML tty_alsclockdlog(char *paramstart[])
{
	INTSML itemHit, retval, i, j;
	char *line;
	float durval[MAXPHASES];
	INTSML levval[MAXPHASES], phases;
	static char *retdur[MAXPHASES];
	static INTSML first = 0;

	/* display the ALS clock dialog box */
	if (DiaInitDialog(&usr_alsclockdialog) != 0) return(0);
	DiaInitTextDialog(16, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1, 0);

	/* setup complex clock specification */
	DiaSetText(11, "0.0");	/* random */
	DiaSetControl(8, 1);	/* gate strength */
	DiaSetControl(14, 1);	/* level */
	DiaSetText(20, "0");	/* infinite cycles */

	/* now disable complex clock specification */
	DiaSetControl(3, 1);										/* frequency */
	DiaDimItem(10);   DiaDimItem(11);   DiaNoEditControl(11);	/* random */
	DiaDimItem(13);   DiaDimItem(8);    DiaDimItem(12);			/* strength */
	DiaDimItem(23);   DiaDimItem(14);   DiaDimItem(9);			/* level */
	DiaDimItem(17);   DiaDimItem(21);   DiaNoEditControl(21);	/* duration */
	DiaDimItem(18);   DiaDimItem(15);							/* add/delete */
	DiaDimItem(22);												/* list header */
	DiaDimItem(19);   DiaDimItem(20);   DiaNoEditControl(20);	/* cycles */
	DiaUnDimItem(7);  DiaUnDimItem(6);  DiaEditControl(6);		/* freq/per */

	/* loop until done */
	phases = 0;
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;
		if (itemHit == 3 || itemHit == 4 || itemHit == 5)
		{
			DiaSetControl(3, 0);   DiaSetControl(4, 0);   DiaSetControl(5, 0);
			DiaSetControl(itemHit, 1);
			if (itemHit == 5)
			{
				DiaUnDimItem(10);   DiaUnDimItem(11);   DiaEditControl(11);	/* random */
				DiaUnDimItem(13);   DiaUnDimItem(8);    DiaUnDimItem(12);	/* strength */
				DiaUnDimItem(23);   DiaUnDimItem(14);   DiaUnDimItem(9);	/* level */
				DiaUnDimItem(17);   DiaUnDimItem(21);   DiaEditControl(21);	/* duration */
				DiaUnDimItem(18);   DiaUnDimItem(15);						/* add/delete */
				DiaUnDimItem(22);											/* list header */
				DiaUnDimItem(19);   DiaUnDimItem(20);   DiaEditControl(20);	/* cycles */
				DiaDimItem(7);      DiaDimItem(6);      DiaNoEditControl(6);/* freq/per */
			} else
			{
				DiaDimItem(10);   DiaDimItem(11);   DiaNoEditControl(11);	/* random */
				DiaDimItem(13);   DiaDimItem(8);    DiaDimItem(12);			/* strength */
				DiaDimItem(23);   DiaDimItem(14);   DiaDimItem(9);			/* level */
				DiaDimItem(17);   DiaDimItem(21);   DiaNoEditControl(21);	/* duration */
				DiaDimItem(18);   DiaDimItem(15);							/* add/delete */
				DiaDimItem(22);												/* list header */
				DiaDimItem(19);   DiaDimItem(20);   DiaNoEditControl(20);	/* cycles */
				DiaUnDimItem(7);  DiaUnDimItem(6);  DiaEditControl(6);		/* freq/per */
			}
			continue;
		}
		if (itemHit == 13 || itemHit == 8 || itemHit == 12)
		{
			DiaSetControl(13, 0);   DiaSetControl(8, 0);   DiaSetControl(12, 0);
			DiaSetControl(itemHit, 1);
			continue;
		}
		if (itemHit == 23 || itemHit == 14 || itemHit == 9)
		{
			DiaSetControl(23, 0);   DiaSetControl(14, 0);   DiaSetControl(9, 0);
			DiaSetControl(itemHit, 1);
			continue;
		}
		if (itemHit == 18)
		{
			/* add phase */
			if (phases >= MAXPHASES) continue;
			line = DiaGetText(21);
			durval[phases] = atof(line);
			if (DiaGetControl(23) != 0) levval[phases] = 0; else
				if (DiaGetControl(14) != 0) levval[phases] = 1; else levval[phases] = 2;
			phases++;
			tty_writephases(durval, levval, phases);
			continue;
		}
		if (itemHit == 15)
		{
			/* delete phase */
			if (phases <= 0) continue;
			j = DiaGetCurLine(16);
			for(i=j; i<phases; i++)
			{
				durval[i] = durval[i+1];
				levval[i] = levval[i+1];
			}
			phases--;
			tty_writephases(durval, levval, phases);
			continue;
		}
	}
	retval = 0;
	if (itemHit == OK && DiaGetControl(3) != 0)
	{

		paramstart[0] = "frequency";
		paramstart[1] = us_putintoinfstr(DiaGetText(6));
		retval = 2;
	} else if (itemHit == OK && DiaGetControl(4) != 0)
	{
		paramstart[0] = "period";
		paramstart[1] = us_putintoinfstr(DiaGetText(6));
		retval = 2;
	} else if (itemHit == OK && DiaGetControl(5) != 0)
	{
		paramstart[0] = "custom";
		paramstart[1] = us_putintoinfstr(DiaGetText(11));
		if (DiaGetControl(13) != 0) paramstart[2] = "1"; else
			if (DiaGetControl(8) != 0) paramstart[2] = "2"; else
				paramstart[2] = "3";
		paramstart[3] = us_putintoinfstr(DiaGetText(20));
		retval = 4;
		if (first == 0) for(i=0; i<MAXPHASES; i++) retdur[i] = 0;
		first++;
		for(i=0; i<phases; i++)
		{
			if (retdur[i] != 0) efree(retdur[i]);
			retdur[i] = (char *)emalloc(50, us_aid->cluster);
			if (retdur[i] == 0) break;
			(void)sprintf(retdur[i], "%e", durval[i]);
			paramstart[retval++] = (levval[i]==0 ? "low" : (levval[i]==1 ? "high" : "undefined"));
			paramstart[retval++] = retdur[i];
		}
	}
	DiaDoneDialog();
	return(retval);
}

void tty_writephases(float durval[], INTSML levval[], INTSML phases)
{
	INTSML i;
	char lne[50];

	DiaLoadTextDialog(16, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1);
	for(i=0; i<phases; i++)
	{
		(void)sprintf(lne, "%s for %e",
			(levval[i]==0 ? "low" : (levval[i]==1 ? "high" : "undefined")), durval[i]);
		DiaStuffLine(16, lne);
	}
	if (phases <= 0) DiaSelectLine(16, -1); else DiaSelectLine(16, 0);
}

/*
 * special case for the "copyfacet" dialog
 * Library name = 5 (static text)
 * Facet list   = 3 (user item)
 */
INTSML tty_copyfacetdlog(char *prompt, char *paramstart[])
{
	INTSML itemHit, libcount, i;
	REGISTER LIBRARY *lib, *olib;
	REGISTER char **liblist;

	/* see how many libraries should be in the popup */
	libcount = 0;
	for(olib = el_curlib; olib != NOLIBRARY; olib = olib->nextlibrary) libcount++;

	/* determine the initial library */
	lib = el_curlib;
	if (libcount > 1) lib = lib->nextlibrary;
	if (*prompt == '!')
	{
		olib = getlibrary(&prompt[1]);
		if (olib != NOLIBRARY)
		{
			libcount = 1;
			lib = olib;
		}
	}

	/* load up list of libraries */
	liblist = (char **)emalloc(libcount * (sizeof (char *)), el_tempcluster);
	if (liblist == 0) return(0);
	if (libcount == 1) liblist[0] = lib->libname; else
	{
		for(olib = el_curlib->nextlibrary, i=0; olib != NOLIBRARY;
			olib = olib->nextlibrary)
				liblist[i++] = olib->libname;
		libcount = i;
	}

	/* display the copyfacet dialog box */
	if (DiaInitDialog(&usr_copyfacetdialog) != 0)
	{
		efree((char *)liblist);
		return(0);
	}
	DiaSetPopup(5, libcount, liblist);

	olib = el_curlib;   el_curlib = lib;
	DiaInitTextDialog(3, us_topoffacets, us_nextparse, tty_nulldlogdone, 0,
		SCSELMOUSE|SCSELKEY|SCDOUBLEQUIT);
	el_curlib = olib;

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;
		if (itemHit == 5)
		{
			i = DiaGetPopupEntry(5);
			for(lib = el_curlib; lib != NOLIBRARY; lib = lib->nextlibrary)
				if (strcmp(lib->libname, liblist[i]) == 0) break;
			if (lib == NOLIBRARY) continue;
			olib = el_curlib;
			el_curlib = lib;
			DiaLoadTextDialog(3, us_topoffacets, us_nextparse, tty_nulldlogdone, 0);
			el_curlib = olib;
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		(void)initinfstr();
		(void)addstringtoinfstr(lib->libname);
		(void)addtoinfstr(':');
		(void)addstringtoinfstr(DiaGetScrollLine(3, DiaGetCurLine(3)));
		paramstart[0] = returninfstr();
	}
	DiaDoneDialog();
	efree((char *)liblist);
	return(1);
}

/*
 * special case for the "defarc" menu
 * defaults for specific type = 4 (radio button)
 * defaults for all types     = 5 (radio button)
 * specific arc               = 3 (stat text)
 * next arc                   = 6 (button)
 * reset to initial state     = 13 (button)
 * rigid                      = 7 (check button)
 * fixed-angle                = 8 (check button)
 * slidable                   = 9 (check button)
 * negated                    = 10 (check button)
 * directional                = 11 (check button)
 * ends extended              = 12 (check button)
 * width                      = 14 (edit text)
 * width title                = 15 (stat text)
 * angle title                = 16 (stat text)
 * angle                      = 17 (edit text)
 * default pin title          = 18 (stat text)
 * default pin                = 19 (stat text)
 * set pin                    = 20 (button)
 */
static ARCPROTO *tty_thisap;
static NODEPROTO *tty_posprims;
INTSML tty_defarcdlog(char *paramstart[])
{
	INTSML itemHit;
	REGISTER INTBIG allstyle, i, j, origallstyle;
	REGISTER VARIABLE *var;
	REGISTER ARCPROTO *ap;
	REGISTER NODEPROTO **pins, *np;
	extern DIALOG tty_listdialog;

	/* display the default arc dialog box */
	if (DiaInitDialog(&usr_defarcdialog) != 0) return(0);

	/* remember all state */
	var = getvalkey((INTBIG)us_aid, VAID, VINTEGER, us_arcstyle);
	if (var != NOVARIABLE) allstyle = var->addr; else allstyle = WANTFIXANG;
	origallstyle = allstyle;
	for(i=0, ap = el_curtech->firstarcproto; ap != NOARCPROTO; ap = ap->nextarcproto) i++;
	pins = (NODEPROTO **)emalloc(i * (sizeof (NODEPROTO *)), el_tempcluster);
	if (pins == 0) return(0);
	for(i=0, ap = el_curtech->firstarcproto; ap != NOARCPROTO; ap = ap->nextarcproto, i++)
	{
		ap->temp1 = ap->userbits;
		ap->temp2 = ap->nominalwidth;
		pins[i] = getpinproto(ap);
	}

	/* initially load for first arc in technology */
	tty_thisap = us_curarcproto;
	tty_defarcload(tty_thisap, pins);
	DiaSetControl(4, 1);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;
		if (itemHit == 7 || itemHit == 8 || itemHit == 9 ||
			itemHit == 10 || itemHit == 11 || itemHit == 12)
		{
			j = DiaGetControl(itemHit);
			DiaSetControl(itemHit, (INTSML)(1-j));
			if (DiaGetControl(4) == 0) i = allstyle; else
				i = tty_thisap->temp1;
			switch (itemHit)
			{
				case 7:
					if (j == 0) i |= WANTFIX; else i &= ~WANTFIX;
					break;
				case 8:
					if (j == 0) i |= WANTFIXANG; else i &= ~WANTFIXANG;
					break;
				case 9:
					if (j != 0) i |= WANTCANTSLIDE; else i &= ~WANTCANTSLIDE;
					break;
				case 10:
					if (j == 0) i |= WANTNEGATED; else i &= ~WANTNEGATED;
					break;
				case 11:
					if (j == 0) i |= WANTDIRECTIONAL; else i &= ~WANTDIRECTIONAL;
					break;
				case 12:
					if (j != 0) i |= WANTNOEXTEND; else i &= ~WANTNOEXTEND;
					break;
			}
			if (DiaGetControl(4) == 0) allstyle = i; else
				tty_thisap->temp1 = i;
			continue;
		}
		if (itemHit == 4)
		{
			tty_defarcload(tty_thisap, pins);
			DiaSetControl(4, 1);
			DiaSetControl(5, 0);
			continue;
		}
		if (itemHit == 5)
		{
			tty_defarcload(NOARCPROTO, pins);
			DiaSetControl(4, 0);
			DiaSetControl(5, 1);
			continue;
		}
		if (itemHit == 13)
		{
			allstyle = WANTFIXANG;
			DiaSetControl(7, 0);
			DiaSetControl(8, 1);
			DiaSetControl(9, 1);
			DiaSetControl(10, 0);
			DiaSetControl(11, 0);
			DiaSetControl(12, 1);
			continue;
		}
		if (itemHit == 6)
		{
			tty_thisap = tty_thisap->nextarcproto;
			if (tty_thisap == NOARCPROTO) tty_thisap = el_curtech->firstarcproto;
			tty_defarcload(tty_thisap, pins);
			continue;
		}
		if (itemHit == 14)
		{
			if (DiaGetControl(4) == 0) continue;
			tty_thisap->temp2 = atola(DiaGetText(14));
			continue;
		}
		if (itemHit == 17)
		{
			if (DiaGetControl(4) == 0) continue;
			tty_thisap->temp1 = (tty_thisap->temp1 & ~AANGLEINC) | ((atoi(DiaGetText(17))%360) << AANGLEINCSH);
			continue;
		}
		if (itemHit == 20)
		{
			if (DiaGetControl(4) == 0) continue;

			DiaAllowSubDialog();
			if (DiaInitDialog(&tty_listdialog) != 0) continue;
			DiaInitTextDialog(3, tty_topofprims, tty_nextprims, tty_nulldlogdone,
				0, SCSELMOUSE|SCSELKEY|SCDOUBLEQUIT);
			DiaSetText(4, "Select a node to use as a pin");

			for(;;)
			{
				itemHit = DiaNextHit();
				if (itemHit == OK || itemHit == CANCEL) break;
			}
			np = getnodeproto(DiaGetScrollLine(3, DiaGetCurLine(3)));
			DiaDoneDialog();
			if (itemHit == CANCEL) continue;

			for(i=0, ap = el_curtech->firstarcproto; ap != NOARCPROTO; ap = ap->nextarcproto, i++)
				if (tty_thisap == ap) break;
			if (ap != NOARCPROTO) pins[i] = np;
			DiaSetText(19, describenodeproto(np));
			continue;
		}
	}

	if (itemHit != CANCEL)
	{
		for(i=0, ap = el_curtech->firstarcproto; ap != NOARCPROTO;
			ap = ap->nextarcproto, i++)
		{
			if (ap->temp1 != ap->userbits)
				(void)setval((INTBIG)ap, VARCPROTO, "userbits", ap->temp1, VINTEGER);
			if (ap->temp2 != ap->nominalwidth)
				(void)setval((INTBIG)ap, VARCPROTO, "nominalwidth", arcwidthoffset(ap) + ap->temp2, VINTEGER);
			np = getpinproto(ap);
			if (np != pins[i])
				(void)setval((INTBIG)ap, VARCPROTO, "ARC_Default_Pin", (INTBIG)pins[i], VNODEPROTO|VDONTSAVE);
		}
		if (allstyle != origallstyle)
			(void)setvalkey((INTBIG)us_aid, VAID, us_arcstyle, allstyle, VINTEGER|VDONTSAVE);
	}
	DiaDoneDialog();
	efree((char *)pins);
	paramstart[0] = "x";
	return(1);
}

INTSML tty_topofprims(char **c)
{
	tty_posprims = el_curtech->firstnodeproto;
	return(1);
}

char *tty_nextprims(void)
{
	REGISTER char *nextname;
	REGISTER INTSML i;
	REGISTER PORTPROTO *pp;

	for( ; tty_posprims != NONODEPROTO; tty_posprims = tty_posprims->nextnodeproto)
	{
		/* test this pin for validity */
		pp = tty_posprims->firstportproto;
		for(i=0; pp->connects[i] != NOARCPROTO; i++)
			if (pp->connects[i] == tty_thisap) break;
		if (pp->connects[i] == NOARCPROTO) continue;
		nextname = tty_posprims->primname;
		tty_posprims = tty_posprims->nextnodeproto;
		return(nextname);
	}
	return(0);
}

/*
 * Helper routine for arc defaults
 */
void tty_defarcload(ARCPROTO *ap, NODEPROTO **pins)
{
	REGISTER VARIABLE *var;
	REGISTER NODEPROTO *np;
	REGISTER ARCPROTO *oap;
	REGISTER INTSML i;
	REGISTER INTBIG style;
	char line[20];

	if (ap == NOARCPROTO)
	{
		var = getvalkey((INTBIG)us_aid, VAID, VINTEGER, us_arcstyle);
		if (var != NOVARIABLE) style = var->addr; else style = WANTFIXANG;
		DiaDimItem(6);
		DiaSetText(3, "");
		DiaUnDimItem(13);
		DiaDimItem(15);
		DiaSetText(14, "");
		DiaNoEditControl(14);
		DiaDimItem(16);
		DiaSetText(17, "");
		DiaNoEditControl(17);
		DiaDimItem(18);
		DiaSetText(19, "");
		DiaDimItem(20);
	} else
	{
		style = ap->userbits;
		DiaUnDimItem(6);
		DiaSetText(3, ap->protoname);
		DiaDimItem(13);
		DiaUnDimItem(15);
		DiaSetText(-14, latoa(ap->nominalwidth - arcwidthoffset(ap)));
		DiaEditControl(14);
		DiaUnDimItem(16);
		(void)sprintf(line, "%d", (ap->userbits&AANGLEINC) >> AANGLEINCSH);
		DiaSetText(17, line);
		DiaEditControl(17);
		DiaUnDimItem(18);
		np = NONODEPROTO;
		for(i=0, oap = el_curtech->firstarcproto; oap != NOARCPROTO; oap = oap->nextarcproto, i++)
			if (ap == oap) np = pins[i];
		DiaSetText(19, describenodeproto(np));
		DiaUnDimItem(20);
	}
	DiaSetControl(7, (INTSML)((style&WANTFIX) != 0 ? 1 : 0));
	DiaSetControl(8, (INTSML)((style&WANTFIXANG) != 0 ? 1 : 0));
	DiaSetControl(9, (INTSML)((style&WANTCANTSLIDE) == 0 ? 1 : 0));
	DiaSetControl(10, (INTSML)((style&WANTNEGATED) != 0 ? 1 : 0));
	DiaSetControl(11, (INTSML)((style&WANTDIRECTIONAL) != 0 ? 1 : 0));
	DiaSetControl(12, (INTSML)((style&WANTNOEXTEND) == 0 ? 1 : 0));
}

/*
 * special case for the "defnode" menu
 * Primitives     = 9 (radio button)
 * Facets         = 12 (radio button)
 * Primitive name = 10 (stat text)
 * Facet name     = 13 (stat text)
 * Next node      = 11 (button)
 * X size label   = 6 (stat text)
 * Y size label   = 7 (stat text)
 * X size         = 3 (edit text)
 * Y size         = 8 (edit text)
 * Expanded       = 4 (radio button)
 * Unexpanded     = 5 (radio button)
 * Allow facetmod = 14 (check button)
 * Check dates    = 15 (check button)
 * Rotation       = 17 (edit text)
 * Transposed     = 18 (check button)
 * Separator line = 19 (user item)
 * Separator line = 20 (user item)
 * Separator line = 21 (user item)
 * Allow prim mod = 22 (check button)
 * Tiny facets    = 23 (check button)
 */
INTSML tty_defnodedlog(char *paramstart[])
{
	INTSML itemHit, i, j, pangle;
	INTBIG plx, ply, phx, phy, lx, hx, ly, hy;
	REGISTER NODEPROTO *thisprim, *thisfacet, *np;
	REGISTER VARIABLE *var;
	RECTAREA itemRect;

	/* display the defnode dialog box */
	if (DiaInitDialog(&usr_defnodedialog) != 0) return(0);

	/* draw the separator bars */
	DiaItemRect(19, &itemRect);   DiaDrawRect(&itemRect, 1);
	DiaItemRect(20, &itemRect);   DiaDrawRect(&itemRect, 1);
	DiaItemRect(21, &itemRect);   DiaDrawRect(&itemRect, 1);

	/* save existing state */
	for(np = el_curtech->firstnodeproto; np != NONODEPROTO; np = np->nextnodeproto)
	{
		nodesizeoffset(np, &plx, &ply, &phx, &phy);
		np->temp1 = np->highx - np->lowx - plx - phx;
		np->temp2 = np->highy - np->lowy - ply - phy;
	}
	for(np = el_curlib->firstnodeproto; np != NONODEPROTO; np = np->nextnodeproto)
		np->temp1 = np->userbits;

	/* decide what to display first */
	if (us_curnodeproto == NONODEPROTO)
	{
		thisfacet = el_curlib->firstnodeproto;
		thisprim = el_curtech->firstnodeproto;
		DiaSetControl(9, 1);
		DiaSetControl(12, 0);
		tty_loadnode(thisprim);
	} else
	{
		if (us_curnodeproto->index == 0)
		{
			thisfacet = us_curnodeproto;
			thisprim = el_curtech->firstnodeproto;
			DiaSetControl(9, 0);
			DiaSetControl(12, 1);
		} else
		{
			thisfacet = el_curlib->firstnodeproto;
			thisprim = us_curnodeproto;
			DiaSetControl(9, 1);
			DiaSetControl(12, 0);
		}
		tty_loadnode(us_curnodeproto);
	}

	/* load defaults for all nodes */
	var = getvalkey((INTBIG)us_aid, VAID, VINTEGER, us_placement_angle);
	if (var == NOVARIABLE) pangle = 0; else pangle = var->addr;
	DiaSetText(-17, frtoa(pangle%3600*WHOLE/10));
	DiaSetControl(18, (INTSML)((pangle >= 3600 ? 1 : 0)));
	DiaSetControl(14, (INTSML)((us_aid->aidstate&NOFACETCHANGES) != 0 ? 1 : 0));
	DiaSetControl(22, (INTSML)((us_aid->aidstate&NOPRIMCHANGES) != 0 ? 1 : 0));
	DiaSetControl(15, (INTSML)((us_aid->aidstate&CHECKDATE) != 0 ? 1 : 0));
	DiaSetControl(23, (INTSML)((us_aid->aidstate&DRAWTINYFACETS) == 0 ? 1 : 0));

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;
		if (itemHit == 9)
		{
			DiaSetControl(9, 1);
			DiaSetControl(12, 0);
			tty_loadnode(thisprim);
		}
		if (itemHit == 12)
		{
			if (thisfacet == NONODEPROTO) continue;
			DiaSetControl(9, 0);
			DiaSetControl(12, 1);
			tty_loadnode(thisfacet);
		}
		if (itemHit == 11)
		{
			if (DiaGetControl(9) != 0)
			{
				thisprim = thisprim->nextnodeproto;
				if (thisprim == NONODEPROTO) thisprim = el_curtech->firstnodeproto;
				tty_loadnode(thisprim);
			} else
			{
				thisfacet = thisfacet->nextnodeproto;
				if (thisfacet == NONODEPROTO) thisfacet = el_curlib->firstnodeproto;
				tty_loadnode(thisfacet);
			}
		}
		if (itemHit == 3 || itemHit == 8)
		{
			if (DiaGetControl(9) == 0) continue;
			thisprim->temp1 = atola(DiaGetText(3));
			thisprim->temp2 = atola(DiaGetText(8));
		}
		if (itemHit == 4)
		{
			DiaSetControl(4, 1);
			DiaSetControl(5, 0);
			thisfacet->temp1 |= WANTNEXPAND;
		}
		if (itemHit == 5)
		{
			DiaSetControl(4, 0);
			DiaSetControl(5, 1);
			thisfacet->temp1 &= ~WANTNEXPAND;
		}
		if (itemHit == 14 || itemHit == 15 || itemHit == 18 ||
			itemHit == 22 || itemHit == 23)
				DiaSetControl(itemHit, (INTSML)(1-DiaGetControl(itemHit)));
	}

	paramstart[0] = "x";
	if (itemHit != CANCEL)
	{
		/* handle primitive size changes */
		for(np = el_curtech->firstnodeproto; np != NONODEPROTO; np = np->nextnodeproto)
		{
			nodesizeoffset(np, &plx, &ply, &phx, &phy);
			if (np->temp1 != np->highx - np->lowx - plx - phx ||
				np->temp2 != np->highy - np->lowy - ply - phy)
			{
				lx = -(np->temp1+plx+phx) / 2;   hx = lx+np->temp1+plx+phx;
				ly = -(np->temp2+ply+phy) / 2;   hy = ly+np->temp2+ply+phy;
				(void)setval((INTBIG)np, VNODEPROTO, "lowx", lx, VINTEGER);
				(void)setval((INTBIG)np, VNODEPROTO, "highx", hx, VINTEGER);
				(void)setval((INTBIG)np, VNODEPROTO, "lowy", ly, VINTEGER);
				(void)setval((INTBIG)np, VNODEPROTO, "highy", hy, VINTEGER);
			}
		}

		/* handle facet expansion changes */
		for(np = el_curlib->firstnodeproto; np != NONODEPROTO; np = np->nextnodeproto)
			if ((np->temp1&WANTNEXPAND) != (np->userbits&WANTNEXPAND))
				(void)setval((INTBIG)np, VNODEPROTO, "userbits", np->temp1, VINTEGER);

		/* handle changes to all nodes */
		lx = us_aid->aidstate;
		i = DiaGetControl(14);
		if (i != 0) lx |= NOFACETCHANGES; else lx &= ~NOFACETCHANGES;
		i = DiaGetControl(22);
		if (i != 0) lx |= NOPRIMCHANGES; else lx &= ~NOPRIMCHANGES;
		i = DiaGetControl(15);
		if (i != 0) lx |= CHECKDATE; else lx &= ~CHECKDATE;
		i = DiaGetControl(23);
		if (i == 0) lx |= DRAWTINYFACETS; else lx &= ~DRAWTINYFACETS;
		if ((lx&(NOFACETCHANGES|NOPRIMCHANGES|CHECKDATE|DRAWTINYFACETS)) !=
			(us_aid->aidstate&(NOFACETCHANGES|NOPRIMCHANGES|CHECKDATE|DRAWTINYFACETS)))
				(void)setval((INTBIG)us_aid, VAID, "aidstate", lx, VINTEGER);
		j = (atofr(DiaGetText(17))*10/WHOLE) % 3600;
		if (DiaGetControl(18) != 0) j += 3600;
		if (j != pangle)
			(void)setvalkey((INTBIG)us_aid, VAID, us_placement_angle, j, VINTEGER|VDONTSAVE);
	}
	DiaDoneDialog();
	return(1);
}

/*
 * helper routine for defnode dialog
 */
void tty_loadnode(NODEPROTO *thisnp)
{
	INTBIG plx, ply, phx, phy;
	INTSML i, j;

	if (thisnp->index == 0)
	{
		DiaSetText(10, "");
		DiaSetText(13, describenodeproto(thisnp));
		DiaDimItem(6);
		DiaDimItem(7);
		DiaNoEditControl(3);   DiaNoEditControl(8);
		DiaSetText(3, "");   DiaSetText(8, "");
		DiaUnDimItem(4);
		DiaUnDimItem(5);
		if ((thisnp->userbits&WANTNEXPAND) != 0)
		{ i = 4;   j = 5; } else { i = 5;   j = 4; }
		DiaSetControl(i, 1);
		DiaSetControl(j, 0);
	} else
	{
		DiaSetText(10, thisnp->primname);
		DiaSetText(13, "");
		DiaUnDimItem(6);
		DiaUnDimItem(7);
		DiaDimItem(4);
		DiaDimItem(5);
		nodesizeoffset(thisnp, &plx, &ply, &phx, &phy);
		DiaEditControl(3);   DiaEditControl(8);
		DiaSetText(3, latoa(thisnp->highx-thisnp->lowx-plx-phx));
		DiaSetText(8, latoa(thisnp->highy-thisnp->lowy-ply-phy));
	}
}

/*
 * special case for "DRC error" options
 * 5 = Error message      (stat text)
 * 1 = Acknowledge        (button)
 * 2 = Quit-checking      (button)
 * 3 = Ignore-error       (button)
 * 4 = Continue-silently  (button)
 */
INTSML tty_drcerrordlog(char *prompt, char *paramstart[])
{
	INTSML itemHit, oldplease;

	/* display the DRC error dialog box */
	if (DiaInitDialog(&usr_drcerrdialog) != 0) return(0);

	/* load the message */
	DiaSetText(5, prompt);

	/* loop until done */
	oldplease = el_pleasestop;
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == 1 || itemHit == 2 || itemHit == 3 || itemHit == 4) break;
	}
	el_pleasestop = oldplease;

	switch (itemHit)
	{
		case 2:  paramstart[0] = "quit-checking";       break;
		case 3:  paramstart[0] = "ignore-error";        break;
		case 4:  paramstart[0] = "continue-silently";   break;
		default: paramstart[0] = "acknowledge";         break;
	}
	DiaDoneDialog();
	return(1);
}

static TECHNOLOGY *usr_postechcomcomp;
INTSML usr_topoftechs(char **c) { usr_postechcomcomp = el_technologies; return(1); }
char *usr_nexttechs(void)
{
	REGISTER char *retname;

	if (usr_postechcomcomp == 0) return(0);
	if (usr_postechcomcomp == NOTECHNOLOGY)
	{
		usr_postechcomcomp = 0;
		return("schematic, analog");
	}
	retname = usr_postechcomcomp->techname;
	if (usr_postechcomcomp == sch_tech) retname = "schematic, digital";
	usr_postechcomcomp = usr_postechcomcomp->nexttechnology;
	return(retname);
}

void tty_stufftechdescript(void)
{
	REGISTER TECHNOLOGY *t;
	REGISTER char *tech;

	tech = DiaGetScrollLine(3, DiaGetCurLine(3));
	if (namesamen(tech, "schematic", 9) == 0)
	{
		t = sch_tech;
		DiaSetText(4, t->techdescript);
		return;
	}

	for(t = el_technologies; t != NOTECHNOLOGY; t = t->nexttechnology)
		if (strcmp(t->techname, tech) == 0) break;
	if (t == NOTECHNOLOGY) return;
	DiaSetText(4, t->techdescript);
}

/*
 * special case for the "select technology" menu
 * Technology description = 5 (stat text)
 * Technology list        = 3 (user item)
 */
INTSML tty_technologydlog(char *paramstart[])
{
	INTSML itemHit;

	/* display the new facet dialog box */
	if (DiaInitDialog(&usr_techselectdialog) != 0) return(0);
	DiaInitTextDialog(3, usr_topoftechs, usr_nexttechs, tty_nulldlogdone, 0,
		SCSELMOUSE|SCSELKEY|SCDOUBLEQUIT|SCREPORT);
	tty_stufftechdescript();

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK) break;
		if (itemHit == 3)
		{
			tty_stufftechdescript();
			continue;
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		paramstart[0] = us_putintoinfstr(DiaGetScrollLine(3, DiaGetCurLine(3)));
		if (namesame(paramstart[0], "schematic, digital") == 0) paramstart[0] = "schematic";
	}
	DiaDoneDialog();
	return(1);
}

/*
 * special case for the "dependent libraries" menu
 * Dependent list = 3 (user item)
 * Library list   = 12 (user item)
 * Add lib        = 7 (button)
 * Remove lib     = 6 (button)
 * New name       = 9 (edit text)
 * Current lib    = 14 (stat text)
 */
INTSML tty_dependentlibdlog(char *paramstart[])
{
	INTSML itemHit, i, j, liblistlen;
	REGISTER VARIABLE *var;
	char **liblist, **newliblist, *pt;

	/* display the new facet dialog box */
	if (DiaInitDialog(&usr_dependentlibdialog) != 0) return(0);
	DiaSetText(14, el_curlib->libname);
	DiaInitTextDialog(12, topoflibs, nextlibs, tty_nulldlogdone, 0, SCSELMOUSE|SCSELKEY);
	DiaInitTextDialog(3, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, 0,
		SCSELMOUSE|SCSELKEY);
	var = getval((INTBIG)el_curlib, VLIBRARY, VSTRING|VISARRAY, "EDTEC_dependent_libraries");
	if (var == NOVARIABLE) liblistlen = 0; else
	{
		liblistlen = getlength(var);
		liblist = (char **)emalloc(liblistlen * (sizeof (char *)), el_tempcluster);
		if (liblist == 0) return(0);
		for(i=0; i<liblistlen; i++)
			(void)allocstring(&liblist[i], ((char **)var->addr)[i], el_tempcluster);
	}
	tty_showliblist(liblist, liblistlen);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK) break;
		if (itemHit == 6)
		{
			/* remove */
			i = DiaGetCurLine(3);
			if (i < 0 || i >= liblistlen) continue;
			efree(liblist[i]);
			for(j=i; j<liblistlen-1; j++) liblist[j] = liblist[j+1];
			liblistlen--;
			if (liblistlen == 0) efree((char *)liblist);
			tty_showliblist(liblist, liblistlen);
			continue;
		}
		if (itemHit == 7)
		{
			/* add */
			pt = DiaGetText(9);
			while (*pt == ' ') pt++;
			if (*pt == 0) pt = DiaGetScrollLine(12, DiaGetCurLine(12));
			i = DiaGetCurLine(3);
			if (i < 0) i = 0;

			/* create a new list */
			newliblist = (char **)emalloc((liblistlen+1) * (sizeof (char *)), el_tempcluster);
			if (newliblist == 0) return(0);
			for(j=0; j<liblistlen; j++) newliblist[j] = liblist[j];
			if (liblistlen != 0) efree((char *)liblist);
			liblist = newliblist;

			for(j=liblistlen; j>i; j--) liblist[j] = liblist[j-1];
			liblistlen++;
			(void)allocstring(&liblist[i], pt, el_tempcluster);
			tty_showliblist(liblist, liblistlen);
			DiaSetText(9, "");
			continue;
		}
	}

	if (itemHit != CANCEL)
	{
		if (liblistlen == 0)
		{
			if (var != NOVARIABLE)
				delval((INTBIG)el_curlib, VLIBRARY, "EDTEC_dependent_libraries");
		} else
		{
			(void)setval((INTBIG)el_curlib, VLIBRARY, "EDTEC_dependent_libraries",
				(INTBIG)liblist, VSTRING|VISARRAY|(liblistlen<<VLENGTHSH));
		}
	}
	for(i=0; i<liblistlen; i++) efree(liblist[i]);
	if (liblistlen != 0) efree((char *)liblist);
	DiaDoneDialog();
	return(0);
}

void tty_showliblist(char **liblist, INTSML liblistlen)
{
	REGISTER INTSML i;

	DiaLoadTextDialog(3, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1);
	if (liblistlen == 0)
	{
		DiaSelectLine(3, -1);
		return;
	}
	for(i=0; i<liblistlen; i++) DiaStuffLine(3, liblist[i]);
	DiaSelectLine(3, 0);
}

/*
 * special case for the "library paths" menu
 * library file location = 4 (stat text)
 */
INTSML tty_librarypathdlog(char *paramstart[])
{
	INTSML itemHit;
	char *pt;

	/* display the library paths dialog box */
	if (DiaInitDialog(&usr_librarypathdialog) != 0) return(0);
	DiaSetText(4, el_libdir);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL) break;
		if (itemHit == OK && DiaValidEntry(4)) break;
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		pt = DiaGetText(4);
		if (strcmp(pt, el_libdir) != 0) (void)reallocstring(&el_libdir, pt, db_cluster);
	}
	DiaDoneDialog();
	return(1);
}

/*
 * special case for the "help" menu
 * topics       = 4 (user item)
 * help         = 3 (user item)
 */
INTSML tty_helpdlog(char *prompt, char *paramstart[])
{
	char *filename, *line, buf[256];
	INTSML itemHit, i;
	FILE *in;

	/* get the help file */
	(void)initinfstr();
	(void)addstringtoinfstr(el_libdir);
	(void)addstringtoinfstr(prompt);
	line = returninfstr();
	in = xopen(line, FILETYPEHELP, "", &filename);
	if (in == NULL)
	{
		us_abortcommand("Cannot find help file: %s", line);
		return(0);
	}

	/* show the "help" dialog */
	if (DiaInitDialog(&usr_helpdialog) != 0)
	{
		xclose(in);
		return(0);
	}
	DiaInitTextDialog(3, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1,
		SCHORIZBAR|SCSMALLFONT|SCFIXEDWIDTH);
	DiaInitTextDialog(4, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1,
		SCSELMOUSE|SCSELKEY|SCREPORT|SCSMALLFONT);

	/* load the topics list */
	for(;;)
	{
		if (xfgets(buf, 256, in) != 0) break;
		if (buf[0] != '!') continue;
		DiaStuffLine(4, &buf[1]);
	}
	DiaSelectLine(4, -1);

	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK) break;
		if (itemHit == 4)
		{
			line = DiaGetScrollLine(4, DiaGetCurLine(4));
			xseek(in, 0, 0);
			DiaLoadTextDialog(3, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1);
			for(;;)
			{
				if (xfgets(buf, 256, in) != 0) break;
				if (buf[0] != '!') continue;
				if (strcmp(&buf[1], line) == 0) break;
			}
			for(i=0; ; i++)
			{
				if (xfgets(buf, 256, in) != 0) break;
				if (buf[0] == '!') break;
				if (buf[0] == 0 && i == 0) continue;
				DiaStuffLine(3, buf);
			}
			DiaSelectLine(3, -1);
			continue;
		}
	}
	DiaDoneDialog();
	xclose(in);
	paramstart[0] = "";
	return(1);
}

/*
 * special case for the "technology variables" menu
 * Type          =  5 (stat text)
 * Description   =  6 (stat text)
 * Current vars  =  3 (user)
 * Known vars    =  7 (user)
 * Remove        = 11 (button)
 * Copy          = 10 (button)
 * Edit Strings  = 13 (button)
 * the Value     = 12 (edit text)
 */
INTSML tty_techvarsdlog(char *paramstart[])
{
	char **varnames, *name, *cmd[5];
	INTSML itemHit, i, j;
	REGISTER VARIABLE *var, *ovar;
	TECHVAR *newvars, *tvar, *ltvar, *t;

	/* show the "technology variables" dialog */
	if (DiaInitDialog(&usr_techvarsdialog) != 0) return(0);
	DiaInitTextDialog(3, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1,
		SCSELMOUSE|SCREPORT);
	DiaInitTextDialog(7, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1,
		SCSELMOUSE|SCREPORT);

	/* load the known variables list */
	for(i=0; us_knownvars[i].varname != 0; i++) DiaStuffLine(7, us_knownvars[i].varname);
	DiaSelectLine(7, -1);

	/* see what variables are already in the list */
	var = getval((INTBIG)el_curlib, VLIBRARY, VSTRING|VISARRAY, "EDTEC_variable_list");
	newvars = NOTECHVAR;
	if (var != NOVARIABLE)
	{
		j = getlength(var);
		varnames = (char **)var->addr;
		for(i=0; i<j; i++)
		{
			ovar = getval((INTBIG)el_curlib, VLIBRARY, -1, varnames[i]);
			if (ovar == NOVARIABLE) continue;
			DiaStuffLine(3, varnames[i]);
			tvar = (TECHVAR *)emalloc(sizeof (TECHVAR), el_tempcluster);
			if (tvar == 0) break;
			(void)allocstring(&tvar->varname, varnames[i], el_tempcluster);
			tvar->nexttechvar = newvars;
			tvar->changed = 0;
			switch (ovar->type&(VTYPE|VISARRAY))
			{
				case VFLOAT:   tvar->fval = castfloat(ovar->addr);   break;
				case VINTEGER: tvar->ival = ovar->addr;              break;
				case VSTRING:
					(void)allocstring(&tvar->sval, (char *)ovar->addr, el_tempcluster);
					break;
			}
			tvar->vartype = ovar->type;
			newvars = tvar;
		}
	}
	DiaSelectLine(3, -1);

	/* set dialog allowances state */
	tty_setcurrenttechvar(newvars);
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL || itemHit == 13) break;

		/* hit in one scroll area turns off highlight in the other */
		if (itemHit == 3)
		{
			DiaSelectLine(7, -1);
			tty_setcurrenttechvar(newvars);
		}
		if (itemHit == 7)
		{
			DiaSelectLine(3, -1);
			tty_setcurrenttechvar(newvars);
		}

		/* change to the value */
		if (itemHit == 12)
		{
			i = DiaGetCurLine(3);
			if (i < 0) continue;
			name = DiaGetScrollLine(3, i);
			for(t = newvars; t != NOTECHVAR; t = t->nexttechvar)
				if (namesame(t->varname, name) == 0) break;
			if (t == NOTECHVAR) continue;
			switch (t->vartype&(VTYPE|VISARRAY))
			{
				case VINTEGER: t->ival = myatoi(DiaGetText(12));   break;
				case VFLOAT:   t->fval = atof(DiaGetText(12));     break;
				case VSTRING:
					(void)reallocstring(&t->sval, DiaGetText(12), el_tempcluster);
					break;
			}
			t->changed++;
			continue;
		}

		/* the "<< Copy" button */
		if (itemHit == 10)
		{
			i = DiaGetCurLine(7);
			if (i < 0) continue;
			name = DiaGetScrollLine(7, i);
			for(t = newvars; t != NOTECHVAR; t = t->nexttechvar)
				if (namesame(t->varname, name) == 0) break;
			if (t != NOTECHVAR) continue;

			tvar = (TECHVAR *)emalloc(sizeof (TECHVAR), el_tempcluster);
			if (tvar == 0) break;
			(void)allocstring(&tvar->varname, name, el_tempcluster);
			tvar->vartype = us_knownvars[i].vartype;
			tvar->ival = 0;
			tvar->fval = 0.0;
			if ((tvar->vartype&(VTYPE|VISARRAY)) == VSTRING)
				(void)allocstring(&tvar->sval, "", el_tempcluster);
			tvar->changed = 1;
			tvar->nexttechvar = newvars;
			newvars = tvar;
			DiaLoadTextDialog(3, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1);
			for(t = newvars; t != NOTECHVAR; t = t->nexttechvar) DiaStuffLine(3, t->varname);
			DiaSelectLine(3, -1);
			tty_setcurrenttechvar(newvars);
			continue;
		}

		/* the "Remove" button */
		if (itemHit == 11)
		{
			i = DiaGetCurLine(3);
			if (i < 0) continue;
			name = DiaGetScrollLine(3, i);

			ltvar = NOTECHVAR;
			for(t = newvars; t != NOTECHVAR; t = t->nexttechvar)
			{
				if (namesame(t->varname, name) == 0) break;
				ltvar = t;
			}
			if (t == NOTECHVAR) continue;
			if (ltvar == NOTECHVAR) newvars = t->nexttechvar; else
				ltvar->nexttechvar = t->nexttechvar;
			if ((t->vartype&(VTYPE|VISARRAY)) == VSTRING) efree(t->sval);
			efree(t->varname);
			efree((char *)t);
			DiaLoadTextDialog(3, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1);
			for(t = newvars; t != NOTECHVAR; t = t->nexttechvar) DiaStuffLine(3, t->varname);
			DiaSelectLine(3, -1);
			tty_setcurrenttechvar(newvars);
			continue;
		}
	}
	if (itemHit == 13)
	{
		i = DiaGetCurLine(3);
		if (i < 0) itemHit = OK; else
			name = DiaGetScrollLine(3, i);
	}
	DiaDoneDialog();
	if (itemHit == OK || itemHit == 13)
	{
		j = 0;
		for(t = newvars; t != NOTECHVAR; t = t->nexttechvar) j++;
		if (j > 0)
		{
			varnames = (char **)emalloc(j * (sizeof (char *)), el_tempcluster);
			if (varnames == 0) return(0);
			j = 0;
			for(t = newvars; t != NOTECHVAR; t = t->nexttechvar)
			{
				(void)allocstring(&varnames[j], t->varname, el_tempcluster);
				j++;
				if (t->changed == 0) continue;
				switch (t->vartype&(VTYPE|VISARRAY))
				{
					case VINTEGER:
						(void)setval((INTBIG)el_curlib, VLIBRARY, t->varname, t->ival, VINTEGER);
						break;
					case VFLOAT:
						(void)setval((INTBIG)el_curlib, VLIBRARY, t->varname, castint(t->fval), VFLOAT);
						break;
					case VSTRING:
						(void)setval((INTBIG)el_curlib, VLIBRARY, t->varname, (INTBIG)t->sval, VSTRING);
						break;
					case VSTRING|VISARRAY:
						cmd[0] = "EMPTY";
						(void)setval((INTBIG)el_curlib, VLIBRARY, t->varname,
							(INTBIG)cmd, VSTRING|VISARRAY|(1<<VLENGTHSH));
						break;
				}
			}
			(void)setval((INTBIG)el_curlib, VLIBRARY, "EDTEC_variable_list",
				(INTBIG)varnames, VSTRING|VISARRAY|(j<<VLENGTHSH));
			for(i=0; i<j; i++) efree(varnames[i]);
			efree((char *)varnames);
		} else
		{
			if (getval((INTBIG)el_curlib, VLIBRARY, VSTRING|VISARRAY, "EDTEC_variable_list") != NOVARIABLE)
				(void)delval((INTBIG)el_curlib, VLIBRARY, "EDTEC_variable_list");
		}
	}
	if (itemHit == 13)
	{
		cmd[0] = "textedit";
		(void)initinfstr();
		(void)addstringtoinfstr("lib:~.");
		(void)addstringtoinfstr(name);
		(void)allocstring(&cmd[1], returninfstr(), el_tempcluster);
		cmd[2] = "quiet";
		cmd[3] = "header";
		(void)initinfstr();
		(void)addstringtoinfstr("Editing technology variable: ");
		(void)addstringtoinfstr(name);
		(void)allocstring(&cmd[4], returninfstr(), el_tempcluster);
		us_var(5, cmd);
		efree(cmd[1]);
		efree(cmd[4]);
	}
	paramstart[0] = "";
	return(1);
}

void tty_setcurrenttechvar(TECHVAR *newvars)
{
	TECHVAR *t;
	INTSML i;
	char line[20], *name;

	DiaDimItem(13);      DiaSetText(12, "");   DiaNoEditControl(12);
	DiaDimItem(11);      DiaDimItem(10);
	DiaSetText(5, "");   DiaSetText(6, "");
	i = DiaGetCurLine(3);
	if (i >= 0)
	{
		DiaUnDimItem(11);
		name = DiaGetScrollLine(3, i);
		for(i=0; us_knownvars[i].varname != 0; i++)
			if (namesame(us_knownvars[i].varname, name) == 0) break;
		if (us_knownvars[i].varname != 0) DiaSetText(6, us_knownvars[i].description);
		for(t = newvars; t != NOTECHVAR; t = t->nexttechvar)
			if (namesame(t->varname, name) == 0) break;
		if (t != NOTECHVAR) switch (t->vartype&(VTYPE|VISARRAY))
		{
			case VINTEGER:
				DiaSetText(5, "Integer");
				DiaEditControl(12);
				(void)sprintf(line, "%d", t->ival);
				DiaSetText(-12, line);
				break;
			case VFLOAT:
				DiaSetText(5, "Real");
				DiaEditControl(12);
				(void)sprintf(line, "%g", t->fval);
				DiaSetText(-12, line);
				break;
			case VSTRING:
				DiaSetText(5, "String");
				DiaEditControl(12);
				DiaSetText(-12, t->sval);
				break;
			case VSTRING|VISARRAY:
				DiaSetText(5, "Strings");
				DiaUnDimItem(13);
				break;
		}
	}

	i = DiaGetCurLine(7);
	if (i >= 0)
	{
		name = DiaGetScrollLine(7, i);
		for(i=0; us_knownvars[i].varname != 0; i++)
			if (namesame(us_knownvars[i].varname, name) == 0) break;
		if (us_knownvars[i].varname != 0)
		{
			DiaSetText(6, us_knownvars[i].description);
			switch (us_knownvars[i].vartype&(VTYPE|VISARRAY))
			{
				case VINTEGER:         DiaSetText(5, "Integer");   break;
				case VFLOAT:           DiaSetText(5, "Real");      break;
				case VSTRING:          DiaSetText(5, "String");    break;
				case VSTRING|VISARRAY: DiaSetText(5, "Strings");   break;
			}
		}
		DiaUnDimItem(10);
	}
}

/*
 * special case for the "SPICE options" menu
 */
INTSML tty_simdlog(char *paramstart[])
{
#if SIMAID & SIMSPICE
	INTSML itemHit, i, level, oldplease;
	INTBIG spice_state;
	char *subparams[3], *pt;
	static char *formatnames[3] = {"Spice 2", "Spice 3", "Hspice"};
	static char *levelnames[3] = {"1", "2", "3"};
	REGISTER VARIABLE *var;
	REGISTER NODEPROTO *np;
	extern COMCOMP us_colorreadp;
#if defined(MACOS) || defined(WIN32)
# define NOEXECUTE 1
#else
	INTSML execute;
#endif

	/* Display the simulator dialog box */
	if (DiaInitDialog(&usr_spiceoptdialog) != 0) return(0);
	DiaSetPopup(4, 3, formatnames);
	DiaSetPopup(7, 3, levelnames);

	/* state of the execute flag */
#ifdef NOEXECUTE
	DiaDimItem(3);
#else
	var = getvalkey((INTBIG)sim_aid, VAID, VINTEGER, sim_dontrun);
	if (var == NOVARIABLE) execute = 1; else
	{
		if (var->addr == 0) execute = 1; else execute = 0;
	}
	DiaSetControl(3, execute);
#endif

	/* get the spice level */
	var = getvalkey((INTBIG)sim_aid, VAID, VINTEGER, sim_spice_level);
	if (var == NOVARIABLE) level = 1; else level = var->addr;
	DiaSetPopupEntry(7, (INTSML)(level-1));

	/* get miscellaneous state */
	var = getvalkey((INTBIG)sim_aid, VAID, VINTEGER, sim_spice_state);
	if (var != NOVARIABLE) spice_state = var->addr; else spice_state = 0;
	if ((spice_state&SPICENODENAMES) != 0) DiaSetControl(10, 1);
	if ((spice_state&SPICERESISTANCE) != 0) DiaSetControl(11, 1);
	switch (spice_state & SPICETYPE)
	{
		case SPICE2:      DiaSetPopupEntry(4, 0);   DiaDimItem(10);     break;
		case SPICE3:      DiaSetPopupEntry(4, 1);   DiaDimItem(10);     break;
		case SPICEHSPICE: DiaSetPopupEntry(4, 2);   DiaUnDimItem(10);   break;
	}

	/* get model and trailer cards */
	(void)initinfstr();
	(void)addstringtoinfstr("For technology: ");
	(void)addstringtoinfstr(el_curtech->techname);
	DiaSetText(20, returninfstr());
	var = getval((INTBIG)el_curtech, VTECHNOLOGY, VSTRING, "SIM_spice_model_file");
	if (var != NOVARIABLE)
	{
		DiaSetText(16, (char *)var->addr);
		DiaSetControl(15, 1);
		DiaUnDimItem(21);
	} else
	{
		DiaSetControl(14, 1);
		DiaDimItem(21);
	}
	var = getval((INTBIG)el_curtech, VTECHNOLOGY, VSTRING, "SIM_spice_trailer_file");
	if (var != NOVARIABLE)
	{
		DiaSetText(19, (char *)var->addr);
		DiaSetControl(18, 1);
		DiaUnDimItem(22);
	} else
	{
		DiaSetControl(17, 1);
		DiaDimItem(22);
	}

	/* list of facets for model description files */
	DiaInitTextDialog(23, us_topoffacets, us_nextparse, tty_nulldlogdone,
		0, SCSELMOUSE|SCSELKEY|SCREPORT);
	for(np = el_curlib->firstnodeproto; np != NONODEPROTO; np = np->nextnodeproto)
	{
		np->temp1 = 0;
		var = getval((INTBIG)np, VNODEPROTO, VSTRING, "SIM_spice_behave_file");
		if (var != NOVARIABLE)
			(void)allocstring((char **)&np->temp1, (char *)var->addr, el_tempcluster);
	}
	pt = DiaGetScrollLine(23, DiaGetCurLine(23));
	DiaSetControl(6, 1);   DiaSetControl(5, 0);
	DiaSetText(9, "");     DiaDimItem(8);
	np = getnodeproto(pt);
	if (np != NONODEPROTO)
	{
		var = getval((INTBIG)np, VNODEPROTO, VSTRING, "SIM_spice_behave_file");
		if (var != NOVARIABLE)
		{
			DiaSetControl(6, 0);   DiaSetControl(5, 1);
			DiaSetText(9, (char *)var->addr);   DiaUnDimItem(8);
		}
	}

	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;

		if (itemHit == 4)
		{
			/* file format button */
			if (DiaGetPopupEntry(4) == 2) DiaUnDimItem(10); else DiaDimItem(10);
			continue;
		}

		if (itemHit == 3 || itemHit == 10 || itemHit == 11)
		{
			/* execute deck, use node names, use parasitics */
			DiaSetControl(itemHit, (INTSML)(1-DiaGetControl(itemHit)));
			continue;
		}

		if (itemHit == 14 || itemHit == 15)
		{
			/* model cards button */
			DiaSetControl(14, 0);   DiaSetControl(15, 0);
			DiaSetControl(itemHit, 1);
			if (itemHit == 15)
			{
				DiaUnDimItem(21);   DiaUnDimItem(16);
				itemHit = 21;
			} else
			{
				DiaDimItem(21);   DiaDimItem(16);
				continue;
			}
		}
		if (itemHit == 21)
		{
			/* select model cards */
			oldplease = el_pleasestop;
			i = ttygetparam("spice/SPICE Model File", &us_colorreadp, 1, subparams);
			el_pleasestop = oldplease;
			if (i != 0 && subparams[0][0] != 0) DiaSetText(16, subparams[0]);
			if (*DiaGetText(16) == 0)
			{
				DiaSetControl(14, 1);   DiaSetControl(15, 0);
				DiaDimItem(21);         DiaDimItem(16);
			}
			continue;
		}

		if (itemHit == 17 || itemHit == 18)
		{
			/* trailer cards button */
			DiaSetControl(17, 0);   DiaSetControl(18, 0);
			DiaSetControl(itemHit, 1);
			if (itemHit == 18)
			{
				DiaUnDimItem(22);   DiaUnDimItem(19);
				itemHit = 22;
			} else
			{
				DiaDimItem(22);   DiaDimItem(19);
				continue;
			}
		}

		if (itemHit == 22)
		{
			/* select trailer cards */
			oldplease = el_pleasestop;
			i = ttygetparam("spice/SPICE Trailer File", &us_colorreadp, 1, subparams);
			el_pleasestop = oldplease;
			if (i != 0 && subparams[0][0] != 0) DiaSetText(19, subparams[0]);
			if (*DiaGetText(19) == 0)
			{
				DiaSetControl(17, 1);   DiaSetControl(18, 0);
				DiaDimItem(22);         DiaDimItem(19);
			}
			continue;
		}

		if (itemHit == 23)
		{
			/* selection of facets */
			DiaSetControl(6, 1);   DiaSetControl(5, 0);
			DiaSetText(9, "");     DiaDimItem(8);
			pt = DiaGetScrollLine(23, DiaGetCurLine(23));
			np = getnodeproto(pt);
			if (np != NONODEPROTO && np->temp1 != 0)
			{
				DiaSetControl(6, 0);   DiaSetControl(5, 1);
				DiaSetText(9, (char *)np->temp1);   DiaUnDimItem(8);
			}
			continue;
		}

		if (itemHit == 6 || itemHit == 5)
		{
			/* model for facet */
			DiaSetControl(6, 0);   DiaSetControl(5, 0);
			DiaSetControl(itemHit, 1);
			if (itemHit == 5)
			{
				DiaUnDimItem(8);   DiaUnDimItem(9);
				itemHit = 8;
			} else
			{
				DiaDimItem(8);   DiaDimItem(9);
				DiaSetText(9, "");
				pt = DiaGetScrollLine(23, DiaGetCurLine(23));
				np = getnodeproto(pt);
				if (np != NONODEPROTO)
				{
					if (np->temp1 != 0) efree((char *)np->temp1);
					np->temp1 = 0;
				}
				continue;
			}
		}

		if (itemHit == 8)
		{
			/* set model for facet */
			pt = DiaGetScrollLine(23, DiaGetCurLine(23));
			np = getnodeproto(pt);
			if (np == NONODEPROTO) continue;
			oldplease = el_pleasestop;
			i = ttygetparam("spice/Facet's Model File", &us_colorreadp, 1, subparams);
			el_pleasestop = oldplease;
			if (i != 0 && subparams[0][0] != 0)
			{
				DiaSetText(9, subparams[0]);
				if (np->temp1 != 0) efree((char *)np->temp1);
				(void)allocstring((char **)&np->temp1, subparams[0], el_tempcluster);
			} else
			{
				DiaSetControl(6, 1);   DiaSetControl(5, 0);
				DiaDimItem(8);         DiaDimItem(9);
			}
			continue;
		}
	}

	if (itemHit != CANCEL)  /* now update the values */
	{
#ifndef NOEXECUTE
		if (DiaGetControl(3) != execute)
			(void)setvalkey((INTBIG)sim_aid, VAID, sim_dontrun, execute,
				VINTEGER|VDONTSAVE);
#endif

		level = DiaGetPopupEntry(7) + 1;
		(void)setvalkey((INTBIG)sim_aid, VAID, sim_spice_level, level,
			VINTEGER|VDONTSAVE);

		if (DiaGetControl(10) != 0) spice_state |= SPICENODENAMES; else
			spice_state &= ~SPICENODENAMES;
		if (DiaGetControl(11) != 0) spice_state |= SPICERESISTANCE; else
			spice_state &= ~SPICERESISTANCE;
		switch (DiaGetPopupEntry(4))
		{
			case 0: spice_state = (spice_state & ~SPICETYPE) | SPICE2;        break;
			case 1: spice_state = (spice_state & ~SPICETYPE) | SPICE3;        break;
			case 2: spice_state = (spice_state & ~SPICETYPE) | SPICEHSPICE;   break;
		}
		(void)setvalkey((INTBIG)sim_aid, VAID, sim_spice_state, spice_state, VINTEGER|VDONTSAVE);

		if (DiaGetControl(15) != 0)
		{
			/* set model cards */
			(void)setval((INTBIG)el_curtech, VTECHNOLOGY, "SIM_spice_model_file",
				(INTBIG)DiaGetText(16), VSTRING);
		} else
		{
			/* remove model cards */
			if (getval((INTBIG)el_curtech, VTECHNOLOGY, VSTRING, "SIM_spice_model_file") != NOVARIABLE)
				(void)delval((INTBIG)el_curtech, VTECHNOLOGY, "SIM_spice_model_file");
		}

		if (DiaGetControl(18) != 0)
		{
			/* set trailer cards */
			(void)setval((INTBIG)el_curtech, VTECHNOLOGY, "SIM_spice_trailer_file",
				(INTBIG)DiaGetText(19), VSTRING);
		} else
		{
			/* remove trailer cards */
			if (getval((INTBIG)el_curtech, VTECHNOLOGY, VSTRING, "SIM_spice_trailer_file") != NOVARIABLE)
				(void)delval((INTBIG)el_curtech, VTECHNOLOGY, "SIM_spice_trailer_file");
		}
		for(np = el_curlib->firstnodeproto; np != NONODEPROTO; np = np->nextnodeproto)
		{
			var = getval((INTBIG)np, VNODEPROTO, VSTRING, "SIM_spice_behave_file");
			if (var != NOVARIABLE)
			{
				if (np->temp1 == 0)
					(void)delval((INTBIG)np, VNODEPROTO, "SIM_spice_behave_file"); else
				{
					if (strcmp((char *)np->temp1, (char *)var->addr) != 0)
						(void)setval((INTBIG)np, VNODEPROTO, "SIM_spice_behave_file", (INTBIG)np->temp1, VSTRING);
				}
			} else if (np->temp1 != 0)
				(void)setval((INTBIG)np, VNODEPROTO, "SIM_spice_behave_file", (INTBIG)np->temp1, VSTRING);
			if (np->temp1 != 0) efree((char *)np->temp1);
		}
	}
	DiaDoneDialog();
	paramstart[0] = "x";	/* passed back to menu handler */
	return(1);
#else
	ttyputerr("No simulation tool");
	return(1);
#endif
}

/*
 * special case for the "print options" menu
 * plot entire facet       = 4 (radio)
 * focus on highlighted    = 3 (radio)
 * encapsulated postscript = 5 (check box)
 * date in corner          = 6 (check box)
 * HPGL                    = 7 (radio)
 * HPGL/2                  = 8 (radio)
 * HPGL/2 plot fills page  = 9 (radio)
 * HPGL/2 plot fixed at    = 10 (radio)
 * HPGL/2 plot scale       = 11 (edit text)
 */
INTSML tty_plotoptionsdlog(char *paramstart[])
{
	INTSML itemHit, state;
	REGISTER INTBIG scale;
	REGISTER VARIABLE *var;
	char buf[50];

	/* display the print options dialog box */
	if (DiaInitDialog(&usr_printingoptdialog) != 0) return(0);
	var = getvalkey((INTBIG)io_aid, VAID, VINTEGER, io_state);
	if (var != NOVARIABLE) state = var->addr; else state = 0;
	if ((state&PLOTFOCUS) != 0) DiaSetControl(3, 1); else DiaSetControl(4, 1);
	if ((state&EPSPSCRIPT) != 0) DiaSetControl(5, 1);
	if ((state&PLOTDATES) != 0) DiaSetControl(6, 1);
	if ((state&HPGL2) != 0)
	{
		DiaSetControl(8, 1);
		DiaUnDimItem(9);   DiaUnDimItem(10);   DiaUnDimItem(12);
		DiaEditControl(11);
		var = getval((INTBIG)io_aid, VAID, VINTEGER, "IO_hpgl2_scale");
		if (var == NOVARIABLE)
		{
			DiaSetControl(9, 1);
			DiaSetText(11, "20");
		} else
		{
			DiaSetControl(10, 1);
			(void)sprintf(buf, "%d", var->addr);
			DiaSetText(11, buf);
		}
	} else
	{
		DiaSetControl(7, 1);
		DiaSetControl(9, 1);
		DiaSetText(11, "20");
		DiaDimItem(9);   DiaDimItem(10);   DiaDimItem(12);
		DiaNoEditControl(11);
	}

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK) break;
		if (itemHit == 5 || itemHit == 6)
		{
			DiaSetControl(itemHit, (INTSML)(1-DiaGetControl(itemHit)));
			continue;
		}
		if (itemHit == 3 || itemHit == 4)
		{
			DiaSetControl(3, 0);
			DiaSetControl(4, 0);
			DiaSetControl(itemHit, 1);
			continue;
		}
		if (itemHit == 7)
		{
			DiaSetControl(7, 1);   DiaSetControl(8, 0);
			DiaDimItem(9);   DiaDimItem(10);   DiaDimItem(12);
			DiaNoEditControl(11);
			continue;
		}
		if (itemHit == 8)
		{
			DiaSetControl(7, 0);   DiaSetControl(8, 1);
			DiaUnDimItem(9);   DiaUnDimItem(10);   DiaUnDimItem(12);
			DiaEditControl(11);
			continue;
		}
		if (itemHit == 9 || itemHit == 10)
		{
			DiaSetControl(9, 0);
			DiaSetControl(10, 0);
			DiaSetControl(itemHit, 1);
			continue;
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		if (DiaGetControl(3) != 0) state |= PLOTFOCUS; else state &= ~PLOTFOCUS;
		if (DiaGetControl(5) != 0) state |= EPSPSCRIPT; else state &= ~EPSPSCRIPT;
		if (DiaGetControl(6) != 0) state |= PLOTDATES; else state &= ~PLOTDATES;
		if (DiaGetControl(8) != 0) state |= HPGL2; else state &= ~HPGL2;
		(void)setvalkey((INTBIG)io_aid, VAID, io_state, state, VINTEGER|VDONTSAVE);
		if ((state&HPGL2) != 0)
		{
			if (DiaGetControl(9) != 0)
			{
				if (getval((INTBIG)io_aid, VAID, VINTEGER, "IO_hpgl2_scale") != NOVARIABLE)
					(void)delval((INTBIG)io_aid, VAID, "IO_hpgl2_scale");
			} else
			{
				scale = myatoi(DiaGetText(11));
				if (scale <= 0) scale = 1;
				(void)setval((INTBIG)io_aid, VAID, "IO_hpgl2_scale", scale, VINTEGER|VDONTSAVE);
			}
		}
	}
	DiaDoneDialog();
	return(1);
}

/*
 * routine to move dialog "dia" to a place close to object "geom" in the current window
 */
void tty_movedialogtonode(DIALOG *dia, GEOM *geom)
{
	REGISTER INTBIG x, y, wid, hei;
	INTSML swid, shei;

	if (geom == NOGEOM) return;
	if (el_curwindow == NOWINDOW) return;
	wid = dia->windowRect.right - dia->windowRect.left;
	hei = dia->windowRect.bottom - dia->windowRect.top;

	/* see which side the dialog goes on */
	x = applyxscale(el_curwindow, geom->highx-el_curwindow->screenlx) + el_curwindow->uselx;
	us_getwindowsize(el_curwindow->frame, &swid, &shei);
	if (x + wid > swid)
	{
		/* attach on left side */
		x = applyxscale(el_curwindow, geom->lowx-el_curwindow->screenlx) + el_curwindow->uselx;
		dia->windowRect.left = x - wid;   dia->windowRect.right = x;
	} else
	{
		/* attach on right side */
		dia->windowRect.left = x;   dia->windowRect.right = x + wid;
	}

	y = applyyscale(el_curwindow, geom->highy-el_curwindow->screenly) + el_curwindow->usely;
	if (shei-y-hei <= 39)
	{
		/* attach on bottom side */
		y = applyyscale(el_curwindow, geom->lowy-el_curwindow->screenly) + el_curwindow->usely;
		dia->windowRect.bottom = shei - y + hei;
		dia->windowRect.top = shei - y;
	} else
	{
		/* attach on top side */
		dia->windowRect.bottom = shei - y;
		dia->windowRect.top = shei - y - hei;
	}
}

/*
 * special case for the "resistance" menu
 * resistance value   = 3 (edit)
 * units              = 4 (popup)
 * More...            = 5 (button)
 */
INTSML tty_resistancedlog(char *prompt, char *paramstart[], char *initial)
{
	INTSML itemHit, i;
	static char *resnames[] = {"Ohms", "Kilo-ohms", "Mega-ohms", "Giga-Ohms"};
	REGISTER HIGHLIGHT *high;
	char line[70];

	/* if an initial value is given, search for highlighted node and move dialog to it */
	if (initial != 0)
	{
		high = us_getonehighlight();
		if (high != NOHIGHLIGHT) tty_movedialogtonode(&usr_resistancedialog, high->fromgeom);
	}

	/* display the resistance dialog box */
	if (namesame(prompt, "ccvs") == 0) (void)strcpy(line, "CCVS transresistance"); else
		(void)sprintf(line, "%s resistance", prompt);
	usr_resistancedialog.movable = line;
	if (initial != 0) usr_resistancedialog.items = 5; else usr_resistancedialog.items = 4;
	if (DiaInitDialog(&usr_resistancedialog) != 0) return(0);
	DiaSetPopup(4, 4, resnames);
	if (initial == 0) DiaSetText(3, "100"); else
	{
		i = strlen(initial);
		if (i > 0 && namesame(&initial[i-1], "K") == 0)
		{
			DiaSetPopupEntry(4, 1);
			initial[i-1] = 0;
			DiaSetText(3, initial);
			initial[i-1] = 'K';
		} else if (i > 2 && namesame(&initial[i-3], "MEG") == 0)
		{
			DiaSetPopupEntry(4, 2);
			initial[i-3] = 0;
			DiaSetText(3, initial);
			initial[i-3] = 'M';
		} else if (i > 0 && namesame(&initial[i-1], "G") == 0)
		{
			DiaSetPopupEntry(4, 3);
			initial[i-1] = 0;
			DiaSetText(3, initial);
			initial[i-1] = 'G';
		} else DiaSetText(3, initial);
	}

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK || itemHit == 5) break;
	}

	(void)initinfstr();
	(void)addstringtoinfstr(DiaGetText(3));
	i = DiaGetPopupEntry(4);
	switch (i)
	{
		case 1: (void)addstringtoinfstr("K");     break;
		case 2: (void)addstringtoinfstr("MEG");   break;
		case 3: (void)addstringtoinfstr("G");     break;
	}
	paramstart[0] = returninfstr();
	DiaDoneDialog();
	if (itemHit == OK) return(1);
	if (itemHit == 5) (void)tty_showdlog(paramstart, 0);
	return(0);
}

/*
 * special case for the "capacitance" menu
 * capacitance value   = 3 (edit)
 * units               = 4 (popup)
 * More...             = 5 (button)
 */
INTSML tty_capacitancedlog(char *paramstart[], char *initial)
{
	INTSML itemHit, i;
	static char *capnames[] = {"Femto-farads", "Pico-farads", "Micro-farads", "Milli-farads",
		"Farads"};
	REGISTER HIGHLIGHT *high;

	/* if an initial value is given, search for highlighted node and move dialog to it */
	if (initial != 0)
	{
		high = us_getonehighlight();
		if (high != NOHIGHLIGHT) tty_movedialogtonode(&usr_capacitancedialog, high->fromgeom);
	}

	/* display the capacitance dialog box */
	if (initial != 0) usr_capacitancedialog.items = 5; else usr_capacitancedialog.items = 4;
	if (DiaInitDialog(&usr_capacitancedialog) != 0) return(0);
	DiaSetPopup(4, 5, capnames);
	if (initial == 0)
	{
		DiaSetText(3, "100");
		DiaSetPopupEntry(4, 3);
	} else
	{
		i = strlen(initial);
		if (i > 0 && namesame(&initial[i-1], "F") == 0)
		{
			initial[i-1] = 0;
			DiaSetText(3, initial);
			initial[i-1] = 'F';
		} else if (i > 0 && namesame(&initial[i-1], "P") == 0)
		{
			DiaSetPopupEntry(4, 1);
			initial[i-3] = 0;
			DiaSetText(3, initial);
			initial[i-3] = 'P';
		} else if (i > 0 && namesame(&initial[i-1], "U") == 0)
		{
			DiaSetPopupEntry(4, 2);
			initial[i-1] = 0;
			DiaSetText(3, initial);
			initial[i-1] = 'U';
		} else if (i > 0 && namesame(&initial[i-1], "M") == 0)
		{
			DiaSetPopupEntry(4, 3);
			initial[i-1] = 0;
			DiaSetText(3, initial);
			initial[i-1] = 'M';
		} else
		{
			DiaSetPopupEntry(4, 4);
			DiaSetText(3, initial);
		}
	}

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK || itemHit == 5) break;
	}

	(void)initinfstr();
	(void)addstringtoinfstr(DiaGetText(3));
	i = DiaGetPopupEntry(4);
	switch (i)
	{
		case 0: (void)addstringtoinfstr("F");   break;
		case 1: (void)addstringtoinfstr("P");   break;
		case 2: (void)addstringtoinfstr("U");   break;
		case 3: (void)addstringtoinfstr("M");   break;
	}
	paramstart[0] = returninfstr();
	DiaDoneDialog();
	if (itemHit == OK) return(1);
	if (itemHit == 5) (void)tty_showdlog(paramstart, 0);
	return(0);
}

/*
 * special case for the "inductance" menu
 * inductance value   = 3 (edit)
 * units              = 4 (popup)
 * More...            = 5 (button)
 */
INTSML tty_inductancedlog(char *paramstart[], char *initial)
{
	INTSML itemHit, i;
	static char *indnames[] = {"Micro-henrys", "Milli-henrys", "Henrys"};
	REGISTER HIGHLIGHT *high;

	/* if an initial value is given, search for highlighted node and move dialog to it */
	if (initial != 0)
	{
		high = us_getonehighlight();
		if (high != NOHIGHLIGHT) tty_movedialogtonode(&usr_inductancedialog, high->fromgeom);
	}

	/* display the inductance dialog box */
	if (initial != 0) usr_inductancedialog.items = 5; else usr_inductancedialog.items = 4;
	if (DiaInitDialog(&usr_inductancedialog) != 0) return(0);
	DiaSetPopup(4, 3, indnames);
	if (initial == 0)
	{
		DiaSetText(3, "100");
		DiaSetPopupEntry(4, 2);
	} else
	{
		i = strlen(initial);
		if (i > 0 && namesame(&initial[i-1], "U") == 0)
		{
			initial[i-1] = 0;
			DiaSetText(3, initial);
			initial[i-1] = 'U';
		} else if (i > 0 && namesame(&initial[i-1], "M") == 0)
		{
			DiaSetPopupEntry(4, 1);
			initial[i-1] = 0;
			DiaSetText(3, initial);
			initial[i-1] = 'M';
		} else
		{
			DiaSetPopupEntry(4, 2);
			DiaSetText(3, initial);
		}
	}

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK || itemHit == 5) break;
	}

	(void)initinfstr();
	(void)addstringtoinfstr(DiaGetText(3));
	i = DiaGetPopupEntry(4);
	switch (i)
	{
		case 0: (void)addstringtoinfstr("U");   break;
		case 1: (void)addstringtoinfstr("M");   break;
	}
	paramstart[0] = returninfstr();
	DiaDoneDialog();
	if (itemHit == OK) return(1);
	if (itemHit == 5) (void)tty_showdlog(paramstart, 0);
	return(0);
}

/*
 * special case for the "VCCS Transconductance" menu
 * siemens value       = 3 (edit)
 * units               = 4 (popup)
 * More...             = 5 (button)
 */
INTSML tty_vccsdlog(char *paramstart[], char *initial)
{
	INTSML itemHit, i;
	static char *sienames[] = {"Micro-siemens", "Milli-siemens", "Siemens"};
	REGISTER HIGHLIGHT *high;

	/* if an initial value is given, search for highlighted node and move dialog to it */
	if (initial != 0)
	{
		high = us_getonehighlight();
		if (high != NOHIGHLIGHT) tty_movedialogtonode(&usr_vccsdialog, high->fromgeom);
	}

	/* display the siemens dialog box */
	if (initial != 0) usr_vccsdialog.items = 5; else usr_vccsdialog.items = 4;
	if (DiaInitDialog(&usr_vccsdialog) != 0) return(0);
	DiaSetPopup(4, 3, sienames);
	if (initial == 0)
	{
		DiaSetText(3, "100");
		DiaSetPopupEntry(4, 2);
	} else
	{
		i = strlen(initial);
		if (i > 0 && namesame(&initial[i-1], "U") == 0)
		{
			initial[i-1] = 0;
			DiaSetText(3, initial);
			initial[i-1] = 'U';
		} else if (i > 0 && namesame(&initial[i-1], "M") == 0)
		{
			DiaSetPopupEntry(4, 1);
			initial[i-1] = 0;
			DiaSetText(3, initial);
			initial[i-1] = 'M';
		} else
		{
			DiaSetPopupEntry(4, 2);
			DiaSetText(3, initial);
		}
	}

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK || itemHit == 5) break;
	}

	(void)initinfstr();
	(void)addstringtoinfstr(DiaGetText(3));
	i = DiaGetPopupEntry(4);
	switch (i)
	{
		case 0: (void)addstringtoinfstr("U");   break;
		case 1: (void)addstringtoinfstr("M");   break;
	}
	paramstart[0] = returninfstr();
	DiaDoneDialog();
	if (itemHit == OK) return(1);
	if (itemHit == 5) (void)tty_showdlog(paramstart, 0);
	return(0);
}

/*
 * special case for the "area" menu
 * area value           = 3 (edit)
 * units                = 4 (popup)
 * More...              = 5 (button)
 */
INTSML tty_areadlog(char *prompt, char *paramstart[], char *initial)
{
	INTSML itemHit, i;
	REGISTER INTBIG area;
	static char line[50];
	static char *areanames[] = {"Square centimicrons", "Square microns", "Square mils"};
	REGISTER HIGHLIGHT *high;

	/* if an initial value is given, search for highlighted node and move dialog to it */
	if (initial != 0)
	{
		high = us_getonehighlight();
		if (high != NOHIGHLIGHT) tty_movedialogtonode(&usr_areadialog, high->fromgeom);
	}

	/* display the area dialog box */
	(void)sprintf(line, "%s area", prompt);
	usr_areadialog.movable = line;
	if (initial != 0) usr_areadialog.items = 5; else usr_areadialog.items = 4;
	if (DiaInitDialog(&usr_areadialog) != 0) return(0);
	DiaSetPopup(4, 3, areanames);
	if (initial == 0) DiaSetText(3, "10"); else
	{
		area = myatoi(initial);
		if (area / 1000000 * 1000000 == area)
		{
			DiaSetPopupEntry(4, 2);
			(void)sprintf(line, "%d", area / 1000000);
			DiaSetText(3, line);
		} else if (area / 10000 * 10000 == area)
		{
			DiaSetPopupEntry(4, 1);
			(void)sprintf(line, "%d", area / 10000);
			DiaSetText(3, line);
		} else DiaSetText(3, initial);
	}

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK || itemHit == 5) break;
	}

	area = myatoi(DiaGetText(3));
	i = DiaGetPopupEntry(4);
	switch (i)
	{
		case 1: area *= 10000;     break;
		case 2: area *= 1000000;   break;
	}
	(void)sprintf(line, "%d", area);
	paramstart[0] = line;
	DiaDoneDialog();
	if (itemHit == OK) return(1);
	if (itemHit == 5) (void)tty_showdlog(paramstart, 0);
	return(0);
}

/*
 * special case for the "gain" menu
 * area value           = 3 (edit)
 * units                = 4 (popup)
 * More...              = 5 (button)
 */
INTSML tty_gaindlog(char *prompt, char *paramstart[], char *initial)
{
	INTSML itemHit;
	static char line[50];
	REGISTER HIGHLIGHT *high;

	/* if an initial value is given, search for highlighted node and move dialog to it */
	if (initial != 0)
	{
		high = us_getonehighlight();
		if (high != NOHIGHLIGHT) tty_movedialogtonode(&usr_gaindialog, high->fromgeom);
	}

	/* display the area dialog box */
	(void)sprintf(line, "%s gain", prompt);
	usr_gaindialog.movable = line;
	if (initial != 0) usr_gaindialog.items = 5; else usr_gaindialog.items = 4;
	if (DiaInitDialog(&usr_gaindialog) != 0) return(0);
	if (initial == 0) DiaSetText(3, "10"); else DiaSetText(3, initial);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK || itemHit == 5) break;
	}

	paramstart[0] = us_putintoinfstr(DiaGetText(3));
	DiaDoneDialog();
	if (itemHit == OK) return(1);
	if (itemHit == 5) (void)tty_showdlog(paramstart, 0);
	return(0);
}

/*
 * special case for the "width/length" menu
 * width value      = 3 (edit)
 * length value     = 6 (edit)
 * units            = 4 (popup)
 * More...          = 8 (button)
 */
INTSML tty_widlendlog(char *paramstart[], char *initial)
{
	INTSML itemHit, i;
	REGISTER INTBIG length, width;
	REGISTER char *pt;
	static char line[60];
	static char *lennames[] = {"Microns", "Centimicrons", "Mils"};
	REGISTER HIGHLIGHT *high;

	/* if an initial value is given, search for highlighted node and move dialog to it */
	if (initial != 0)
	{
		high = us_getonehighlight();
		if (high != NOHIGHLIGHT) tty_movedialogtonode(&usr_widlendialog, high->fromgeom);
	}

	/* display the width/length dialog box */
	if (initial != 0) usr_widlendialog.items = 8; else usr_widlendialog.items = 7;
	if (DiaInitDialog(&usr_widlendialog) != 0) return(0);
	DiaSetPopup(4, 3, lennames);
	if (initial == 0)
	{
		DiaSetText(3, "2");
		DiaSetText(6, "2");
		DiaSetPopupEntry(4, 1);
	} else
	{
		width = myatoi(initial);
		for(pt = initial; *pt != 0 && *pt != '/'; pt++) ;
		if (*pt == '/') length = myatoi(&pt[1]); else length = width;
		if (width / 1000 * 1000 == width && length / 1000 * 1000 == length)
		{
			DiaSetPopupEntry(4, 2);
			(void)sprintf(line, "%d", width / 1000);
			DiaSetText(3, line);
			(void)sprintf(line, "%d", length / 1000);
			DiaSetText(6, line);
		} else if (width / 100 * 100 == width && length / 100 * 100 == length)
		{
			(void)sprintf(line, "%d", width / 100);
			DiaSetText(3, line);
			(void)sprintf(line, "%d", length / 100);
			DiaSetText(6, line);
		} else
		{
			DiaSetPopupEntry(4, 1);
			(void)sprintf(line, "%d", width);
			DiaSetText(3, line);
			(void)sprintf(line, "%d", length);
			DiaSetText(6, line);
		}
	}

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK || itemHit == 8) break;
	}

	width = myatoi(DiaGetText(3));
	length = myatoi(DiaGetText(6));
	i = DiaGetPopupEntry(4);
	switch (i)
	{
		case 0: width *= 100;    length *= 100;    break;
		case 2: width *= 1000;   length *= 1000;   break;
	}
	(void)sprintf(line, "%d/%d", width, length);
	paramstart[0] = line;
	DiaDoneDialog();
	if (itemHit == OK) return(1);
	if (itemHit == 8) (void)tty_showdlog(paramstart, 0);
	return(0);
}

/*
 * special case for the "Window View" dialog
 * restore view     = 1 (button)
 * save view        = 5 (button)
 * view list        = 3 (scroll)
 * new view name    = 4 (edit text)
 */
INTSML tty_windowviewdlog(char *paramstart[])
{
	INTSML itemHit, i;
	REGISTER VARIABLE *var;
	char *par[3], *pt;

	/* display the window view dialog box */
	if (DiaInitDialog(&usr_windowviewdialog) != 0) return(0);
	DiaInitTextDialog(3, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, 0,
		SCSELMOUSE | SCSELKEY | SCDOUBLEQUIT);
	for(i=0; i<us_aid->numvar; i++)
	{
		var = &us_aid->firstvar[i];
		pt = makename(var->key);
		if (namesamen(pt, "USER_windowview_", 16) == 0) DiaStuffLine(3, &pt[16]);
	}
	DiaSelectLine(3, -1);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL) break;
		if (itemHit == 1)
		{
			/* restore selected view */
			par[0] = "name";
			i = DiaGetCurLine(3);
			if (i < 0) continue;
			pt = DiaGetScrollLine(3, i);
			par[1] = pt;
			us_window(2, par);
			break;
		}

		if (itemHit == 5)
		{
			/* save selected view */
			if (DiaValidEntry(4) == 0) continue;
			par[0] = "save";
			par[1] = DiaGetText(4);
			us_window(2, par);
			DiaLoadTextDialog(12, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1);
			for(i=0; i<us_aid->numvar; i++)
			{
				var = &us_aid->firstvar[i];
				pt = makename(var->key);
				if (namesamen(pt, "USER_windowview_", 16) == 0) DiaStuffLine(3, &pt[16]);
			}
			DiaSelectLine(3, -1);
			continue;
		}
	}

	DiaDoneDialog();
	return(0);
}

/*
 * special case for the "Create To" dialog
 * X coordinate     = 3 (edit text)
 * Y coordinate     = 5 (edit text)
 */
INTSML tty_createtodlog(char *paramstart[])
{
	INTSML itemHit;
	INTBIG x, y;

	/* determine default location (use snap point if there is one) */
	if (us_getonesnappoint(&x, &y) == 0) x = y = 0;

	/* get coordinates from dialog */
	if (DiaInitDialog(&usr_createtodialog) != 0) return(0);
	DiaSetText(3, latoa(x));
	DiaSetText(5, latoa(y));
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK) break;
	}
	paramstart[0] = us_putintoinfstr(DiaGetText(3));
	paramstart[1] = us_putintoinfstr(DiaGetText(5));
	DiaDoneDialog();
	if (itemHit == CANCEL) return(0);
	return(2);
}

/*
 * special case for the "Port Display" dialog
 * Full Port Names     = 3 (button)
 * Short Port Names    = 4 (button)
 * Ports as Crosses    = 5 (button)
 * No Ports Shown      = 6 (button)
 */
INTSML tty_portdisplaydlog(char *paramstart[])
{
	INTSML itemHit;
	INTBIG labels;
	WINDOW *w;

	/* get coordinates from dialog */
	if (us_needwindow()) return(0);
	if (DiaInitDialog(&usr_portdisplaydialog) != 0) return(0);
	switch (el_curwindow->state&PORTLABELS)
	{
		case PORTSFULL:  DiaSetControl(3, 1);   break;
		case PORTSSHORT: DiaSetControl(4, 1);   break;
		case PORTSCROSS: DiaSetControl(5, 1);   break;
		case PORTSOFF:   DiaSetControl(6, 1);   break;
	}
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK) break;
		if (itemHit == 3 || itemHit == 4 || itemHit == 5 || itemHit == 6)
		{
			DiaSetControl(3, 0);
			DiaSetControl(4, 0);
			DiaSetControl(5, 0);
			DiaSetControl(6, 0);
			DiaSetControl(itemHit, 1);
			continue;
		}
	}
	if (DiaGetControl(3) != 0) labels = PORTSFULL; else
		if (DiaGetControl(4) != 0) labels = PORTSSHORT; else
			if (DiaGetControl(5) != 0) labels = PORTSCROSS; else
				labels = PORTSOFF;
	DiaDoneDialog();
	if (itemHit == OK)
	{
		us_pushhighlight();
		us_clearhighlightcount();
		for(w = el_topwindow; w != NOWINDOW; w = w->nextwindow)
		{
			startobjectchange((INTBIG)w, VWINDOW);
			w->state = (w->state & ~PORTLABELS) | labels;
			if (w->redisphandler != 0) (*w->redisphandler)(w);
			endobjectchange((INTBIG)w, VWINDOW);
		}
		(void)us_pophighlight(0);
	}
	return(0);
}
