/*
 * Electric(tm) VLSI Design System
 *
 * File: usrdiacom2.c
 * Special command dialogs, part 2
 * Written by: Steven M. Rubin, Electric Editor Incorporated
 *
 * Copyright (c) 1998 Electric Editor Incorporated.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Electric Editor Incorporated
 * 23470 Sunset Drive, Suite 108
 * Los Gatos, California 95033
 * support@electriceditor.com
 */

#include "global.h"
#include "egraphics.h"
#include "usr.h"
#include "usrdiacom.h"
#include "database.h"
#include "efunction.h"
#include "usredtec.h"
#include "edialogs.h"
#include "tecgen.h"
#include "tecart.h"
#include "tecschem.h"

struct butlist
{
	INTBIG value;  INTSML button;
};

/* icons for text and port dialogs */
unsigned char usr_icon200[] =
{
	0377, 0377, 0377, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 040, 0, 0200, 0200, 060, 0, 0200, 0203, 0370, 0, 0200,
	0200, 060, 0, 0200, 0200, 040, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0377, 0377, 0377, 0200, 0, 0, 0, 0,
	0377, 0377, 0377, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 010, 0, 0200, 0200, 010, 0, 0200,
	0200, 010, 0, 0200, 0200, 010, 0, 0200, 0200, 076, 0, 0200, 0200, 034, 0, 0200,
	0200, 010, 0, 0200, 0200, 0, 0, 0200, 0377, 0377, 0377, 0200, 0, 0, 0, 0
};
unsigned char usr_icon201[] =
{
	0377, 0377, 0377, 0200, 0200, 0, 0, 0200, 0200, 010, 0, 0200, 0200, 034, 0, 0200,
	0200, 076, 0, 0200, 0200, 010, 0, 0200, 0200, 010, 0, 0200, 0200, 010, 0, 0200,
	0200, 010, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0377, 0377, 0377, 0200, 0, 0, 0, 0,
	0377, 0377, 0377, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 010, 0200, 0200, 0, 014, 0200, 0200, 0, 0376, 0200,
	0200, 0, 014, 0200, 0200, 0, 010, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0377, 0377, 0377, 0200, 0, 0, 0, 0
};
unsigned char usr_icon202[] =
{
	0377, 0377, 0377, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0210, 0, 0, 0200, 0230, 0, 0, 0200, 0277, 0200, 0, 0200,
	0230, 0, 0, 0200, 0210, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0377, 0377, 0377, 0200, 0, 0, 0, 0,
	0377, 0377, 0377, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0100, 0200,
	0200, 0, 040, 0200, 0200, 0, 022, 0200, 0200, 0, 016, 0200, 0200, 0, 016, 0200,
	0200, 0, 036, 0200, 0200, 0, 0, 0200, 0377, 0377, 0377, 0200, 0, 0, 0, 0
};
unsigned char usr_icon203[] =
{
	0377, 0377, 0377, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0201, 0, 0, 0200,
	0202, 0, 0, 0200, 0244, 0, 0, 0200, 0270, 0, 0, 0200, 0270, 0, 0, 0200,
	0274, 0, 0, 0200, 0200, 0, 0, 0200, 0377, 0377, 0377, 0200, 0, 0, 0, 0,
	0377, 0377, 0377, 0200, 0200, 0, 0, 0200, 0200, 0, 036, 0200, 0200, 0, 016, 0200,
	0200, 0, 016, 0200, 0200, 0, 022, 0200, 0200, 0, 040, 0200, 0200, 0, 0100, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0377, 0377, 0377, 0200, 0, 0, 0, 0
};
unsigned char usr_icon204[] =
{
	0377, 0377, 0377, 0200, 0200, 0, 0, 0200, 0274, 0, 0, 0200, 0270, 0, 0, 0200,
	0270, 0, 0, 0200, 0244, 0, 0, 0200, 0202, 0, 0, 0200, 0201, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200, 0200, 0, 0, 0200,
	0200, 0, 0, 0200, 0200, 0, 0, 0200, 0377, 0377, 0377, 0200, 0, 0, 0, 0,
	0377, 0377, 0377, 0200, 0200, 0, 0, 0200, 0200, 010, 0, 0200, 0200, 034, 0, 0200,
	0200, 076, 0, 0200, 0210, 010, 010, 0200, 0230, 010, 014, 0200, 0277, 0200, 0376, 0200,
	0230, 010, 014, 0200, 0210, 010, 010, 0200, 0200, 076, 0, 0200, 0200, 034, 0, 0200,
	0200, 010, 0, 0200, 0200, 0, 0, 0200, 0377, 0377, 0377, 0200, 0, 0, 0, 0
};

/* Quit */
DIALOGITEM usr_quitdialogitems[] =
{
 /*  1 */ {0, {101,16,125,80}, BUTTON, "Yes"},
 /*  2 */ {0, {136,136,160,192}, BUTTON, "Cancel"},
 /*  3 */ {0, {136,16,160,80}, BUTTON, "No"},
 /*  4 */ {0, {8,16,90,208}, MESSAGE, ""}
};
DIALOG usr_quitdialog = {{50,75,224,315}, 0, 4, usr_quitdialogitems};

/* Spread */
DIALOGITEM usr_spreaddialogitems[] =
{
 /*  1 */ {0, {96,128,120,200}, BUTTON, "OK"},
 /*  2 */ {0, {96,16,120,88}, BUTTON, "Cancel"},
 /*  3 */ {0, {55,15,71,205}, EDITTEXT, ""},
 /*  4 */ {0, {20,230,40,380}, RADIO, "Spread up"},
 /*  5 */ {0, {45,230,66,380}, RADIO, "Spread down"},
 /*  6 */ {0, {70,230,90,380}, RADIO, "Spread left"},
 /*  7 */ {0, {95,230,115,380}, RADIO, "Spread right"},
 /*  8 */ {0, {25,15,41,180}, MESSAGE, "Distance to spread"}
};
DIALOG usr_spreaddialog = {{50,75,188,451}, "Spread About Highlighted", 8, usr_spreaddialogitems};

/* Units */
DIALOGITEM usr_unitsdialogitems[] =
{
 /*  1 */ {0, {84,212,108,284}, BUTTON, "OK"},
 /*  2 */ {0, {88,24,112,96}, BUTTON, "Cancel"},
 /*  3 */ {0, {32,228,48,303}, EDITTEXT, ""},
 /*  4 */ {0, {32,8,48,224}, MESSAGE, "Internal units per Lambda unit:"},
 /*  5 */ {0, {8,116,24,276}, POPUP, "Lambda units"},
 /*  6 */ {0, {8,8,24,103}, MESSAGE, "Display Units:"},
 /*  7 */ {0, {56,116,72,276}, POPUP, "Half-millimicrons"},
 /*  8 */ {0, {56,8,72,112}, MESSAGE, "Internal Units:"}
};
DIALOG usr_unitsdialog = {{50,75,170,388}, "Change Units", 8, usr_unitsdialogitems};

/* Change */
DIALOGITEM usr_changedialogitems[] =
{
 /*  1 */ {0, {144,344,168,416}, BUTTON, "OK"},
 /*  2 */ {0, {144,248,168,320}, BUTTON, "Cancel"},
 /*  3 */ {0, {16,240,36,430}, RADIO, "Change this one only"},
 /*  4 */ {0, {56,240,76,430}, RADIO, "Change all in this facet"},
 /*  5 */ {0, {96,240,116,430}, RADIO, "Change all in this library"},
 /*  6 */ {0, {8,16,168,231}, SCROLL, ""}
};
DIALOG usr_changedialog = {{50,75,228,509}, "Change Type of Highlight", 6, usr_changedialogitems};

/* Node info */
DIALOGITEM usr_shownodedialogitems[] =
{
 /*  1 */ {0, {352,288,376,360}, BUTTON, "OK"},
 /*  2 */ {0, {352,32,376,104}, BUTTON, "Cancel"},
 /*  3 */ {0, {216,8,344,392}, SCROLL, ""},
 /*  4 */ {0, {152,88,168,184}, RADIO, "Expanded"},
 /*  5 */ {0, {152,192,168,296}, RADIO, "Unexpanded"},
 /*  6 */ {0, {8,64,24,384}, MESSAGE, ""},
 /*  7 */ {0, {32,64,48,376}, EDITTEXT, ""},
 /*  8 */ {0, {56,80,72,165}, EDITTEXT, ""},
 /*  9 */ {0, {80,80,96,165}, EDITTEXT, ""},
 /* 10 */ {0, {104,80,120,128}, EDITTEXT, ""},
 /* 11 */ {0, {104,136,120,246}, CHECK, "Transposed"},
 /* 12 */ {0, {56,296,72,384}, EDITTEXT, ""},
 /* 13 */ {0, {80,296,96,384}, EDITTEXT, ""},
 /* 14 */ {0, {8,8,24,56}, MESSAGE, "Type:"},
 /* 15 */ {0, {32,8,48,56}, MESSAGE, "Name:"},
 /* 16 */ {0, {56,8,72,72}, MESSAGE, "X size:"},
 /* 17 */ {0, {80,8,96,72}, MESSAGE, "Y size:"},
 /* 18 */ {0, {104,8,120,72}, MESSAGE, "Rotation:"},
 /* 19 */ {0, {56,208,72,288}, MESSAGE, "X position:"},
 /* 20 */ {0, {80,208,96,288}, MESSAGE, "Y position:"},
 /* 21 */ {0, {200,136,216,232}, MESSAGE, "Connections:"},
 /* 22 */ {0, {176,184,192,392}, MESSAGE, ""},
 /* 23 */ {0, {128,8,144,160}, MESSAGE, ""},
 /* 24 */ {0, {128,160,144,384}, MESSAGE, ""},
 /* 25 */ {0, {176,8,192,180}, MESSAGE, ""}
};
DIALOG usr_shownodedialog = {{50,75,435,484}, "Node Information", 25, usr_shownodedialogitems};

/* Arc info */
DIALOGITEM usr_showarcdialogitems[] =
{
 /*  1 */ {0, {144,320,168,392}, BUTTON, "OK"},
 /*  2 */ {0, {104,320,128,392}, BUTTON, "Cancel"},
 /*  3 */ {0, {184,312,200,392}, CHECK, "Rigid"},
 /*  4 */ {0, {216,312,232,408}, CHECK, "Fixed-angle"},
 /*  5 */ {0, {8,80,24,385}, MESSAGE, ""},
 /*  6 */ {0, {32,88,48,393}, MESSAGE, ""},
 /*  7 */ {0, {56,88,72,393}, EDITTEXT, ""},
 /*  8 */ {0, {104,88,120,173}, MESSAGE, ""},
 /*  9 */ {0, {128,88,144,255}, MESSAGE, ""},
 /* 10 */ {0, {80,280,96,365}, MESSAGE, ""},
 /* 11 */ {0, {152,88,168,255}, MESSAGE, ""},
 /* 12 */ {0, {8,16,24,80}, MESSAGE, "Type:"},
 /* 13 */ {0, {32,16,48,80}, MESSAGE, "Network:"},
 /* 14 */ {0, {80,16,96,80}, MESSAGE, "Width:"},
 /* 15 */ {0, {104,16,120,80}, MESSAGE, "Angle:"},
 /* 16 */ {0, {128,16,144,80}, MESSAGE, "Head:"},
 /* 17 */ {0, {80,216,96,280}, MESSAGE, "Bus size:"},
 /* 18 */ {0, {152,16,168,80}, MESSAGE, "Tail:"},
 /* 19 */ {0, {232,312,248,408}, CHECK, "Slidable"},
 /* 20 */ {0, {200,16,216,112}, CHECK, "Negated"},
 /* 21 */ {0, {216,16,232,112}, CHECK, "Directional"},
 /* 22 */ {0, {232,16,248,120}, CHECK, "Ends extend"},
 /* 23 */ {0, {200,136,216,240}, CHECK, "Ignore head"},
 /* 24 */ {0, {216,136,232,232}, CHECK, "Ignore tail"},
 /* 25 */ {0, {232,136,248,304}, CHECK, "Reverse head and tail"},
 /* 26 */ {0, {200,328,216,424}, CHECK, "Temporary"},
 /* 27 */ {0, {80,88,96,173}, EDITTEXT, ""},
 /* 28 */ {0, {56,16,72,72}, MESSAGE, "Name:"},
 /* 29 */ {0, {176,16,192,240}, MESSAGE, ""}
};
DIALOG usr_showarcdialog = {{50,75,304,498}, "Arc Information", 29, usr_showarcdialogitems};

/* Text info */
DIALOGITEM usr_showtextdialogitems[] =
{
 /*  1 */ {0, {200,248,224,320}, BUTTON, "OK"},
 /*  2 */ {0, {200,160,224,232}, BUTTON, "Cancel"},
 /*  3 */ {0, {144,8,160,64}, RADIO, "Left"},
 /*  4 */ {0, {40,16,56,332}, EDITTEXT, ""},
 /*  5 */ {0, {72,232,88,340}, POPUP, "Small"},
 /*  6 */ {0, {80,8,96,80}, RADIO, "Center"},
 /*  7 */ {0, {96,8,112,80}, RADIO, "Bottom"},
 /*  8 */ {0, {112,8,128,64}, RADIO, "Top"},
 /*  9 */ {0, {128,8,144,72}, RADIO, "Right"},
 /* 10 */ {0, {160,8,176,104}, RADIO, "Lower right"},
 /* 11 */ {0, {176,8,192,104}, RADIO, "Lower left"},
 /* 12 */ {0, {192,8,208,104}, RADIO, "Upper right"},
 /* 13 */ {0, {208,8,224,96}, RADIO, "Upper left"},
 /* 14 */ {0, {224,8,240,80}, RADIO, "Boxed"},
 /* 15 */ {0, {72,152,88,231}, MESSAGE, "Text size:"},
 /* 16 */ {0, {64,16,80,110}, MESSAGE, "Text corner:"},
 /* 17 */ {0, {104,224,120,304}, EDITTEXT, ""},
 /* 18 */ {0, {128,224,144,304}, EDITTEXT, ""},
 /* 19 */ {0, {104,152,120,217}, MESSAGE, "X offset:"},
 /* 20 */ {0, {128,152,144,217}, MESSAGE, "Y offset:"},
 /* 21 */ {0, {80,112,112,144}, ICON, (char *)usr_icon200},
 /* 22 */ {0, {112,112,144,144}, ICON, (char *)usr_icon201},
 /* 23 */ {0, {144,112,176,144}, ICON, (char *)usr_icon202},
 /* 24 */ {0, {176,112,208,144}, ICON, (char *)usr_icon203},
 /* 25 */ {0, {208,112,240,144}, ICON, (char *)usr_icon204},
 /* 26 */ {0, {8,16,24,340}, MESSAGE, ""}
};
DIALOG usr_showtextdialog = {{50,75,304,418}, "Information on Highlighted Text", 26, usr_showtextdialogitems};

/* Grid settings */
DIALOGITEM usr_griddialogitems[] =
{
 /*  1 */ {0, {48,328,72,392}, BUTTON, "OK"},
 /*  2 */ {0, {8,328,32,392}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,208,24,288}, EDITTEXT, ""},
 /*  4 */ {0, {88,8,104,205}, MESSAGE, "Alignment of cursor to grid:"},
 /*  5 */ {0, {120,8,136,205}, MESSAGE, "Alignment of edges to grid:"},
 /*  6 */ {0, {32,208,48,288}, EDITTEXT, ""},
 /*  7 */ {0, {8,8,24,205}, MESSAGE, "Horizontal grid dot spacing:"},
 /*  8 */ {0, {32,8,48,205}, MESSAGE, "Vertical grid dot spacing:"},
 /*  9 */ {0, {88,208,104,280}, EDITTEXT, ""},
 /* 10 */ {0, {120,208,136,280}, EDITTEXT, ""},
 /* 11 */ {0, {96,288,112,430}, MESSAGE, "Values of zero will"},
 /* 12 */ {0, {112,288,128,432}, MESSAGE, "cause no alignment."}
};
DIALOG usr_griddialog = {{50,75,198,507}, "Grid Settings", 12, usr_griddialogitems};

/* New port */
DIALOGITEM usr_portdialogitems[] =
{
 /*  1 */ {0, {88,232,112,304}, BUTTON, "OK"},
 /*  2 */ {0, {88,32,112,104}, BUTTON, "Cancel"},
 /*  3 */ {0, {32,160,48,324}, POPUP, "Input"},
 /*  4 */ {0, {8,104,24,320}, EDITTEXT, ""},
 /*  5 */ {0, {8,16,24,96}, MESSAGE, "Port name:"},
 /*  6 */ {0, {56,16,72,136}, CHECK, "Always drawn"},
 /*  7 */ {0, {32,16,48,159}, MESSAGE, "Port characteristics:"},
 /*  8 */ {0, {56,168,72,288}, CHECK, "Body only"}
};
DIALOG usr_portdialog = {{50,75,174,410}, "Create Port on Highlighted", 8, usr_portdialogitems};

/* Port info */
DIALOGITEM usr_portinfodialogitems[] =
{
 /*  1 */ {0, {184,328,208,400}, BUTTON, "OK"},
 /*  2 */ {0, {152,328,176,400}, BUTTON, "Cancel"},
 /*  3 */ {0, {120,8,136,56}, RADIO, "Left"},
 /*  4 */ {0, {8,112,24,408}, EDITTEXT, ""},
 /*  5 */ {0, {72,232,88,354}, POPUP, "Small"},
 /*  6 */ {0, {56,8,72,88}, RADIO, "Center"},
 /*  7 */ {0, {72,8,88,80}, RADIO, "Bottom"},
 /*  8 */ {0, {88,8,104,56}, RADIO, "Top"},
 /*  9 */ {0, {104,8,120,64}, RADIO, "Right"},
 /* 10 */ {0, {136,8,152,104}, RADIO, "Lower right"},
 /* 11 */ {0, {152,8,168,96}, RADIO, "Lower left"},
 /* 12 */ {0, {168,8,184,104}, RADIO, "Upper right"},
 /* 13 */ {0, {184,8,200,96}, RADIO, "Upper left"},
 /* 14 */ {0, {200,8,216,72}, RADIO, "Boxed"},
 /* 15 */ {0, {72,160,88,231}, MESSAGE, "Text size:"},
 /* 16 */ {0, {40,16,56,107}, MESSAGE, "Text corner:"},
 /* 17 */ {0, {104,232,120,312}, EDITTEXT, ""},
 /* 18 */ {0, {128,232,144,312}, EDITTEXT, ""},
 /* 19 */ {0, {104,160,120,225}, MESSAGE, "X offset:"},
 /* 20 */ {0, {128,160,144,225}, MESSAGE, "Y offset:"},
 /* 21 */ {0, {56,112,88,144}, ICON, (char *)usr_icon200},
 /* 22 */ {0, {88,112,120,144}, ICON, (char *)usr_icon201},
 /* 23 */ {0, {120,112,152,144}, ICON, (char *)usr_icon202},
 /* 24 */ {0, {152,112,184,144}, ICON, (char *)usr_icon203},
 /* 25 */ {0, {184,112,216,144}, ICON, (char *)usr_icon204},
 /* 26 */ {0, {8,8,24,104}, MESSAGE, "Port name:"},
 /* 27 */ {0, {40,272,56,416}, POPUP, "Input"},
 /* 28 */ {0, {40,160,56,271}, MESSAGE, "Characteristics:"},
 /* 29 */ {0, {184,160,200,272}, CHECK, "Always drawn"},
 /* 30 */ {0, {160,160,176,252}, CHECK, "Body only"}
};
DIALOG usr_portinfodialog = {{50,75,273,496}, "Port Information", 30, usr_portinfodialogitems};

/* Layer visibility */
DIALOGITEM usr_visiblelaydialogitems[] =
{
 /*  1 */ {0, {168,328,192,400}, BUTTON, "OK"},
 /*  2 */ {0, {168,232,192,304}, BUTTON, "Cancel"},
 /*  3 */ {0, {48,224,64,412}, MESSAGE, "Marked layers are visible."},
 /*  4 */ {0, {32,8,208,222}, SCROLL, ""},
 /*  5 */ {0, {32,224,48,412}, MESSAGE, "Click to change visibility."},
 /*  6 */ {0, {88,232,112,404}, BUTTON, "Make all layers visible"},
 /*  7 */ {0, {120,232,144,404}, BUTTON, "Make all layers invisible"},
 /*  8 */ {0, {8,8,24,82}, MESSAGE, "Layer set:"},
 /*  9 */ {0, {8,88,24,222}, POPUP, "Electric Layers"}
};
DIALOG usr_visiblelaydialog = {{50,75,266,491}, "Layer Visibility", 9, usr_visiblelaydialogitems};

/* Yes/No */
DIALOGITEM usr_yesnodialogitems[] =
{
 /*  1 */ {0, {64,208,88,280}, BUTTON, "Yes"},
 /*  2 */ {0, {64,16,88,88}, BUTTON, "No"},
 /*  3 */ {0, {6,15,54,279}, MESSAGE, ""}
};
DIALOG usr_yesnodialog = {{50,75,150,369}, 0, 3, usr_yesnodialogitems};

/* New view */
DIALOGITEM usr_newviewdialogitems[] =
{
 /*  1 */ {0, {64,232,88,304}, BUTTON, "OK"},
 /*  2 */ {0, {64,16,88,88}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,8,24,145}, MESSAGE, "New view name:"},
 /*  4 */ {0, {32,8,48,145}, MESSAGE, "View abbreviation:"},
 /*  5 */ {0, {8,148,24,304}, EDITTEXT, ""},
 /*  6 */ {0, {32,148,48,304}, EDITTEXT, ""},
 /*  7 */ {0, {68,104,84,213}, CHECK, "Textual View"}
};
DIALOG usr_newviewdialog = {{50,75,154,391}, "New View", 7, usr_newviewdialogitems};

/* No/Yes */
DIALOGITEM usr_noyesdialogitems[] =
{
 /*  1 */ {0, {80,184,104,256}, BUTTON, "No"},
 /*  2 */ {0, {80,8,104,72}, BUTTON, "Yes"},
 /*  3 */ {0, {8,8,72,256}, MESSAGE, ""}
};
DIALOG usr_noyesdialog = {{50,75,162,341}, 0, 3, usr_noyesdialogitems};

/* Edit facet */
DIALOGITEM tty_editfacetdialoglist[] =
{
 /*  1 */ {0, {272,208,296,272}, BUTTON, "OK"},
 /*  2 */ {0, {272,16,296,80}, BUTTON, "Cancel"},
 /*  3 */ {0, {32,8,208,281}, SCROLL, ""},
 /*  4 */ {0, {216,8,232,153}, CHECK, "Show Old Versions"},
 /*  5 */ {0, {240,8,256,231}, CHECK, "Make New Window for Facet"},
 /*  6 */ {0, {272,104,296,187}, BUTTON, "New Facet"},
 /*  7 */ {0, {8,8,24,67}, MESSAGE, "Library:"},
 /*  8 */ {0, {8,72,24,280}, POPUP, "Library"}
};
DIALOG tty_editfacetdialog = {{50,75,358,364}, "Edit Facet", 8, tty_editfacetdialoglist};

/* New facet */
DIALOGITEM usr_newfacetdialogitems[] =
{
 /*  1 */ {0, {56,304,80,368}, BUTTON, "OK"},
 /*  2 */ {0, {56,12,80,76}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,160,24,367}, EDITTEXT, ""},
 /*  4 */ {0, {8,8,24,157}, MESSAGE, "Name of new facet:"},
 /*  5 */ {0, {32,160,48,367}, POPUP, "Unknown"},
 /*  6 */ {0, {32,56,48,149}, MESSAGE, "Facet view:"},
 /*  7 */ {0, {60,84,78,297}, CHECK, "Make new window for facet"}
};
DIALOG usr_newfacetdialog = {{350,75,445,455}, "New Facet Creation", 7, usr_newfacetdialogitems};

/* Facet List */
DIALOGITEM tty_facetlistdialoglist[] =
{
 /*  1 */ {0, {232,284,256,348}, BUTTON, "OK"},
 /*  2 */ {0, {232,12,256,76}, BUTTON, "Cancel"},
 /*  3 */ {0, {4,8,219,356}, SCROLL, ""},
 /*  4 */ {0, {236,108,254,253}, CHECK, "Show Old Versions"}
};
DIALOG tty_facetlistdialog = {{50,75,316,439}, "Facet List", 4, tty_facetlistdialoglist};

/* Batch DRC */
DIALOGITEM tty_batdrcdialoglist[] =
{
 /*  1 */ {0, {10,70,34,134}, BUTTON, "Check"},
 /*  2 */ {0, {80,10,174,363}, MESSAGE, ""},
 /*  3 */ {0, {10,240,34,304}, BUTTON, "Done"},
 /*  4 */ {0, {50,10,74,122}, BUTTON, "Show First Error"},
 /*  5 */ {0, {50,250,74,362}, BUTTON, "Show Prev Error"},
 /*  6 */ {0, {50,130,75,242}, BUTTON, "Show Next Error"}
};
DIALOG tty_batdrcdialog = {{50,75,229,446}, "Batch DRC", 6, tty_batdrcdialoglist};

/* Menu Position */
DIALOGITEM usr_menuposdialogitems[] =
{
 /*  1 */ {0, {128,168,152,232}, BUTTON, "OK"},
 /*  2 */ {0, {88,168,112,232}, BUTTON, "Cancel"},
 /*  3 */ {0, {32,200,48,248}, EDITTEXT, ""},
 /*  4 */ {0, {64,8,80,136}, RADIO, "Menu at Top"},
 /*  5 */ {0, {88,8,104,136}, RADIO, "Menu at Bottom"},
 /*  6 */ {0, {112,8,128,136}, RADIO, "Menu on Left"},
 /*  7 */ {0, {136,8,152,136}, RADIO, "Menu on Right"},
 /*  8 */ {0, {8,8,24,197}, MESSAGE, "Number of Entries Across:"},
 /*  9 */ {0, {32,8,48,197}, MESSAGE, "Number of Entries Down:"},
 /* 10 */ {0, {8,200,24,248}, EDITTEXT, ""},
 /* 11 */ {0, {160,8,176,100}, RADIO, "No Menu"}
};
DIALOG usr_menuposdialog = {{50,75,233,334}, "Component Menu Configuration", 11, usr_menuposdialogitems};

/* Routing Arc */
DIALOGITEM usr_routearcdialogitems[] =
{
 /*  1 */ {0, {120,200,144,264}, BUTTON, "OK"},
 /*  2 */ {0, {80,200,104,264}, BUTTON, "Cancel"},
 /*  3 */ {0, {40,192,64,272}, BUTTON, "Use Default"},
 /*  4 */ {0, {32,8,144,184}, SCROLL, ""},
 /*  5 */ {0, {8,88,24,272}, MESSAGE, ""},
 /*  6 */ {0, {8,8,24,88}, MESSAGE, "Currently:"}
};
DIALOG usr_routearcdialog = {{50,75,203,352}, "Prefered Routing Arc", 6, usr_routearcdialogitems};

/* Variables */
DIALOGITEM usr_variabledialogitems[] =
{
 /*  1 */ {0, {392,344,416,400}, BUTTON, "OK"},
 /*  2 */ {0, {336,8,352,56}, MESSAGE, "Value:"},
 /*  3 */ {0, {320,8,321,408}, MESSAGE, ""},
 /*  4 */ {0, {24,8,40,64}, MESSAGE, "Object:"},
 /*  5 */ {0, {8,80,24,240}, RADIO, "Currently Highlighted"},
 /*  6 */ {0, {24,80,40,192}, RADIO, "Current Facet"},
 /*  7 */ {0, {40,80,56,184}, RADIO, "Current Cell"},
 /*  8 */ {0, {8,256,24,376}, RADIO, "Current Library"},
 /*  9 */ {0, {24,256,40,408}, RADIO, "Current Technology"},
 /* 10 */ {0, {40,256,56,352}, RADIO, "Current Aid"},
 /* 11 */ {0, {128,24,144,96}, MESSAGE, "Attribute:"},
 /* 12 */ {0, {144,8,288,184}, SCROLL, ""},
 /* 13 */ {0, {296,32,312,152}, CHECK, "New Attribute:"},
 /* 14 */ {0, {296,160,312,400}, EDITTEXT, ""},
 /* 15 */ {0, {200,192,216,251}, CHECK, "Array"},
 /* 16 */ {0, {224,200,240,248}, MESSAGE, "Index:"},
 /* 17 */ {0, {224,250,240,312}, EDITTEXT, ""},
 /* 18 */ {0, {392,192,416,296}, BUTTON, "Set Attribute"},
 /* 19 */ {0, {328,80,360,400}, EDITTEXT, ""},
 /* 20 */ {0, {392,24,416,144}, BUTTON, "Delete Attribute"},
 /* 21 */ {0, {152,192,168,288}, CHECK, "Displayable"},
 /* 22 */ {0, {176,192,192,288}, CHECK, "Temporary"},
 /* 23 */ {0, {260,224,284,361}, BUTTON, "Examine Attribute"},
 /* 24 */ {0, {96,40,112,80}, MESSAGE, "Type:"},
 /* 25 */ {0, {96,80,112,216}, MESSAGE, ""},
 /* 26 */ {0, {128,184,144,224}, MESSAGE, "Type:"},
 /* 27 */ {0, {128,224,144,383}, MESSAGE, ""},
 /* 28 */ {0, {120,8,121,408}, MESSAGE, ""},
 /* 29 */ {0, {64,80,96,408}, MESSAGE, ""},
 /* 30 */ {0, {64,32,80,80}, MESSAGE, "Name:"},
 /* 31 */ {0, {152,304,168,410}, POPUP, "Not Code"},
 /* 32 */ {0, {368,80,384,160}, MESSAGE, "Evaluation:"},
 /* 33 */ {0, {368,160,384,400}, MESSAGE, ""},
 /* 34 */ {0, {216,320,232,366}, BUTTON, "Next"},
 /* 35 */ {0, {232,320,248,366}, BUTTON, "Prev"},
};
DIALOG usr_variabledialog = {{50,75,477,490}, "Variable Control", 35, usr_variabledialogitems};

/* Trace Info */
DIALOGITEM us_tracedialogitems[] =
{
 /*  1 */ {0, {96,208,120,272}, BUTTON, "OK"},
 /*  2 */ {0, {40,208,64,272}, BUTTON, "Cancel"},
 /*  3 */ {0, {8,8,168,192}, SCROLL, ""},
 /*  4 */ {0, {184,8,200,28}, MESSAGE, "X:"},
 /*  5 */ {0, {184,32,200,104}, EDITTEXT, ""},
 /*  6 */ {0, {216,8,232,28}, MESSAGE, "Y:"},
 /*  7 */ {0, {216,32,232,104}, EDITTEXT, ""},
 /*  8 */ {0, {208,160,232,272}, BUTTON, "Duplicate Point"},
 /*  9 */ {0, {176,160,200,272}, BUTTON, "Delete Point"}
};
DIALOG us_tracedialog = {{50,75,290,353}, "Trace Information", 9, us_tracedialogitems};

/* Text defaults */
DIALOGITEM us_deftextdialogitems[] =
{
 /*  1 */ {0, {248,160,272,232}, BUTTON, "OK"},
 /*  2 */ {0, {248,16,272,88}, BUTTON, "Cancel"},
 /*  3 */ {0, {112,32,128,88}, RADIO, "Left"},
 /*  4 */ {0, {8,80,24,196}, POPUP, "Small"},
 /*  5 */ {0, {48,32,64,104}, RADIO, "Center"},
 /*  6 */ {0, {64,32,80,104}, RADIO, "Bottom"},
 /*  7 */ {0, {80,32,96,88}, RADIO, "Top"},
 /*  8 */ {0, {96,32,112,96}, RADIO, "Right"},
 /*  9 */ {0, {128,32,144,128}, RADIO, "Lower right"},
 /* 10 */ {0, {144,32,160,128}, RADIO, "Lower left"},
 /* 11 */ {0, {160,32,176,128}, RADIO, "Upper right"},
 /* 12 */ {0, {176,32,192,120}, RADIO, "Upper left"},
 /* 13 */ {0, {192,32,208,104}, RADIO, "Boxed"},
 /* 14 */ {0, {8,8,24,79}, MESSAGE, "Text size:"},
 /* 15 */ {0, {32,8,48,103}, MESSAGE, "Text corner:"},
 /* 16 */ {0, {48,136,80,168}, ICON, (char *)usr_icon200},
 /* 17 */ {0, {80,136,112,168}, ICON, (char *)usr_icon201},
 /* 18 */ {0, {112,136,144,168}, ICON, (char *)usr_icon202},
 /* 19 */ {0, {144,136,176,168}, ICON, (char *)usr_icon203},
 /* 20 */ {0, {176,136,208,168}, ICON, (char *)usr_icon204},
 /* 21 */ {0, {216,8,232,259}, CHECK, "Easy selection of annotation text"}
};
DIALOG us_deftextdialog = {{50,75,339,338}, "Text Defaults", 21, us_deftextdialogitems};

/* prototypes for local routines */
INTSML tty_oldfacettopoffacets(char**);
char *tty_oldfacetnextfacets(void);
INTSML tty_onproto(PORTPROTO*, ARCPROTO*);
void tty_updatenodeinfo(NODEINST*, VARIABLE*, char*, char*, char*);
void tty_dlogchatportproto(NODEINST*, PORTPROTO*);
INTSML tty_topofvars(char**);
char *tty_nextvars(void);
void tty_varestablish(INTBIG, INTSML, char*);
void tty_varidentify(void);
void tty_vislayerloadset(void);

/****************************** DIALOG CODE ******************************/

/*
 * special case for the "grid settings" menu
 * Horizontal spacing = 3 (edit text)
 * Vertical spacing   = 6 (edit text)
 * Grid alignment     = 9 (edit text)
 * Edge alignment     = 10 (edit text)
 */
INTSML tty_griddlog(char *paramstart[])
{
	INTSML itemHit;
	INTBIG retval1, retval2;

	if (us_needwindow()) return(0);

	/* display the grid settings dialog box */
	if (DiaInitDialog(&usr_griddialog) != 0) return(0);
	DiaSetText(-3, latoa(el_curwindow->gridx));
	DiaSetText(6, latoa(el_curwindow->gridy));
	DiaSetText(9, latoa(us_alignment));
	DiaSetText(10, latoa(us_edgealignment));

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;
	}

	if (itemHit != CANCEL)
	{
		/* see if grid size changed */
		retval1 = atola(DiaGetText(3));
		retval2 = atola(DiaGetText(6));
		if (retval1 != el_curwindow->gridx || retval2 != el_curwindow->gridy)
		{
			us_pushhighlight();
			us_clearhighlightcount();
			startobjectchange((INTBIG)el_curwindow, VWINDOW);

			/* turn grid off if on */
			if ((el_curwindow->state&GRIDON) != 0)
				(void)setval((INTBIG)el_curwindow, VWINDOW, "state", el_curwindow->state & ~GRIDON, VINTEGER);

			/* adjust grid */
			(void)setval((INTBIG)el_curwindow, VWINDOW, "gridx", retval1, VINTEGER);
			(void)setval((INTBIG)el_curwindow, VWINDOW, "gridy", retval2, VINTEGER);

			/* show new grid */
			us_gridset(el_curwindow, GRIDON);

			/* restore highlighting */
			endobjectchange((INTBIG)el_curwindow, VWINDOW);
			(void)us_pophighlight(0);
		}

		/* see if alignment changed */
		retval1 = atola(DiaGetText(9));
		if (retval1 != us_alignment)
			(void)setvalkey((INTBIG)us_aid, VAID, us_alignment_obj, retval1, VINTEGER|VDONTSAVE);
		retval1 = atola(DiaGetText(10));
		if (retval1 != us_edgealignment)
			(void)setvalkey((INTBIG)us_aid, VAID, us_alignment_edge, retval1, VINTEGER|VDONTSAVE);
	}
	DiaDoneDialog();
	paramstart[0] = "x";
	return(1);
}

/*
 * special case for the "batch drc" menu
 * Check                = 1 (button)
 * Done                 = 3 (button)
 * Show First Error     = 4 (button)
 * Show Next Error      = 6 (button)
 * Show Prev Error      = 5 (button)
 * Error Message        = 2 (stat text)
 */
INTSML tty_batchdrcdlog(char *paramstart[])
{
#if DRCAID
	INTSML itemHit, errs, oldplease;
	char *msg, lne[50];
	extern AIDENTRY *dr_aid;

	/* display the batch DRC dialog box */
	if (DiaInitDialog(&tty_batdrcdialog) != 0) return(0);
	errs = askaid(dr_aid, "batch-error-count");
	if (errs == 0)
	{
		DiaDimItem(4);
		DiaDimItem(6);
		DiaDimItem(5);
	} else
	{
		DiaUnDimItem(4);
		DiaUnDimItem(6);
		DiaUnDimItem(5);
	}

	/* loop until done */
	oldplease = el_pleasestop;
	for(;;)
	{
		el_pleasestop = oldplease;
		itemHit = DiaNextHit();
		if (itemHit == 3) break;
		if (itemHit == 1)
		{
			/* "check" button */
			DiaSetText(2, "Checking...");
			errs = askaid(dr_aid, "batch-run");
			(void)sprintf(lne, "%d errors found", errs);
			DiaSetText(2, lne);
			DiaUnDimItem(4);
			DiaUnDimItem(6);
			DiaUnDimItem(5);
			continue;
		}
		if (itemHit == 4)
		{
			/* "show first error" button */
			msg = (char *)askaid(dr_aid, "batch-first-error");
			if (msg == 0) msg = "";
			DiaSetText(2, msg);
			continue;
		}
		if (itemHit == 6)
		{
			/* "show next error" button */
			msg = (char *)askaid(dr_aid, "batch-next-error");
			if (msg == 0) msg = "";
			DiaSetText(2, msg);
			continue;
		}
		if (itemHit == 5)
		{
			/* "show prev error" button */
			msg = (char *)askaid(dr_aid, "batch-previous-error");
			if (msg == 0) msg = "";
			DiaSetText(2, msg);
			continue;
		}
	}

	DiaDoneDialog();
	return(0);
#else
	ttyputerr("No DRC tool available");
		return(0);
#endif
}

/*
 * special case for the "units" menu
 * Display units    = 5 (popup)
 * Lambda           = 3 (edit text)
 * Internal units   = 7 (popup)
 */
INTSML tty_lambdadlog(char *paramstart[])
{
	INTSML itemHit, i, intunit;
	char ent[20];
	static char *dispunitnames[8] = {"Lambda units", "Inches", "Centimeters",
		"Millimeters", "Mils", "Microns", "Centimicrons", "Millimicrons"};
	static char *intunitnames[2] = {"Half-Millimicrons", "Half-Decimicrons"};

	/* display the units dialog box */
	if (DiaInitDialog(&usr_unitsdialog) != 0) return(0);
	(void)sprintf(ent, "%d", el_curtech->deflambda);
	DiaSetText(-3, ent);
	if ((el_units&DISPLAYUNITS) == DISPUNITLAMBDA)
	{
		DiaUnDimItem(4);
		DiaUnDimItem(3);
		DiaEditControl(3);
	} else
	{
		DiaDimItem(4);
		DiaDimItem(3);
		DiaNoEditControl(3);
	}
	DiaSetPopup(5, 8, dispunitnames);
	switch (el_units&DISPLAYUNITS)
	{
		case DISPUNITLAMBDA: DiaSetPopupEntry(5, 0);   break;
		case DISPUNITINCH:   DiaSetPopupEntry(5, 1);   break;
		case DISPUNITCM:     DiaSetPopupEntry(5, 2);   break;
		case DISPUNITMM:     DiaSetPopupEntry(5, 3);   break;
		case DISPUNITMIL:    DiaSetPopupEntry(5, 4);   break;
		case DISPUNITMIC:    DiaSetPopupEntry(5, 5);   break;
		case DISPUNITCMIC:   DiaSetPopupEntry(5, 6);   break;
		case DISPUNITMMIC:   DiaSetPopupEntry(5, 7);   break;
	}
	DiaSetPopup(7, 2, intunitnames);
	switch (el_units&INTERNALUNITS)
	{
		case INTUNITHMMIC:   DiaSetPopupEntry(7, 0);   break;
		case INTUNITHDMIC:   DiaSetPopupEntry(7, 1);   break;
	}

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL) break;
		if (itemHit == OK && DiaValidEntry(3)) break;
		if (itemHit == 5)
		{
			if (DiaGetPopupEntry(5) == 0)
			{
				DiaUnDimItem(4);
				DiaUnDimItem(3);
				DiaEditControl(3);
			} else
			{
				DiaDimItem(4);
				DiaDimItem(3);
				DiaNoEditControl(3);
			}
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		/* set display unit */
		i = DiaGetPopupEntry(5);
		switch (i)
		{
			case 0: el_units = (el_units & ~DISPLAYUNITS) | DISPUNITLAMBDA;   break;
			case 1: el_units = (el_units & ~DISPLAYUNITS) | DISPUNITINCH;     break;
			case 2: el_units = (el_units & ~DISPLAYUNITS) | DISPUNITCM;       break;
			case 3: el_units = (el_units & ~DISPLAYUNITS) | DISPUNITMM;       break;
			case 4: el_units = (el_units & ~DISPLAYUNITS) | DISPUNITMIL;      break;
			case 5: el_units = (el_units & ~DISPLAYUNITS) | DISPUNITMIC;      break;
			case 6: el_units = (el_units & ~DISPLAYUNITS) | DISPUNITCMIC;     break;
			case 7: el_units = (el_units & ~DISPLAYUNITS) | DISPUNITMMIC;     break;
		}

		/* see if internal unit was changed */
		i = DiaGetPopupEntry(7);
		switch (i)
		{
			case 0: intunit = INTUNITHMMIC;   break;
			case 1: intunit = INTUNITHDMIC;   break;
		}
		if (intunit != (el_units&INTERNALUNITS))
		{
			/* only change internal unit, not lambda */
			changeinternalunits(NOLIBRARY, el_units, intunit);
		} else
		{
			/* accept change to lambda value */
			paramstart[0] = us_putintoinfstr(DiaGetText(3));
		}
	}
	DiaDoneDialog();
	return(1);
}

/*
 * special case for the "menu" menu
 * Menus at top    = 4 (radio button)
 * Menus at bottom = 5 (radio button)
 * Menus at left   = 6 (radio button)
 * Menus at right  = 7 (radio button)
 * No menu         = 11 (radio button)
 * Across label    = 8 (static text)
 * Down label      = 9 (static text)
 * Across          = 10 (edit text)
 * Down            = 3 (edit text)
 */
INTSML tty_menudlog(char *paramstart[])
{
	INTSML itemHit, large, smallf;
	char amt[10];

	/* display the array dialog box */
	if (DiaInitDialog(&usr_menuposdialog) != 0) return(0);
	if ((us_aid->aidstate&MENUON) == 0)
	{
		DiaSetControl(11, 1);
		DiaNoEditControl(3);
		DiaNoEditControl(10);
		DiaDimItem(8);
		DiaDimItem(9);
	} else
	{
		switch (us_menupos)
		{
			case 0: DiaSetControl(4, 1);   break;
			case 1: DiaSetControl(5, 1);   break;
			case 2: DiaSetControl(6, 1);   break;
			case 3: DiaSetControl(7, 1);   break;
		}
		DiaEditControl(3);
		DiaEditControl(10);
		DiaUnDimItem(8);
		DiaUnDimItem(9);
	}
	if (us_menux < us_menuy) { large = us_menuy;   smallf = us_menux; } else
		{ large = us_menux;   smallf = us_menuy; }
	if (us_menupos <= 1)
	{
		(void)sprintf(amt, "%d", large);
		DiaSetText(10, amt);
		(void)sprintf(amt, "%d", smallf);
		DiaSetText(3, amt);
	} else
	{
		(void)sprintf(amt, "%d", smallf);
		DiaSetText(10, amt);
		(void)sprintf(amt, "%d", large);
		DiaSetText(3, amt);
	}

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL) break;
		if (itemHit == OK && DiaValidEntry(10) && DiaValidEntry(3)) break;
		if (itemHit == 4 || itemHit == 5 || itemHit == 6 || itemHit == 7 || itemHit == 11)
		{
			DiaSetControl(4, 0);
			DiaSetControl(5, 0);
			DiaSetControl(6, 0);
			DiaSetControl(7, 0);
			DiaSetControl(11, 0);
			DiaSetControl(itemHit, 1);
			if (itemHit == 11)
			{
				DiaNoEditControl(3);
				DiaNoEditControl(10);
				DiaDimItem(8);
				DiaDimItem(9);
			} else
			{
				DiaEditControl(3);
				DiaEditControl(10);
				DiaUnDimItem(8);
				DiaUnDimItem(9);
			}
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		(void)initinfstr();
		if (DiaGetControl(11) != 0) (void)addstringtoinfstr("off"); else
		{
			if (DiaGetControl(4) != 0) (void)addstringtoinfstr("top");
			if (DiaGetControl(5) != 0) (void)addstringtoinfstr("bottom");
			if (DiaGetControl(6) != 0) (void)addstringtoinfstr("left");
			if (DiaGetControl(7) != 0) (void)addstringtoinfstr("right");
			(void)addstringtoinfstr(" size ");
			(void)addstringtoinfstr(DiaGetText(10));
			(void)addtoinfstr(' ');
			(void)addstringtoinfstr(DiaGetText(3));
		}
		paramstart[0] = returninfstr();
	}
	DiaDoneDialog();
	return(1);
}

/*
 * special case for the "port" menu
 * Name             = 4 (edit text)
 * Characteristics  = 3 (popup)
 * Always drawn     = 6 (check button)
 * Body only        = 8 (check button)
 */
INTSML tty_portdlog(char *paramstart[])
{
	INTSML itemHit, i;
	struct portbut { INTSML button;  char *name; };
	static char *charnames[15] = {"Unknown", "Input", "Output", "Bidirectional", "Power",
		"Ground", "Reference Output", "Reference Input", "Clock", "Clock phase 1",
		"Clock phase 2", "Clock phase 3", "Clock phase 4", "Clock phase 5", "Clock phase 6"};
	static char *intnames[15] = {"", " input", " output", " bidirectional", " power", " ground",
		" refout", " refin", " clock", " clock1", " clock2", " clock3", " clock4", " clock5",
		" clock6"};

	/* display the port dialog box */
	if (DiaInitDialog(&usr_portdialog) != 0) return(0);
	DiaSetText(-4, "");
	DiaSetPopup(3, 15, charnames);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL) break;
		if (itemHit == OK && DiaValidEntry(4)) break;
		if (itemHit == 6 || itemHit == 8)
			DiaSetControl(itemHit, (INTSML)(1-DiaGetControl(itemHit)));
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		(void)initinfstr();
		(void)addstringtoinfstr(DiaGetText(4));
		i = DiaGetPopupEntry(3);
		(void)addstringtoinfstr(intnames[i]);
		if (DiaGetControl(6) != 0) (void)addstringtoinfstr(" always-drawn");
		if (DiaGetControl(8) != 0) (void)addstringtoinfstr(" body-only");
		paramstart[0] = returninfstr();
	}
	DiaDoneDialog();
	return(1);
}

/*
 * special case for the "new view" menu
 * New view name     = 5 (edit text)
 * View abbreviation = 6 (edit text)
 * Textual view      = 7 (check box)
 */
INTSML tty_newviewdlog(char *paramstart[])
{
	INTSML itemHit;

	/* display the port dialog box */
	if (DiaInitDialog(&usr_newviewdialog) != 0) return(0);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL) break;
		if (itemHit == OK && DiaValidEntry(5) && DiaValidEntry(6)) break;
		if (itemHit == 7)
		{
			DiaSetControl(itemHit, (INTSML)(1-DiaGetControl(itemHit)));
			continue;
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		(void)initinfstr();
		(void)addstringtoinfstr(DiaGetText(5));
		(void)addtoinfstr(' ');
		(void)addstringtoinfstr(DiaGetText(6));
		if (DiaGetControl(7) != 0) (void)addstringtoinfstr(" text");
		paramstart[0] = returninfstr();
	}
	DiaDoneDialog();
	return(1);
}

/*
 * special case for "yes/no" options ("no" is default)
 * Message = 3 (stat text)
 * No = 1      (button)
 * Yes = 2     (button)
 */
INTSML tty_noyesdlog(char *prompt, char *paramstart[])
{
	INTSML itemHit, oldplease;

	/* display the no/yes dialog box */
	if (DiaInitDialog(&usr_noyesdialog) != 0) return(0);

	/* load the message */
	DiaSetText(3, prompt);

	/* loop until done */
	oldplease = el_pleasestop;
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == 1 || itemHit == 2) break;
	}
	el_pleasestop = oldplease;

	if (itemHit == 1) paramstart[0] = "no"; else
		paramstart[0] = "yes";
	DiaDoneDialog();
	return(1);
}

/*
 * special case for the "edit facet" command
 * Facet list                = 3 (stat text)
 * Show old versions         = 4 (check box)
 * Make new window for facet = 5 (check box)
 * New facet                 = 6 (button)
 * Library name              = 8 (stat text)
 *
 * special case for the "new facet" button
 * Facet name                = 3 (edit text)
 * View list                 = 5 (popup)
 * Make new window for facet = 7 (check box)
 */
static NODEPROTO *tty_oldfacetprotos;
static INTSML tty_showoldversions;
static LIBRARY *tty_curlib;

INTSML tty_oldfacettopoffacets(char **c)
{
	tty_oldfacetprotos = tty_curlib->firstnodeproto;
	return(1);
}

char *tty_oldfacetnextfacets(void)
{
	REGISTER NODEPROTO *thisnp;
	REGISTER LIBRARY *savelibrary;
	REGISTER char *ret;

	while (tty_oldfacetprotos != NONODEPROTO)
	{
		thisnp = tty_oldfacetprotos;
		tty_oldfacetprotos = tty_oldfacetprotos->nextnodeproto;
		if (tty_showoldversions == 0 && thisnp->newestversion != thisnp) continue;
		savelibrary = el_curlib;
		el_curlib = tty_curlib;
		ret = describenodeproto(thisnp);
		el_curlib = savelibrary;
		return(ret);
	}
	return(0);
}

INTSML tty_editfacetdlog(char *prompt, char *paramstart[])
{
	INTSML itemHit;
	REGISTER INTSML viewcount, librarycount, i, libindex;
	REGISTER NODEPROTO *np, *curfacet;
	char **viewlist, **librarylist, *pt;
	REGISTER VIEW *v;
	REGISTER LIBRARY *lib;
	static INTSML makenewwindow = -1;

	/* make a list of view names */
	for(viewcount=0, v=el_views; v!=NOVIEW; v=v->nextview) viewcount++;
	viewlist = (char **)emalloc(viewcount * (sizeof (char *)), el_tempcluster);
	if (viewlist == 0) return(0);
	viewlist[0] = "unknown";   i = 1;
	for(v = el_views; v != NOVIEW; v = v->nextview)
		if (namesame(v->viewname, "unknown") != 0) viewlist[i++] = v->viewname;

	/* the general case: display the dialog box */
	tty_curlib = el_curlib;
	for(pt = prompt; *pt != 0; pt++) if (*pt == '/') break;
	if (*pt == '/')
	{
		*pt++ = 0;
		tty_curlib = getlibrary(prompt);
		if (tty_curlib == NOLIBRARY) tty_curlib = el_curlib;
		prompt = pt;
	}
	tty_editfacetdialog.movable = prompt;
	if (DiaInitDialog(&tty_editfacetdialog) != 0) return(0);

	/* make a list of library names */
	for(librarycount=0, lib=el_curlib; lib!=NOLIBRARY; lib=lib->nextlibrary) librarycount++;
	librarylist = (char **)emalloc(librarycount * (sizeof (char *)), el_tempcluster);
	if (librarylist == 0) return(0);
	i = 0;
	for(lib = el_curlib; lib != NOLIBRARY; lib = lib->nextlibrary)
	{
		if (lib == tty_curlib) libindex = i;
		librarylist[i++] = lib->libname;
	}
	DiaSetPopup(8, librarycount, librarylist);
	DiaSetPopupEntry(8, libindex);

	/* show the facets */
	tty_showoldversions = 1;
	DiaInitTextDialog(3, tty_oldfacettopoffacets, tty_oldfacetnextfacets, tty_nulldlogdone,
		0, SCSELMOUSE|SCSELKEY|SCDOUBLEQUIT);
	if (tty_curlib->firstnodeproto == NONODEPROTO) DiaDefaultButton(6); else
		DiaDefaultButton(OK);

	/* see if there are any old versions */
	for(np = tty_curlib->firstnodeproto; np != NONODEPROTO; np = np->nextnodeproto)
		if (np->newestversion != np) break;
	if (np == NONODEPROTO) DiaDimItem(4); else
	{
		DiaUnDimItem(4);
		DiaSetControl(4, tty_showoldversions);
	}

	/* if the current window has a facet in it and multiple windows are supported, offer new one */
	curfacet = getcurfacet();
	if (makenewwindow < 0)
	{
		makenewwindow = 0;
		if (curfacet != NONODEPROTO && us_graphicshas(CANUSEFRAMES)) makenewwindow = 1;
	}
	if (curfacet == NONODEPROTO) makenewwindow = 0;
	DiaSetControl(5, makenewwindow);

	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL)
		{
			(void)initinfstr();
			if (tty_curlib != el_curlib)
			{
				(void)addstringtoinfstr(tty_curlib->libname);
				(void)addtoinfstr(':');
			}
			(void)addstringtoinfstr(DiaGetScrollLine(3, DiaGetCurLine(3)));
			paramstart[0] = returninfstr();
			break;
		}
		if (itemHit == 5)
		{
			DiaSetControl(5, (INTSML)(1 - DiaGetControl(5)));
			continue;
		}
		if (itemHit == 8)
		{
			tty_curlib = getlibrary(DiaGetText(8));
			DiaLoadTextDialog(3, tty_oldfacettopoffacets, tty_oldfacetnextfacets, tty_nulldlogdone, 0);
			continue;
		}
		if (itemHit == 4)
		{
			tty_showoldversions = 1 - DiaGetControl(4);
			DiaSetControl(4, tty_showoldversions);
			DiaLoadTextDialog(3, tty_oldfacettopoffacets, tty_oldfacetnextfacets, tty_nulldlogdone, 0);
			continue;
		}
		if (itemHit == 6)
		{
			/* display the new facet dialog box */
			makenewwindow = DiaGetControl(5);
			DiaAllowSubDialog();
			if (DiaInitDialog(&usr_newfacetdialog) != 0) continue;
			DiaSetPopup(5, viewcount, viewlist);
			DiaSetControl(7, makenewwindow);

			/* loop until done */
			for(;;)
			{
				itemHit = DiaNextHit();
				if (itemHit == CANCEL) break;
				if (itemHit == 7)
				{
					DiaSetControl(7, (INTSML)(1 - DiaGetControl(7)));
					continue;
				}
				if (itemHit == OK && DiaValidEntry(3)) break;
			}

			paramstart[0] = "";
			if (itemHit != CANCEL)
			{
				i = DiaGetPopupEntry(5);
				(void)initinfstr();
				if (tty_curlib != el_curlib)
				{
					(void)addstringtoinfstr(tty_curlib->libname);
					(void)addtoinfstr(':');
				}
				(void)addstringtoinfstr(DiaGetText(3));
				for(v = el_views; v != NOVIEW; v = v->nextview)
					if (namesame(viewlist[i], v->viewname) == 0)
				{
					if (*v->sviewname == 0) break;
					(void)addtoinfstr('{');
					(void)addstringtoinfstr(v->sviewname);
					(void)addtoinfstr('}');
					break;
				}
				paramstart[0] = returninfstr();
			}
			makenewwindow = DiaGetControl(7);
			DiaDoneDialog();
			if (itemHit == CANCEL) continue;
			DiaSetControl(5, makenewwindow);
			break;
		}
	}
	makenewwindow = DiaGetControl(5);
	DiaDoneDialog();
	efree((char *)viewlist);
	if (itemHit == CANCEL) return(0);
	if (makenewwindow != 0)
	{
		(void)initinfstr();
		(void)addstringtoinfstr(paramstart[0]);
		(void)addstringtoinfstr(" new-window");
		paramstart[0] = returninfstr();
	}
	return(1);
}

/*
 * special case for the "Delete Facet" "New Facet Instance", "List Facet Usage", and
 * "plot simulation in facet window" command
 * Facet list              = 3 (stat text)
 * Show old versions       = 4 (check box)
 */
INTSML tty_facetlist(char *prompt, char *paramstart[])
{
	INTSML itemHit;
	REGISTER char *curnode, *line;
	REGISTER INTSML i;
	REGISTER NODEPROTO *np;

	/* display the dialog box */
	tty_facetlistdialog.movable = prompt;
	if (DiaInitDialog(&tty_facetlistdialog) != 0) return(0);
	tty_showoldversions = 1;
	tty_curlib = el_curlib;
	DiaInitTextDialog(3, tty_oldfacettopoffacets, tty_oldfacetnextfacets, tty_nulldlogdone,
		0, SCSELMOUSE|SCSELKEY|SCDOUBLEQUIT);

	/* find the current node and make it the default */
	np = getcurfacet();
	if (np != NONODEPROTO)
	{
		curnode = describenodeproto(np);
		for(i=0; ; i++)
		{
			line = DiaGetScrollLine(3, i);
			if (*line == 0) break;
			if (strcmp(line, curnode) == 0)
			{
				DiaSelectLine(3, i);
				break;
			}
		}
	}

	/* see if there are any old versions */
	for(np = el_curlib->firstnodeproto; np != NONODEPROTO; np = np->nextnodeproto)
		if (np->newestversion != np) break;
	if (np == NONODEPROTO) DiaDimItem(4); else
	{
		DiaUnDimItem(4);
		DiaSetControl(4, tty_showoldversions);
	}

	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;
		if (itemHit == 4)
		{
			tty_showoldversions = 1 - DiaGetControl(4);
			DiaSetControl(4, tty_showoldversions);
			DiaLoadTextDialog(3, tty_oldfacettopoffacets, tty_oldfacetnextfacets, tty_nulldlogdone, 0);
		}
	}
	paramstart[0] = us_putintoinfstr(DiaGetScrollLine(3, DiaGetCurLine(3)));
	DiaDoneDialog();
	if (itemHit == CANCEL) return(0);
	return(1);
}

/*
 * special case for the "quit" command
 * Message = 4 (stat text)
 * Yes = 1     (button)
 * Cancel = 2  (button)
 * No = 3      (button)
 */
INTSML tty_quitdlog(char *prompt, char *paramstart[])
{
	INTSML itemHit, i, len, oldplease;

	/* display the quit dialog box */
	if (DiaInitDialog(&usr_quitdialog) != 0) return(0);

	/* load the message */
	len = strlen(prompt);
	for(i=0; i<len; i++) if (strncmp(&prompt[i], " has changed.  ", 15) == 0) break;
	if (i >= len) DiaSetText(4, prompt); else
	{
		(void)initinfstr();
		prompt[i+15] = 0;
		(void)addstringtoinfstr(prompt);
		(void)addstringtoinfstr("Save?");
		DiaSetText(4, returninfstr());
	}

	/* loop until done */
	oldplease = el_pleasestop;
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == 1 || itemHit == 2 || itemHit == 3) break;
	}
	el_pleasestop = oldplease;

	switch (itemHit)
	{
		case 2:  paramstart[0] = "no";     break;
		case 3:  paramstart[0] = "yes";    break;
		default: paramstart[0] = "save";   break;
	}
	DiaDoneDialog();
	return(1);
}

/*
 * special case for the "change" menu
 * Alternate list = 6 (user item)
 * This only      = 3 (radio button)
 * In facet       = 4 (radio button)
 * Universally    = 5 (radio button)
 */
INTSML tty_replacedlog(char *paramstart[])
{
	INTSML i, itemHit;
	HIGHLIGHT high;
	REGISTER VARIABLE *var;
	REGISTER ARCPROTO *ap;
	REGISTER ARCINST *ai;
	REGISTER PORTPROTO *pp1, *pp2;

	/* display the change dialog box */
	var = getvalkey((INTBIG)us_aid, VAID, VSTRING|VISARRAY, us_highlighted);
	if (var == NOVARIABLE) return(0);
	if (getlength(var) > 1) return(0);
	if (us_makehighlight(((char **)var->addr)[0], &high) != 0) return(0);
	if ((high.status&HIGHTYPE) != HIGHFROM) return(0);
	if (DiaInitDialog(&usr_changedialog) != 0) return(0);
	if (high.fromgeom->entrytype == OBJARCINST)
	{
		/* load arcs in current technology, arc's technology, and generic technology */
		ai = high.fromgeom->entryaddr.ai;
		pp1 = ai->end[0].portarcinst->proto;
		pp2 = ai->end[1].portarcinst->proto;
		DiaInitTextDialog(6, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, 0,
			SCSELMOUSE|SCSELKEY|SCDOUBLEQUIT);
		for(ap = el_curtech->firstarcproto; ap != NOARCPROTO; ap = ap->nextarcproto)
		{
			if (tty_onproto(pp1, ap) == 0) continue;
			if (tty_onproto(pp2, ap) == 0) continue;
			DiaStuffLine(6, ap->protoname);
		}
		if (el_curtech != gen_tech)
			for(ap = gen_tech->firstarcproto; ap != NOARCPROTO; ap = ap->nextarcproto)
		{
			if (tty_onproto(pp1, ap) == 0) continue;
			if (tty_onproto(pp2, ap) == 0) continue;
			DiaStuffLine(6, describearcproto(ap));
		}
		if (ai->proto->tech != el_curtech && ai->proto->tech != gen_tech)
			for(ap = ai->proto->tech->firstarcproto; ap != NOARCPROTO; ap = ap->nextarcproto)
		{
			if (tty_onproto(pp1, ap) == 0) continue;
			if (tty_onproto(pp2, ap) == 0) continue;
			DiaStuffLine(6, describearcproto(ap));
		}
		DiaSelectLine(6, 0);
	} else DiaInitTextDialog(6, us_topofnodes, us_nextparse, tty_nulldlogdone, 0,
		SCSELMOUSE|SCSELKEY|SCDOUBLEQUIT);
	DiaSetControl(3, 1);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;
		if (itemHit >= 3 && itemHit <= 5)
		{
			for(i=3; i<=5; i++) DiaSetControl(i, 0);
			DiaSetControl(itemHit, 1);
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		(void)initinfstr();
		(void)addstringtoinfstr(DiaGetScrollLine(6, DiaGetCurLine(6)));
		if (DiaGetControl(4) != 0) (void)addstringtoinfstr(" this-facet");
		if (DiaGetControl(5) != 0) (void)addstringtoinfstr(" universally");
		paramstart[0] = returninfstr();
	}
	DiaDoneDialog();
	return(1);
}

/*
 * helper routine to determine whether arcproto "ap" can connect to portproto "pp".
 * returns nonzero if so
 */
INTSML tty_onproto(PORTPROTO *pp, ARCPROTO *ap)
{
	REGISTER INTSML i;

	for(i=0; pp->connects[i] != NOARCPROTO; i++)
		if (pp->connects[i] == ap) return(1);
	return(0);
}

/*
 * special case for the "Set Routing Arc" menu
 * Arc list       = 4 (user item)
 * Current arc    = 5 (stat text)
 * Use default    = 3 (button)
 */
INTSML tty_routearcdlog(char *paramstart[])
{
#if ROUTAID
	INTSML itemHit;
	char *next;
	REGISTER VARIABLE *var;
	extern AIDENTRY *ro_aid;
	REGISTER ARCPROTO *ap;

	/* display the router arc dialog box */
	if (DiaInitDialog(&usr_routearcdialog) != 0) return(0);
	DiaInitTextDialog(4, us_topofarcs, us_nextparse, tty_nulldlogdone, 0,
		SCSELMOUSE|SCDOUBLEQUIT|SCREPORT);
	var = getval((INTBIG)ro_aid, VAID, VARCPROTO, "ROUT_prefered_arc");
	if (var == NOVARIABLE)
	{
		ap = NOARCPROTO;
		DiaSetText(5, "DEFAULT ARC");
	} else
	{
		ap = (ARCPROTO *)var->addr;
		DiaSetText(5, ap->protoname);
	}

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;
		if (itemHit == 3)
		{
			ap = NOARCPROTO;
			DiaSetText(5, "DEFAULT ARC");
		}
		if (itemHit == 4)
		{
			/* find this arc */
			next = DiaGetScrollLine(4, DiaGetCurLine(4));
			for(ap = el_curtech->firstarcproto; ap != NOARCPROTO; ap = ap->nextarcproto)
				if (namesame(ap->protoname, next) == 0) break;
			if (ap != NOARCPROTO) DiaSetText(5, ap->protoname);
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		if (ap == NOARCPROTO) paramstart[0] = "*"; else
			paramstart[0] = ap->protoname;
	}
	DiaDoneDialog();
	return(1);
#else
	ttyputerr("No routing tool available");
		return(1);
#endif
}

/*
 ***** Text info menu:
 * text name             = 4 (edit text)
 * text size             = 5 (popup)
 * X offset              = 17 (edit text)
 * Y offset              = 18 (edit text)
 * center                = 6 (radio button)
 * bottom                = 7 (radio button)
 * top                   = 8 (radio button)
 * right                 = 9 (radio button)
 * left                  = 3 (radio button)
 * lower right           = 10 (radio button)
 * lower left            = 11 (radio button)
 * upper right           = 12 (radio button)
 * upper left            = 13 (radio button)
 * boxed                 = 14 (radio button)
 * title                 = 26 (stat text)
 *
 ***** Node info menu:
 * expanded              = 4 (radio button)
 * unexpanded            = 5 (radio button)
 * type                  = 6 (stat text)
 * name                  = 7 (edit text)
 * connection list       = 3 (user item)
 * X size                = 8 (edit text)
 * Y size                = 9 (edit text)
 * rotation              = 10 (edit text)
 * transposed            = 11 (check button)
 * X position            = 12 (edit text)
 * X position            = 13 (edit text)
 * Special value value   = 22 (stat/edit text)
 * Special feature title = 23 (stat text)
 * Special feature value = 24 (stat text)
 * Special value title   = 25 (stat text)
 *
 ***** Arc info menu:
 * type                  = 5 (stat text)
 * network               = 6 (stat text)
 * name                  = 7 (edit text)
 * width                 = 27 (edit text)
 * angle                 = 8 (stat text)
 * head                  = 9 (stat text)
 * tail                  = 11 (stat text)
 * bus size              = 10 (stat text)
 * rigid                 = 3 (check button)
 * temporarily           = 26 (check button)
 * fixed-angle           = 4 (check button)
 * slidable              = 19 (check button)
 * negated               = 20 (check button)
 * directional           = 21 (check button)
 * ends extend           = 22 (check button)
 * ignore head           = 23 (check button)
 * ignore tail           = 24 (check button)
 * reverse               = 25 (check button)
 * constraints           = 29 (stat text)
 *
 ***** Port info menu:
 * text name             = 4 (edit text)
 * text size             = 5 (popup)
 * X offset              = 17 (edit text)
 * Y offset              = 18 (edit text)
 * center                = 6 (radio button)
 * bottom                = 7 (radio button)
 * top                   = 8 (radio button)
 * right                 = 9 (radio button)
 * left                  = 3 (radio button)
 * lower right           = 10 (radio button)
 * lower left            = 11 (radio button)
 * upper right           = 12 (radio button)
 * upper left            = 13 (radio button)
 * boxed                 = 14 (radio button)
 * characteristics       = 27 (popup)
 * always drawn          = 29 (check button)
 * body only             = 30 (check button)
 */
INTSML tty_showdlog(char *paramstart[], INTSML canspecialize)
{
	INTSML itemHit, i, j, r, t, haslw, trandessize, x, y,
		rigstate, oldrigstate, fun, skipchrs, changed, serpwidth, xyrev;
	char ent[50], *next, *str, *newstr, *namestr, *pt;
	HIGHLIGHT *high;
	RECTAREA itemRect;
	double startoffset, endangle;
	INTBIG descript, plx, ply, phx, phy, newval, newdescript, objtype, lambda,
		xcur, ycur, wid, oldwid, newbit, index, len, xs, ys, xc, yc, dx, dy,
		nlx, nhx, nly, nhy, newdeg, cox, coy;
	REGISTER NODEINST *ni;
	REGISTER NODEPROTO *np, *onp;
	REGISTER ARCINST *ai;
	REGISTER PORTPROTO *pp;
	REGISTER PORTARCINST *pi;
	REGISTER PORTEXPINST *pe;
	REGISTER VARIABLE *var;
	extern INTBIG cla_changeclock;	/* from layout constraints: "conlay.c" */
	extern CONSTRAINT *cla_constraint;
	static char *sizenames[12] = {"4 Points", "6 Points", "8 Points", "10 Points", "12 Points",
		"14 Points", "16 Points", "18 Points", "20 Points", "Small", "Medium", "Large"};
	static INTSML sizelist[12] = {TXT4P, TXT6P, TXT8P, TXT10P, TXT12P, TXT14P, TXT16P,
		TXT18P, TXT20P, TXTSMALL, TXTMEDIUM, TXTLARGE};
	static char *charnames[15] = {"Input", "Output", "Bidirectional", "Power", "Ground",
		"Reference Output", "Reference Input", "Clock", "Clock phase 1", "Clock phase 2",
		"Clock phase 3", "Clock phase 4", "Clock phase 5", "Clock phase 6", "Unknown"};
	static UINTBIG charlist[15] = {INPORT, OUTPORT, BIDIRPORT, PWRPORT, GNDPORT,
		REFOUTPORT, REFINPORT, CLKPORT, C1PORT, C2PORT, C3PORT, C4PORT, C5PORT, C6PORT};
	static struct butlist poslist[10] =
	{
		{VTPOSCENT,       6},
		{VTPOSUP,         7},
		{VTPOSDOWN,       8},
		{VTPOSLEFT,       9},
		{VTPOSRIGHT,      3},
		{VTPOSUPLEFT,    10},
		{VTPOSUPRIGHT,   11},
		{VTPOSDOWNLEFT,  12},
		{VTPOSDOWNRIGHT, 13},
		{VTPOSBOXED,     14}
	};

	high = us_getonehighlight();
	if (high == NOHIGHLIGHT) return(0);
	if ((high->status&HIGHTYPE) == HIGHTEXT)
	{
		/* display text */
		skipchrs = 0;
		if (high->fromvar != NOVARIABLE)
		{
			if (high->fromgeom->entrytype == OBJNODEINST) objtype = VNODEINST; else
				objtype = VARCINST;

			/* special case if known variables are selected */
			if (canspecialize != 0)
			{
				if (high->fromvar->key == sch_resistancekey)
				{
					i = tty_resistancedlog("Resistor", paramstart, (char *)high->fromvar->addr);
					if (i == 0) return(0);
					us_pushhighlight();
					us_clearhighlightcount();
					startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
					(void)setvalkey(high->fromgeom->entryaddr.blind, objtype, sch_resistancekey,
						(INTBIG)paramstart[0], high->fromvar->type);
					endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
					(void)us_pophighlight(0);
					return(1);
				}
				if (high->fromvar->key == sch_capacitancekey)
				{
					str = (char *)high->fromvar->addr;
					while (*str == ' ') str++;
					if (*str == 'e' || *str == 'E') str++;
					i = tty_capacitancedlog(paramstart, str);
					if (i == 0) return(0);
					us_pushhighlight();
					us_clearhighlightcount();
					startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
					(void)initinfstr();
					for(pt = (char *)high->fromvar->addr; pt != str; pt++)
						(void)addtoinfstr(*pt);
					(void)addstringtoinfstr(paramstart[0]);
					(void)setvalkey(high->fromgeom->entryaddr.blind, objtype, sch_capacitancekey,
						(INTBIG)returninfstr(), high->fromvar->type);
					endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
					(void)us_pophighlight(0);
					return(1);
				}
				if (high->fromvar->key == sch_inductancekey)
				{
					i = tty_inductancedlog(paramstart, (char *)high->fromvar->addr);
					if (i == 0) return(0);
					us_pushhighlight();
					us_clearhighlightcount();
					startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
					(void)setvalkey(high->fromgeom->entryaddr.blind, objtype, sch_inductancekey,
						(INTBIG)paramstart[0], high->fromvar->type);
					endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
					(void)us_pophighlight(0);
					return(1);
				}
				if (high->fromvar->key == sch_diodekey)
				{
					str = (char *)high->fromvar->addr;
					while (*str == ' ') str++;
					if (*str == 'z' || *str == 'Z') str++;
					i = tty_areadlog("Diode", paramstart, str);
					if (i == 0) return(0);
					us_pushhighlight();
					us_clearhighlightcount();
					startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
					(void)initinfstr();
					for(pt = (char *)high->fromvar->addr; pt != str; pt++)
						(void)addtoinfstr(*pt);
					(void)addstringtoinfstr(paramstart[0]);
					(void)setvalkey(high->fromgeom->entryaddr.blind, objtype, sch_diodekey,
						(INTBIG)returninfstr(), high->fromvar->type);
					endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
					(void)us_pophighlight(0);
					return(1);
				}
				if (high->fromvar->key == sch_twoportkey)
				{
					str = (char *)high->fromvar->addr;
					while (*str == ' ') str++;
					if (*str == 'h' || *str == 'H')
					{
						str++;
						i = tty_resistancedlog("CCVS", paramstart, str);
						if (i == 0) return(0);
						us_pushhighlight();
						us_clearhighlightcount();
						startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)initinfstr();
						for(pt = (char *)high->fromvar->addr; pt != str; pt++)
							(void)addtoinfstr(*pt);
						(void)addstringtoinfstr(paramstart[0]);
						(void)setvalkey(high->fromgeom->entryaddr.blind, objtype, sch_twoportkey,
							(INTBIG)returninfstr(), high->fromvar->type);
						endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)us_pophighlight(0);
						return(1);
					} else if (*str == 'g' || *str == 'G')
					{
						str++;
						i = tty_vccsdlog(paramstart, str);
						if (i == 0) return(0);
						us_pushhighlight();
						us_clearhighlightcount();
						startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)initinfstr();
						for(pt = (char *)high->fromvar->addr; pt != str; pt++)
							(void)addtoinfstr(*pt);
						(void)addstringtoinfstr(paramstart[0]);
						(void)setvalkey(high->fromgeom->entryaddr.blind, objtype, sch_twoportkey,
							(INTBIG)returninfstr(), high->fromvar->type);
						endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)us_pophighlight(0);
						return(1);
					} else if (*str == 'u' || *str == 'U')
					{
						str++;
						i = tty_gaindlog("VCVS", paramstart, str);
						if (i == 0) return(0);
						us_pushhighlight();
						us_clearhighlightcount();
						startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)initinfstr();
						for(pt = (char *)high->fromvar->addr; pt != str; pt++)
							(void)addtoinfstr(*pt);
						(void)addstringtoinfstr(paramstart[0]);
						(void)setvalkey(high->fromgeom->entryaddr.blind, objtype, sch_twoportkey,
							(INTBIG)returninfstr(), high->fromvar->type);
						endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)us_pophighlight(0);
						return(1);
					} else if (*str == 'f' || *str == 'F')
					{
						str++;
						i = tty_gaindlog("CCCS", paramstart, str);
						if (i == 0) return(0);
						us_pushhighlight();
						us_clearhighlightcount();
						startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)initinfstr();
						for(pt = (char *)high->fromvar->addr; pt != str; pt++)
							(void)addtoinfstr(*pt);
						(void)addstringtoinfstr(paramstart[0]);
						(void)setvalkey(high->fromgeom->entryaddr.blind, objtype, sch_twoportkey,
							(INTBIG)returninfstr(), high->fromvar->type);
						endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)us_pophighlight(0);
						return(1);
					}
				}
				if (high->fromvar->key == sch_transistortypekey)
				{
					str = (char *)high->fromvar->addr;
					haslw = trandessize = 0;
					if (namesamen(str, "nmos", 4) == 0)  { trandessize = 4;  haslw = 1;   } else
					if (namesamen(str, "dmos", 4) == 0)  { trandessize = 4;  haslw = 1;   } else
					if (namesamen(str, "pmos", 4) == 0)  { trandessize = 4;  haslw = 1;   } else
					if (namesamen(str, "npn", 3) == 0)   { trandessize = 3;  } else
					if (namesamen(str, "pnp", 3) == 0)   { trandessize = 3;  } else
					if (namesamen(str, "njfet", 5) == 0) { trandessize = 5;  } else
					if (namesamen(str, "pjfet", 5) == 0) { trandessize = 5;  } else
					if (namesamen(str, "dmes", 4) == 0)  { trandessize = 4;  } else
					if (namesamen(str, "emes", 4) == 0)  { trandessize = 4;  }
					if (haslw != 0)
					{
						i = tty_widlendlog(paramstart, &str[trandessize]);
						if (i == 0) return(0);
						us_pushhighlight();
						us_clearhighlightcount();
						startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)initinfstr();
						for(i=0; i<trandessize; i++) (void)addtoinfstr(str[i]);
						(void)addstringtoinfstr(paramstart[0]);
						(void)setvalkey(high->fromgeom->entryaddr.blind, objtype,
							sch_transistortypekey, (INTBIG)returninfstr(), high->fromvar->type);
						endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)us_pophighlight(0);
						return(1);
					} else if (trandessize != 0)
					{
						i = tty_areadlog("Transistor", paramstart, &str[trandessize]);
						if (i == 0) return(0);
						us_pushhighlight();
						us_clearhighlightcount();
						startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)initinfstr();
						for(i=0; i<trandessize; i++) (void)addtoinfstr(str[i]);
						(void)addstringtoinfstr(paramstart[0]);
						(void)setvalkey(high->fromgeom->entryaddr.blind, objtype,
							sch_transistortypekey, (INTBIG)returninfstr(), high->fromvar->type);
						endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);
						(void)us_pophighlight(0);
						return(1);
					}
				}
			}

			/* display the text dialog box */
			if (DiaInitDialog(&usr_showtextdialog) != 0) return(0);
			DiaSetPopup(5, 12, sizenames);

			(void)initinfstr();
			if (high->fromgeom->entrytype == OBJNODEINST)
			{
				if (high->fromgeom->entryaddr.ni->proto == gen_invispinprim)
					(void)addstringtoinfstr("Text on Message Node"); else
				{
					(void)addstringtoinfstr("Text on node ");
					(void)addstringtoinfstr(describenodeinst(high->fromgeom->entryaddr.ni));
				}
			} else
			{
				(void)addstringtoinfstr("Text on arc ");
				(void)addstringtoinfstr(describearcinst(high->fromgeom->entryaddr.ai));
			}
			DiaSetText(26, returninfstr());
			index = -1;
			if ((high->fromvar->type&VISARRAY) != 0)
			{
				if (getlength(high->fromvar) == 1) index = 0;
			} else skipchrs = (high->fromvar->type&VLENGTH) >> VLENGTHSH;
			str = describevariable(high->fromvar, (INTSML)index, -1);
			descript = high->fromvar->textdescript;
			DiaSetText(-4, &str[skipchrs]);
			DiaEditControl(4);
		} else if (high->fromport != NOPORTPROTO)
		{
			/* display the port dialog box */
			if (DiaInitDialog(&usr_portinfodialog) != 0) return(0);
			DiaSetPopup(5, 12, sizenames);
			DiaSetPopup(27, 15, charnames);

			str = high->fromport->protoname;
			descript = high->fromport->textdescript;
			objtype = VNODEINST;

			/* set the port characteristics button */
			for(i=0; i<15; i++)
				if (charlist[i] == (high->fromport->userbits&STATEBITS))
			{
				DiaSetPopupEntry(27, i);
				break;
			}
			if ((high->fromport->userbits&PORTDRAWN) != 0) DiaSetControl(29, 1);
			if ((high->fromport->userbits&BODYONLY) != 0) DiaSetControl(30, 1);
			DiaSetText(-4, str);
			DiaEditControl(4);
		} else if (high->fromgeom->entrytype == OBJNODEINST)
		{
			/* display the text dialog box */
			if (DiaInitDialog(&usr_showtextdialog) != 0) return(0);
			DiaSetPopup(5, 12, sizenames);

			ni = high->fromgeom->entryaddr.ni;
			str = describenodeproto(ni->proto);
			descript = ni->textdescript;
			objtype = VNODEINST;
			DiaNoEditControl(4);
			DiaSetText(4, str);
			DiaSetText(26, "Text information for facet name:");
		} else return(0);

		/* set the orientation button */
		for(i=0; i<10; i++)
			if (poslist[i].value == (descript&VTPOSITION))
		{
			DiaSetControl(poslist[i].button, 1);
			break;
		}

		/* set the size button */
		for(i=0; i<12; i++)
			if (sizelist[i] == ((descript&VTSIZE) >> VTSIZESH))
		{
			DiaSetPopupEntry(5, i);
			break;
		}

		/* set offsets */
		lambda = figurelambda(high->fromgeom);
		i = (descript&VTXOFF) >> VTXOFFSH;
		if ((descript&VTXOFFNEG) != 0) i = -i;
		DiaSetText(17, latoa(i * lambda / 4));
		j = (descript&VTYOFF) >> VTYOFFSH;
		if ((descript&VTYOFFNEG) != 0) j = -j;
		DiaSetText(18, latoa(j * lambda / 4));

		/* loop until done */
		changed = 0;
		for(;;)
		{
			itemHit = DiaNextHit();
			if (itemHit == OK || itemHit == CANCEL) break;
			if (itemHit >= 21 && itemHit <= 25)
			{
				DiaItemRect(itemHit, &itemRect);
				DiaGetMouse(&x, &y);
				itemHit = (itemHit-21) * 2;
				if (y > (itemRect.top + itemRect.bottom) / 2) itemHit++;
				itemHit = poslist[itemHit].button;
			}
			for(i=0; i<10; i++) if (itemHit == poslist[i].button)
			{
				for(j=0; j<10; j++) DiaSetControl(poslist[j].button, 0);
				DiaSetControl(itemHit, 1);
				changed++;
				continue;
			}
			if (itemHit == 29 || itemHit == 30)
			{
				DiaSetControl(itemHit, (INTSML)(1-DiaGetControl(itemHit)));
				changed++;
			}
			if (itemHit == 5 || itemHit == 27 || itemHit == 17 || itemHit == 18) changed++;
		}

		if (itemHit != CANCEL)
		{
			/* get new port characteristics if applicable */
			if (high->fromvar == NOVARIABLE && high->fromport != NOPORTPROTO && changed != 0)
			{
				newbit = high->fromport->userbits;
				i = DiaGetPopupEntry(27);
				newbit = (newbit & ~STATEBITS) | charlist[i];
				if (DiaGetControl(29) == 0) newbit &= ~PORTDRAWN; else
					newbit |= PORTDRAWN;
				if (DiaGetControl(30) == 0) newbit &= ~BODYONLY; else
					newbit |= BODYONLY;
				if (newbit != high->fromport->userbits)
				{
					high->fromport->userbits = newbit;
					changeallports(high->fromport);
				}
			}

			/* get the new descriptor */
			if (changed != 0)
			{
				xcur = atola(DiaGetText(17));
				ycur = atola(DiaGetText(18));
				newdescript = us_setdescriptoffset(descript, xcur*4/lambda, ycur*4/lambda);
				j = DiaGetPopupEntry(5);
				newdescript = (newdescript & ~VTSIZE) | (sizelist[j] << VTSIZESH);
				for(j=0; j<10; j++)
					if (DiaGetControl(poslist[j].button) != 0) break;
				newdescript = (newdescript & ~VTPOSITION) | poslist[j].value;
			} else newdescript = descript;

			/* get the new name */
			newstr = DiaGetText(4);

			/* see if changes were made */
			if (newdescript != descript || strcmp(&str[skipchrs], newstr) != 0)
			{
				/* save highlighting */
				us_pushhighlight();
				us_clearhighlightcount();

				/* set the new descriptor */
				startobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);

				/* handle changes */
				if (newdescript != descript) us_modifytextdescript(high, newdescript);
				if (strcmp(&str[skipchrs], newstr) != 0)
				{
					/* message field changed */
					var = high->fromvar;
					if (var != NOVARIABLE)
					{
						switch (var->type&VTYPE)
						{
							case VINTEGER:
							case VSHORT:   newval = myatoi(newstr);   break;
							case VSTRING:
								if (skipchrs == 0) newval = (INTBIG)newstr; else
								{
									(void)initinfstr();
									for(j=0; j<skipchrs; j++) (void)addtoinfstr(str[j]);
									(void)addstringtoinfstr(newstr);
									newval = (INTBIG)returninfstr();
								}
								break;
							case VFLOAT:
							case VDOUBLE:  newval = castint(atof(newstr)); break;
						}
						if ((var->type&VISARRAY) == 0)
						{
							(void)setval(high->fromgeom->entryaddr.blind, objtype,
								makename(var->key), newval, var->type);
						} else
						{
							(void)setind(high->fromgeom->entryaddr.blind, objtype,
								makename(var->key), 0, newval);
						}
					} else if (high->fromport != NOPORTPROTO)
					{
						us_renameport(high->fromport, newstr);
					}
				}

				/* redisplay the text */
				endobjectchange((INTBIG)high->fromgeom->entryaddr.blind, objtype);

				/* restore highlighting */
				(void)us_pophighlight(1);
			}
		}
		DiaDoneDialog();
		paramstart[0] = "x";
		return(1);
	}

	if ((high->status&HIGHTYPE) != HIGHFROM) return(0);
	if (high->fromgeom->entrytype == OBJARCINST)
	{
		/* arc getinfo */
		ai = (ARCINST *)high->fromgeom->entryaddr.ai;
		if (DiaInitDialog(&usr_showarcdialog) != 0) return(0);

		/* set prototype name */
		DiaSetText(5, ai->proto->protoname);

		/* load the network and arc names if any */
		var = getvalkey((INTBIG)ai, VARCINST, VSTRING, el_arc_name);
		if (var != NOVARIABLE)
		{
			str = (char *)var->addr;
			DiaSetText(-7, str);
		} else str = "";
		if (ai->network != NONETWORK && ai->network->namecount != 0)
			DiaSetText(6, describenetwork(ai->network)); else
				DiaSetText(6, "*** NONE ***");

		/* load the width */
		oldwid = ai->width - arcwidthoffset(ai->proto);
		DiaSetText(27, latoa(oldwid));

		/* load the position */
		(void)sprintf(ent, "(%s,%s)", latoa(ai->end[1].xpos), latoa(ai->end[1].ypos));
		DiaSetText(9, ent);
		(void)sprintf(ent, "(%s,%s)", latoa(ai->end[0].xpos), latoa(ai->end[0].ypos));
		DiaSetText(11, ent);

		/* load angle */
		(void)sprintf(ent, " %d", (ai->userbits&AANGLE) >> AANGLESH);
		DiaSetText(8, ent);

		/* load bus width if any */
		if (ai->network != NONETWORK && ai->network->signals > 1)
		{
			(void)sprintf(ent, " %d", ai->network->signals);
			DiaSetText(10, ent);
		} else DiaSetText(10, "N/A");

		/* set the constraint buttons */
		if (el_curconstraint == cla_constraint)
		{
			oldrigstate = 1;
			if (((ai->userbits&FIXED) == 0 || ai->changed == cla_changeclock+3) &&
				ai->changed != cla_changeclock+2)
			{
				if (ai->changed == cla_changeclock+3) oldrigstate = 3;
			} else
			{
				if (ai->changed == cla_changeclock+2) oldrigstate = 2; else
					oldrigstate = 0;
			}
			switch (oldrigstate)
			{
				case 0: DiaSetControl(3, 1);    break;
				case 1:                         break;
				case 2: DiaSetControl(3, 1);
				case 3: DiaSetControl(26, 1);   break;
			}
			if ((ai->userbits&FIXANG) != 0) DiaSetControl(4, 1);
			if ((ai->userbits&CANTSLIDE) == 0) DiaSetControl(19, 1);
		} else
		{
			DiaDimItem(3);
			DiaDimItem(4);
			DiaDimItem(19);
			DiaDimItem(26);
			newstr = (char *)(*(el_curconstraint->request))("describearc", (INTBIG)ai);
			if (*newstr != 0)
			{
				(void)initinfstr();
				(void)addstringtoinfstr("Constraint: ");
				(void)addstringtoinfstr(newstr);
				DiaSetText(29, returninfstr());
			}
		}
		if ((ai->userbits&ISNEGATED) != 0) DiaSetControl(20, 1);
		if ((ai->userbits&ISDIRECTIONAL) != 0) DiaSetControl(21, 1);
		if ((ai->userbits&NOEXTEND) == 0) DiaSetControl(22, 1);
		if ((ai->userbits&NOTEND1) != 0) DiaSetControl(23, 1);
		if ((ai->userbits&NOTEND0) != 0) DiaSetControl(24, 1);
		if ((ai->userbits&REVERSEEND) != 0) DiaSetControl(25, 1);

		/* loop until done */
		changed = 0;
		for(;;)
		{
			itemHit = DiaNextHit();
			if (itemHit == OK || itemHit == CANCEL) break;
			if (itemHit == 3 || itemHit == 4 || itemHit == 19 || itemHit == 20 || itemHit == 21 ||
				itemHit == 22 || itemHit == 23 || itemHit == 24 || itemHit == 25 || itemHit == 26)
			{
				DiaSetControl(itemHit, (INTSML)(1-DiaGetControl(itemHit)));
				changed++;
			}
			if (itemHit == 7 || itemHit == 27) changed++;
		}

		if (itemHit != CANCEL && changed != 0)
		{
			us_pushhighlight();
			us_clearhighlightcount();
			startobjectchange((INTBIG)ai, VARCINST);
			wid = atola(DiaGetText(27));
			if (wid != oldwid && wid >= 0)
			{
				wid = arcwidthoffset(ai->proto) + wid;
				if (wid != ai->width)
				{
					startobjectchange((INTBIG)ai, VARCINST);
					(void)modifyarcinst(ai, wid - ai->width, 0, 0, 0, 0);
					endobjectchange((INTBIG)ai, VARCINST);
				}
			}
			if (DiaGetControl(3) == 0)
			{
				if (DiaGetControl(26) == 0) rigstate = 1; else
					rigstate = 3;
			} else
			{
				if (DiaGetControl(26) == 0) rigstate = 0; else
					rigstate = 2;
			}
			if (rigstate != oldrigstate) switch (rigstate)
			{
				case 0:
					(void)(*el_curconstraint->setobject)((INTBIG)ai,VARCINST,8,0);
					(void)(*el_curconstraint->setobject)((INTBIG)ai,VARCINST,0,0);
					break;
				case 1:
					(void)(*el_curconstraint->setobject)((INTBIG)ai,VARCINST,8,0);
					(void)(*el_curconstraint->setobject)((INTBIG)ai,VARCINST,1,0);
					break;
				case 2:
					(void)(*el_curconstraint->setobject)((INTBIG)ai,VARCINST,6,0);
					break;
				case 3:
					(void)(*el_curconstraint->setobject)((INTBIG)ai,VARCINST,7,0);
					break;
			}
			i = DiaGetControl(4);
			if (i != 0 && (ai->userbits&FIXANG) == 0)
				(void)(*el_curconstraint->setobject)((INTBIG)ai,VARCINST,2,0);
			if (i == 0 && (ai->userbits&FIXANG) != 0)
				(void)(*el_curconstraint->setobject)((INTBIG)ai,VARCINST,3,0);
			i = DiaGetControl(19);
			if (i != 0 && (ai->userbits&CANTSLIDE) != 0)
				(void)(*el_curconstraint->setobject)((INTBIG)ai,VARCINST,4,0);
			if (i == 0 && (ai->userbits&CANTSLIDE) == 0)
				(void)(*el_curconstraint->setobject)((INTBIG)ai,VARCINST,5,0);
			i = DiaGetControl(20);
			if (i != 0 && (ai->userbits&ISNEGATED) == 0)
				(void)setval((INTBIG)ai, VARCINST,"userbits", ai->userbits | ISNEGATED, VINTEGER);
			if (i == 0 && (ai->userbits&ISNEGATED) != 0)
				(void)setval((INTBIG)ai, VARCINST,"userbits", ai->userbits & ~ISNEGATED, VINTEGER);
			i = DiaGetControl(21);
			if (i != 0 && (ai->userbits&ISDIRECTIONAL) == 0)
				(void)setval((INTBIG)ai, VARCINST, "userbits", ai->userbits | ISDIRECTIONAL, VINTEGER);
			if (i == 0 && (ai->userbits&ISDIRECTIONAL) != 0)
				(void)setval((INTBIG)ai, VARCINST, "userbits", ai->userbits & ~ISDIRECTIONAL, VINTEGER);
			i = DiaGetControl(22);
			if (i != 0 && (ai->userbits&NOEXTEND) != 0)
				(void)setval((INTBIG)ai, VARCINST, "userbits", ai->userbits & ~NOEXTEND, VINTEGER);
			if (i == 0 && (ai->userbits&NOEXTEND) == 0)
				(void)setval((INTBIG)ai, VARCINST, "userbits", ai->userbits | NOEXTEND, VINTEGER);
			i = DiaGetControl(23);
			if (i != 0 && (ai->userbits&NOTEND1) == 0)
				(void)setval((INTBIG)ai, VARCINST, "userbits", ai->userbits | NOTEND1, VINTEGER);
			if (i == 0 && (ai->userbits&NOTEND1) != 0)
				(void)setval((INTBIG)ai, VARCINST, "userbits", ai->userbits & ~NOTEND1, VINTEGER);
			i = DiaGetControl(24);
			if (i != 0 && (ai->userbits&NOTEND0) == 0)
				(void)setval((INTBIG)ai, VARCINST, "userbits", ai->userbits | NOTEND0, VINTEGER);
			if (i == 0 && (ai->userbits&NOTEND0) != 0)
				(void)setval((INTBIG)ai, VARCINST, "userbits", ai->userbits & ~NOTEND0, VINTEGER);
			i = DiaGetControl(25);
			if (i != 0 && (ai->userbits&REVERSEEND) == 0)
				(void)setval((INTBIG)ai, VARCINST, "userbits", ai->userbits | REVERSEEND, VINTEGER);
			if (i == 0 && (ai->userbits&REVERSEEND) != 0)
				(void)setval((INTBIG)ai, VARCINST, "userbits", ai->userbits & ~REVERSEEND, VINTEGER);
			newstr = DiaGetText(7);
			while (*newstr == ' ') newstr++;
			if (strcmp(str, newstr) != 0)
			{
				if (*newstr == 0) us_setarcname(ai, (char *)0); else
					us_setarcname(ai, newstr);
			}
			endobjectchange((INTBIG)ai, VARCINST);
			(void)us_pophighlight(0);
		}
		DiaDoneDialog();
		paramstart[0] = "x";
		return(1);
	}

	/* node getinfo: display the dialog box */
	ni = (NODEINST *)high->fromgeom->entryaddr.ni;
	np = ni->proto;
	if (DiaInitDialog(&usr_shownodedialog) != 0) return(0);
	DiaInitTextDialog(3, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1, SCHORIZBAR);
	DiaNoEditControl(22);

	/* load the prototype name */
	DiaSetText(6, describenodeproto(np));

	/* load the node name if any */
	var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, el_node_name);
	if (var != NOVARIABLE)
	{
		namestr = (char *)var->addr;
		DiaSetText(-7, namestr);
	} else namestr = "";

	/* load the size */
	xyrev = 0;
	if (ni->transpose == 0)
	{
		if (ni->rotation == 900 || ni->rotation == 2700) xyrev = 1;
	} else
	{
		if (ni->rotation == 0 || ni->rotation == 1800) xyrev = 1;
	}
	nodesizeoffset(np, &plx, &ply, &phx, &phy);
	if (xyrev == 0)
	{
		DiaSetText(8, latoa(ni->highx-ni->lowx-plx-phx));
		DiaSetText(9, latoa(ni->highy-ni->lowy-ply-phy));
	} else
	{
		DiaSetText(9, latoa(ni->highx-ni->lowx-plx-phx));
		DiaSetText(8, latoa(ni->highy-ni->lowy-ply-phy));
	}

	/* load the position */
	corneroffset(ni, ni->proto, ni->rotation, ni->transpose, &cox, &coy);
	DiaSetText(12, latoa(ni->lowx+cox));
	DiaSetText(13, latoa(ni->lowy+coy));

	/* load rotation */
	DiaSetText(10, frtoa(ni->rotation*WHOLE/10));
	if (ni->transpose != 0) DiaSetControl(11, 1);

	/* set the expansion button */
	if (np->index == 0)
	{
		if ((ni->userbits&NEXPAND) != 0) i = 4; else i = 5;
		DiaSetControl(i, 1);
		DiaNoEditControl(8);
		DiaNoEditControl(9);
	} else
	{
		DiaDimItem(4);
		DiaDimItem(5);
		DiaEditControl(8);
		DiaEditControl(9);
	}

	/* load special features, if any */
	serpwidth = -1;
	if (np->index != 0 && (np->userbits&HOLDSTRACE) != 0)
	{
		fun = (np->userbits&NFUNCTION) >> NFUNCTIONSH;
		if (fun == NPTRANMOS || fun == NPTRADMOS || fun == NPTRAPMOS)
		{
			var = getvalkey((INTBIG)ni, VNODEINST, VINTEGER|VISARRAY, el_trace);
			if (var != NOVARIABLE)
			{
				transistorsize(ni, &len, &wid);
				if (len != -1 && wid != -1)
				{
					DiaSetText(23, "Transistor Width:");
					DiaSetText(24, latoa(wid));
					DiaEditControl(22);
					DiaSetText(25, "Transistor Length:");
					DiaSetText(22, latoa(len));
					serpwidth = len;
				}
			}
		}
	}
	var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_diodekey);
	if (var != NOVARIABLE)
	{
		str = (char *)var->addr;
		while (*str == ' ') str++;
		if (*str == 'z' || *str == 'Z') str++;
		DiaEditControl(22);
		DiaSetText(25, "Diode size");
		DiaSetText(22, str);
	}
	var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_capacitancekey);
	if (var != NOVARIABLE)
	{
		str = (char *)var->addr;
		while (*str == ' ') str++;
		if (*str == 'e' || *str == 'E') str++;
		DiaEditControl(22);
		DiaSetText(25, "Capacitance:");
		DiaSetText(22, str);
	}
	var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_resistancekey);
	if (var != NOVARIABLE)
	{
		DiaEditControl(22);
		DiaSetText(25, "Resistance:");
		DiaSetText(22, (char *)var->addr);
	}
	var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_inductancekey);
	if (var != NOVARIABLE)
	{
		DiaEditControl(22);
		DiaSetText(25, "Inductance:");
		DiaSetText(22, (char *)var->addr);
	}
	var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_functionkey);
	if (var != NOVARIABLE)
	{
		DiaEditControl(22);
		DiaSetText(25, "Function:");
		DiaSetText(22, (char *)var->addr);
	}
	var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_sourcekey);
	if (var != NOVARIABLE)
	{
		str = (char *)var->addr;
		for(i=0; str[i] != 0 && str[i] != '/'; i++) ent[i] = str[i];
		if (str[i] == '/') ent[i++] = 0; else ent[i=0] = 0;
		DiaEditControl(22);
		if (namesame(ent, "v") == 0) DiaSetText(25, "Voltage SPICE Card"); else
		if (namesame(ent, "c") == 0) DiaSetText(25, "Current SPICE Card"); else
		if (namesame(ent, "vt") == 0) DiaSetText(25, "Transient SPICE Card"); else
			DiaSetText(25, "SPICE card:");
		DiaSetText(22, &str[i]);
	}
	var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_twoportkey);
	if (var != NOVARIABLE)
	{
		DiaEditControl(22);
		str = (char *)var->addr;
		while (*str == ' ') str++;
		switch (*str)
		{
			case 'g': DiaSetText(25, "VCCS transconductance:");   break;
			case 'h': DiaSetText(25, "CCVS transresistance:");    break;
			case 'u': DiaSetText(25, "VCVS gain:");               break;
			case 'f': DiaSetText(25, "CCCS gain:");               break;
			case 'l': DiaSetText(25, "Transmission value:");      break;
		}
		DiaSetText(22, &str[1]);
	}
	var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_transistortypekey);
	if (var != NOVARIABLE)
	{
		str = (char *)var->addr;
		next = "";
		haslw = 0;
		trandessize = 0;
		if (namesamen(str, "nmos", 4) == 0)  { trandessize = 4;  haslw = 1;   next = "N-type MOS"; } else
		if (namesamen(str, "dmos", 4) == 0)  { trandessize = 4;  haslw = 1;   next = "Depletion MOS"; } else
		if (namesamen(str, "pmos", 4) == 0)  { trandessize = 4;  haslw = 1;   next = "P-type MOS"; } else
		if (namesamen(str, "npn", 3) == 0)   { trandessize = 3;  next = "NPN Bipolar"; } else
		if (namesamen(str, "pnp", 3) == 0)   { trandessize = 3;  next = "PNP Bipolar"; } else
		if (namesamen(str, "njfet", 5) == 0) { trandessize = 5;  next = "N-type JFET"; } else
		if (namesamen(str, "pjfet", 5) == 0) { trandessize = 5;  next = "P-type JFET"; } else
		if (namesamen(str, "dmes", 4) == 0)  { trandessize = 4;  next = "Depletion MESFET"; } else
		if (namesamen(str, "emes", 4) == 0)  { trandessize = 4;  next = "Enhancement MESFET"; }
		if (*next != 0)
		{
			DiaSetText(23, "Transistor type:");
			DiaSetText(24, next);
			if (haslw != 0) DiaSetText(25, "Width/Length:"); else
				DiaSetText(25, "Area:");
			DiaEditControl(22);
			DiaSetText(22, &str[trandessize]);
		}
	}
	if (np->index != 0 && np->tech == art_tech)
	{
		DiaSetText(23, "Color:");
		var = getvalkey((INTBIG)ni, VNODEINST, VINTEGER, art_colorkey);
		if (var == NOVARIABLE) DiaSetText(24, "Black"); else
			switch (var->addr)
		{
			case LAYERT1: DiaSetText(24, "Overlappable-1");   break;
			case LAYERT2: DiaSetText(24, "Overlappable-2");   break;
			case LAYERT3: DiaSetText(24, "Overlappable-3");   break;
			case LAYERT4: DiaSetText(24, "Overlappable-4");   break;
			case LAYERT5: DiaSetText(24, "Overlappable-5");   break;
			case WHITE:   DiaSetText(24, "White");            break;
			case BLACK:   DiaSetText(24, "Black");            break;
			case RED:     DiaSetText(24, "Red");              break;
			case BLUE:    DiaSetText(24, "Blue");             break;
			case GREEN:   DiaSetText(24, "Green");            break;
			case CYAN:    DiaSetText(24, "Cyan");             break;
			case MAGENTA: DiaSetText(24, "Magenta");          break;
			case YELLOW:  DiaSetText(24, "Yellow");           break;
			case GRAY:    DiaSetText(24, "Gray");             break;
			case ORANGE:  DiaSetText(24, "Orange");           break;
			case PURPLE:  DiaSetText(24, "Purple");           break;
			case BROWN:   DiaSetText(24, "Brown");            break;
			case LGRAY:   DiaSetText(24, "Light Gray");       break;
			case DGRAY:   DiaSetText(24, "Dark Gray");        break;
			case LRED:    DiaSetText(24, "Light Red");        break;
			case DRED:    DiaSetText(24, "Dark Red");         break;
			case LGREEN:  DiaSetText(24, "Light Green");      break;
			case DGREEN:  DiaSetText(24, "Dark Green");       break;
			case LBLUE:   DiaSetText(24, "Light Blue");       break;
			case DBLUE:   DiaSetText(24, "Dark Blue");        break;
		}
	}
	i = us_tecedgetoption(ni);
	if (i >= 0)
	{
		DiaSetText(23, "Tech. edit relevance:");
		switch (i)
		{
			case LAYERCOLOR:
				DiaSetText(24, "Color definition");
				break;
			case LAYERSTYLE:
				DiaSetText(24, "Style definition");
				break;
			case LAYERCIF:
				DiaSetText(24, "CIF name");
				break;
			case LAYERFUNCTION:
				DiaSetText(24, "Layer function");
				break;
			case LAYERLETTERS:
				DiaSetText(24, "Layer letters");
				break;
			case LAYERPATTERN:
				DiaSetText(24, "Layer stipple pattern");
				break;
			case LAYERPATCH:
			case HIGHLIGHTOBJ:
				var = getval((INTBIG)ni, VNODEINST, VNODEPROTO, "EDTEC_layer");
				if (var == NOVARIABLE) DiaSetText(24, "UNKNOWN LAYER"); else
				{
					onp = (NODEPROTO *)var->addr;
					if (onp == NONODEPROTO) DiaSetText(24, "Highlight box"); else
					{
						(void)strcpy(ent, "Layer ");
						(void)strcat(ent, &onp->cell->cellname[6]);
						DiaSetText(24, ent);
					}
				}
				break;
			case ARCFUNCTION:
				DiaSetText(24, "Arc function");
				break;
			case NODEFUNCTION:
				DiaSetText(24, "Node function");
				break;
			case ARCFIXANG:
				DiaSetText(24, "Arc fixed-angle factor");
				break;
			case ARCWIPESPINS:
				DiaSetText(24, "Arc coverage");
				break;
			case ARCNOEXTEND:
				DiaSetText(24, "Arc extension");
				break;
			case TECHLAMBDA:
				DiaSetText(24, "Lambda value");
				break;
			case TECHDESCRIPT:
				DiaSetText(24, "Technology description");
				break;
			case NODESERPENTINE:
				DiaSetText(24, "Serpentine transistor");
				break;
			case LAYERDXF:
				DiaSetText(24, "DXF name(s)");
				break;
			case PORTOBJ:
				var = getval((INTBIG)ni, VNODEINST, VSTRING, "EDTEC_portname");
				if (var == NOVARIABLE) DiaSetText(24, "Unnamed port"); else
				{
					(void)strcpy(ent, "Port ");
					(void)strcat(ent, (char *)var->addr);
					DiaSetText(24, ent);
				}
				break;
			case LAYERGDS:
				DiaSetText(24, "GDS-II number");
				break;
			case NODESQUARE:
				DiaSetText(24, "Square node");
				break;
			case NODEWIPES:
				DiaSetText(24, "Dissapearing pin");
				break;
			case ARCINC:
				DiaSetText(24, "Arc angle increment");
				break;
			case NODELOCKABLE:
				DiaSetText(24, "Node lockability");
				break;
			case CENTEROBJ:
				DiaSetText(24, "Grab point");
				break;
		}
	}

	/* load the special-value entries if appropriate */
	if (np == art_circleprim && ni->highx-ni->lowx == ni->highy-ni->lowy)
	{
		DiaSetText(25, "Degrees of circle:");
		getarcdegrees(ni, &startoffset, &endangle);
		DiaEditControl(22);
		i = rounddouble((startoffset+endangle)*180.0/EPI) * WHOLE;
		DiaSetText(22, frtoa(i));
	}

	/* reset the "chat" indicator on the port prototypes */
	for(pp = np->firstportproto; pp != NOPORTPROTO; pp = pp->nextportproto) pp->temp1 = 0;

	/* always describe the highlighted port */
	if (high->fromport != NOPORTPROTO)
		tty_dlogchatportproto(ni, high->fromport);

	/* describe all arcs and ports */
	for(pe = ni->firstportexpinst; pe != NOPORTEXPINST; pe = pe->nextportexpinst)
		tty_dlogchatportproto(ni, pe->proto);
	for(pi = ni->firstportarcinst; pi != NOPORTARCINST; pi = pi->nextportarcinst)
		tty_dlogchatportproto(ni, pi->proto);
	DiaSelectLine(3, -1);

	/* loop until done */
	changed = 0;
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;
		if (itemHit == 11)
		{
			DiaSetControl(11, (INTSML)(1-DiaGetControl(11)));
			changed++;
			continue;
		}
		if (itemHit == 4 || itemHit == 5)
		{
			DiaSetControl(4, 0);   DiaSetControl(5, 0);
			DiaSetControl(itemHit, 1);
			changed++;
			continue;
		}
		if (itemHit == 7 || itemHit == 8 || itemHit == 9 || itemHit == 10 ||
			 itemHit == 12 || itemHit == 13 || itemHit == 22) changed++;
	}

	if (itemHit != CANCEL && changed != 0)
	{
		/* see if size, rotation, or position changed */
		if (xyrev == 0)
		{
			xs = atola(DiaGetText(8));
			ys = atola(DiaGetText(9));
		} else
		{
			xs = atola(DiaGetText(9));
			ys = atola(DiaGetText(8));
		}
		xc = atola(DiaGetText(12));
		yc = atola(DiaGetText(13));
		r = atofr(DiaGetText(10))*10/WHOLE;
		t = (DiaGetControl(11) != 0 ? 1 : 0);
		if (xc != ni->lowx+cox || yc != ni->lowy+coy || r != ni->rotation || t != ni->transpose ||
			xs != ni->highx-ni->lowx-plx-phx || ys != ni->highy-ni->lowy-ply-phy)
		{
			us_pushhighlight();
			us_clearhighlightcount();
			startobjectchange((INTBIG)ni, VNODEINST);
			dx = xc - ni->lowx - cox;   dy = yc - ni->lowy - coy;
			nlx = ni->lowx + dx;
			nhx = nlx + xs + plx + phx;
			nly = ni->lowy + dy;
			nhy = nly + ys + ply + phy;
			modifynodeinst(ni, nlx-ni->lowx, nly-ni->lowy, nhx-ni->highx,
				nhy-ni->highy, (INTSML)(r - ni->rotation), (INTSML)(t - ni->transpose));
			endobjectchange((INTBIG)ni, VNODEINST);
			(void)us_pophighlight(1);
		}

		/* update transistor width if it changed */
		if (serpwidth >= 0)
		{
			newstr = DiaGetText(22);
			while (*newstr == ' ') newstr++;
			if (*newstr != 0 && atola(newstr) != serpwidth)
			{
				us_pushhighlight();
				us_clearhighlightcount();
				startobjectchange((INTBIG)ni, VNODEINST);
				(void)setvalkey((INTBIG)ni, VNODEINST, el_transistor_width, atofr(newstr), VFRACT);
				endobjectchange((INTBIG)ni, VNODEINST);
				(void)us_pophighlight(0);
			}
		}

		/* update diode area if it changed */
		var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_diodekey);
		if (var != NOVARIABLE)
		{
			str = (char *)var->addr;
			while (*str == ' ') str++;
			if (*str == 'z' || *str == 'Z') str++;
			tty_updatenodeinfo(ni, var, "SCHEM_diode", (char *)var->addr, str);
		}

		/* update capacitance if it changed */
		var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_capacitancekey);
		if (var != NOVARIABLE)
		{
			str = (char *)var->addr;
			while (*str == ' ') str++;
			if (*str == 'e' || *str == 'E') str++;
			tty_updatenodeinfo(ni, var, "SCHEM_capacitance", (char *)var->addr, str);
		}

		/* update resistance if it changed */
		var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_resistancekey);
		if (var != NOVARIABLE)
			tty_updatenodeinfo(ni, var, "SCHEM_resistance", (char *)var->addr, (char *)var->addr);

		/* update inductance if it changed */
		var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_inductancekey);
		if (var != NOVARIABLE)
			tty_updatenodeinfo(ni, var, "SCHEM_inductance", (char *)var->addr, (char *)var->addr);

		/* update black-box function if it changed */
		var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_functionkey);
		if (var != NOVARIABLE)
			tty_updatenodeinfo(ni, var, "SCHEM_function", (char *)var->addr, (char *)var->addr);

		/* update source information if it changed */
		var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_sourcekey);
		if (var != NOVARIABLE)
		{
			str = (char *)var->addr;
			while (*str != 0 && *str != '/') str++;
			if (*str == '/') str++; else str = (char *)var->addr;
			tty_updatenodeinfo(ni, var, "SCHEM_source", (char *)var->addr, str);
		}

		/* update two-port information if it changed */
		var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_twoportkey);
		if (var != NOVARIABLE)
		{
			str = (char *)var->addr;
			while (*str == ' ') str++;
			tty_updatenodeinfo(ni, var, "SCHEM_twoport_type", (char *)var->addr, str+1);
		}

		/* update transistor size if it changed */
		var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, sch_transistortypekey);
		if (var != NOVARIABLE)
		{
			str = (char *)var->addr;
			tty_updatenodeinfo(ni, var, "SCHEM_transistor_type", str, &str[trandessize]);
		}

		/* update expansion bit if changed */
		if (np->index == 0)
		{
			i = ni->userbits;
			if (DiaGetControl(4) != 0) i |= NEXPAND; else
				i &= ~NEXPAND;
			if (i != ni->userbits)
			{
				us_pushhighlight();
				us_clearhighlightcount();
				startobjectchange((INTBIG)ni, VNODEINST);
				ni->userbits = i;
				endobjectchange((INTBIG)ni, VNODEINST);
				(void)us_pophighlight(0);
			}
		}

		/* update name if it changed */
		newstr = DiaGetText(7);
		while (*newstr == ' ') newstr++;
		if (strcmp(newstr, namestr) != 0)
		{
			us_pushhighlight();
			us_clearhighlightcount();

			/* change the name of the nodeinst */
			startobjectchange((INTBIG)ni, VNODEINST);
			if (*newstr == 0)
				(void)delvalkey((INTBIG)ni, VNODEINST, el_node_name); else
			{
				var = getvalkey((INTBIG)ni, VNODEINST, VSTRING, el_node_name);
				if (var != NOVARIABLE) descript = var->textdescript; else
					descript = defaulttextdescript();
				var = setvalkey((INTBIG)ni, VNODEINST, el_node_name, (INTBIG)newstr, VSTRING|VDISPLAY);
				if (var != NOVARIABLE) var->textdescript = descript;

				/* shift text down if on a facet instance */
				if (var != NOVARIABLE && np->index == 0)
				{
					var->textdescript = us_setdescriptoffset(var->textdescript,
						0, (ni->highy-ni->lowy) / el_curtech->deflambda);
				}
			}
			endobjectchange((INTBIG)ni, VNODEINST);

			/* restore highlighting */
			(void)us_pophighlight(0);
		}

		/* update the special-value entries if it changed */
		if (np == art_circleprim && ni->highx-ni->lowx == ni->highy-ni->lowy)
		{
			str = DiaGetText(25);
			if (strcmp(str, "Degrees of circle:") == 0)
			{
				newdeg = atofr(DiaGetText(22)) * 10 / WHOLE;
				if (((double)newdeg)/10.0 != (startoffset+endangle)*180.0/EPI)
				{
					us_pushhighlight();
					us_clearhighlightcount();
					startobjectchange((INTBIG)ni, VNODEINST);
					setarcdegrees(ni, startoffset, (double)newdeg * EPI / 1800.0);
					endobjectchange((INTBIG)ni, VNODEINST);
					(void)us_pophighlight(1);
				}
			}
		}
	}
	DiaDoneDialog();
	paramstart[0] = "x";
	return(1);
}

void tty_updatenodeinfo(NODEINST *ni, VARIABLE *var, char *varname, char *wholemessage,
	char *variablepart)
{
	REGISTER char *newstr, *pt;

	newstr = DiaGetText(22);
	if (strcmp(newstr, variablepart) == 0) return;

	us_pushhighlight();
	us_clearhighlightcount();
	startobjectchange((INTBIG)ni, VNODEINST);
	(void)initinfstr();
	for(pt = wholemessage; pt < variablepart; pt++) (void)addtoinfstr(*pt);
	(void)addstringtoinfstr(newstr);
	(void)setval((INTBIG)ni, VNODEINST, varname, (INTBIG)returninfstr(), var->type);
	endobjectchange((INTBIG)ni, VNODEINST);
	(void)us_pophighlight(1);
}

INTSML tty_nulldloglist(char **c) { return(0); }
char *tty_nulldlogitem(void) { return(0); }
void tty_nulldlogdone(void) {}

/*
 * routine to display information about port prototype "pp" on nodeinst "ni".
 * If the port prototype's "temp1" is nonzero, this port has already been
 * mentioned and should not be done again.
 */
void tty_dlogchatportproto(NODEINST *ni, PORTPROTO *pp)
{
	REGISTER PORTARCINST *pi;
	REGISTER PORTEXPINST *pe;
	REGISTER ARCINST *ai;
	REGISTER INTSML i;
	REGISTER char *activity;
	char line[256];

	/* if this port has already been discussed, quit now */
	if (pp->temp1 != 0) return;
	pp->temp1++;

	/* talk about the port prototype */
	(void)initinfstr();
	activity = us_describeportbits(pp);
	if (*activity != 0)
	{
		(void)addstringtoinfstr(activity);
		(void)addstringtoinfstr(" port ");
	} else (void)addstringtoinfstr("Port ");
	(void)addstringtoinfstr(pp->protoname);
	(void)addstringtoinfstr(" can connect to ");
	for(i=0; pp->connects[i] != NOARCPROTO; i++)
	{
		if (i != 0) (void)addstringtoinfstr(", ");
		(void)addstringtoinfstr(pp->connects[i]->protoname);
	}
	DiaStuffLine(3, returninfstr());

	/* talk about any arcs on this prototype */
	for(pi=ni->firstportarcinst; pi!=NOPORTARCINST; pi=pi->nextportarcinst)
	{
		if (pi->proto != pp) continue;
		ai = pi->conarcinst;
		if (ai->end[0].portarcinst == pi) i = 0; else i = 1;
		(void)sprintf(line, "  Connected at (%s,%s) to %s", latoa(ai->end[i].xpos),
			latoa(ai->end[i].ypos), describearcinst(ai));
		DiaStuffLine(3, line);
	}

	/* talk about any exported ports of this prototype */
	for(pe=ni->firstportexpinst; pe!=NOPORTEXPINST; pe=pe->nextportexpinst)
		if (pe->proto == pp)
	{
		(void)initinfstr();
		(void)addstringtoinfstr("  Exported as ");
		(void)addstringtoinfstr(us_describeportbits(pe->exportproto));
		(void)addstringtoinfstr(" port '");
		(void)addstringtoinfstr(pe->exportproto->protoname);
		(void)addstringtoinfstr("' (label ");
		(void)addstringtoinfstr(us_describetextdescript(pe->exportproto->textdescript));
		if ((pe->exportproto->userbits&PORTDRAWN) != 0) (void)addstringtoinfstr(",always-drawn");
		if ((pe->exportproto->userbits&BODYONLY) != 0) (void)addstringtoinfstr(",only-on-body");
		(void)addtoinfstr(')');
		DiaStuffLine(3, returninfstr());
	}
}

/* special case for the "trace" menu
 * Points    = 3 (user item)
 * X         = 5 (edit text)
 * Y         = 7 (edit text)
 * duplicate = 8 (button)
 * delete    = 9 (button)
 */
INTSML tty_tracedlog(char *paramstart[])
{
	INTSML itemHit, len, i, j, space, changed;
	INTBIG *pts, *newpts, x, y;
	char lne[256];
	HIGHLIGHT *high;
	REGISTER NODEINST *ni;
	REGISTER VARIABLE *var;

	/* make sure there is a highlighted node with trace information */
	high = us_getonehighlight();
	if (high == NOHIGHLIGHT) return(0);
	if ((high->status&HIGHTYPE) != HIGHFROM) return(0);
	if (high->fromgeom->entrytype != OBJNODEINST) return(0);
	ni = (NODEINST *)high->fromgeom->entryaddr.ni;
	if ((ni->proto->userbits&HOLDSTRACE) == 0) return(0);
	var = gettrace(ni);

	/* display the trace dialog box */
	if (DiaInitDialog(&us_tracedialog) != 0) return(0);
	DiaInitTextDialog(3, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1,
		SCSELMOUSE|SCREPORT);

	/* copy trace data and display it */
	if (var == NOVARIABLE) len = 0; else len = getlength(var) / 2;
	x = (ni->highx + ni->lowx) / 2;
	y = (ni->highy + ni->lowy) / 2;
	space = len+1;
	pts = (INTBIG *)emalloc(space * 2 * SIZEOFINTBIG, el_tempcluster);
	for(i=0; i<len; i++)
	{
		pts[i*2] = ((INTBIG *)var->addr)[i*2] + x;
		pts[i*2+1] = ((INTBIG *)var->addr)[i*2+1] + y;
		(void)sprintf(lne, "%d: (%s, %s)", i, latoa(pts[i*2]), latoa(pts[i*2+1]));
		DiaStuffLine(3, lne);
	}
	if (len == 0) DiaSelectLine(3, -1); else
	{
		DiaSelectLine(3, 0);
		DiaSetText(-5, latoa(pts[0]));
		DiaSetText(7, latoa(pts[1]));
	}

	/* loop until done */
	changed = 0;
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL || itemHit == OK) break;
		if (itemHit == 3)
		{
			/* load this point */
			i = DiaGetCurLine(3);
			if (i < 0 || i >= len) continue;
			DiaSetText(5, latoa(pts[i*2]));
			DiaSetText(7, latoa(pts[i*2+1]));
			continue;
		}
		if (itemHit == 8)
		{
			/* duplicate point */
			changed++;
			if (len == 0)
			{
				pts[0] = pts[1] = 0;
				(void)sprintf(lne, "%d: (%s, %s)", 0, latoa(pts[0]), latoa(pts[1]));
				DiaSetScrollLine(3, 0, lne);
				len++;
				continue;
			}

			if (len >= space)
			{
				newpts = (INTBIG *)emalloc((len+1) * 2 * SIZEOFINTBIG, el_tempcluster);
				if (newpts == 0) continue;
				for(i=0; i<len; i++)
				{
					newpts[i*2] = pts[i*2];
					newpts[i*2+1] = pts[i*2+1];
				}
				efree((char *)pts);
				pts = newpts;
				space = len + 1;
			}
			i = DiaGetCurLine(3);
			for(j=len; j>i; j--)
			{
				pts[j*2] = pts[(j-1)*2];
				pts[j*2+1] = pts[(j-1)*2+1];
				(void)sprintf(lne, "%d: (%s, %s)", j, latoa(pts[j*2]), latoa(pts[j*2+1]));
				DiaSetScrollLine(3, j, lne);
			}
			len++;
			continue;
		}
		if (itemHit == 9)
		{
			/* delete point */
			changed++;
			if (len <= 1) continue;
			i = DiaGetCurLine(3);
			for(j=i; j<len-1; j++)
			{
				pts[j*2] = pts[(j+1)*2];
				pts[j*2+1] = pts[(j+1)*2+1];
				(void)sprintf(lne, "%d: (%s, %s)", j, latoa(pts[j*2]), latoa(pts[j*2+1]));
				DiaSetScrollLine(3, j, lne);
			}
			DiaSetScrollLine(3, (INTSML)(len-1), "");
			len--;
			if (i == len) DiaSelectLine(3, (INTSML)(i-1));
			continue;
		}
		if (itemHit == 5 || itemHit == 7)
		{
			i = DiaGetCurLine(3);
			if (i < 0) continue;
			x = atola(DiaGetText(5));
			y = atola(DiaGetText(7));
			if (pts[i*2] == x && pts[i*2+1] == y) continue;
			changed++;
			pts[i*2] = x;   pts[i*2+1] = y;
			(void)sprintf(lne, "%d: (%s, %s)", i, latoa(pts[i*2]), latoa(pts[i*2+1]));
			DiaSetScrollLine(3, i, lne);
			continue;
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL && changed != 0)
	{
		us_pushhighlight();
		us_clearhighlightcount();
		us_settrace(ni, pts, len);
		(void)us_pophighlight(1);
	}
	DiaDoneDialog();
	efree((char *)pts);
	return(1);
}

/*
 * special case for the "spread" menu
 * Distance = 3 (edit text)
 * Up       = 4 (radio button)
 * Down     = 5 (radio button)
 * Left     = 6 (radio button)
 * Right    = 7 (radio button)
 */
INTSML tty_spreaddlog(char *paramstart[])
{
	INTSML itemHit, defdir;

	/* display the array dialog box */
	if (DiaInitDialog(&usr_spreaddialog) != 0) return(0);

	/* "up" is the default direction, distance is 1 */
	DiaSetText(-3, "1");
	defdir = 4;
	DiaSetControl(defdir, 1);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == CANCEL) break;
		if (itemHit == OK && DiaValidEntry(3)) break;
		if (itemHit >= 4 && itemHit <= 7)
		{
			DiaSetControl(defdir, 0);
			defdir = itemHit;
			DiaSetControl(defdir, 1);
		}
	}

	paramstart[0] = "";
	if (itemHit != CANCEL)
	{
		(void)initinfstr();
		switch (defdir)
		{
			case 4: (void)addstringtoinfstr("up ");      break;
			case 5: (void)addstringtoinfstr("down ");    break;
			case 6: (void)addstringtoinfstr("left ");    break;
			case 7: (void)addstringtoinfstr("right ");   break;
		}
		(void)addstringtoinfstr(DiaGetText(3));
		paramstart[0] = returninfstr();
	}
	DiaDoneDialog();
	return(1);
}

/* special case for the "variables" menu
 * Currently highlighted object = 5 (radio button)
 * Current facet                = 6 (radio button)
 * Current cell                 = 7 (radio button)
 * Current library              = 8 (radio button)
 * Current technology           = 9 (radio button)
 * Current aid                  = 10 (radio button)
 * Object type                  = 25 (stat text)
 * Object name                  = 29 (stat text)
 * Object/Attribute Divider bar = 28 (stat text)
 * Attribute name list          = 12 (scroll)
 * Attribute type               = 27 (stat text)
 * Examine                      = 23 (button)
 * Displayable attribute        = 21 (check box)
 * Temporary attribute          = 22 (check box)
 * Array attribute              = 15 (check box)
 * Array index                  = 17 (edit text)
 * New Attribute                = 13 (check box)
 * New Attribute name           = 14 (edit text)
 * Attribute/Value Divider bar  = 3 (stat text)
 * Attribute value              = 19 (edit text)
 * Attribute language           = 31 (popup)
 * Set Attribute                = 18 (button)
 * OK                           = 1 (button)
 * Delete Attribute             = 20 (button)
 * CANCEL (not a button)        = 2 (returned by  tty_modaldialog()
 */
INTBIG tty_possearch, tty_varaddr, tty_curvaraddr;
INTSML tty_vartype, tty_curvartype;
VARIABLE *tty_variablesvar;

INTSML tty_topofvars(char **c)
{
	tty_possearch = initobjlist(tty_varaddr, tty_vartype, 0);
	return(1);
}
char *tty_nextvars(void)
{
	VARIABLE *var;

	return(nextobjectlist(&var, tty_possearch));
}

INTSML tty_variablesdlog(char *paramstart[])
{
	INTSML itemHit, i, j, which, len;
	REGISTER INTBIG search, newval, newtype, *newarray, oldlen, descript;
	char *varname, *name, *newstr, *pp, line[100];
	HIGHLIGHT high;
	VARIABLE *var;
	NODEPROTO *curfacet;
	RECTAREA itemRect;
	static char nullstr[] = "";
	static char *languages[] = {"Not Code", "TCL", "LISP", "MATHEMATICA"};

	/* display the variables dialog box */
	if (DiaInitDialog(&usr_variabledialog) != 0) return(0);
#if LANGTCL == 0
	languages[1] = "TCL (not available)";
#endif
#if LANGLISP == 0
	languages[2] = "LISP (not available)";
#endif
#if LANGMM == 0
	languages[3] = "MATHEMATICA (not available)";
#endif
	DiaSetPopup(31, 4, languages);
	DiaItemRect(28, &itemRect);  DiaDrawRect(&itemRect, 1);
	DiaItemRect(3, &itemRect);   DiaDrawRect(&itemRect, 1);
	DiaNoEditControl(14);
	DiaNoEditControl(17);

	/* presume the current facet or library */
	curfacet = getcurfacet();
	tty_varaddr = (INTBIG)curfacet;
	tty_vartype = VNODEPROTO;
	if (curfacet == NONODEPROTO)
	{
		/* no current facet: cannot select facet/cell */
		DiaDimItem(6);
		DiaDimItem(7);
		tty_varaddr = (INTBIG)el_curlib;
		tty_vartype = VLIBRARY;
	}

	/* see if a single object is highlighted */
	tty_curvaraddr = 0;
	tty_curvartype = VUNKNOWN;
	var = getvalkey((INTBIG)us_aid, VAID, VSTRING|VISARRAY, us_highlighted);
	if (var != NOVARIABLE)
	{
		if (getlength(var) == 1)
		{
			if (us_makehighlight(((char **)var->addr)[0], &high) == 0)
			{
				if ((high.status&HIGHTYPE) == HIGHFROM)
				{
					if (high.fromgeom->entrytype == OBJARCINST) tty_vartype = VARCINST; else
						tty_vartype = VNODEINST;
					tty_curvaraddr = tty_varaddr = high.fromgeom->entryaddr.blind;
					tty_curvartype = tty_vartype;
				}
			}
		}
	}
	if (tty_vartype == VNODEPROTO || tty_vartype == VLIBRARY) DiaDimItem(5);

	/* initialize the attribute list */
	DiaInitTextDialog(12, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1,
		SCSELMOUSE|SCREPORT);
	tty_varestablish(tty_varaddr, tty_vartype, "");

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == 1 || itemHit == 18 || itemHit == 20 || itemHit == 2) break;
		if (itemHit == 12)
		{
			/* select a new attribute name */
			tty_varidentify();
			continue;
		}
		if (itemHit == 13)
		{
			/* want a new variable */
			DiaSetText(14, "");
			i = DiaGetControl(13);
			DiaSetControl(13, (INTSML)(1-i));
			if (i != 0) DiaNoEditControl(14); else DiaEditControl(14);
			DiaSetText(19, "");
			DiaSetText(-14, "");
			DiaUnDimItem(15);
			DiaUnDimItem(21);   DiaUnDimItem(22);
			DiaUnDimItem(31);
			DiaDimItem(23);
			DiaDimItem(20);
			DiaUnDimItem(18);
			continue;
		}
		if (itemHit == 23)
		{
			/* examine the variable */
			which = DiaGetCurLine(12);
			if (which < 0) continue;
			varname = DiaGetScrollLine(12, which);
			search = initobjlist(tty_varaddr, tty_vartype, 0);
			for(;;)
			{
				name = nextobjectlist(&var, search);
				if (name == 0) break;
				if (strcmp(name, varname) == 0)
				{
					if ((var->type&VISARRAY) != 0)
					{
						i = myatoi(DiaGetText(17));
						if (i < 0) i = 0;
						if (i > getlength(var)) i = getlength(var)-1;
						(void)sprintf(line, "%s[%d]", varname, i);
						tty_varestablish(((INTBIG *)var->addr)[i], (INTSML)(var->type&VTYPE), line);
					} else tty_varestablish(var->addr, (INTSML)(var->type&VTYPE), varname);
					break;
				}
			}
			continue;
		}
		if (itemHit == 17)
		{
			/* changing index */
			if (DiaGetControl(13) != 0) continue;
			i = myatoi(DiaGetText(17));
			if (i < 0) i = 0;
			len = getlength(tty_variablesvar);
			if (i >= len) i = len-1;
			DiaSetText(19, describevariable(tty_variablesvar, i, -1));
			continue;
		}
		if (itemHit == 34)
		{
			/* increment index */
			i = myatoi(DiaGetText(17)) + 1;
			if (DiaGetControl(13) == 0)
			{
				len = getlength(tty_variablesvar);
				if (i >= len) i = len-1;
			}
			(void)sprintf(line, "%d", i);
			DiaSetText(17, line);
			if (DiaGetControl(13) == 0)
				DiaSetText(19, describevariable(tty_variablesvar, i, -1));
			continue;
		}
		if (itemHit == 35)
		{
			/* decrement index */
			i = myatoi(DiaGetText(17)) - 1;
			if (i < 0) continue;
			(void)sprintf(line, "%d", i);
			DiaSetText(17, line);
			if (DiaGetControl(13) == 0)
				DiaSetText(19, describevariable(tty_variablesvar, i, -1));
			continue;
		}
		if (itemHit == 5)
		{
			/* want current object */
			tty_varestablish(tty_curvaraddr, tty_curvartype, "");
			continue;
		}
		if (itemHit == 6)
		{
			/* want current facet */
			tty_varestablish((INTBIG)curfacet, VNODEPROTO, "");
			continue;
		}
		if (itemHit == 7)
		{
			/* want current cell */
			tty_varestablish((INTBIG)curfacet->cell, VCELL, "");
			continue;
		}
		if (itemHit == 8)
		{
			/* want current library */
			tty_varestablish((INTBIG)el_curlib, VLIBRARY, "");
			continue;
		}
		if (itemHit == 9)
		{
			/* want current technology */
			tty_varestablish((INTBIG)el_curtech, VTECHNOLOGY, "");
			continue;
		}
		if (itemHit == 10)
		{
			/* want current aid */
			tty_varestablish((INTBIG)us_aid, VAID, "");
			continue;
		}
		if (itemHit == 21)
		{
			/* displayable attribute */
			DiaSetControl(21, (INTSML)(1-DiaGetControl(21)));
			continue;
		}
		if (itemHit == 22)
		{
			/* temporary attribute */
			DiaSetControl(22, (INTSML)(1-DiaGetControl(22)));
			continue;
		}
		if (itemHit == 15)
		{
			/* array attribute */
			i = DiaGetControl(15);
			DiaSetControl(15, (INTSML)(1-i));
			if (i == 0)
			{
				DiaUnDimItem(16);   DiaUnDimItem(17);
				DiaUnDimItem(34);   DiaUnDimItem(35);
				DiaEditControl(17);
				DiaSetText(17, "0");
			} else
			{
				DiaDimItem(16);   DiaDimItem(17);
				DiaDimItem(34);   DiaDimItem(35);
				DiaNoEditControl(17);
				DiaSetText(17, "");
			}
			continue;
		}
	}

	/* handle attribute deletion */
	if (itemHit == 20)
	{
		startobjectchange(tty_varaddr, tty_vartype);
		delvalkey(tty_varaddr, tty_vartype, tty_variablesvar->key);
		endobjectchange(tty_varaddr, tty_vartype);
	}

	/* handle attribute setting */
	if (itemHit == 18)
	{
		/* initialize object to be changed */
		startobjectchange(tty_varaddr, tty_vartype);
		if (DiaGetControl(5) != 0)
		{
			us_pushhighlight();
			us_clearhighlightcount();
		}

		/* get new attribute string */
		newstr = DiaGetText(19);

		/* determine type of attribute */
		if (DiaGetControl(13) != 0)
		{
			/* setting new attribute */
			varname = DiaGetText(14);
			if (isanumber(newstr) == 0) newtype = VSTRING; else
			{
				newtype = VINTEGER;
				for(pp = newstr; *pp != 0; pp++) if (*pp == '.')
				{
					newtype = VFLOAT;
					break;
				}
			}
			if (DiaGetControl(15) != 0) newtype |= VISARRAY;
		} else
		{
			/* modifying existing attribute */
			which = DiaGetCurLine(12);
			if (which >= 0) varname = DiaGetScrollLine(12, which); else
				varname = "";
			newtype = tty_variablesvar->type;
		}
		if (DiaGetControl(21) != 0) newtype |= VDISPLAY; else newtype &= ~VDISPLAY;
		if (DiaGetControl(22) != 0) newtype |= VCANTSET; else newtype &= ~VCANTSET;
		newtype &= ~(VCODE1 | VCODE2);
		switch (DiaGetPopupEntry(31))
		{
			case 1: newtype |= VTCL;           break;
			case 2: newtype |= VLISP;          break;
			case 3: newtype |= VMATHEMATICA;   break;
		}

		/* get proper attribute value */
		newval = (INTBIG)newstr;
		if ((newtype&(VCODE1|VCODE2)) == 0)
		{
			switch (newtype&VTYPE)
			{
				case VINTEGER:
				case VADDRESS:
				case VSHORT:
					newval = myatoi(newstr);
					break;
				case VFRACT:
					newval = atofr(newstr);
					break;
				case VFLOAT:
				case VDOUBLE:
					newval = castint(atof(newstr));
					break;
			}
		}

		/* set the attribute if valid */
		if (*varname != 0)
		{
			/* see if it is an array attribute */
			if (DiaGetControl(15) != 0)
			{
				/* get the array index, examine former attribute */
				which = myatoi(DiaGetText(17));
				if (which < 0) which = 0;
				var = getval(tty_varaddr, tty_vartype, -1, varname);
				if (var == NOVARIABLE)
				{
					/* attribute did not exist: create the array */
					newarray = emalloc(((which+1) * SIZEOFINTBIG), el_tempcluster);
					if (newarray == 0) return(0);
					for(j=0; j<=which; j++) newarray[j] = newval;
					newtype |= VISARRAY | ((which+1)<<VLENGTHSH);
					var = setval(tty_varaddr, tty_vartype, varname, (INTBIG)newarray, newtype);
					if (var != NOVARIABLE) var->textdescript = defaulttextdescript();
					efree((char *)newarray);
				} else if (getlength(var) <= which)
				{
					/* extend existing array attribute */
					oldlen = getlength(var);
					newarray = emalloc(((which+1) * SIZEOFINTBIG), el_tempcluster);
					if (newarray == 0) return(0);
					if ((newtype&VTYPE) == VSTRING)
					{
						for(j=0; j<oldlen; j++)
							(void)allocstring((char **)&newarray[j],
								(char *)((INTBIG *)var->addr)[j], el_tempcluster);
						for(j=oldlen; j<which; j++) newarray[j] = (INTBIG)nullstr;
					} else
					{
						for(j=0; j<oldlen; j++) newarray[j] = ((INTBIG *)var->addr)[j];
						for(j=oldlen; j<which; j++) newarray[j] = 0;
					}
					newarray[which] = newval;
					newtype = (newtype & ~VLENGTH) | ((which+1)<<VLENGTHSH);
					(void)setval(tty_varaddr, tty_vartype, varname, (INTBIG)newarray, newtype);
					if ((newtype&VTYPE) == VSTRING)
						for(j=0; j<oldlen; j++) efree((char *)newarray[j]);
					efree((char *)newarray);
				} else
				{
					/* set a single attribute entry */
					(void)setind(tty_varaddr, tty_vartype, varname, which, newval);
				}
			} else
			{
				/* setting non-array or code attribute */
				var = getval(tty_varaddr, tty_vartype, newtype, varname);
				if (var != NOVARIABLE) descript = var->textdescript; else
					descript = defaulttextdescript();
				var = setval(tty_varaddr, tty_vartype, varname, newval, newtype);
				if (var != NOVARIABLE) var->textdescript = descript;
			}
		}

		/* finish the change */
		if (DiaGetControl(5) != 0) (void)us_pophighlight(1);
		endobjectchange(tty_varaddr, tty_vartype);
	}
	DiaDoneDialog();
	paramstart[0] = "x";
	return(1);
}

void tty_varestablish(INTBIG addr, INTSML type, char *thisname)
{
	INTSML i;

	/* determine which radio button to set */
	for(i=5; i<=10; i++) DiaSetControl(i, 0);
	if (tty_curvaraddr != 0 && addr == tty_curvaraddr && type == tty_curvartype)
	{
		DiaSetControl(5, 1);
		DiaSetText(29, "~");
		thisname = "";
	} else if (getcurfacet() != NONODEPROTO && addr == (INTBIG)getcurfacet() && type == VNODEPROTO)
	{
		DiaSetControl(6, 1);
		DiaSetText(29, "facet:~");
		thisname = "";
	} else if (getcurfacet() != NONODEPROTO && addr == (INTBIG)getcurfacet()->cell && type == VCELL)
	{
		DiaSetControl(7, 1);
		DiaSetText(29, "cell:~");
		thisname = "";
	} else if (addr == (INTBIG)el_curlib && type == VLIBRARY)
	{
		DiaSetControl(8, 1);
		DiaSetText(29, "lib:~");
		thisname = "";
	} else if (addr == (INTBIG)el_curtech && type == VTECHNOLOGY)
	{
		DiaSetControl(9, 1);
		DiaSetText(29, "tech:~");
		thisname = "";
	} else if (addr == (INTBIG)us_aid && type == VAID)
	{
		DiaSetControl(10, 1);
		DiaSetText(29, "aid:~");
		thisname = "";
	}
	if (*thisname != 0)
	{
		(void)initinfstr();
		(void)addstringtoinfstr(DiaGetText(29));
		(void)addtoinfstr('.');
		(void)addstringtoinfstr(thisname);
		DiaSetText(29, returninfstr());
	}
	tty_varaddr = addr;
	tty_vartype = type;
	DiaSetText(25, us_variabletypename(type));
	DiaLoadTextDialog(12, tty_topofvars, tty_nextvars, tty_nulldlogdone, 0);
	tty_varidentify();
}

void tty_varidentify(void)
{
	INTSML which, index, type;
	REGISTER INTBIG search, language;
	char *varname, *name;
	VARIABLE retvar;

	DiaSetControl(13, 0);
	DiaSetText(14, "");
	DiaNoEditControl(14);
	DiaDimItem(15);
	DiaDimItem(31);
	DiaDimItem(18);
	DiaDimItem(20);
	DiaDimItem(21);   DiaDimItem(22);
	DiaDimItem(23);
	DiaDimItem(16);   DiaDimItem(34);   DiaDimItem(35);
	which = DiaGetCurLine(12);
	if (which < 0) return;
	varname = DiaGetScrollLine(12, which);
	search = initobjlist(tty_varaddr, tty_vartype, 0);
	for(;;)
	{
		name = nextobjectlist(&tty_variablesvar, search);
		if (name == 0) break;
		if (strcmp(name, varname) == 0) break;
	}
	if (name == 0) return;

	type = tty_variablesvar->type&VTYPE;
	if ((tty_variablesvar->type&VCREF) == 0)
	{
		DiaUnDimItem(20);   DiaUnDimItem(21);   DiaUnDimItem(22);
		DiaUnDimItem(31);
	}
	if ((tty_variablesvar->type&VCANTSET) == 0) DiaUnDimItem(18);
	DiaSetText(27, us_variabletypename(type));
	if ((tty_variablesvar->type&VDISPLAY) != 0) DiaSetControl(21, 1); else
		DiaSetControl(21, 0);
	if ((tty_variablesvar->type&VDONTSAVE) != 0) DiaSetControl(22, 1); else
		DiaSetControl(22, 0);
	language = tty_variablesvar->type & (VCODE1|VCODE2);
	switch (language)
	{
		case 0:            DiaSetPopupEntry(31, 0);   break;
		case VTCL:         DiaSetPopupEntry(31, 1);   break;
		case VLISP:        DiaSetPopupEntry(31, 2);   break;
		case VMATHEMATICA: DiaSetPopupEntry(31, 3);   break;
	}
	if ((tty_variablesvar->type&VISARRAY) != 0)
	{
		DiaSetControl(15, 1);
		DiaUnDimItem(16);   DiaUnDimItem(34);   DiaUnDimItem(35);
		DiaSetText(17, "0");
		DiaEditControl(17);
		index = 0;
	} else
	{
		DiaSetControl(15, 0);
		DiaSetText(17, "");
		DiaNoEditControl(17);
		index = -1;
	}
	DiaSetText(19, describevariable(tty_variablesvar, index, -1));
	if (language != 0)
	{
		retvar.key = tty_variablesvar->key;
		retvar.type = tty_variablesvar->type & ~(VCODE1|VCODE2);
		retvar.textdescript = tty_variablesvar->textdescript;
		if (doquerry((char *)tty_variablesvar->addr, language, retvar.type, &retvar.addr) != 0)
			retvar.addr = 0;
		DiaSetText(33, describevariable(&retvar, index, -1));
		DiaSetText(32, "Evaluation:");
	} else
	{
		DiaSetText(33, "");
		DiaSetText(32, "");
	}
	if (type != VUNKNOWN && type != VINTEGER && type != VADDRESS && type != VCHAR &&
		type != VSTRING && type != VFLOAT && type != VDOUBLE && type != VFRACT && type != VSHORT)
			DiaUnDimItem(23);
}

/* special case for the "visiblelayers" menu
 * Layers             = 4 (user item)
 * Make all visible   = 6 (button)
 * Make all invisible = 7 (button)
 */
#define LAYERSELEC 0		/* Electric layers */
#define LAYERSDXF  1		/* DXF layers */
#define LAYERSGDS  2		/* GDS layers */

void tty_vislayerloadset(void)
{
	REGISTER NODEINST *ni;
	REGISTER NODEPROTO *np;
	REGISTER VARIABLE *var, *cvar;
	REGISTER INTSML i, dispstyle, layerset;
	REGISTER char *lname, *entry;
	char lbuff[100], lnum[20];

	DiaLoadTextDialog(4, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, 0);
	layerset = DiaGetPopupEntry(9);
	switch (layerset)
	{
		case LAYERSELEC:
			dispstyle = us_getdispstyle(el_curwindow);
			for(i=0; i<el_curtech->layercount; i++)
			{
				(void)initinfstr();
				if ((el_curtech->layers[i]->style[dispstyle]&INVISIBLE) != 0) (void)addtoinfstr(' '); else
					(void)addtoinfstr('>');
				(void)addtoinfstr(' ');
				(void)addstringtoinfstr(layername(el_curtech, i));
				DiaStuffLine(4, returninfstr());
			}
			break;
		case LAYERSDXF:
		case LAYERSGDS:
			np = getcurfacet();
			if (np == NONODEPROTO) break;
			for(ni = np->firstnodeinst; ni != NONODEINST; ni = ni->nextnodeinst)
			{
				if (layerset == LAYERSDXF)
				{
					var = getval((INTBIG)ni, VNODEINST, VSTRING, "IO_dxf_layer");
					if (var == NOVARIABLE) continue;
					lname = (char *)var->addr;
				} else
				{
					var = getval((INTBIG)ni, VNODEINST, VINTEGER, "IO_gds_layer");
					if (var == NOVARIABLE) continue;
					sprintf(lnum, "%d", var->addr);
					lname = lnum;
				}
				for(i=0; ; i++)
				{
					entry = DiaGetScrollLine(4, i);
					if (*entry == 0) break;
					if (namesame(&entry[2], lname) == 0) break;
				}
				if (*entry == 0)
				{
					cvar = getvalkey((INTBIG)ni, VNODEINST, VINTEGER, art_colorkey);
					if (cvar != NOVARIABLE && cvar->addr == 0)
						sprintf(lbuff, "  %s", lname); else
							sprintf(lbuff, "> %s", lname);
					DiaStuffLine(4, lbuff);
				}
			}
			break;
	}
	DiaSelectLine(4, -1);
}

INTSML tty_visiblelayersdlog(char *prompt, char *paramstart[])
{
	INTSML itemHit, i, changes, val, dispstyle, layerset;
	REGISTER NODEINST *ni;
	REGISTER NODEPROTO *np;
	REGISTER VARIABLE *var;
	WINDOW *w;
	char *msg, *entry, *layersets[3], lnum[20], *lname;

	if (us_needwindow()) return(0);

	/* display the visibility dialog box */
	if (DiaInitDialog(&usr_visiblelaydialog) != 0) return(0);
	layersets[LAYERSELEC] = "Electric layers";
	layersets[LAYERSDXF] = "DXF layers";
	layersets[LAYERSGDS] = "GDS layers";
	DiaSetPopup(9, 3, layersets);
	if (namesame(prompt, "DXF") == 0) DiaSetPopupEntry(9, LAYERSDXF); else
		if (namesame(prompt, "GDS") == 0) DiaSetPopupEntry(9, LAYERSGDS);
	DiaInitTextDialog(4, tty_nulldloglist, tty_nulldlogitem, tty_nulldlogdone, -1,
		SCSELMOUSE|SCREPORT);
	tty_vislayerloadset();

	/* loop until done */
	changes = 0;
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;
		if (itemHit == 4)
		{
			/* toggle layer visibility for this layer */
			i = DiaGetCurLine(4);
			msg = DiaGetScrollLine(4, i);
			if (*msg == ' ') *msg = '>'; else *msg = ' ';
			DiaSetScrollLine(4, i, msg);
			DiaSelectLine(4, -1);
			changes++;
			continue;
		}
		if (itemHit == 6 || itemHit == 7)
		{
			/* set visibility for all layers */
			for(i=0; ; i++)
			{
				msg = DiaGetScrollLine(4, i);
				if (*msg == 0) break;
				if (itemHit == 6) *msg = '>'; else *msg = ' ';
				DiaSetScrollLine(4, i, msg);
			}
			changes++;
			continue;
		}
		if (itemHit == 9)
		{
			/* construct new layer set */
			tty_vislayerloadset();
			changes = 0;
			continue;
		}
	}

	if (itemHit != CANCEL && changes != 0)
	{
		layerset = DiaGetPopupEntry(9);
		switch (layerset)
		{
			case LAYERSELEC:
				/* save highlighting */
				us_pushhighlight();

				/* start of change to all display windows */
				for(w = el_topwindow; w != NOWINDOW; w = w->nextwindow)
					if ((w->state&WINDOWTYPE) == DISPWINDOW)
						startobjectchange((INTBIG)w, VWINDOW);

				/* change the layer visibility */
				dispstyle = us_getdispstyle(el_curwindow);
				for(i=0; i<el_curtech->layercount; i++)
				{
					msg = DiaGetScrollLine(4, i);
					val = el_curtech->layers[i]->style[dispstyle];
					if ((val&INVISIBLE) == 0 && *msg == ' ')
					{
						(void)setind((INTBIG)el_curtech->layers[i], VGRAPHICS,
							"style", dispstyle, val | INVISIBLE);
					} else if ((val&INVISIBLE) != 0 && *msg != ' ')
					{
						(void)setind((INTBIG)el_curtech->layers[i], VGRAPHICS,
							"style", dispstyle, val & ~INVISIBLE);
					}
				}

				/* end of change to all display windows (redraws) */
				for(w = el_topwindow; w != NOWINDOW; w = w->nextwindow)
					if ((w->state&WINDOWTYPE) == DISPWINDOW)
						endobjectchange((INTBIG)w, VWINDOW);

				/* restore highlighting */
				(void)us_pophighlight(0);
				break;
			case LAYERSDXF:
			case LAYERSGDS:
				np = getcurfacet();
				if (np == NONODEPROTO) break;
				for(ni = np->firstnodeinst; ni != NONODEINST; ni = ni->nextnodeinst)
				{
					if (layerset == LAYERSDXF)
					{
						var = getval((INTBIG)ni, VNODEINST, VSTRING, "IO_dxf_layer");
						if (var == NOVARIABLE) continue;
						lname = (char *)var->addr;
					} else
					{
						var = getval((INTBIG)ni, VNODEINST, VINTEGER, "IO_gds_layer");
						if (var == NOVARIABLE) continue;
						sprintf(lnum, "%d", var->addr);
						lname = lnum;
					}
					for(i=0; ; i++)
					{
						entry = DiaGetScrollLine(4, i);
						if (*entry == 0) break;
						if (namesame(&entry[2], lname) == 0) break;
					}
					if (*entry != 0)
					{
						startobjectchange((INTBIG)ni, VNODEINST);
						if (entry[0] == '>')
						{
							/* make node visible */
							var = getvalkey((INTBIG)ni, VNODEINST, VINTEGER, art_colorkey);
							if (var != NOVARIABLE && var->addr == 0)
								delvalkey((INTBIG)ni, VNODEINST, art_colorkey);
						} else
						{
							/* make node invisible */
							setvalkey((INTBIG)ni, VNODEINST, art_colorkey, 0, VINTEGER);
						}
						endobjectchange((INTBIG)ni, VNODEINST);
					}
				}
				break;
		}
	}
	DiaDoneDialog();
	paramstart[0] = "x";
	return(1);
}

/*
 * special case for "yes/no" options ("yes" is default)
 * Message = 3 (stat text)
 * Yes = 1     (button)
 * No = 2      (button)
 */
INTSML tty_yesnodlog(char *prompt, char *paramstart[])
{
	INTSML itemHit, oldplease;

	/* display the yes/no dialog box */
	if (DiaInitDialog(&usr_yesnodialog) != 0) return(0);

	/* load the message */
	DiaSetText(3, prompt);

	/* loop until done */
	oldplease = el_pleasestop;
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == 1 || itemHit == 2) break;
	}
	el_pleasestop = oldplease;

	if (itemHit == 1) paramstart[0] = "yes"; else paramstart[0] = "no";
	DiaDoneDialog();
	return(1);
}

/*
 * special case for "text default" options
 * text size             = 4 (popup)
 * center                = 5 (radio button)
 * bottom                = 6 (radio button)
 * top                   = 7 (radio button)
 * right                 = 8 (radio button)
 * left                  = 3 (radio button)
 * lower right           = 9 (radio button)
 * lower left            = 10 (radio button)
 * upper right           = 11 (radio button)
 * upper left            = 12 (radio button)
 * boxed                 = 13 (radio button)
 * easy to select        = 21 (check box)
 */
INTSML tty_deftextdlog(char *prompt, char *paramstart[])
{
	INTSML itemHit, i, x, y;
	REGISTER VARIABLE *var;
	REGISTER INTBIG grabpoint, font;
	RECTAREA itemRect;
	static char *sizenames[12] = {"4 Points", "6 Points", "8 Points", "10 Points", "12 Points",
		"14 Points", "16 Points", "18 Points", "20 Points", "Small", "Medium", "Large"};
	static INTSML sizelist[12] = {TXT4P, TXT6P, TXT8P, TXT10P, TXT12P, TXT14P, TXT16P,
		TXT18P, TXT20P, TXTSMALL, TXTMEDIUM, TXTLARGE};
	static struct butlist poslist[10] =
	{
		{VTPOSCENT,       5},
		{VTPOSUP,         6},
		{VTPOSDOWN,       7},
		{VTPOSLEFT,       8},
		{VTPOSRIGHT,      3},
		{VTPOSUPLEFT,     9},
		{VTPOSUPRIGHT,   10},
		{VTPOSDOWNLEFT,  11},
		{VTPOSDOWNRIGHT, 12},
		{VTPOSBOXED,     13}
	};

	/* display the default text dialog box */
	if (DiaInitDialog(&us_deftextdialog) != 0) return(0);
	DiaSetPopup(4, 12, sizenames);

	/* set current defaults */
	var = getval((INTBIG)us_aid, VAID, VINTEGER, "USER_default_text_style");
	if (var == NOVARIABLE) grabpoint = VTPOSCENT; else grabpoint = var->addr;
	for(i=0; i<10; i++) if (grabpoint == poslist[i].value)
	{
		DiaSetControl(poslist[i].button, 1);
		break;
	}

	var = getval((INTBIG)us_aid, VAID, VINTEGER, "USER_default_text_size");
	if (var == NOVARIABLE) font = TXTSMALL; else font = var->addr;
	for(i=0; i<12; i++) if (font == sizelist[i])
	{
		DiaSetPopupEntry(4, i);
		break;
	}

	if ((us_aid->aidstate&NOTEXTSELECT) == 0) DiaSetControl(21, 1);

	/* loop until done */
	for(;;)
	{
		itemHit = DiaNextHit();
		if (itemHit == OK || itemHit == CANCEL) break;

		if (itemHit >= 16 && itemHit <= 20)
		{
			DiaItemRect(itemHit, &itemRect);
			DiaGetMouse(&x, &y);
			itemHit = (itemHit-16) * 2;
			if (y > (itemRect.top + itemRect.bottom) / 2) itemHit++;
			itemHit = poslist[itemHit].button;
		}

		/* hits on the orientation buttons */
		for(i=0; i<10; i++) if (itemHit == poslist[i].button)
		{
			DiaSetControl(poslist[grabpoint].button, 0);
			grabpoint = i;
			DiaSetControl(poslist[i].button, 1);
			break;
		}

		if (itemHit == 21)
		{
			DiaSetControl(21, (INTSML)(1-DiaGetControl(21)));
			continue;
		}
	}

	if (itemHit == OK)
	{
		font = sizelist[DiaGetPopupEntry(4)];
		setval((INTBIG)us_aid, VAID, "USER_default_text_size", font, VINTEGER|VDONTSAVE);
		setval((INTBIG)us_aid, VAID, "USER_default_text_style", grabpoint, VINTEGER|VDONTSAVE);
		if (DiaGetControl(21) != 0)
		{
			(void)setval((INTBIG)us_aid, VAID, "aidstate",
				us_aid->aidstate & ~NOTEXTSELECT, VINTEGER);
		} else
		{
			(void)setval((INTBIG)us_aid, VAID, "aidstate",
				us_aid->aidstate | NOTEXTSELECT, VINTEGER);
		}
	}
	DiaDoneDialog();
	paramstart[0] = "x";
	return(1);
}
