" /*	int sys_gettic(VMSTIME *bintim)  *@  * Similar to SYS$GETTIM, get an idea of the VMS time (quadword)@  * from EXE$GL_ABSTIM_TICS, which is _not_ subject to TICKLENGTH  * adjustments.   *D  * On the very first call, this routine obtains the system time fromC  * SYS$GETTIM() in order to get the offset from EXE$GL_ABSTIM_TICS; B  * afterwards it's independent of (possibly adjusted) system time.  *K  * On VAX, this is just as precise as the system time (resolution = 10 ms).   *H  * On ALPHA, this has the same 10 ms resolution (worse than the 1024 Hz ?  * 	[minimum] hardware tick rate) as on VAX, and as of VMS 6.1, C  *	it's also a little wrong (too slow by 64 ppm for 1024 Hz clock). :  *	The latter error gets corrected #ifdef ALPHA_TICS_FIX .  *  * w.j.m. apr 1995I  * mod 17-may-1995 wjm: do handle (31-bit-)overflow of EXE$GL_ABSTIM_TICS .  *			which occurs once per 248 days of uptime,-  *			_assuming_ that this function is called  (  *			at least once per 248-day interval.<  * mod 31-jul-1995 wjm: ALPHA_TICS_FIX correction factor now  *			computed at runtime.   *  * BUGS:;  *	I've had no chance yet to _test_ the TICS overflow code!   */   ' #define ALPHA_TICS_FIX		/* see above */    #ifdef __alphaD typedef __int64 LLONG;  /* 32-bit value used in 64-bit arithmetic */ #else  typedef int LLONG; #endif   typedef union {  #ifdef __alpha         __int64 q; #endif         int l[2]; 
 } VMSTIME;      static VMSTIME qdif; static LLONG oldtics; ! static int/*logical*/ inited = 0;   / #if defined(__alpha) && defined(ALPHA_TICS_FIX) ) static __int64 tics_fix_num,tics_fix_den;   * extern int get_tickfreq(		/* => 1 if ok */+ 			int *hwfreqp,	/* out: clock frequency */ 5 			int *systickp);	/* out: tick length (10^-7 sec) */  #endif     int sys_gettic(VMSTIME *timadr)  {  	VMSTIME systim,ntics; 	LLONG tics;+ 	globalref volatile int EXE$GL_ABSTIM_TICS;  	int status;    ? 	if(!inited) {	/* find offset from 100000*(EXE$GL_ABSTIM_TICS)   			 * to system time 			 */ 		status = sys$gettim(&systim); " 		if(!(status & 1)) return status;  < 		tics = EXE$GL_ABSTIM_TICS & 0x7FFFFFFF;	/* 31 bits only */ 		oldtics = tics;  #if defined(__alpha) #if defined(ALPHA_TICS_FIX) / 		/* EXE$GL_ABSTIM_TICS "should" be incremented . 		 * exactly 100 times per second (as on VAX)./ 		 * As of VMS AXP V6.1, it is incremented only 2 		 * ((systick * hwfreq) / 10^5) times per second,0 		 * where (systick) is just an approximation to 		 * (10^7 / hwfreq).  		 */    		{	int hwfreq,systick;   + 			status = get_tickfreq(&hwfreq,&systick); # 			if(!(status & 1)) return status;   0 			/* we actually want (num) and (den) such that1 			 *	ntics = (10^12 * tics) / (systick * hwfreq)   			 *	      = (tics *	num) / den8 			 * Naively using (num == 10^12) would cause overflow,/ 			 * so we have to "right shift" both factors. : 			 * With (hwfreq) a power of 2, this will even be exact! 			 */   			tics_fix_num = 1000000; 			tics_fix_num *= 1000000;    			tics_fix_den = systick; 			tics_fix_den *= hwfreq;  % 			while(tics_fix_num > 0x7FFFFFFF) {  				tics_fix_num /= 2; 				tics_fix_den /= 2; 			} 		}   1 		ntics.q = (tics * tics_fix_num) / tics_fix_den;  #else  		ntics.q = tics * 100000; #endif 		qdif.q = systim.q - ntics.q; #else  	/*VAX*/- 		status = lib$emul(&100000,&tics,&0,&ntics); " 		if(!(status & 1)) return status;* 		status = lib$subx(&systim,&ntics,&qdif);" 		if(!(status & 1)) return status; #endif
 		inited = 1;  	}  < 	tics = EXE$GL_ABSTIM_TICS & 0x7FFFFFFF;		/* 31 bits only */2 	if(tics < oldtics) {		/* _assume_ 31-bit overflow" 					 * (just once every 248 days) 					 */ #if defined(__alpha) 		ntics.q = 0x7FFFFFFF;  		ntics.q += 1;  #if defined(ALPHA_TICS_FIX) 4 		ntics.q = (ntics.q * tics_fix_num) / tics_fix_den; #else  		ntics.q = ntics.q * 100000;  #endif 		qdif.q += ntics.q; #else  	/*VAX*/8 		status = lib$emul(&100000,&0x7FFFFFFF,&100000,&ntics);" 		if(!(status & 1)) return status;( 		status = lib$addx(&qdif,&ntics,&qdif);" 		if(!(status & 1)) return status; #endif 	} 	oldtics = tics;   #if defined(__alpha) #if defined(ALPHA_TICS_FIX) 0 	ntics.q = (tics * tics_fix_num) / tics_fix_den; #else  	ntics.q = tics * 100000;  #endif 	timadr->q = ntics.q + qdif.q; #else  	/*VAX*/, 	status = lib$emul(&100000,&tics,&0,&ntics);! 	if(!(status & 1)) return status; ( 	status = lib$addx(&ntics,&qdif,timadr);! 	if(!(status & 1)) return status;  #endif  
 	return 1; }      #ifdef TESTING #include <stdio.h>   main() {  	VMSTIME st,tt,dt; 	const float one = 2.0;  	int i,sts;      	for(i = 0; i <= 10; i++) {  		sts = sys$gettim(&st); 		if(!(sts & 1)) lib$stop(sts);  		sts = sys_gettic(&tt); 		if(!(sts & 1)) lib$stop(sts);  		sts = lib$subx(&st,&tt,&dt); 		if(!(sts & 1)) lib$stop(sts); 8 		printf("sys: 0x%08X%08X  tic: 0x%08X%08X  s-t: %d.\n",, 			st.l[1],st.l[0],tt.l[1],tt.l[0],dt.l[0]);  ) 		sts = lib$wait(&one);		/* wait 1 sec */  		if(!(sts & 1)) lib$stop(sts);  	} }  #endif