file=$objdir/Makefile

if test ! -s $src_dir/kernel/$asmarch/Makefile.SH; then
  echo "No Makefile for asmarch $asmarch !" >&2; fi

echo Extracting $file
rm -f $file

# Path to directories
case "$src_dir"    in /*) src=$src_dir ;;    *) src=../$src_dir ;; esac
case "$data_dir"   in /*) data=$data_dir ;;  *) data=../$data_dir ;; esac
case "$doc_dir"    in /*) doc=$doc_dir ;;    *) doc=../$doc_dir ;; esac
case "$emacs_dir"  in /*) emx=$emacs_dir ;;  *) emx=../$emacs_dir ;; esac
case "$config_dir" in /*) cfg=$config_dir ;; *) cfg=../$config_dir ;; esac

# File lists
kernel="kernel mp"
inline="mpinline"
khlist="pariinline"
. $src_dir/kernel/$asmarch/Makefile.SH

graph="plot plotport"
gp="gp gp_init gp_rl"
language=`ls $src_dir/language/*.c | sed 's,.*/\(.*\)\.c,\1,'`
basemath=`ls $src_dir/basemath/*.c | sed 's,.*/\(.*\)\.c,\1,'`
modules=`ls $src_dir/modules/*.c   | sed 's,.*/\(.*\)\.c,\1,'`

if test m68k = "$asmarch"; then hlist=pari68k; else hlist=pariport; fi
hlist="pari paritypes paricast paricom parierr parigen parimemio parisys $hlist"

HEADERS=''
for f in $khlist; do
  HEADERS="$HEADERS $f.h";
done
for f in $hlist; do
  HEADERS="$HEADERS $src/headers/$f.h";
done

# We don't want to recompile everything when only changing a prototype
hlist="$hlist paridecl"

OBJS=''
for f in $kernel $basemath $modules $language; do
  OBJS="$OBJS $f.o"
done
OBJSGP=''
for f in $gp $graph; do
  OBJSGP="$OBJSGP $f.o"
done
OINLINE=''
for f in $inline; do
  if test -n "$__gnuc__" -a "$optimization" != debugging; then
    OINLINE="$OINLINE $f.o"
  else
    OBJS="$OBJS $f.o"
  fi
done

case "$which_graphic_lib" in
none)
  PLOTFILE=plotnull.c
  PLOTCFLAGS=
  PLOTLIBS=
  plotrunpath=
  ;;
sunview)
  PLOTFILE=plotsun.c
  PLOTCFLAGS=
  PLOTLIBS='-lsuntool -lsunwindow -lpixrect'
  plotrunpath=
  ;;
X11)
  PLOTFILE=plotX.c
  PLOTCFLAGS=-I$Xincroot
  PLOTLIBS="-L$X11 -lX11 $extralib"
  if test "$osname" = concentrix; then PLOTLIBS="-lX11"; fi
  plotrunpath=$X11
  ;;
esac

case "$runpathprefix" in
  -R) RUNPTH_FINAL="-R$runpath"
      if test -n "$plotrunpath"; then
        RUNPTH_FINAL="$RUNPTH_FINAL -R$plotrunpath"
      fi
      RUNPTH="-R$TOP/$objdir $RUNPTH_FINAL";;
  *-rpath*)
      tmp="$runpath:$plotrunpath"
      RUNPTH_FINAL="$runpathprefix $tmp"
      RUNPTH="$runpathprefix $TOP/$objdir:$tmp";;
esac

if test -z "$DLLD"; then
  exec="gp-sta"
else 
  exec="gp-sta gp-dyn"
fi
if test -z "$emacs"; then
  install_emacs_files=
  pari_elc=
else
  install_emacs_files=install_emacs_files
  pari_elc=$emx/pari.elc
fi
case "$static" in
  n) dft=dyn ;;
  y) dft=sta ;;
esac

cat > $file << EOT
# Makefile for Pari/GP -- $pretty
#
#  This file was created by Configure. Any change made to it will be
#  lost when Configure is run.
#
SHELL      = $make_sh

AS         = $AS
ASFLAGS    = $ASFLAGS

CC         = $CC
CPPFLAGS   = -I. -I$src/headers
CFLAGS     = $cflags
LD         = $LD
LDFLAGS    = $LDFLAGS
DLLD       = $DLLD
DLLDFLAGS  = $DLLDFLAGS
EXTRADLLDFLAGS  = $EXTRADLLDFLAGS
CPP        = $CPP

RUNPTH       = $RUNPTH
RUNPTH_FINAL = $RUNPTH_FINAL
LDDYN        = $LDDYN
DLCFLAGS     = $DLCFLAGS
LIBS = -lm $LIBS

RM = rm -f
MV = mv -f
LN = $ln_s

# Change these installation directories to suit your needs.

LIBDIR = $libdir
BINDIR = $bindir
DATADIR= $datadir
MANDIR = $mandir
MISCDIR = $miscdir
INCLUDEDIR = $includedir

INSTALL = $cfg/install
INSTALL_PROGRAM = \$(INSTALL)
INSTALL_DATA = \$(INSTALL) -m 644

# Graphic library.
PLOTFILE   = $PLOTFILE
PLOTCFLAGS = $PLOTCFLAGS
PLOTLIBS   = $PLOTLIBS
# Try uncommenting this line if you're using X11 and linking fails:
#  PLOTLIBS="-L$X11 -lX11"

EOT
if test -n "$readline"; then
cat >> $file << EOT

RLINCLUDE = $RLINCLUDE
RLLIBS    = $RLLIBS

EOT
fi
cat >> $file << EOT
TOPLDDYN     = -L$TOP/$objdir \$(RLLIBS)

OBJS   = $OBJS
OBJSGP = $OBJSGP
OINLINE = $OINLINE

dft: gp $pari_elc
	-

gp: gp-$dft lib-$dft ../gp$suffix$exe_suff
	-

../gp$suffix$exe_suff: gp-$dft
	-\$(RM) \$@
	-\$(LN) $objdir/gp-$dft \$@

all: gp-sta gp-dyn lib-sta

lib-sta: libpari.a
lib-dyn: libpari.$somake

libpari.a: \$(OBJS) \$(OINLINE)
	-\$(RM) \$@
	ar r \$@  \$(OBJS) \$(OINLINE)
EOT
if test -n "$ranlib"; then
cat >> $file << EOT
	$ranlib \$@
EOT
fi
cat >> $file << EOT

gp-sta: \$(OBJS) \$(OBJSGP)
	\$(RM) \$@
	\$(LD) -o \$@ \$(LDFLAGS) \$(OBJS) \$(OBJSGP) \$(RUNPTH) \$(RLLIBS) \$(PLOTLIBS) \$(LIBS)

gp-dyn: \$(OBJSGP) libpari.$somake
	\$(RM) \$@
	\$(LD) -o \$@ \$(LDFLAGS) \$(OBJSGP) \$(RUNPTH) \$(TOPLDDYN) \$(LDDYN) \$(PLOTLIBS) \$(LIBS)

bench: $exec dobench
test: $exec dotest
test-compat: $exec dotest-compat
test-graphic: $exec dotest-graphic

cleantest:
	\$(RM) out.* pari.ps

dobench::
	@$src/test-bench/dotest $sizeof_long
dotest::
	@$src/test/dotest $sizeof_long
dotest-compat::
	@$src/test/dotest $sizeof_long -c
dotest-graphic::
	@$src/test/dotest $sizeof_long -g

clean: cleantest
	-\$(RM) *.o *.s libpari.* gp-dyn gp-sta

.headers: $HEADERS
	@touch \$@

install: install-lib-$dft install-include install-bin install-man install-misc install-data

install-include:
	-mkdir -p \$(INCLUDEDIR)
	\$(INSTALL_DATA) pariconfig.h              \$(INCLUDEDIR)
	-for i in $khlist; do \\
	   \$(INSTALL_DATA) \$\$i.h                \$(INCLUDEDIR); done
	-for i in $hlist; do \\
	   \$(INSTALL_DATA) $src/headers/\$\$i.h   \$(INCLUDEDIR); done
	-\$(RM) \$(INCLUDEDIR)/genpari.h
	-\$(LN) pari.h \$(INCLUDEDIR)/genpari.h

install-bin: install-bin-$dft

install-bin-dyn: gp-dyn
	-mkdir -p \$(BINDIR)
	-\$(RM) \$(BINDIR)/gp-$version \$(BINDIR)/gp$exe_suff
	-\$(LD) -o \$(BINDIR)/gp-$version \$(LDFLAGS) \$(OBJSGP) \$(RUNPTH_FINAL) \$(TOPLDDYN) \$(LDDYN) \$(PLOTLIBS) \$(LIBS)
	strip \$(BINDIR)/gp-$version
	-\$(LN) gp-$version$exe_suff \$(BINDIR)/gp$exe_suff

install-bin-sta: gp-sta
	-mkdir -p \$(BINDIR)
	-\$(RM) \$(BINDIR)/gp-$version \$(BINDIR)/gp$exe_suff
	\$(INSTALL_PROGRAM) gp-sta \$(BINDIR)/gp-$version
	-\$(LN) gp-$version$exe_suff \$(BINDIR)/gp$exe_suff
# Can't strip it if we want install() to work on Linux or OSF.
#	strip \$(BINDIR)/gp-$version

install-man::
	-mkdir -p \$(MANDIR)
	\$(INSTALL_DATA) $doc/gp.1 \$(MANDIR)

install-misc: $install_emacs_files
	-mkdir -p \$(MISCDIR)
	\$(INSTALL_DATA)    $doc/macros.tex     \$(MISCDIR)
	\$(INSTALL_DATA)    $doc/users.help.tex \$(MISCDIR)
	\$(INSTALL_DATA)    $doc/usersch3.tex   \$(MISCDIR)
	\$(INSTALL_PROGRAM) $doc/gphelp         \$(MISCDIR)
	\$(INSTALL_DATA)    $doc/translations   \$(MISCDIR)

install-data:
	-mkdir -p \$(DATADIR)
	@-for f in $data/*; do \$(INSTALL_DATA)  \$\$f \$(DATADIR); done 2>/dev/null

install-lib-sta: libpari.a
	-mkdir -p \$(LIBDIR)
	-\$(RM) \$(LIBDIR)/libpari.a
	\$(INSTALL_DATA) libpari.a \$(LIBDIR)/libpari.a.$version
	-\$(LN) libpari.a.$version \$(LIBDIR)/libpari.a

install-lib-dyn: libpari.$somake
	-mkdir -p \$(LIBDIR)
	-\$(RM) \$(LIBDIR)/libpari.$sodest
	\$(INSTALL_DATA) libpari.$sodest \$(LIBDIR)/libpari.$sodest
EOT
if test "$somake" != "$sodest"; then
  cat >> $file << EOT
	-\$(RM) \$(LIBDIR)/libpari.$somake
	-\$(LN) libpari.$sodest \$(LIBDIR)/libpari.$somake
	-\$(RM) \$(LIBDIR)/libpari.$DLSUFFIX
	-\$(LN) libpari.$sodest \$(LIBDIR)/libpari.$DLSUFFIX
EOT
fi

if test -z "$DLLD"; then
  cat >> $file << EOT

libpari.$somake::
	@echo "Configure could not find a way to build a shared library on this machine."

EOT
else
  cat >> $file << EOT

libpari.$somake: \$(OBJS) \$(OINLINE)
	-\$(RM) libpari.$somake
	\$(DLLD) -o \$@ \$(DLLDFLAGS) \$(OBJS) \$(OINLINE) \$(EXTRADLLDFLAGS)
EOT
  if test "$somake" != "$sodest"; then
    cat >> $file << EOT
	-\$(RM) libpari.$sodest
	-\$(MV) libpari.$somake libpari.$sodest
	-\$(LN) libpari.$sodest libpari.$somake
	-\$(RM) libpari.$DLSUFFIX
	-\$(LN) libpari.$sodest libpari.$DLSUFFIX
EOT
  fi
fi

if test -n "$emacs"; then
  cat >> $file << EOT
$pari_elc: $emx/pari.el
	@echo "Byte-Compiling pari.el..."
	-cd $emx; $emacs -batch -l compile

$install_emacs_files: $pari_elc
	-mkdir -p \$(MISCDIR)
	-\$(INSTALL_DATA)   $pari_elc           \$(MISCDIR)
	\$(INSTALL_DATA)    $emx/pari.el        \$(MISCDIR)
# otherwise Warning from emacs (file not writeable)
	\$(INSTALL) -m 666  $emx/pari.menu      \$(MISCDIR)
	\$(INSTALL_DATA)    $emx/pariemacs.txt  \$(MISCDIR)
EOT
fi

if test -s $src_dir/kernel/$asmarch/Makefile.SH; then
  . $src_dir/kernel/$asmarch/Makefile.SH rules
else
  echo "No Makefile for asmarch $asmarch !" >&2
fi

HUGELINE=
for dir in basemath modules language gp graph; do
  eval list='$'$dir
  for f in $list; do

  source="$src/$dir/$f.c"
  depend=
  cflags=
  case "$f" in
  plot)
    source="$src/graph/\$(PLOTFILE)"
    cflags="\$(PLOTCFLAGS)"
    depend="$src/graph/rect.h"
    ;;
  gp|gp_rl)
    cflags="-I$src/language \$(RLINCLUDE)"
    depend="$src/language/anal.h $src/gp/gp.h ./pariconfig.h"
    ;;
  gp_init|plotport)
    cflags="-I$src/graph"
    depend="$src/graph/rect.h"
    ;;
  init|es|sumiter)
    depend="$src/language/anal.h"
    ;;
  anal)
    depend="$src/language/anal.h $src/headers/parinf.h"
    ;;
  base1|bibli1|buch2)
    depend="$src/headers/parinf.h"
    ;;
  esac

HUGELINE="$HUGELINE
$f.o: .headers $depend $source
	\$(CC) -c \$(CFLAGS) \$(CPPFLAGS) $cflags -o $f.o $source"
  done
done
#to avoid execing too many "cat".
echo "$HUGELINE" >> $file
